/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.engine.history.HistoricProcessInstance;
import org.finra.herd.model.api.xml.Job;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class CheckEmrClusterTest
extends AbstractServiceTest {
    @Test
    public void testCheckClusterByClusterIdStepId() throws Exception {
        List<FieldExtension> fieldExtensions = this.getOptionalFieldExtensions();
        FieldExtension fieldExtension = new FieldExtension();
        fieldExtension.setFieldName("emrStepId");
        fieldExtension.setExpression("${addHiveStepServiceTask_emrStepId}");
        fieldExtensions.add(fieldExtension);
        Job job = this.jobServiceTestHelper.createJobForCreateClusterForActivitiXml(this.getCheckClusterActivitiXml(fieldExtensions), this.getParameters(true, "false"));
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        Map variables = hisInstance.getProcessVariables();
        String hiveStepId = (String)variables.get("addHiveStepServiceTask_emrStepId");
        String emrStepId = (String)variables.get("checkClusterServiceTask_step_id");
        Assert.assertEquals((Object)hiveStepId, (Object)emrStepId);
        String emrStepJarLocation = (String)variables.get("checkClusterServiceTask_step_jarLocation");
        Assert.assertNull((Object)emrStepJarLocation);
        String shellStepId = (String)variables.get("addShellStepServiceTask_emrStepId");
        String activeStepId = (String)variables.get("checkClusterServiceTask_activeStep_id");
        Assert.assertEquals((Object)shellStepId, (Object)activeStepId);
        String activeStepJarLocation = (String)variables.get("checkClusterServiceTask_activeStep_jarLocation");
        Assert.assertNull((Object)activeStepJarLocation);
    }

    @Test
    public void testCheckClusterByClusterIdStepIdVerbose() throws Exception {
        List<FieldExtension> fieldExtensions = this.getOptionalFieldExtensions();
        FieldExtension fieldExtension = new FieldExtension();
        fieldExtension.setFieldName("emrStepId");
        fieldExtension.setExpression("${addHiveStepServiceTask_emrStepId}");
        fieldExtensions.add(fieldExtension);
        Job job = this.jobServiceTestHelper.createJobForCreateClusterForActivitiXml(this.getCheckClusterActivitiXml(fieldExtensions), this.getParameters(true, "true"));
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        Map variables = hisInstance.getProcessVariables();
        String hiveStepId = (String)variables.get("addHiveStepServiceTask_emrStepId");
        String emrStepId = (String)variables.get("checkClusterServiceTask_step_id");
        Assert.assertEquals((Object)hiveStepId, (Object)emrStepId);
        String emrStepJarLocation = (String)variables.get("checkClusterServiceTask_step_jarLocation");
        Assert.assertNotNull((Object)emrStepJarLocation);
        String shellStepId = (String)variables.get("addShellStepServiceTask_emrStepId");
        String activeStepId = (String)variables.get("checkClusterServiceTask_activeStep_id");
        Assert.assertEquals((Object)shellStepId, (Object)activeStepId);
        String activeStepJarLocation = (String)variables.get("checkClusterServiceTask_activeStep_jarLocation");
        Assert.assertNotNull((Object)activeStepJarLocation);
    }

    @Test
    public void testCheckClusterByClusterIdStepIdNoActiveStep() throws Exception {
        List<FieldExtension> fieldExtensions = this.getOptionalFieldExtensions();
        FieldExtension fieldExtension = new FieldExtension();
        fieldExtension.setFieldName("emrStepId");
        fieldExtension.setExpression("${addHiveStepServiceTask_emrStepId}");
        fieldExtensions.add(fieldExtension);
        Job job = this.jobServiceTestHelper.createJobForCreateClusterForActivitiXml(this.getCheckClusterActivitiXml(fieldExtensions), this.getParameters(false, "false"));
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        Map variables = hisInstance.getProcessVariables();
        String hiveStepId = (String)variables.get("addHiveStepServiceTask_emrStepId");
        String emrStepId = (String)variables.get("checkClusterServiceTask_step_id");
        Assert.assertEquals((Object)hiveStepId, (Object)emrStepId);
        String emrStepJarLocation = (String)variables.get("checkClusterServiceTask_step_jarLocation");
        Assert.assertNull((Object)emrStepJarLocation);
    }

    @Test
    public void testCheckCluster() throws Exception {
        Job job = this.jobServiceTestHelper.createJobForCreateCluster("classpath:org/finra/herd/service/activitiWorkflowCheckEmrCluster.bpmn20.xml", this.getParameters(true, ""));
        Assert.assertNotNull((Object)job);
    }

    private List<Parameter> getParameters(boolean isShellStepRunning, String verbose) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("clusterName", "testCluster1"));
        parameters.add(new Parameter("hiveStepName", "a_hive_step"));
        parameters.add(new Parameter("hiveScriptLocation", "a_hive_step_location"));
        parameters.add(new Parameter("shellStepName", isShellStepRunning ? "mock_step_running_name" : "a_shell_step"));
        parameters.add(new Parameter("shellScriptLocation", "a_shell_step_location"));
        parameters.add(new Parameter("verbose", verbose));
        return parameters;
    }

    private String getCheckClusterActivitiXml(List<FieldExtension> checkClusterFieldExtensions) throws Exception {
        BpmnModel bpmnModel = this.getBpmnModelForXmlResource("classpath:org/finra/herd/service/activitiWorkflowCheckEmrCluster.bpmn20.xml");
        ServiceTask serviceTask = (ServiceTask)((Process)bpmnModel.getProcesses().get(0)).getFlowElement("checkClusterServiceTask");
        serviceTask.getFieldExtensions().addAll(checkClusterFieldExtensions);
        return this.getActivitiXmlFromBpmnModel(bpmnModel);
    }

    private List<FieldExtension> getOptionalFieldExtensions() {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        FieldExtension fieldExtension = new FieldExtension();
        fieldExtension.setFieldName("emrClusterId");
        fieldExtension.setExpression("${createClusterServiceTask_emrClusterId}");
        fieldExtensionList.add(fieldExtension);
        fieldExtension = new FieldExtension();
        fieldExtension.setFieldName("verbose");
        fieldExtension.setExpression("${verbose}");
        fieldExtensionList.add(fieldExtension);
        return fieldExtensionList;
    }
}

