/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.Map;
import org.activiti.engine.history.HistoricProcessInstance;
import org.finra.herd.dao.impl.MockAwsOperationsHelper;
import org.finra.herd.model.api.xml.Job;
import org.finra.herd.model.api.xml.OozieWorkflowJob;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class CheckEmrOozieWorkflowJobTest
extends AbstractServiceTest {
    @Test
    public void testCheckOozieWorkflowJob() throws Exception {
        String clusterName = "testCluster" + Math.random();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("clusterName", clusterName));
        parameters.add(new Parameter("oozieWorkflowJobId", "case1"));
        parameters.add(new Parameter("verbose", "false"));
        Job job = this.jobServiceTestHelper.createJobForCreateCluster("classpath:org/finra/herd/service/activitiWorkflowCheckOozieJob.bpmn20.xml", parameters, MockAwsOperationsHelper.AMAZON_CLUSTER_STATUS_WAITING);
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        Map variables = hisInstance.getProcessVariables();
        String oozieJobTaskStatus = (String)variables.get("checkOozieWorkflowTask_taskStatus");
        String jsonResponse = (String)variables.get("checkOozieWorkflowTask_jsonResponse");
        Assert.assertEquals((Object)oozieJobTaskStatus, (Object)"SUCCESS");
        Assert.assertNotNull((Object)jsonResponse);
        OozieWorkflowJob oozieWorkflowJob = (OozieWorkflowJob)this.jsonHelper.unmarshallJsonToObject(OozieWorkflowJob.class, jsonResponse);
        Assert.assertNotNull((Object)oozieWorkflowJob);
        Assert.assertEquals((String)"job ID", (Object)"case1", (Object)oozieWorkflowJob.getId());
        Assert.assertEquals((String)"EMR cluster name", (Object)clusterName, (Object)oozieWorkflowJob.getEmrClusterName());
        Assert.assertNotNull((String)"job start time is null", (Object)oozieWorkflowJob.getStartTime());
        Assert.assertNull((String)"job end time is not null", (Object)oozieWorkflowJob.getEndTime());
        Assert.assertNull((String)"actions is not null", (Object)oozieWorkflowJob.getWorkflowActions());
    }

    @Test
    public void testCheckOozieWorkflowJobVerbose() throws Exception {
        String clusterName = "testCluster" + Math.random();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("clusterName", clusterName));
        parameters.add(new Parameter("oozieWorkflowJobId", "case1"));
        parameters.add(new Parameter("verbose", "true"));
        Job job = this.jobServiceTestHelper.createJobForCreateCluster("classpath:org/finra/herd/service/activitiWorkflowCheckOozieJob.bpmn20.xml", parameters, MockAwsOperationsHelper.AMAZON_CLUSTER_STATUS_WAITING);
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        Map variables = hisInstance.getProcessVariables();
        String oozieJobTaskStatus = (String)variables.get("checkOozieWorkflowTask_taskStatus");
        String jsonResponse = (String)variables.get("checkOozieWorkflowTask_jsonResponse");
        Assert.assertEquals((Object)oozieJobTaskStatus, (Object)"SUCCESS");
        Assert.assertNotNull((Object)jsonResponse);
        OozieWorkflowJob oozieWorkflowJob = (OozieWorkflowJob)this.jsonHelper.unmarshallJsonToObject(OozieWorkflowJob.class, jsonResponse);
        Assert.assertNotNull((Object)oozieWorkflowJob);
        Assert.assertEquals((String)"job ID", (Object)"case1", (Object)oozieWorkflowJob.getId());
        Assert.assertEquals((String)"EMR cluster name", (Object)clusterName, (Object)oozieWorkflowJob.getEmrClusterName());
        Assert.assertNotNull((String)"job start time is null", (Object)oozieWorkflowJob.getStartTime());
        Assert.assertNull((String)"job end time is not null", (Object)oozieWorkflowJob.getEndTime());
        Assert.assertNotNull((String)"actions is null", (Object)oozieWorkflowJob.getWorkflowActions());
    }
}

