/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.HashMap;
import org.activiti.bpmn.model.FieldExtension;
import org.finra.herd.model.api.xml.BusinessObjectDataAttribute;
import org.finra.herd.model.api.xml.BusinessObjectDataAttributeKey;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.model.jpa.BusinessObjectDataAttributeEntity;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.finra.herd.service.activiti.task.DeleteBusinessObjectDataAttribute;
import org.finra.herd.service.activiti.task.HerdActivitiServiceTaskTest;
import org.junit.Assert;
import org.junit.Test;

public class DeleteBusinessObjectDataAttributeTest
extends HerdActivitiServiceTaskTest {
    @Test
    public void testDeleteBusinessObjectDataAttribute() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataAttributeKey businessObjectDataAttributeKey = this.businessObjectDataAttributeHelper.getBusinessObjectDataAttributeKey(businessObjectDataKey, "Attribute Name 1");
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(businessObjectDataKey, "Attribute Name 1", "Attribute Value 1");
        Assert.assertNotNull((Object)this.businessObjectDataAttributeDao.getBusinessObjectDataAttributeByKey(businessObjectDataAttributeKey));
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatUsage", "${businessObjectFormatUsage}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatFileType", "${businessObjectFormatFileType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("partitionValue", "${partitionValue}"));
        fieldExtensionList.add(this.buildFieldExtension("subPartitionValues", "${subPartitionValues}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataVersion", "${businessObjectDataVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataAttributeName", "${businessObjectDataAttributeName}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", BDEF_NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        parameters.add(this.buildParameter("businessObjectFormatUsage", FORMAT_USAGE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("partitionValue", PARTITION_VALUE));
        parameters.add(this.buildParameter("subPartitionValues", this.herdStringHelper.buildStringWithDefaultDelimiter(SUBPARTITION_VALUES)));
        parameters.add(this.buildParameter("businessObjectDataVersion", DATA_VERSION.toString()));
        parameters.add(this.buildParameter("businessObjectDataAttributeName", "Attribute Name 1"));
        BusinessObjectDataAttribute expectedBusinessObjectDataAttribute = new BusinessObjectDataAttribute(businessObjectDataAttributeEntity.getId().intValue(), businessObjectDataAttributeKey, "Attribute Value 1");
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("jsonResponse", this.jsonHelper.objectToJson((Object)expectedBusinessObjectDataAttribute));
        this.testActivitiServiceTaskSuccess(DeleteBusinessObjectDataAttribute.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
        Assert.assertNull((Object)this.businessObjectDataAttributeDao.getBusinessObjectDataAttributeByKey(businessObjectDataAttributeKey));
    }

    @Test
    public void testDeleteBusinessObjectDataAttributeMissingRequiredParameter() throws Exception {
        ArrayList fieldExtensionList = new ArrayList();
        ArrayList parameters = new ArrayList();
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "A namespace must be specified.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(DeleteBusinessObjectDataAttribute.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testDeleteBusinessObjectDataAttributeMissingOptionalParameters() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataAttributeKey businessObjectDataAttributeKey = this.businessObjectDataAttributeHelper.getBusinessObjectDataAttributeKey(businessObjectDataKey, "Attribute Name 1");
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(businessObjectDataKey, "Attribute Name 1", "Attribute Value 1");
        Assert.assertNotNull((Object)this.businessObjectDataAttributeDao.getBusinessObjectDataAttributeByKey(businessObjectDataAttributeKey));
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatUsage", "${businessObjectFormatUsage}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatFileType", "${businessObjectFormatFileType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("partitionValue", "${partitionValue}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataVersion", "${businessObjectDataVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataAttributeName", "${businessObjectDataAttributeName}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", BDEF_NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        parameters.add(this.buildParameter("businessObjectFormatUsage", FORMAT_USAGE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("partitionValue", PARTITION_VALUE));
        parameters.add(this.buildParameter("businessObjectDataVersion", DATA_VERSION.toString()));
        parameters.add(this.buildParameter("businessObjectDataAttributeName", "Attribute Name 1"));
        BusinessObjectDataAttribute expectedBusinessObjectDataAttribute = new BusinessObjectDataAttribute(businessObjectDataAttributeEntity.getId().intValue(), this.businessObjectDataAttributeHelper.getBusinessObjectDataAttributeKey(businessObjectDataKey, "Attribute Name 1"), "Attribute Value 1");
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("jsonResponse", this.jsonHelper.objectToJson((Object)expectedBusinessObjectDataAttribute));
        this.testActivitiServiceTaskSuccess(DeleteBusinessObjectDataAttribute.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
        Assert.assertNull((Object)this.businessObjectDataAttributeDao.getBusinessObjectDataAttributeByKey(businessObjectDataAttributeKey));
    }

    @Test
    public void testDeleteBusinessObjectDataAttributeMissingOptionalParametersSubPartitionValuesAsEmptyString() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataAttributeKey businessObjectDataAttributeKey = this.businessObjectDataAttributeHelper.getBusinessObjectDataAttributeKey(businessObjectDataKey, "Attribute Name 1");
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(businessObjectDataKey, "Attribute Name 1", "Attribute Value 1");
        Assert.assertNotNull((Object)this.businessObjectDataAttributeDao.getBusinessObjectDataAttributeByKey(businessObjectDataAttributeKey));
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatUsage", "${businessObjectFormatUsage}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatFileType", "${businessObjectFormatFileType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("partitionValue", "${partitionValue}"));
        fieldExtensionList.add(this.buildFieldExtension("subPartitionValues", "${subPartitionValues}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataVersion", "${businessObjectDataVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataAttributeName", "${businessObjectDataAttributeName}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", BDEF_NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        parameters.add(this.buildParameter("businessObjectFormatUsage", FORMAT_USAGE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("partitionValue", PARTITION_VALUE));
        parameters.add(this.buildParameter("subPartitionValues", ""));
        parameters.add(this.buildParameter("businessObjectDataVersion", DATA_VERSION.toString()));
        parameters.add(this.buildParameter("businessObjectDataAttributeName", "Attribute Name 1"));
        BusinessObjectDataAttribute expectedBusinessObjectDataAttribute = new BusinessObjectDataAttribute(businessObjectDataAttributeEntity.getId().intValue(), this.businessObjectDataAttributeHelper.getBusinessObjectDataAttributeKey(businessObjectDataKey, "Attribute Name 1"), "Attribute Value 1");
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("jsonResponse", this.jsonHelper.objectToJson((Object)expectedBusinessObjectDataAttribute));
        this.testActivitiServiceTaskSuccess(DeleteBusinessObjectDataAttribute.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
        Assert.assertNull((Object)this.businessObjectDataAttributeDao.getBusinessObjectDataAttributeByKey(businessObjectDataAttributeKey));
    }

    @Test
    public void testDeleteBusinessObjectDataAttributeInvalidBusinessObjectFormatVersion() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("businessObjectFormatVersion", "NOT_AN_INTEGER"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"businessObjectFormatVersion\" must be a valid integer value.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(DeleteBusinessObjectDataAttribute.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testDeleteBusinessObjectDataAttributeInvalidBusinessObjectDataVersion() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataVersion", "${businessObjectDataVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("businessObjectDataVersion", "NOT_AN_INTEGER"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"businessObjectDataVersion\" must be a valid integer value.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(DeleteBusinessObjectDataAttribute.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }
}

