/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.FieldExtension;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.BusinessObjectDataAttributeKeys;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.finra.herd.service.activiti.task.GetBusinessObjectDataAttributes;
import org.finra.herd.service.activiti.task.HerdActivitiServiceTaskTest;
import org.junit.Test;

public class GetBusinessObjectDataAttributesTest
extends HerdActivitiServiceTaskTest {
    @Test
    public void testGetBusinessObjectDataAttribute() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        List<Attribute> testAttributes = this.businessObjectDefinitionServiceTestHelper.getNewAttributes();
        for (Attribute attribute : testAttributes) {
            this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(businessObjectDataKey, attribute.getName(), attribute.getValue());
        }
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatUsage", "${businessObjectFormatUsage}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatFileType", "${businessObjectFormatFileType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("partitionValue", "${partitionValue}"));
        fieldExtensionList.add(this.buildFieldExtension("subPartitionValues", "${subPartitionValues}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataVersion", "${businessObjectDataVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", BDEF_NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        parameters.add(this.buildParameter("businessObjectFormatUsage", FORMAT_USAGE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("partitionValue", PARTITION_VALUE));
        parameters.add(this.buildParameter("subPartitionValues", this.herdStringHelper.buildStringWithDefaultDelimiter(SUBPARTITION_VALUES)));
        parameters.add(this.buildParameter("businessObjectDataVersion", DATA_VERSION.toString()));
        BusinessObjectDataAttributeKeys expectedBusinessObjectDataAttributeKeys = new BusinessObjectDataAttributeKeys();
        for (Attribute attribute : testAttributes) {
            expectedBusinessObjectDataAttributeKeys.getBusinessObjectDataAttributeKeys().add(this.businessObjectDataAttributeHelper.getBusinessObjectDataAttributeKey(businessObjectDataKey, attribute.getName()));
        }
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("jsonResponse", this.jsonHelper.objectToJson((Object)expectedBusinessObjectDataAttributeKeys));
        this.testActivitiServiceTaskSuccess(GetBusinessObjectDataAttributes.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testGetBusinessObjectDataAttributeMissingRequiredParameter() throws Exception {
        ArrayList fieldExtensionList = new ArrayList();
        ArrayList parameters = new ArrayList();
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "A namespace must be specified.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(GetBusinessObjectDataAttributes.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testGetBusinessObjectDataAttributeMissingOptionalParameters() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        List<Attribute> testAttributes = this.businessObjectDefinitionServiceTestHelper.getNewAttributes();
        for (Attribute attribute : testAttributes) {
            this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(businessObjectDataKey, attribute.getName(), attribute.getValue());
        }
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatUsage", "${businessObjectFormatUsage}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatFileType", "${businessObjectFormatFileType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("partitionValue", "${partitionValue}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataVersion", "${businessObjectDataVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", BDEF_NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        parameters.add(this.buildParameter("businessObjectFormatUsage", FORMAT_USAGE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("partitionValue", PARTITION_VALUE));
        parameters.add(this.buildParameter("businessObjectDataVersion", DATA_VERSION.toString()));
        BusinessObjectDataAttributeKeys expectedBusinessObjectDataAttributeKeys = new BusinessObjectDataAttributeKeys();
        for (Attribute attribute : testAttributes) {
            expectedBusinessObjectDataAttributeKeys.getBusinessObjectDataAttributeKeys().add(this.businessObjectDataAttributeHelper.getBusinessObjectDataAttributeKey(businessObjectDataKey, attribute.getName()));
        }
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("jsonResponse", this.jsonHelper.objectToJson((Object)expectedBusinessObjectDataAttributeKeys));
        this.testActivitiServiceTaskSuccess(GetBusinessObjectDataAttributes.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testGetBusinessObjectDataAttributeMissingOptionalParametersSubPartitionValuesAsEmptyString() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        List<Attribute> testAttributes = this.businessObjectDefinitionServiceTestHelper.getNewAttributes();
        for (Attribute attribute : testAttributes) {
            this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(businessObjectDataKey, attribute.getName(), attribute.getValue());
        }
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatUsage", "${businessObjectFormatUsage}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatFileType", "${businessObjectFormatFileType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("partitionValue", "${partitionValue}"));
        fieldExtensionList.add(this.buildFieldExtension("subPartitionValues", "${subPartitionValues}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataVersion", "${businessObjectDataVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", BDEF_NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        parameters.add(this.buildParameter("businessObjectFormatUsage", FORMAT_USAGE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("partitionValue", PARTITION_VALUE));
        parameters.add(this.buildParameter("subPartitionValues", ""));
        parameters.add(this.buildParameter("businessObjectDataVersion", DATA_VERSION.toString()));
        BusinessObjectDataAttributeKeys expectedBusinessObjectDataAttributeKeys = new BusinessObjectDataAttributeKeys();
        for (Attribute attribute : testAttributes) {
            expectedBusinessObjectDataAttributeKeys.getBusinessObjectDataAttributeKeys().add(this.businessObjectDataAttributeHelper.getBusinessObjectDataAttributeKey(businessObjectDataKey, attribute.getName()));
        }
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("jsonResponse", this.jsonHelper.objectToJson((Object)expectedBusinessObjectDataAttributeKeys));
        this.testActivitiServiceTaskSuccess(GetBusinessObjectDataAttributes.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testGetBusinessObjectDataAttributeInvalidBusinessObjectFormatVersion() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("businessObjectFormatVersion", "NOT_AN_INTEGER"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"businessObjectFormatVersion\" must be a valid integer value.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(GetBusinessObjectDataAttributes.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    @Test
    public void testGetBusinessObjectDataAttributeInvalidBusinessObjectDataVersion() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataVersion", "${businessObjectDataVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("businessObjectDataVersion", "NOT_AN_INTEGER"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"businessObjectDataVersion\" must be a valid integer value.");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(GetBusinessObjectDataAttributes.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }
}

