/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.engine.history.HistoricProcessInstance;
import org.apache.commons.collections4.IterableUtils;
import org.finra.herd.core.HerdDateUtils;
import org.finra.herd.model.api.xml.BusinessObjectData;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectDataStatusChangeEvent;
import org.finra.herd.model.api.xml.Job;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.BusinessObjectDataStatusEntity;
import org.finra.herd.model.jpa.BusinessObjectDataStatusHistoryEntity;
import org.finra.herd.model.jpa.BusinessObjectDefinitionEntity;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.model.jpa.DataProviderEntity;
import org.finra.herd.model.jpa.FileTypeEntity;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.model.jpa.StorageFileEntity;
import org.finra.herd.model.jpa.StoragePlatformEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.finra.herd.service.activiti.task.GetBusinessObjectData;
import org.finra.herd.service.activiti.task.HerdActivitiServiceTaskTest;
import org.junit.Assert;
import org.junit.Test;

public class GetBusinessObjectDataTest
extends HerdActivitiServiceTaskTest {
    private static final char DELIMITER = '|';
    private static final String DELIMITER_ESCAPE = Matcher.quoteReplacement("\\|");
    private static final String PATTERN_DELIMITER = Pattern.quote(String.valueOf('|'));
    private static final String VARIABLE_JSON_RESPONSE = "jsonResponse";
    private static final String IMPLEMENTATION = GetBusinessObjectData.class.getCanonicalName();

    @Test
    public void test_WithSubPartitions_NoFormatVersion_NoDataVersion() throws Exception {
        String dataProviderName = this.randomString();
        String namespace = this.randomString();
        String businessObjectDefinitionName = this.randomString();
        String fileTypeCode = this.randomString();
        Integer businessObjectFormatVersion = 0;
        String partitionKey = this.randomString();
        String businessObjectFormatUsage = this.randomString();
        String[] partitionValues = new String[]{this.randomString(), this.randomString(), this.randomString(), this.randomString(), this.randomString()};
        Integer businessObjectDataVersion = 0;
        this.setupDatabase(namespace, dataProviderName, businessObjectDefinitionName, fileTypeCode, businessObjectFormatUsage, businessObjectFormatVersion, businessObjectDataVersion, partitionKey, partitionValues);
        String subPartitionValues = this.buildDelimitedSubPartitionValues(partitionValues);
        String partitionValue = partitionValues[0];
        Map<String, Object> variables = this.executeJob(namespace, businessObjectDefinitionName, businessObjectFormatUsage, fileTypeCode, partitionKey, partitionValue, subPartitionValues, null, null);
        String serviceTaskStatus = (String)variables.get(this.getServiceTaskVariableName("taskStatus"));
        Assert.assertEquals((Object)"SUCCESS", (Object)serviceTaskStatus);
        String jsonResponse = (String)variables.get(this.getServiceTaskVariableName(VARIABLE_JSON_RESPONSE));
        ObjectMapper om = new ObjectMapper();
        BusinessObjectData businessObjectData = (BusinessObjectData)om.readValue(jsonResponse.getBytes(), BusinessObjectData.class);
        Assert.assertEquals((Object)namespace, (Object)businessObjectData.getNamespace());
        Assert.assertEquals((Object)businessObjectDefinitionName, (Object)businessObjectData.getBusinessObjectDefinitionName());
        Assert.assertEquals((Object)businessObjectFormatUsage, (Object)businessObjectData.getBusinessObjectFormatUsage());
        Assert.assertEquals((Object)fileTypeCode, (Object)businessObjectData.getBusinessObjectFormatFileType());
        Assert.assertEquals((long)businessObjectFormatVersion.intValue(), (long)businessObjectData.getBusinessObjectFormatVersion());
        Assert.assertEquals((Object)partitionKey, (Object)businessObjectData.getPartitionKey());
        Assert.assertEquals((Object)partitionValue, (Object)businessObjectData.getPartitionValue());
        Assert.assertEquals((long)4L, (long)businessObjectData.getSubPartitionValues().size());
        Assert.assertEquals((Object)partitionValues[1], businessObjectData.getSubPartitionValues().get(0));
        Assert.assertEquals((Object)partitionValues[2], businessObjectData.getSubPartitionValues().get(1));
        Assert.assertEquals((Object)partitionValues[3], businessObjectData.getSubPartitionValues().get(2));
        Assert.assertEquals((Object)partitionValues[4], businessObjectData.getSubPartitionValues().get(3));
        Assert.assertEquals((long)businessObjectDataVersion.intValue(), (long)businessObjectData.getVersion());
        Assert.assertEquals((Object)true, (Object)businessObjectData.isLatestVersion());
        Assert.assertEquals((long)1L, (long)businessObjectData.getStorageUnits().size());
        Assert.assertEquals((long)0L, (long)businessObjectData.getAttributes().size());
        Assert.assertEquals((long)0L, (long)businessObjectData.getBusinessObjectDataParents().size());
        Assert.assertEquals((long)0L, (long)businessObjectData.getBusinessObjectDataChildren().size());
    }

    @Test
    public void test_WithSubPartitions_NoFormatVersion_NoDataVersion_WithSubPartitionDelimiterEscapeValue() throws Exception {
        String dataProviderName = this.randomString();
        String namespace = this.randomString();
        String businessObjectDefinitionName = this.randomString();
        String fileTypeCode = this.randomString();
        Integer businessObjectFormatVersion = 0;
        String partitionKey = this.randomString();
        String businessObjectFormatUsage = this.randomString();
        String[] partitionValues = new String[]{this.randomString() + '|', this.randomString() + '|', this.randomString() + '|', this.randomString() + '|', this.randomString() + '|'};
        Integer businessObjectDataVersion = 0;
        this.setupDatabase(namespace, dataProviderName, businessObjectDefinitionName, fileTypeCode, businessObjectFormatUsage, businessObjectFormatVersion, businessObjectDataVersion, partitionKey, partitionValues);
        String subPartitionValues = this.buildDelimitedSubPartitionValues(partitionValues);
        String partitionValue = partitionValues[0];
        Map<String, Object> variables = this.executeJob(namespace, businessObjectDefinitionName, businessObjectFormatUsage, fileTypeCode, partitionKey, partitionValue, subPartitionValues, null, null);
        String serviceTaskStatus = (String)variables.get(this.getServiceTaskVariableName("taskStatus"));
        Assert.assertEquals((Object)"SUCCESS", (Object)serviceTaskStatus);
        String jsonResponse = (String)variables.get(this.getServiceTaskVariableName(VARIABLE_JSON_RESPONSE));
        ObjectMapper om = new ObjectMapper();
        BusinessObjectData businessObjectData = (BusinessObjectData)om.readValue(jsonResponse.getBytes(), BusinessObjectData.class);
        Assert.assertEquals((Object)namespace, (Object)businessObjectData.getNamespace());
        Assert.assertEquals((Object)businessObjectDefinitionName, (Object)businessObjectData.getBusinessObjectDefinitionName());
        Assert.assertEquals((Object)businessObjectFormatUsage, (Object)businessObjectData.getBusinessObjectFormatUsage());
        Assert.assertEquals((Object)fileTypeCode, (Object)businessObjectData.getBusinessObjectFormatFileType());
        Assert.assertEquals((long)businessObjectFormatVersion.intValue(), (long)businessObjectData.getBusinessObjectFormatVersion());
        Assert.assertEquals((Object)partitionKey, (Object)businessObjectData.getPartitionKey());
        Assert.assertEquals((Object)partitionValue, (Object)businessObjectData.getPartitionValue());
        Assert.assertNotNull((Object)businessObjectData.getSubPartitionValues());
        Assert.assertEquals((long)4L, (long)businessObjectData.getSubPartitionValues().size());
        Assert.assertEquals((Object)partitionValues[1], businessObjectData.getSubPartitionValues().get(0));
        Assert.assertEquals((Object)partitionValues[2], businessObjectData.getSubPartitionValues().get(1));
        Assert.assertEquals((Object)partitionValues[3], businessObjectData.getSubPartitionValues().get(2));
        Assert.assertEquals((Object)partitionValues[4], businessObjectData.getSubPartitionValues().get(3));
        Assert.assertEquals((long)businessObjectDataVersion.intValue(), (long)businessObjectData.getVersion());
        Assert.assertEquals((Object)true, (Object)businessObjectData.isLatestVersion());
        Assert.assertEquals((long)1L, (long)businessObjectData.getStorageUnits().size());
        Assert.assertEquals((long)0L, (long)businessObjectData.getAttributes().size());
        Assert.assertEquals((long)0L, (long)businessObjectData.getBusinessObjectDataParents().size());
        Assert.assertEquals((long)0L, (long)businessObjectData.getBusinessObjectDataChildren().size());
    }

    @Test
    public void test_NoSubPartitions_WithFormatVersion_WithDataVersion() throws Exception {
        String dataProviderName = this.randomString();
        String namespace = this.randomString();
        String businessObjectDefinitionName = this.randomString();
        String fileTypeCode = this.randomString();
        Integer businessObjectFormatVersion = 0;
        String partitionKey = this.randomString();
        String businessObjectFormatUsage = this.randomString();
        String[] partitionValues = new String[]{this.randomString(), null, null, null, null};
        Integer businessObjectDataVersion = 0;
        this.setupDatabase(namespace, dataProviderName, businessObjectDefinitionName, fileTypeCode, businessObjectFormatUsage, businessObjectFormatVersion, businessObjectDataVersion, partitionKey, partitionValues);
        Map<String, Object> variables = this.executeJob(namespace, businessObjectDefinitionName, businessObjectFormatUsage, fileTypeCode, partitionKey, partitionValues[0], null, businessObjectFormatVersion.toString(), businessObjectDataVersion.toString());
        String serviceTaskStatus = (String)variables.get(this.getServiceTaskVariableName("taskStatus"));
        Assert.assertEquals((Object)"SUCCESS", (Object)serviceTaskStatus);
        String jsonResponse = (String)variables.get(this.getServiceTaskVariableName(VARIABLE_JSON_RESPONSE));
        ObjectMapper om = new ObjectMapper();
        BusinessObjectData businessObjectData = (BusinessObjectData)om.readValue(jsonResponse.getBytes(), BusinessObjectData.class);
        Assert.assertEquals((Object)namespace, (Object)businessObjectData.getNamespace());
        Assert.assertEquals((Object)businessObjectDefinitionName, (Object)businessObjectData.getBusinessObjectDefinitionName());
        Assert.assertEquals((Object)businessObjectFormatUsage, (Object)businessObjectData.getBusinessObjectFormatUsage());
        Assert.assertEquals((Object)fileTypeCode, (Object)businessObjectData.getBusinessObjectFormatFileType());
        Assert.assertEquals((long)businessObjectFormatVersion.intValue(), (long)businessObjectData.getBusinessObjectFormatVersion());
        Assert.assertEquals((Object)partitionKey, (Object)businessObjectData.getPartitionKey());
        Assert.assertEquals((Object)partitionValues[0], (Object)businessObjectData.getPartitionValue());
        Assert.assertEquals((long)0L, (long)businessObjectData.getSubPartitionValues().size());
        Assert.assertEquals((long)businessObjectDataVersion.intValue(), (long)businessObjectData.getVersion());
        Assert.assertEquals((Object)true, (Object)businessObjectData.isLatestVersion());
        Assert.assertEquals((long)1L, (long)businessObjectData.getStorageUnits().size());
        Assert.assertEquals((long)0L, (long)businessObjectData.getAttributes().size());
        Assert.assertEquals((long)0L, (long)businessObjectData.getBusinessObjectDataParents().size());
        Assert.assertEquals((long)0L, (long)businessObjectData.getBusinessObjectDataChildren().size());
    }

    @Test
    public void test_NoSubPartitions_WithFormatVersion_WithDataVersion_InvalidDataVersion() throws Exception {
        String dataProviderName = this.randomString();
        String namespace = this.randomString();
        String businessObjectDefinitionName = this.randomString();
        String fileTypeCode = this.randomString();
        Integer businessObjectFormatVersion = 0;
        String partitionKey = this.randomString();
        String businessObjectFormatUsage = this.randomString();
        String[] partitionValues = new String[]{this.randomString(), null, null, null, null};
        Integer businessObjectDataVersion = 0;
        this.setupDatabase(namespace, dataProviderName, businessObjectDefinitionName, fileTypeCode, businessObjectFormatUsage, businessObjectFormatVersion, businessObjectDataVersion, partitionKey, partitionValues);
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            Map<String, Object> variables = this.executeJob(namespace, businessObjectDefinitionName, businessObjectFormatUsage, fileTypeCode, partitionKey, partitionValues[0], null, businessObjectFormatVersion.toString(), "INVALID");
            String serviceTaskStatus = (String)variables.get(this.getServiceTaskVariableName("taskStatus"));
            Assert.assertEquals((Object)"ERROR", (Object)serviceTaskStatus);
        });
    }

    @Test
    public void test_NoSubPartitions_WithFormatVersion_WithDataVersion_InvalidFormatVersion() throws Exception {
        String dataProviderName = this.randomString();
        String namespace = this.randomString();
        String businessObjectDefinitionName = this.randomString();
        String fileTypeCode = this.randomString();
        Integer businessObjectFormatVersion = 0;
        String partitionKey = this.randomString();
        String businessObjectFormatUsage = this.randomString();
        String[] partitionValues = new String[]{this.randomString(), null, null, null, null};
        Integer businessObjectDataVersion = 0;
        this.setupDatabase(namespace, dataProviderName, businessObjectDefinitionName, fileTypeCode, businessObjectFormatUsage, businessObjectFormatVersion, businessObjectDataVersion, partitionKey, partitionValues);
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            Map<String, Object> variables = this.executeJob(namespace, businessObjectDefinitionName, businessObjectFormatUsage, fileTypeCode, partitionKey, partitionValues[0], null, "INVALID", businessObjectDataVersion.toString());
            String serviceTaskStatus = (String)variables.get(this.getServiceTaskVariableName("taskStatus"));
            Assert.assertEquals((Object)"ERROR", (Object)serviceTaskStatus);
        });
    }

    @Test
    public void test_NoSubPartitions_NoFormatVersion_NoDataVersion() throws Exception {
        String dataProviderName = this.randomString();
        String namespace = this.randomString();
        String businessObjectDefinitionName = this.randomString();
        String fileTypeCode = this.randomString();
        Integer businessObjectFormatVersion = 0;
        String partitionKey = this.randomString();
        String businessObjectFormatUsage = this.randomString();
        String[] partitionValues = new String[]{this.randomString(), null, null, null, null};
        Integer businessObjectDataVersion = 0;
        this.setupDatabase(namespace, dataProviderName, businessObjectDefinitionName, fileTypeCode, businessObjectFormatUsage, businessObjectFormatVersion, businessObjectDataVersion, partitionKey, partitionValues);
        Map<String, Object> variables = this.executeJob(namespace, businessObjectDefinitionName, businessObjectFormatUsage, fileTypeCode, partitionKey, partitionValues[0], null, null, null);
        String serviceTaskStatus = (String)variables.get(this.getServiceTaskVariableName("taskStatus"));
        Assert.assertEquals((Object)"SUCCESS", (Object)serviceTaskStatus);
        String jsonResponse = (String)variables.get(this.getServiceTaskVariableName(VARIABLE_JSON_RESPONSE));
        ObjectMapper om = new ObjectMapper();
        BusinessObjectData businessObjectData = (BusinessObjectData)om.readValue(jsonResponse.getBytes(), BusinessObjectData.class);
        Assert.assertEquals((Object)namespace, (Object)businessObjectData.getNamespace());
        Assert.assertEquals((Object)businessObjectDefinitionName, (Object)businessObjectData.getBusinessObjectDefinitionName());
        Assert.assertEquals((Object)businessObjectFormatUsage, (Object)businessObjectData.getBusinessObjectFormatUsage());
        Assert.assertEquals((Object)fileTypeCode, (Object)businessObjectData.getBusinessObjectFormatFileType());
        Assert.assertEquals((long)businessObjectFormatVersion.intValue(), (long)businessObjectData.getBusinessObjectFormatVersion());
        Assert.assertEquals((Object)partitionKey, (Object)businessObjectData.getPartitionKey());
        Assert.assertEquals((Object)partitionValues[0], (Object)businessObjectData.getPartitionValue());
        Assert.assertEquals((long)0L, (long)businessObjectData.getSubPartitionValues().size());
        Assert.assertEquals((long)businessObjectDataVersion.intValue(), (long)businessObjectData.getVersion());
        Assert.assertEquals((Object)true, (Object)businessObjectData.isLatestVersion());
        Assert.assertEquals((long)1L, (long)businessObjectData.getStorageUnits().size());
        Assert.assertEquals((long)0L, (long)businessObjectData.getAttributes().size());
        Assert.assertEquals((long)0L, (long)businessObjectData.getBusinessObjectDataParents().size());
        Assert.assertEquals((long)0L, (long)businessObjectData.getBusinessObjectDataChildren().size());
    }

    @Test
    public void test_NoSubPartitions_NoFormatVersion_NoDataVersion_InvalidPartitionKey() throws Exception {
        String dataProviderName = this.randomString();
        String namespace = this.randomString();
        String businessObjectDefinitionName = this.randomString();
        String fileTypeCode = this.randomString();
        Integer businessObjectFormatVersion = 0;
        String partitionKey = this.randomString();
        String businessObjectFormatUsage = this.randomString();
        String[] partitionValues = new String[]{this.randomString(), null, null, null, null};
        Integer businessObjectDataVersion = 0;
        this.setupDatabase(namespace, dataProviderName, businessObjectDefinitionName, fileTypeCode, businessObjectFormatUsage, businessObjectFormatVersion, businessObjectDataVersion, "INVALID", partitionValues);
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            Map<String, Object> variables = this.executeJob(namespace, businessObjectDefinitionName, businessObjectFormatUsage, fileTypeCode, partitionKey, partitionValues[0], null, null, null);
            String serviceTaskStatus = (String)variables.get(this.getServiceTaskVariableName("taskStatus"));
            Assert.assertEquals((Object)"ERROR", (Object)serviceTaskStatus);
        });
    }

    @Test
    public void test_NoSubPartitions_NoFormatVersion_NoDataVersion_NoPartitionKey() throws Exception {
        String dataProviderName = this.randomString();
        String namespace = this.randomString();
        String businessObjectDefinitionName = this.randomString();
        String fileTypeCode = this.randomString();
        Integer businessObjectFormatVersion = 0;
        String partitionKey = this.randomString();
        String businessObjectFormatUsage = this.randomString();
        String[] partitionValues = new String[]{this.randomString(), null, null, null, null};
        Integer businessObjectDataVersion = 0;
        this.setupDatabase(namespace, dataProviderName, businessObjectDefinitionName, fileTypeCode, businessObjectFormatUsage, businessObjectFormatVersion, businessObjectDataVersion, partitionKey, partitionValues);
        Map<String, Object> variables = this.executeJob(namespace, businessObjectDefinitionName, businessObjectFormatUsage, fileTypeCode, null, partitionValues[0], null, null, null);
        String serviceTaskStatus = (String)variables.get(this.getServiceTaskVariableName("taskStatus"));
        Assert.assertEquals((Object)"SUCCESS", (Object)serviceTaskStatus);
    }

    @Test
    public void test_NoSubPartitions_NoFormatVersion_NoDataVersion_NoFileType() throws Exception {
        String dataProviderName = this.randomString();
        String namespace = this.randomString();
        String businessObjectDefinitionName = this.randomString();
        String fileTypeCode = this.randomString();
        Integer businessObjectFormatVersion = 0;
        String partitionKey = this.randomString();
        String businessObjectFormatUsage = this.randomString();
        String[] partitionValues = new String[]{this.randomString(), null, null, null, null};
        Integer businessObjectDataVersion = 0;
        this.setupDatabase(namespace, dataProviderName, businessObjectDefinitionName, fileTypeCode, businessObjectFormatUsage, businessObjectFormatVersion, businessObjectDataVersion, partitionKey, partitionValues);
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            Map<String, Object> variables = this.executeJob(namespace, businessObjectDefinitionName, businessObjectFormatUsage, null, partitionKey, partitionValues[0], null, null, null);
            String serviceTaskStatus = (String)variables.get(this.getServiceTaskVariableName("taskStatus"));
            Assert.assertEquals((Object)"ERROR", (Object)serviceTaskStatus);
        });
    }

    @Test
    public void test_NoSubPartitions_NoFormatVersion_NoDataVersion_NoFormatUsage() throws Exception {
        String dataProviderName = this.randomString();
        String namespace = this.randomString();
        String businessObjectDefinitionName = this.randomString();
        String fileTypeCode = this.randomString();
        Integer businessObjectFormatVersion = 0;
        String partitionKey = this.randomString();
        String businessObjectFormatUsage = this.randomString();
        String[] partitionValues = new String[]{this.randomString(), null, null, null, null};
        Integer businessObjectDataVersion = 0;
        this.setupDatabase(namespace, dataProviderName, businessObjectDefinitionName, fileTypeCode, businessObjectFormatUsage, businessObjectFormatVersion, businessObjectDataVersion, partitionKey, partitionValues);
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            Map<String, Object> variables = this.executeJob(namespace, businessObjectDefinitionName, null, fileTypeCode, partitionKey, partitionValues[0], null, null, null);
            String serviceTaskStatus = (String)variables.get(this.getServiceTaskVariableName("taskStatus"));
            Assert.assertEquals((Object)"ERROR", (Object)serviceTaskStatus);
        });
    }

    @Test
    public void test_NoSubPartitions_NoFormatVersion_NoDataVersion_NoDefinitionName() throws Exception {
        String dataProviderName = this.randomString();
        String namespace = this.randomString();
        String businessObjectDefinitionName = this.randomString();
        String fileTypeCode = this.randomString();
        Integer businessObjectFormatVersion = 0;
        String partitionKey = this.randomString();
        String businessObjectFormatUsage = this.randomString();
        String[] partitionValues = new String[]{this.randomString(), null, null, null, null};
        Integer businessObjectDataVersion = 0;
        this.setupDatabase(namespace, dataProviderName, businessObjectDefinitionName, fileTypeCode, businessObjectFormatUsage, businessObjectFormatVersion, businessObjectDataVersion, partitionKey, partitionValues);
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            Map<String, Object> variables = this.executeJob(namespace, null, businessObjectFormatUsage, fileTypeCode, partitionKey, partitionValues[0], null, null, null);
            String serviceTaskStatus = (String)variables.get(this.getServiceTaskVariableName("taskStatus"));
            Assert.assertEquals((Object)"ERROR", (Object)serviceTaskStatus);
        });
    }

    @Test
    public void test_NoSubPartitions_NoFormatVersion_NoDataVersion_InvalidPartitionValue() throws Exception {
        String dataProviderName = this.randomString();
        String namespace = this.randomString();
        String businessObjectDefinitionName = this.randomString();
        String fileTypeCode = this.randomString();
        Integer businessObjectFormatVersion = 0;
        String partitionKey = this.randomString();
        String businessObjectFormatUsage = this.randomString();
        String[] partitionValues = new String[]{this.randomString(), null, null, null, null};
        Integer businessObjectDataVersion = 0;
        this.setupDatabase(namespace, dataProviderName, businessObjectDefinitionName, fileTypeCode, businessObjectFormatUsage, businessObjectFormatVersion, businessObjectDataVersion, partitionKey, partitionValues);
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            Map<String, Object> variables = this.executeJob(namespace, businessObjectDefinitionName, businessObjectFormatUsage, fileTypeCode, partitionKey, "INVALID", null, null, null);
            String serviceTaskStatus = (String)variables.get(this.getServiceTaskVariableName("taskStatus"));
            Assert.assertEquals((Object)"ERROR", (Object)serviceTaskStatus);
        });
    }

    @Test
    public void test_NoSubPartitions_NoFormatVersion_NoDataVersion_SubPartitionValuesAsEmptyString() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID");
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatUsage", "${businessObjectFormatUsage}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatFileType", "${businessObjectFormatFileType}"));
        fieldExtensionList.add(this.buildFieldExtension("partitionValue", "${partitionValue}"));
        fieldExtensionList.add(this.buildFieldExtension("subPartitionValues", "${subPartitionValues}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", BDEF_NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        parameters.add(this.buildParameter("businessObjectFormatUsage", FORMAT_USAGE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE));
        parameters.add(this.buildParameter("partitionValue", PARTITION_VALUE));
        parameters.add(this.buildParameter("subPartitionValues", ""));
        BusinessObjectData expectedBusinessObjectData = new BusinessObjectData(businessObjectDataEntity.getId().intValue(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION.intValue(), PARTITION_KEY, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION.intValue(), LATEST_VERSION_FLAG_SET, "VALID", NO_STORAGE_UNITS, NO_ATTRIBUTES, NO_BUSINESS_OBJECT_DATA_PARENTS, NO_BUSINESS_OBJECT_DATA_CHILDREN, NO_BUSINESS_OBJECT_DATA_STATUS_HISTORY);
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put(VARIABLE_JSON_RESPONSE, this.jsonHelper.objectToJson((Object)expectedBusinessObjectData));
        this.testActivitiServiceTaskSuccess(GetBusinessObjectData.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testGetBusinessObjectDataIncludeBusinessObjectDataStatusHistory() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID");
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("namespace", "${namespace}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatUsage", "${businessObjectFormatUsage}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatFileType", "${businessObjectFormatFileType}"));
        fieldExtensionList.add(this.buildFieldExtension("partitionValue", "${partitionValue}"));
        fieldExtensionList.add(this.buildFieldExtension("subPartitionValues", "${subPartitionValues}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataVersion", "${businessObjectDataVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataStatus", "${businessObjectDataStatus}"));
        fieldExtensionList.add(this.buildFieldExtension("includeBusinessObjectDataStatusHistory", "${includeBusinessObjectDataStatusHistory}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("namespace", BDEF_NAMESPACE));
        parameters.add(this.buildParameter("businessObjectDefinitionName", BDEF_NAME));
        parameters.add(this.buildParameter("businessObjectFormatUsage", FORMAT_USAGE_CODE));
        parameters.add(this.buildParameter("businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE));
        parameters.add(this.buildParameter("partitionValue", PARTITION_VALUE));
        parameters.add(this.buildParameter("subPartitionValues", this.herdStringHelper.buildStringWithDefaultDelimiter(SUBPARTITION_VALUES)));
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("businessObjectDataVersion", DATA_VERSION.toString()));
        parameters.add(this.buildParameter("businessObjectDataStatus", "VALID"));
        parameters.add(this.buildParameter("includeBusinessObjectDataStatusHistory", INCLUDE_BUSINESS_OBJECT_DATA_STATUS_HISTORY.toString()));
        BusinessObjectData expectedBusinessObjectData = new BusinessObjectData(businessObjectDataEntity.getId().intValue(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION.intValue(), PARTITION_KEY, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION.intValue(), LATEST_VERSION_FLAG_SET, "VALID", NO_STORAGE_UNITS, NO_ATTRIBUTES, NO_BUSINESS_OBJECT_DATA_PARENTS, NO_BUSINESS_OBJECT_DATA_CHILDREN, Arrays.asList(new BusinessObjectDataStatusChangeEvent("VALID", HerdDateUtils.getXMLGregorianCalendarValue((Date)((BusinessObjectDataStatusHistoryEntity)IterableUtils.get((Iterable)businessObjectDataEntity.getHistoricalStatuses(), (int)0)).getCreatedOn()), "SYSTEM")));
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put(VARIABLE_JSON_RESPONSE, this.jsonHelper.objectToJson((Object)expectedBusinessObjectData));
        this.testActivitiServiceTaskSuccess(GetBusinessObjectData.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testGetBusinessObjectDataInvalidIncludeBusinessObjectDataStatusHistory() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataVersion", "${businessObjectDataVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("includeBusinessObjectDataStatusHistory", "${includeBusinessObjectDataStatusHistory}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("businessObjectFormatVersion", FORMAT_VERSION.toString()));
        parameters.add(this.buildParameter("businessObjectDataVersion", DATA_VERSION.toString()));
        parameters.add(this.buildParameter("includeBusinessObjectDataStatusHistory", "NOT_A_BOOLEAN"));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskErrorMessage", "\"includeBusinessObjectDataStatusHistory\" must be a valid boolean value of \"true\" or \"false\".");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(GetBusinessObjectData.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    private String randomString() {
        return ("test" + Math.random()).substring(0, 10);
    }

    private void setupDatabase(String namespace, String dataProviderName, String businessObjectDefinitionName, String fileTypeCode, String businessObjectFormatUsage, Integer businessObjectFormatVersion, Integer businessObjectDataVersion, String partitionKey, String[] partitionValues) {
        DataProviderEntity dataProviderEntity = new DataProviderEntity();
        dataProviderEntity.setName(dataProviderName);
        this.herdDao.saveAndRefresh((Object)dataProviderEntity);
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode(namespace);
        this.herdDao.saveAndRefresh((Object)namespaceEntity);
        BusinessObjectDefinitionEntity businessObjectDefinition = new BusinessObjectDefinitionEntity();
        businessObjectDefinition.setDataProvider(dataProviderEntity);
        businessObjectDefinition.setName(businessObjectDefinitionName);
        businessObjectDefinition.setNamespace(namespaceEntity);
        this.herdDao.saveAndRefresh((Object)businessObjectDefinition);
        FileTypeEntity fileTypeEntity = new FileTypeEntity();
        fileTypeEntity.setCode(fileTypeCode);
        this.herdDao.saveAndRefresh((Object)fileTypeEntity);
        BusinessObjectFormatEntity businessObjectFormatEntity = new BusinessObjectFormatEntity();
        businessObjectFormatEntity.setBusinessObjectDefinition(businessObjectDefinition);
        businessObjectFormatEntity.setBusinessObjectFormatVersion(businessObjectFormatVersion);
        businessObjectFormatEntity.setFileType(fileTypeEntity);
        businessObjectFormatEntity.setLatestVersion(Boolean.valueOf(true));
        businessObjectFormatEntity.setNullValue("#");
        businessObjectFormatEntity.setPartitionKey(partitionKey);
        businessObjectFormatEntity.setUsage(businessObjectFormatUsage);
        this.herdDao.saveAndRefresh((Object)businessObjectFormatEntity);
        StoragePlatformEntity storagePlatformEntity = new StoragePlatformEntity();
        storagePlatformEntity.setName(this.randomString());
        this.herdDao.saveAndRefresh((Object)storagePlatformEntity);
        StorageEntity storageEntity = new StorageEntity();
        storageEntity.setName(this.randomString());
        storageEntity.setStoragePlatform(storagePlatformEntity);
        this.herdDao.saveAndRefresh((Object)storageEntity);
        BusinessObjectDataStatusEntity businessObjectDataStatusEntity = new BusinessObjectDataStatusEntity();
        businessObjectDataStatusEntity.setCode("VALID");
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        businessObjectDataEntity.setBusinessObjectFormat(businessObjectFormatEntity);
        businessObjectDataEntity.setLatestVersion(Boolean.valueOf(true));
        businessObjectDataEntity.setPartitionValue(partitionValues[0]);
        businessObjectDataEntity.setPartitionValue2(partitionValues[1]);
        businessObjectDataEntity.setPartitionValue3(partitionValues[2]);
        businessObjectDataEntity.setPartitionValue4(partitionValues[3]);
        businessObjectDataEntity.setPartitionValue5(partitionValues[4]);
        businessObjectDataEntity.setStatus(businessObjectDataStatusEntity);
        ArrayList<StorageUnitEntity> storageUnits = new ArrayList<StorageUnitEntity>();
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        storageUnitEntity.setStorage(storageEntity);
        ArrayList<StorageFileEntity> storageFiles = new ArrayList<StorageFileEntity>();
        StorageFileEntity storageFileEntity = new StorageFileEntity();
        storageFileEntity.setPath(this.randomString());
        storageFileEntity.setFileSizeBytes(Long.valueOf(1000L));
        storageFileEntity.setStorageUnit(storageUnitEntity);
        storageFiles.add(storageFileEntity);
        storageUnitEntity.setStorageFiles(storageFiles);
        storageUnitEntity.setBusinessObjectData(businessObjectDataEntity);
        storageUnitEntity.setStatus(this.storageUnitStatusDao.getStorageUnitStatusByCode("ENABLED"));
        storageUnits.add(storageUnitEntity);
        businessObjectDataEntity.setStorageUnits(storageUnits);
        businessObjectDataEntity.setVersion(businessObjectDataVersion);
        this.herdDao.saveAndRefresh((Object)businessObjectDataEntity);
    }

    private Map<String, Object> executeJob(String namespace, String businessObjectDefinitionName, String businessObjectFormatUsage, String fileTypeCode, String partitionKey, String partitionValue, String subPartitionValues, String businessObjectFormatVersion, String businessObjectDataVersion) throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        if (namespace != null) {
            fieldExtensionList.add(this.buildFieldExtension("namespace", "${businessObjectDefinitionNamespace}"));
        }
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDefinitionName", "${businessObjectDefinitionName}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatUsage", "${businessObjectFormatUsage}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatFileType", "${businessObjectFormatFileType}"));
        fieldExtensionList.add(this.buildFieldExtension("partitionKey", "${partitionKey}"));
        fieldExtensionList.add(this.buildFieldExtension("partitionValue", "${partitionValue}"));
        fieldExtensionList.add(this.buildFieldExtension("subPartitionValues", "${subPartitionValues}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectFormatVersion", "${businessObjectFormatVersion}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataVersion", "${businessObjectDataVersion}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (namespace != null) {
            parameters.add(this.buildParameter("businessObjectDefinitionNamespace", namespace));
        }
        parameters.add(this.buildParameter("businessObjectDefinitionName", businessObjectDefinitionName));
        parameters.add(this.buildParameter("businessObjectFormatUsage", businessObjectFormatUsage));
        parameters.add(this.buildParameter("businessObjectFormatFileType", fileTypeCode));
        parameters.add(this.buildParameter("partitionKey", partitionKey));
        parameters.add(this.buildParameter("partitionValue", partitionValue));
        parameters.add(this.buildParameter("subPartitionValues", subPartitionValues));
        parameters.add(this.buildParameter("businessObjectFormatVersion", businessObjectFormatVersion));
        parameters.add(this.buildParameter("businessObjectDataVersion", businessObjectDataVersion));
        String activitiXml = this.buildActivitiXml(IMPLEMENTATION, fieldExtensionList);
        Job job = this.jobServiceTestHelper.createJobForCreateClusterForActivitiXml(activitiXml, parameters);
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        return hisInstance.getProcessVariables();
    }

    private String buildDelimitedSubPartitionValues(String[] partitionValues) {
        if (partitionValues.length <= 1) {
            throw new IllegalArgumentException("partitionValues.length must be greater than 1");
        }
        StringBuilder subPartitionValuesBuilder = new StringBuilder();
        for (int i = 1; i < partitionValues.length; ++i) {
            if (i > 1) {
                subPartitionValuesBuilder.append('|');
            }
            String partitionValue = partitionValues[i];
            partitionValue = partitionValue.replaceAll(PATTERN_DELIMITER, DELIMITER_ESCAPE);
            subPartitionValuesBuilder.append(partitionValue);
        }
        return subPartitionValuesBuilder.toString();
    }
}

