/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.FieldExtension;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.model.jpa.PartitionKeyGroupEntity;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.finra.herd.service.activiti.task.GetExpectedPartitionValue;
import org.finra.herd.service.activiti.task.HerdActivitiServiceTaskTest;
import org.junit.Test;

public class GetExpectedPartitionValueTest
extends HerdActivitiServiceTaskTest {
    private static final Integer TEST_EXPECTED_PARTITION_VALUE_INDEX = 3;
    private static final Integer TEST_OFFSET = -2;

    @Test
    public void testGetExpectedPartitionValue() throws Exception {
        PartitionKeyGroupEntity partitionKeyGroupEntity = this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueEntities(partitionKeyGroupEntity, this.expectedPartitionValueDaoTestHelper.getTestUnsortedExpectedPartitionValues());
        List testSortedExpectedPartitionValues = this.expectedPartitionValueDaoTestHelper.getTestSortedExpectedPartitionValues();
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("partitionKeyGroupName", "${partitionKeyGroupName}"));
        fieldExtensionList.add(this.buildFieldExtension("expectedPartitionValue", "${expectedPartitionValue}"));
        fieldExtensionList.add(this.buildFieldExtension("offset", "${offset}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("partitionKeyGroupName", PARTITION_KEY_GROUP));
        parameters.add(this.buildParameter("expectedPartitionValue", (String)testSortedExpectedPartitionValues.get(TEST_EXPECTED_PARTITION_VALUE_INDEX)));
        parameters.add(this.buildParameter("offset", TEST_OFFSET.toString()));
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("partitionKeyGroupName", PARTITION_KEY_GROUP);
        variableValuesToValidate.put("expectedPartitionValue", testSortedExpectedPartitionValues.get(TEST_EXPECTED_PARTITION_VALUE_INDEX + TEST_OFFSET));
        this.testActivitiServiceTaskSuccess(GetExpectedPartitionValue.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testGetExpectedPartitionValueMissingOptionalParameters() throws Exception {
        PartitionKeyGroupEntity partitionKeyGroupEntity = this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueEntities(partitionKeyGroupEntity, this.expectedPartitionValueDaoTestHelper.getTestUnsortedExpectedPartitionValues());
        List testSortedExpectedPartitionValues = this.expectedPartitionValueDaoTestHelper.getTestSortedExpectedPartitionValues();
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("partitionKeyGroupName", "${partitionKeyGroupName}"));
        fieldExtensionList.add(this.buildFieldExtension("expectedPartitionValue", "${expectedPartitionValue}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("partitionKeyGroupName", PARTITION_KEY_GROUP));
        parameters.add(this.buildParameter("expectedPartitionValue", (String)testSortedExpectedPartitionValues.get(TEST_EXPECTED_PARTITION_VALUE_INDEX)));
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("partitionKeyGroupName", PARTITION_KEY_GROUP);
        variableValuesToValidate.put("expectedPartitionValue", testSortedExpectedPartitionValues.get(TEST_EXPECTED_PARTITION_VALUE_INDEX));
        this.testActivitiServiceTaskSuccess(GetExpectedPartitionValue.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testGetExpectedPartitionValueMissingPartitionKeyGroupName() throws Exception {
        ArrayList fieldExtensionList = new ArrayList();
        ArrayList parameters = new ArrayList();
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
            variableValuesToValidate.put("taskErrorMessage", "A partition key group name must be specified.");
            this.testActivitiServiceTaskFailure(GetExpectedPartitionValue.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
        });
    }

    @Test
    public void testGetExpectedPartitionValueInvalidOffset() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("offset", "${offset}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("offset", "INVALID_INTEGER_VALUE"));
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
            variableValuesToValidate.put("taskErrorMessage", String.format("\"%s\" must be a valid integer value.", "offset"));
            this.testActivitiServiceTaskFailure(GetExpectedPartitionValue.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
        });
    }

    @Test
    public void testGetExpectedPartitionValuePartitionKeyGroupNoExists() throws Exception {
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("partitionKeyGroupName", "${partitionKeyGroupName}"));
        fieldExtensionList.add(this.buildFieldExtension("expectedPartitionValue", "${expectedPartitionValue}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("partitionKeyGroupName", PARTITION_KEY_GROUP));
        parameters.add(this.buildParameter("expectedPartitionValue", STRING_VALUE));
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
            variableValuesToValidate.put("taskErrorMessage", String.format("Partition key group \"%s\" doesn't exist.", PARTITION_KEY_GROUP));
            this.testActivitiServiceTaskFailure(GetExpectedPartitionValue.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
        });
    }

    @Test
    public void testGetExpectedPartitionValueExpectedPartitionValueNoExists() throws Exception {
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("partitionKeyGroupName", "${partitionKeyGroupName}"));
        fieldExtensionList.add(this.buildFieldExtension("expectedPartitionValue", "${expectedPartitionValue}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("partitionKeyGroupName", PARTITION_KEY_GROUP));
        parameters.add(this.buildParameter("expectedPartitionValue", STRING_VALUE));
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
            variableValuesToValidate.put("taskErrorMessage", String.format("Expected partition value \"%s\" doesn't exist in \"%s\" partition key group.", STRING_VALUE, PARTITION_KEY_GROUP));
            this.testActivitiServiceTaskFailure(GetExpectedPartitionValue.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
        });
    }
}

