/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.HashMap;
import org.activiti.bpmn.model.FieldExtension;
import org.finra.herd.model.api.xml.BusinessObjectDataInvalidateUnregisteredRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataInvalidateUnregisteredResponse;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.finra.herd.service.activiti.task.HerdActivitiServiceTaskTest;
import org.finra.herd.service.activiti.task.InvalidateUnregisteredBusinessObjectData;
import org.junit.Test;

public class InvalidateUnregisteredBusinessObjectDataTest
extends HerdActivitiServiceTaskTest {
    @Test
    public void testInvalidateUnregisteredBusinessObjectDataSuccessXml() throws Exception {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        BusinessObjectDataInvalidateUnregisteredResponse expectedResponse = this.getExpectedBusinessObjectDataInvalidateUnregisteredResponse(request);
        this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataInvalidateUnregisteredRequest", "${businessObjectDataInvalidateUnregisteredRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "xml"));
        parameters.add(this.buildParameter("businessObjectDataInvalidateUnregisteredRequest", this.xmlHelper.objectToXml((Object)request)));
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("taskStatus", "SUCCESS");
        variableValuesToValidate.put("taskErrorMessage", "IS_NULL");
        variableValuesToValidate.put("jsonResponse", this.jsonHelper.objectToJson((Object)expectedResponse));
        this.testActivitiServiceTaskSuccess(InvalidateUnregisteredBusinessObjectData.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataSuccessJson() throws Exception {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        BusinessObjectDataInvalidateUnregisteredResponse expectedResponse = this.getExpectedBusinessObjectDataInvalidateUnregisteredResponse(request);
        this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataInvalidateUnregisteredRequest", "${businessObjectDataInvalidateUnregisteredRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "json"));
        parameters.add(this.buildParameter("businessObjectDataInvalidateUnregisteredRequest", this.jsonHelper.objectToJson((Object)request)));
        HashMap<String, Object> variableValuesToValidate = new HashMap<String, Object>();
        variableValuesToValidate.put("taskStatus", "SUCCESS");
        variableValuesToValidate.put("taskErrorMessage", "IS_NULL");
        variableValuesToValidate.put("jsonResponse", this.jsonHelper.objectToJson((Object)expectedResponse));
        this.testActivitiServiceTaskSuccess(InvalidateUnregisteredBusinessObjectData.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate);
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataError() throws Exception {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
        fieldExtensionList.add(this.buildFieldExtension("contentType", "${contentType}"));
        fieldExtensionList.add(this.buildFieldExtension("businessObjectDataInvalidateUnregisteredRequest", "${businessObjectDataInvalidateUnregisteredRequest}"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.buildParameter("contentType", "xml"));
        parameters.add(this.buildParameter("businessObjectDataInvalidateUnregisteredRequest", this.xmlHelper.objectToXml((Object)request)));
        HashMap<String, String> variableValuesToValidate = new HashMap<String, String>();
        variableValuesToValidate.put("taskStatus", "ERROR");
        variableValuesToValidate.put("taskErrorMessage", "Business object format with namespace \"" + request.getNamespace() + "\", business object definition name \"" + request.getBusinessObjectDefinitionName() + "\", format usage \"" + request.getBusinessObjectFormatUsage() + "\", format file type \"" + request.getBusinessObjectFormatFileType() + "\", and format version \"" + request.getBusinessObjectFormatVersion() + "\" doesn't exist.");
        variableValuesToValidate.put("jsonResponse", "IS_NULL");
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> this.testActivitiServiceTaskFailure(InvalidateUnregisteredBusinessObjectData.class.getCanonicalName(), fieldExtensionList, parameters, variableValuesToValidate));
    }

    private BusinessObjectDataInvalidateUnregisteredResponse getExpectedBusinessObjectDataInvalidateUnregisteredResponse(BusinessObjectDataInvalidateUnregisteredRequest request) {
        BusinessObjectDataInvalidateUnregisteredResponse expectedResponse = new BusinessObjectDataInvalidateUnregisteredResponse();
        expectedResponse.setNamespace(request.getNamespace());
        expectedResponse.setBusinessObjectDefinitionName(request.getBusinessObjectDefinitionName());
        expectedResponse.setBusinessObjectFormatUsage(request.getBusinessObjectFormatUsage());
        expectedResponse.setBusinessObjectFormatFileType(request.getBusinessObjectFormatFileType());
        expectedResponse.setBusinessObjectFormatVersion(request.getBusinessObjectFormatVersion());
        expectedResponse.setPartitionValue(request.getPartitionValue());
        expectedResponse.setSubPartitionValues(request.getSubPartitionValues());
        expectedResponse.setStorageName(request.getStorageName());
        expectedResponse.setRegisteredBusinessObjectDataList(new ArrayList());
        return expectedResponse;
    }
}

