/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.activiti.task;

import java.util.ArrayList;
import java.util.Map;
import org.activiti.engine.history.HistoricProcessInstance;
import org.finra.herd.dao.impl.MockAwsOperationsHelper;
import org.finra.herd.model.api.xml.Job;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.model.api.xml.RunOozieWorkflowRequest;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.activiti.ActivitiRuntimeHelper;
import org.junit.Assert;
import org.junit.Test;

public class RunOozieWorkflowTest
extends AbstractServiceTest {
    @Test
    public void testRunOozieWorkflowXml() throws Exception {
        String clusterName = "testCluster" + Math.random();
        RunOozieWorkflowRequest runOozieRequest = new RunOozieWorkflowRequest("testNamespace", EMR_CLUSTER_DEFINITION_NAME, clusterName, OOZIE_WORKFLOW_LOCATION, null, null);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("clusterName", clusterName));
        parameters.add(new Parameter("contentType", "xml"));
        parameters.add(new Parameter("runOozieWorkflowRequest", this.xmlHelper.objectToXml((Object)runOozieRequest)));
        Job job = this.jobServiceTestHelper.createJobForCreateCluster("classpath:org/finra/herd/service/activitiWorkflowRunOozieJob.bpmn20.xml", parameters, MockAwsOperationsHelper.AMAZON_CLUSTER_STATUS_WAITING);
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        Map variables = hisInstance.getProcessVariables();
        String oozieJobTaskStatus = (String)variables.get("runOozieWorkflowTask_taskStatus");
        String oozieJobId = (String)variables.get("runOozieWorkflowTask_id");
        Assert.assertEquals((Object)oozieJobTaskStatus, (Object)"SUCCESS");
        Assert.assertNotNull((Object)oozieJobId);
    }

    @Test
    public void testRunOozieWorkflowJson() throws Exception {
        String clusterName = "testCluster" + Math.random();
        RunOozieWorkflowRequest runOozieRequest = new RunOozieWorkflowRequest("testNamespace", EMR_CLUSTER_DEFINITION_NAME, clusterName, OOZIE_WORKFLOW_LOCATION, null, null);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("clusterName", clusterName));
        parameters.add(new Parameter("contentType", "json"));
        parameters.add(new Parameter("runOozieWorkflowRequest", this.jsonHelper.objectToJson((Object)runOozieRequest)));
        Job job = this.jobServiceTestHelper.createJobForCreateCluster("classpath:org/finra/herd/service/activitiWorkflowRunOozieJob.bpmn20.xml", parameters, MockAwsOperationsHelper.AMAZON_CLUSTER_STATUS_WAITING);
        Assert.assertNotNull((Object)job);
        HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
        Map variables = hisInstance.getProcessVariables();
        String oozieJobTaskStatus = (String)variables.get("runOozieWorkflowTask_taskStatus");
        String oozieJobId = (String)variables.get("runOozieWorkflowTask_id");
        Assert.assertEquals((Object)oozieJobTaskStatus, (Object)"SUCCESS");
        Assert.assertNotNull((Object)oozieJobId);
    }

    @Test
    public void testRunOozieWorkflowWrongContentType() throws Exception {
        String clusterName = "testCluster" + Math.random();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("clusterName", clusterName));
        parameters.add(new Parameter("contentType", "wrong_content_type"));
        parameters.add(new Parameter("runOozieWorkflowRequest", "some_request"));
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            Job job = this.jobServiceTestHelper.createJobForCreateCluster("classpath:org/finra/herd/service/activitiWorkflowRunOozieJob.bpmn20.xml", parameters, MockAwsOperationsHelper.AMAZON_CLUSTER_STATUS_WAITING);
            Assert.assertNotNull((Object)job);
            HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
            Map variables = hisInstance.getProcessVariables();
            String oozieJobTaskStatus = (String)variables.get("runOozieWorkflowTask_taskStatus");
            String oozieJobId = (String)variables.get("runOozieWorkflowTask_id");
            Assert.assertEquals((Object)oozieJobTaskStatus, (Object)"ERROR");
            Assert.assertNull((Object)oozieJobId);
        });
    }

    @Test
    public void testRunOozieWorkflowNoRequest() throws Exception {
        String clusterName = "testCluster" + Math.random();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("clusterName", clusterName));
        parameters.add(new Parameter("contentType", "xml"));
        parameters.add(new Parameter("runOozieWorkflowRequest", ""));
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            Job job = this.jobServiceTestHelper.createJobForCreateCluster("classpath:org/finra/herd/service/activitiWorkflowRunOozieJob.bpmn20.xml", parameters, MockAwsOperationsHelper.AMAZON_CLUSTER_STATUS_WAITING);
            Assert.assertNotNull((Object)job);
            HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
            Map variables = hisInstance.getProcessVariables();
            String oozieJobTaskStatus = (String)variables.get("runOozieWorkflowTask_taskStatus");
            String oozieJobId = (String)variables.get("runOozieWorkflowTask_id");
            Assert.assertEquals((Object)oozieJobTaskStatus, (Object)"ERROR");
            Assert.assertNull((Object)oozieJobId);
        });
    }

    @Test
    public void testRunOozieWorkflowWrongXmlRequest() throws Exception {
        String clusterName = "testCluster" + Math.random();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("clusterName", clusterName));
        parameters.add(new Parameter("contentType", "xml"));
        parameters.add(new Parameter("runOozieWorkflowRequest", "wrong_xml_request"));
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            Job job = this.jobServiceTestHelper.createJobForCreateCluster("classpath:org/finra/herd/service/activitiWorkflowRunOozieJob.bpmn20.xml", parameters, MockAwsOperationsHelper.AMAZON_CLUSTER_STATUS_WAITING);
            Assert.assertNotNull((Object)job);
            HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
            Map variables = hisInstance.getProcessVariables();
            String oozieJobTaskStatus = (String)variables.get("runOozieWorkflowTask_taskStatus");
            String oozieJobId = (String)variables.get("runOozieWorkflowTask_id");
            Assert.assertEquals((Object)oozieJobTaskStatus, (Object)"ERROR");
            Assert.assertNull((Object)oozieJobId);
        });
    }

    @Test
    public void testRunOozieWorkflowWrongJsonRequest() throws Exception {
        String clusterName = "testCluster" + Math.random();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("clusterName", clusterName));
        parameters.add(new Parameter("contentType", "json"));
        parameters.add(new Parameter("runOozieWorkflowRequest", "wrong_json_request"));
        this.executeWithoutLogging(ActivitiRuntimeHelper.class, () -> {
            Job job = this.jobServiceTestHelper.createJobForCreateCluster("classpath:org/finra/herd/service/activitiWorkflowRunOozieJob.bpmn20.xml", parameters, MockAwsOperationsHelper.AMAZON_CLUSTER_STATUS_WAITING);
            Assert.assertNotNull((Object)job);
            HistoricProcessInstance hisInstance = (HistoricProcessInstance)this.activitiHistoryService.createHistoricProcessInstanceQuery().processInstanceId(job.getId()).includeProcessVariables().singleResult();
            Map variables = hisInstance.getProcessVariables();
            String oozieJobTaskStatus = (String)variables.get("runOozieWorkflowTask_taskStatus");
            String oozieJobId = (String)variables.get("runOozieWorkflowTask_id");
            Assert.assertEquals((Object)oozieJobTaskStatus, (Object)"ERROR");
            Assert.assertNull((Object)oozieJobId);
        });
    }
}

