/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.advice;

import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.finra.herd.core.helper.LogLevel;
import org.finra.herd.model.annotation.PublishJmsMessages;
import org.finra.herd.model.dto.JmsMessage;
import org.finra.herd.model.jpa.JmsMessageEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.advice.PublishJmsMessagesAdvice;
import org.finra.herd.service.helper.JmsMessageInMemoryQueue;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

public class PublishJmsMessagesAdviceTest
extends AbstractServiceTest {
    @Autowired
    private JmsMessageInMemoryQueue jmsMessageInMemoryQueue;
    @Autowired
    private PublishJmsMessagesAdvice publishJmsMessagesAdvice;

    @Test
    public void testPublishJmsMessages() throws Throwable {
        JmsMessage jmsMessage = new JmsMessage(SQS_QUEUE_NAME, MESSAGE_TEXT);
        Assert.assertTrue((boolean)this.jmsMessageInMemoryQueue.isEmpty());
        this.jmsMessageInMemoryQueue.add(jmsMessage);
        Assert.assertEquals((long)1L, (long)this.jmsMessageInMemoryQueue.size());
        Assert.assertNull((Object)this.jmsMessageDao.getOldestJmsMessage());
        ProceedingJoinPoint joinPoint = this.getMockedProceedingJoinPoint("testPublishJmsMessages");
        this.publishJmsMessagesAdvice.publishJmsMessages(joinPoint);
        Assert.assertTrue((boolean)this.jmsMessageInMemoryQueue.isEmpty());
        Assert.assertNull((Object)this.jmsMessageDao.getOldestJmsMessage());
    }

    @Test
    public void testPublishJmsMessagesDebugEnabled() throws Throwable {
        LogLevel originalLevel = this.getLogLevel(PublishJmsMessagesAdvice.class);
        try {
            this.setLogLevel(PublishJmsMessagesAdvice.class, LogLevel.DEBUG);
            this.testPublishJmsMessages();
        }
        finally {
            this.setLogLevel(PublishJmsMessagesAdvice.class, originalLevel);
        }
    }

    @Test
    public void testPublishJmsMessagesAwsServiceException() throws Throwable {
        JmsMessage jmsMessage = new JmsMessage("mock_sqs_queue_not_found_name", MESSAGE_TEXT);
        Assert.assertTrue((boolean)this.jmsMessageInMemoryQueue.isEmpty());
        this.jmsMessageInMemoryQueue.add(jmsMessage);
        Assert.assertEquals((long)1L, (long)this.jmsMessageInMemoryQueue.size());
        Assert.assertNull((Object)this.jmsMessageDao.getOldestJmsMessage());
        ProceedingJoinPoint joinPoint = this.getMockedProceedingJoinPoint("testPublishJmsMessagesAwsServiceException");
        this.publishJmsMessagesAdvice.publishJmsMessages(joinPoint);
        Assert.assertTrue((boolean)this.jmsMessageInMemoryQueue.isEmpty());
        JmsMessageEntity jmsMessageEntity = this.jmsMessageDao.getOldestJmsMessage();
        Assert.assertNotNull((Object)jmsMessageEntity);
        Assert.assertEquals((Object)"mock_sqs_queue_not_found_name", (Object)jmsMessageEntity.getJmsQueueName());
        Assert.assertEquals((Object)MESSAGE_TEXT, (Object)jmsMessageEntity.getMessageText());
    }

    private ProceedingJoinPoint getMockedProceedingJoinPoint(String methodName) throws Exception {
        ProceedingJoinPoint joinPoint = (ProceedingJoinPoint)Mockito.mock(ProceedingJoinPoint.class);
        MethodSignature methodSignature = (MethodSignature)Mockito.mock(MethodSignature.class);
        Method method = PublishJmsMessagesAdviceTest.class.getDeclaredMethod("mockMethod", new Class[0]);
        Mockito.when((Object)joinPoint.getTarget()).thenReturn((Object)new PublishJmsMessagesAdviceTest());
        Mockito.when((Object)joinPoint.getSignature()).thenReturn((Object)methodSignature);
        Mockito.when((Object)methodSignature.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)methodSignature.getName()).thenReturn((Object)methodName);
        return joinPoint;
    }

    @PublishJmsMessages
    private void mockMethod() {
    }
}

