/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import java.util.ArrayList;
import java.util.Arrays;
import org.finra.herd.dao.S3Operations;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectData;
import org.finra.herd.model.api.xml.BusinessObjectDataInvalidateUnregisteredRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataInvalidateUnregisteredResponse;
import org.finra.herd.model.api.xml.StorageUnit;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class BusinessObjectDataInvalidateUnregisteredHelperTest
extends AbstractServiceTest {
    @Autowired
    private S3Operations s3Operations;

    @Override
    @After
    public void after() {
        this.s3Operations.rollback();
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataS30Herd0() throws Exception {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        try {
            this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Test failed during setup. Most likely setup or developer error.", e);
        }
        BusinessObjectDataInvalidateUnregisteredResponse actualResponse = this.businessObjectDataInvalidateUnregisteredHelper.invalidateUnregisteredBusinessObjectData(request);
        Assert.assertNotNull((String)"response is null", (Object)actualResponse);
        Assert.assertEquals((String)"response namespace", (Object)request.getNamespace(), (Object)actualResponse.getNamespace());
        Assert.assertEquals((String)"response business object definition name", (Object)request.getBusinessObjectDefinitionName(), (Object)actualResponse.getBusinessObjectDefinitionName());
        Assert.assertEquals((String)"response business object format usage", (Object)request.getBusinessObjectFormatUsage(), (Object)actualResponse.getBusinessObjectFormatUsage());
        Assert.assertEquals((String)"response business object format file type", (Object)request.getBusinessObjectFormatFileType(), (Object)actualResponse.getBusinessObjectFormatFileType());
        Assert.assertEquals((String)"response business object format version", (Object)request.getBusinessObjectFormatVersion(), (Object)actualResponse.getBusinessObjectFormatVersion());
        Assert.assertEquals((String)"response partition value", (Object)request.getPartitionValue(), (Object)actualResponse.getPartitionValue());
        Assert.assertEquals((String)"response sub-partition values", (Object)request.getSubPartitionValues(), (Object)actualResponse.getSubPartitionValues());
        Assert.assertEquals((String)"response storage name", (Object)request.getStorageName(), (Object)actualResponse.getStorageName());
        Assert.assertNotNull((String)"response business object datas is null", (Object)actualResponse.getRegisteredBusinessObjectDataList());
        Assert.assertEquals((String)"response business object datas size", (long)0L, (long)actualResponse.getRegisteredBusinessObjectDataList().size());
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataS31Herd1() throws Exception {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        try {
            BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
            this.businessObjectDataServiceTestHelper.createS3Object(businessObjectFormatEntity, request, 0);
            this.createBusinessObjectDataEntityFromBusinessObjectDataInvalidateUnregisteredRequest(businessObjectFormatEntity, request, 0, true);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Test failed during setup. Most likely setup or developer error.", e);
        }
        BusinessObjectDataInvalidateUnregisteredResponse actualResponse = this.businessObjectDataInvalidateUnregisteredHelper.invalidateUnregisteredBusinessObjectData(request);
        Assert.assertNotNull((String)"response business object datas is null", (Object)actualResponse.getRegisteredBusinessObjectDataList());
        Assert.assertEquals((String)"response business object datas size", (long)0L, (long)actualResponse.getRegisteredBusinessObjectDataList().size());
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataS31Herd0() throws Exception {
        BusinessObjectFormatEntity businessObjectFormatEntity;
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        try {
            businessObjectFormatEntity = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
            this.businessObjectDataServiceTestHelper.createS3Object(businessObjectFormatEntity, request, 0);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Test failed during setup. Most likely setup or developer error.", e);
        }
        BusinessObjectDataInvalidateUnregisteredResponse actualResponse = this.businessObjectDataInvalidateUnregisteredHelper.invalidateUnregisteredBusinessObjectData(request);
        Assert.assertNotNull((String)"response business object datas is null", (Object)actualResponse.getRegisteredBusinessObjectDataList());
        Assert.assertEquals((String)"response business object datas size", (long)1L, (long)actualResponse.getRegisteredBusinessObjectDataList().size());
        BusinessObjectData businessObjectData = (BusinessObjectData)actualResponse.getRegisteredBusinessObjectDataList().get(0);
        Assert.assertEquals((String)"response business object data[0] version", (long)0L, (long)businessObjectData.getVersion());
        Assert.assertEquals((String)"response business object data[0] status", (Object)"INVALID", (Object)businessObjectData.getStatus());
        Assert.assertNotNull((String)"response business object data[0] storage units is null", (Object)businessObjectData.getStorageUnits());
        Assert.assertEquals((String)"response business object data[0] storage units size", (long)1L, (long)businessObjectData.getStorageUnits().size());
        String expectedS3KeyPrefix = this.s3KeyPrefixHelper.buildS3KeyPrefix("$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end", businessObjectFormatEntity, this.businessObjectDataHelper.createBusinessObjectDataKey(businessObjectData), STORAGE_NAME);
        StorageUnit storageUnit = (StorageUnit)businessObjectData.getStorageUnits().get(0);
        Assert.assertNotNull((String)"response business object data[0] storage unit[0] storage directory is null", (Object)storageUnit.getStorageDirectory());
        Assert.assertEquals((String)"response business object data[0] storage unit[0] storage directory path", (Object)expectedS3KeyPrefix, (Object)storageUnit.getStorageDirectory().getDirectoryPath());
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataS31Herd0WithSubPartitions() throws Exception {
        BusinessObjectFormatEntity businessObjectFormatEntity;
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, "S3_MANAGED");
        try {
            businessObjectFormatEntity = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
            this.businessObjectDataServiceTestHelper.createS3Object(businessObjectFormatEntity, request, 0);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Test failed during setup. Most likely setup or developer error.", e);
        }
        BusinessObjectDataInvalidateUnregisteredResponse actualResponse = this.businessObjectDataInvalidateUnregisteredHelper.invalidateUnregisteredBusinessObjectData(request);
        Assert.assertNotNull((String)"response sub-partition values is null", (Object)actualResponse.getSubPartitionValues());
        Assert.assertEquals((String)"response sub-partition values", (Object)request.getSubPartitionValues(), (Object)actualResponse.getSubPartitionValues());
        Assert.assertNotNull((String)"response business object datas is null", (Object)actualResponse.getRegisteredBusinessObjectDataList());
        Assert.assertEquals((String)"response business object datas size", (long)1L, (long)actualResponse.getRegisteredBusinessObjectDataList().size());
        BusinessObjectData businessObjectData = (BusinessObjectData)actualResponse.getRegisteredBusinessObjectDataList().get(0);
        Assert.assertEquals((String)"response business object data[0] version", (long)0L, (long)businessObjectData.getVersion());
        Assert.assertEquals((String)"response business object data[0] status", (Object)"INVALID", (Object)businessObjectData.getStatus());
        Assert.assertNotNull((String)"response business object data[0] storage units is null", (Object)businessObjectData.getStorageUnits());
        Assert.assertEquals((String)"response business object data[0] storage units size", (long)1L, (long)businessObjectData.getStorageUnits().size());
        String expectedS3KeyPrefix = this.s3KeyPrefixHelper.buildS3KeyPrefix("$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end", businessObjectFormatEntity, this.businessObjectDataHelper.createBusinessObjectDataKey(businessObjectData), STORAGE_NAME);
        StorageUnit storageUnit = (StorageUnit)businessObjectData.getStorageUnits().get(0);
        Assert.assertNotNull((String)"response business object data[0] storage unit[0] storage directory is null", (Object)storageUnit.getStorageDirectory());
        Assert.assertEquals((String)"response business object data[0] storage unit[0] storage directory path", (Object)expectedS3KeyPrefix, (Object)storageUnit.getStorageDirectory().getDirectoryPath());
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataS32Herd1() throws Exception {
        BusinessObjectFormatEntity businessObjectFormatEntity;
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        try {
            businessObjectFormatEntity = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
            this.createBusinessObjectDataEntityFromBusinessObjectDataInvalidateUnregisteredRequest(businessObjectFormatEntity, request, 0, true);
            this.businessObjectDataServiceTestHelper.createS3Object(businessObjectFormatEntity, request, 0);
            this.businessObjectDataServiceTestHelper.createS3Object(businessObjectFormatEntity, request, 1);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Test failed during setup. Most likely setup or developer error.", e);
        }
        BusinessObjectDataInvalidateUnregisteredResponse actualResponse = this.businessObjectDataInvalidateUnregisteredHelper.invalidateUnregisteredBusinessObjectData(request);
        Assert.assertNotNull((String)"response business object datas is null", (Object)actualResponse.getRegisteredBusinessObjectDataList());
        Assert.assertEquals((String)"response business object datas size", (long)1L, (long)actualResponse.getRegisteredBusinessObjectDataList().size());
        BusinessObjectData businessObjectData = (BusinessObjectData)actualResponse.getRegisteredBusinessObjectDataList().get(0);
        Assert.assertEquals((String)"response business object data[0] version", (long)1L, (long)businessObjectData.getVersion());
        Assert.assertEquals((String)"response business object data[0] status", (Object)"INVALID", (Object)businessObjectData.getStatus());
        Assert.assertNotNull((String)"response business object data[0] storage units is null", (Object)businessObjectData.getStorageUnits());
        Assert.assertEquals((String)"response business object data[0] storage units size", (long)1L, (long)businessObjectData.getStorageUnits().size());
        String expectedS3KeyPrefix = this.s3KeyPrefixHelper.buildS3KeyPrefix("$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end", businessObjectFormatEntity, this.businessObjectDataHelper.createBusinessObjectDataKey(businessObjectData), STORAGE_NAME);
        StorageUnit storageUnit = (StorageUnit)businessObjectData.getStorageUnits().get(0);
        Assert.assertNotNull((String)"response business object data[0] storage unit[0] storage directory is null", (Object)storageUnit.getStorageDirectory());
        Assert.assertEquals((String)"response business object data[0] storage unit[0] storage directory path", (Object)expectedS3KeyPrefix, (Object)storageUnit.getStorageDirectory().getDirectoryPath());
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataS32Herd0() throws Exception {
        BusinessObjectFormatEntity businessObjectFormatEntity;
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        try {
            businessObjectFormatEntity = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
            this.businessObjectDataServiceTestHelper.createS3Object(businessObjectFormatEntity, request, 0);
            this.businessObjectDataServiceTestHelper.createS3Object(businessObjectFormatEntity, request, 1);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Test failed during setup. Most likely setup or developer error.", e);
        }
        BusinessObjectDataInvalidateUnregisteredResponse actualResponse = this.businessObjectDataInvalidateUnregisteredHelper.invalidateUnregisteredBusinessObjectData(request);
        Assert.assertNotNull((String)"response business object datas is null", (Object)actualResponse.getRegisteredBusinessObjectDataList());
        Assert.assertEquals((String)"response business object datas size", (long)2L, (long)actualResponse.getRegisteredBusinessObjectDataList().size());
        BusinessObjectData businessObjectData = (BusinessObjectData)actualResponse.getRegisteredBusinessObjectDataList().get(0);
        Assert.assertEquals((String)"response business object data[0] version", (long)0L, (long)businessObjectData.getVersion());
        Assert.assertEquals((String)"response business object data[0] status", (Object)"INVALID", (Object)businessObjectData.getStatus());
        Assert.assertNotNull((String)"response business object data[0] storage units is null", (Object)businessObjectData.getStorageUnits());
        Assert.assertEquals((String)"response business object data[0] storage units size", (long)1L, (long)businessObjectData.getStorageUnits().size());
        String expectedS3KeyPrefix = this.s3KeyPrefixHelper.buildS3KeyPrefix("$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end", businessObjectFormatEntity, this.businessObjectDataHelper.createBusinessObjectDataKey(businessObjectData), STORAGE_NAME);
        StorageUnit storageUnit = (StorageUnit)businessObjectData.getStorageUnits().get(0);
        Assert.assertNotNull((String)"response business object data[0] storage unit[0] storage directory is null", (Object)storageUnit.getStorageDirectory());
        Assert.assertEquals((String)"response business object data[0] storage unit[0] storage directory path", (Object)expectedS3KeyPrefix, (Object)storageUnit.getStorageDirectory().getDirectoryPath());
        businessObjectData = (BusinessObjectData)actualResponse.getRegisteredBusinessObjectDataList().get(1);
        Assert.assertEquals((String)"response business object data[1] version", (long)1L, (long)businessObjectData.getVersion());
        Assert.assertEquals((String)"response business object data[1] status", (Object)"INVALID", (Object)businessObjectData.getStatus());
        Assert.assertNotNull((String)"response business object data[1] storage units is null", (Object)businessObjectData.getStorageUnits());
        Assert.assertEquals((String)"response business object data[1] storage units size", (long)1L, (long)businessObjectData.getStorageUnits().size());
        expectedS3KeyPrefix = this.s3KeyPrefixHelper.buildS3KeyPrefix("$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end", businessObjectFormatEntity, this.businessObjectDataHelper.createBusinessObjectDataKey(businessObjectData), STORAGE_NAME);
        storageUnit = (StorageUnit)businessObjectData.getStorageUnits().get(0);
        Assert.assertNotNull((String)"response business object data[1] storage unit[0] storage directory is null", (Object)storageUnit.getStorageDirectory());
        Assert.assertEquals((String)"response business object data[1] storage unit[0] storage directory path", (Object)expectedS3KeyPrefix, (Object)storageUnit.getStorageDirectory().getDirectoryPath());
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataS31Herd0WithGap() {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, "S3_MANAGED");
        try {
            BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
            this.businessObjectDataServiceTestHelper.createS3Object(businessObjectFormatEntity, request, 1);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Test failed during setup. Most likely setup or developer error.", e);
        }
        BusinessObjectDataInvalidateUnregisteredResponse actualResponse = this.businessObjectDataInvalidateUnregisteredHelper.invalidateUnregisteredBusinessObjectData(request);
        Assert.assertNotNull((String)"response business object datas is null", (Object)actualResponse.getRegisteredBusinessObjectDataList());
        Assert.assertEquals((String)"response business object datas size", (long)0L, (long)actualResponse.getRegisteredBusinessObjectDataList().size());
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataS3PrefixWithSlash() throws Exception {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        try {
            BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
            request.setPartitionValue("AA");
            this.businessObjectDataServiceTestHelper.createS3Object(businessObjectFormatEntity, request, 0);
            request.setPartitionValue("A");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Test failed during setup. Most likely setup or developer error.", e);
        }
        BusinessObjectDataInvalidateUnregisteredResponse actualResponse = this.businessObjectDataInvalidateUnregisteredHelper.invalidateUnregisteredBusinessObjectData(request);
        Assert.assertNotNull((String)"response business object datas is null", (Object)actualResponse.getRegisteredBusinessObjectDataList());
        Assert.assertEquals((String)"response business object datas size", (long)0L, (long)actualResponse.getRegisteredBusinessObjectDataList().size());
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataValidationNamespaceRequired() {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        request.setNamespace("      \t\t ");
        try {
            this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Test failed during setup. Most likely setup or developer error.", e);
        }
        try {
            this.businessObjectDataInvalidateUnregisteredHelper.invalidateUnregisteredBusinessObjectData(request);
            Assert.fail((String)"expected a IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"The namespace is required", (Object)e.getMessage());
        }
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataValidationBusinessObjectDefinitionNameRequired() {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        try {
            this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Test failed during setup. Most likely setup or developer error.", e);
        }
        try {
            this.businessObjectDataInvalidateUnregisteredHelper.invalidateUnregisteredBusinessObjectData(request);
            Assert.fail((String)"expected a IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"The business object definition name is required", (Object)e.getMessage());
        }
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataValidationBusinessObjectFormatUsageRequired() {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        try {
            this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Test failed during setup. Most likely setup or developer error.", e);
        }
        try {
            this.businessObjectDataInvalidateUnregisteredHelper.invalidateUnregisteredBusinessObjectData(request);
            Assert.fail((String)"expected a IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"The business object format usage is required", (Object)e.getMessage());
        }
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataValidationBusinessObjectFormatMustExist() {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        try {
            this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Test failed during setup. Most likely setup or developer error.", e);
        }
        request.setBusinessObjectFormatFileType("DOES_NOT_EXIST");
        try {
            this.businessObjectDataInvalidateUnregisteredHelper.invalidateUnregisteredBusinessObjectData(request);
            Assert.fail((String)"expected a ObjectNotFoundException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", ObjectNotFoundException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)("Business object format with namespace \"" + request.getNamespace() + "\", business object definition name \"" + request.getBusinessObjectDefinitionName() + "\", format usage \"" + request.getBusinessObjectFormatUsage() + "\", format file type \"" + request.getBusinessObjectFormatFileType() + "\", and format version \"" + request.getBusinessObjectFormatVersion() + "\" doesn't exist."), (Object)e.getMessage());
        }
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataValidationBusinessObjectFormatFileTypeRequired() {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        try {
            this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Test failed during setup. Most likely setup or developer error.", e);
        }
        try {
            this.businessObjectDataInvalidateUnregisteredHelper.invalidateUnregisteredBusinessObjectData(request);
            Assert.fail((String)"expected a IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"The business object format file type is required", (Object)e.getMessage());
        }
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataValidationBusinessObjectFormatVersionRequired() {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        try {
            this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Test failed during setup. Most likely setup or developer error.", e);
        }
        request.setBusinessObjectFormatVersion(null);
        try {
            this.businessObjectDataInvalidateUnregisteredHelper.invalidateUnregisteredBusinessObjectData(request);
            Assert.fail((String)"expected a IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"The business object format version is required", (Object)e.getMessage());
        }
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataValidationBusinessObjectFormatVersionNegative() {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, Integer.valueOf(-1), PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        try {
            this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Test failed during setup. Most likely setup or developer error.", e);
        }
        try {
            this.businessObjectDataInvalidateUnregisteredHelper.invalidateUnregisteredBusinessObjectData(request);
            Assert.fail((String)"expected a IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"The business object format version must be greater than or equal to 0", (Object)e.getMessage());
        }
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataValidationPartitionValueRequired() {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "      \t\t ", NO_SUBPARTITION_VALUES, "S3_MANAGED");
        try {
            this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Test failed during setup. Most likely setup or developer error.", e);
        }
        try {
            this.businessObjectDataInvalidateUnregisteredHelper.invalidateUnregisteredBusinessObjectData(request);
            Assert.fail((String)"expected a IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"The partition value is required", (Object)e.getMessage());
        }
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataValidationStorageNameRequired() {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "      \t\t ");
        try {
            this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Test failed during setup. Most likely setup or developer error.", e);
        }
        try {
            this.businessObjectDataInvalidateUnregisteredHelper.invalidateUnregisteredBusinessObjectData(request);
            Assert.fail((String)"expected a IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"The storage name is required", (Object)e.getMessage());
        }
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataValidationStorageMustExist() {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "DOES_NOT_EXIST");
        try {
            this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Test failed during setup. Most likely setup or developer error.", e);
        }
        try {
            this.businessObjectDataInvalidateUnregisteredHelper.invalidateUnregisteredBusinessObjectData(request);
            Assert.fail((String)"expected a ObjectNotFoundException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", ObjectNotFoundException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)("Storage with name \"" + request.getStorageName() + "\" doesn't exist."), (Object)e.getMessage());
        }
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataValidationStoragePlatformMustBeS3() {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, STORAGE_NAME);
        try {
            this.storageDaoTestHelper.createStorageEntity(request.getStorageName(), "NOT_S3");
            this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Test failed during setup. Most likely setup or developer error.", e);
        }
        try {
            this.businessObjectDataInvalidateUnregisteredHelper.invalidateUnregisteredBusinessObjectData(request);
            Assert.fail((String)"expected a IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)("The specified storage '" + request.getStorageName() + "' is not an S3 storage platform."), (Object)e.getMessage());
        }
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataValidationSubPartitionValueNotBlank() {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList("      \t\t "), "S3_MANAGED");
        try {
            this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Test failed during setup. Most likely setup or developer error.", e);
        }
        try {
            this.businessObjectDataInvalidateUnregisteredHelper.invalidateUnregisteredBusinessObjectData(request);
            Assert.fail((String)"expected a IllegalArgumentException, but no exception was thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)"The sub-partition value [0] must not be blank", (Object)e.getMessage());
        }
    }

    @Test
    public void testInvalidateUnregisteredBusinessObjectDataTrim() throws Exception {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, "S3_MANAGED");
        try {
            this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Test failed during setup. Most likely setup or developer error.", e);
        }
        request.setNamespace("      \t\t " + request.getNamespace() + "      \t\t ");
        request.setBusinessObjectDefinitionName("      \t\t " + request.getBusinessObjectDefinitionName() + "      \t\t ");
        request.setBusinessObjectFormatFileType("      \t\t " + request.getBusinessObjectFormatFileType() + "      \t\t ");
        request.setBusinessObjectFormatUsage("      \t\t " + request.getBusinessObjectFormatUsage() + "      \t\t ");
        request.setPartitionValue("      \t\t " + request.getPartitionValue() + "      \t\t ");
        ArrayList<String> paddedSubPartitionValues = new ArrayList<String>();
        for (String subPartitionValue : request.getSubPartitionValues()) {
            paddedSubPartitionValues.add("      \t\t " + subPartitionValue + "      \t\t ");
        }
        request.setSubPartitionValues(paddedSubPartitionValues);
        BusinessObjectDataInvalidateUnregisteredResponse actualResponse = this.businessObjectDataInvalidateUnregisteredHelper.invalidateUnregisteredBusinessObjectData(request);
        Assert.assertNotNull((String)"response is null", (Object)actualResponse);
        Assert.assertEquals((String)"response namespace", (Object)request.getNamespace(), (Object)actualResponse.getNamespace());
        Assert.assertEquals((String)"response business object definition name", (Object)request.getBusinessObjectDefinitionName(), (Object)actualResponse.getBusinessObjectDefinitionName());
        Assert.assertEquals((String)"response business object format usage", (Object)request.getBusinessObjectFormatUsage(), (Object)actualResponse.getBusinessObjectFormatUsage());
        Assert.assertEquals((String)"response business object format file type", (Object)request.getBusinessObjectFormatFileType(), (Object)actualResponse.getBusinessObjectFormatFileType());
        Assert.assertEquals((String)"response business object format version", (Object)request.getBusinessObjectFormatVersion(), (Object)actualResponse.getBusinessObjectFormatVersion());
        Assert.assertEquals((String)"response partition value", (Object)request.getPartitionValue(), (Object)actualResponse.getPartitionValue());
        Assert.assertEquals((String)"response sub-partition values", (Object)request.getSubPartitionValues(), (Object)actualResponse.getSubPartitionValues());
        Assert.assertEquals((String)"response storage name", (Object)request.getStorageName(), (Object)actualResponse.getStorageName());
        Assert.assertNotNull((String)"response business object datas is null", (Object)actualResponse.getRegisteredBusinessObjectDataList());
        Assert.assertEquals((String)"response business object datas size", (long)0L, (long)actualResponse.getRegisteredBusinessObjectDataList().size());
    }

    private BusinessObjectDataEntity createBusinessObjectDataEntityFromBusinessObjectDataInvalidateUnregisteredRequest(BusinessObjectFormatEntity businessObjectFormatEntity, BusinessObjectDataInvalidateUnregisteredRequest request, int businessObjectDataVersion, boolean latestVersion) {
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        businessObjectDataEntity.setBusinessObjectFormat(businessObjectFormatEntity);
        businessObjectDataEntity.setPartitionValue(request.getPartitionValue());
        businessObjectDataEntity.setPartitionValue2((String)this.herdCollectionHelper.safeGet(request.getSubPartitionValues(), 0));
        businessObjectDataEntity.setPartitionValue3((String)this.herdCollectionHelper.safeGet(request.getSubPartitionValues(), 1));
        businessObjectDataEntity.setPartitionValue4((String)this.herdCollectionHelper.safeGet(request.getSubPartitionValues(), 2));
        businessObjectDataEntity.setPartitionValue5((String)this.herdCollectionHelper.safeGet(request.getSubPartitionValues(), 3));
        businessObjectDataEntity.setVersion(Integer.valueOf(businessObjectDataVersion));
        businessObjectDataEntity.setLatestVersion(Boolean.valueOf(latestVersion));
        businessObjectDataEntity.setStatus(this.businessObjectDataStatusDao.getBusinessObjectDataStatusByCode("VALID"));
        return (BusinessObjectDataEntity)this.businessObjectDataDao.saveAndRefresh((Object)businessObjectDataEntity);
    }
}

