/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.service.helper.BusinessObjectDataKeyComparator;
import org.junit.Assert;
import org.junit.Test;

public class BusinessObjectDataKeyComparatorTest {
    private BusinessObjectDataKeyComparator comparator = new BusinessObjectDataKeyComparator();

    @Test
    public void testCompareNullKey() throws Exception {
        Assert.assertEquals((long)0L, (long)this.comparator.compare(null, null));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(null, new BusinessObjectDataKey()));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(new BusinessObjectDataKey(), null));
    }

    @Test
    public void testCompareBusinessObjectDefinitionName() throws Exception {
        BusinessObjectDataKey businessObjectDataKey1 = new BusinessObjectDataKey();
        BusinessObjectDataKey businessObjectDataKey2 = new BusinessObjectDataKey();
        businessObjectDataKey1.setBusinessObjectDefinitionName("a");
        businessObjectDataKey2.setBusinessObjectDefinitionName("a");
        Assert.assertEquals((long)0L, (long)this.comparator.compare(businessObjectDataKey1, businessObjectDataKey2));
        businessObjectDataKey1.setBusinessObjectDefinitionName("a");
        businessObjectDataKey2.setBusinessObjectDefinitionName("b");
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(businessObjectDataKey1, businessObjectDataKey2));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(businessObjectDataKey2, businessObjectDataKey1));
    }

    @Test
    public void testCompareBusinessObjectFormatUsage() throws Exception {
        BusinessObjectDataKey businessObjectDataKey1 = new BusinessObjectDataKey();
        BusinessObjectDataKey businessObjectDataKey2 = new BusinessObjectDataKey();
        businessObjectDataKey1.setBusinessObjectFormatUsage("a");
        businessObjectDataKey2.setBusinessObjectFormatUsage("a");
        Assert.assertEquals((long)0L, (long)this.comparator.compare(businessObjectDataKey1, businessObjectDataKey2));
        businessObjectDataKey1.setBusinessObjectFormatUsage("a");
        businessObjectDataKey2.setBusinessObjectFormatUsage("b");
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(businessObjectDataKey1, businessObjectDataKey2));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(businessObjectDataKey2, businessObjectDataKey1));
    }

    @Test
    public void testCompareBusinessObjectFormatFileType() throws Exception {
        BusinessObjectDataKey businessObjectDataKey1 = new BusinessObjectDataKey();
        BusinessObjectDataKey businessObjectDataKey2 = new BusinessObjectDataKey();
        businessObjectDataKey1.setBusinessObjectFormatFileType("a");
        businessObjectDataKey2.setBusinessObjectFormatFileType("a");
        Assert.assertEquals((long)0L, (long)this.comparator.compare(businessObjectDataKey1, businessObjectDataKey2));
        businessObjectDataKey1.setBusinessObjectFormatFileType("a");
        businessObjectDataKey2.setBusinessObjectFormatFileType("b");
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(businessObjectDataKey1, businessObjectDataKey2));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(businessObjectDataKey2, businessObjectDataKey1));
    }

    @Test
    public void testCompareBusinessObjectFormatVersion() throws Exception {
        BusinessObjectDataKey businessObjectDataKey1 = new BusinessObjectDataKey();
        BusinessObjectDataKey businessObjectDataKey2 = new BusinessObjectDataKey();
        businessObjectDataKey1.setBusinessObjectFormatVersion(Integer.valueOf(0));
        businessObjectDataKey2.setBusinessObjectFormatVersion(Integer.valueOf(0));
        Assert.assertEquals((long)0L, (long)this.comparator.compare(businessObjectDataKey1, businessObjectDataKey2));
        businessObjectDataKey1.setBusinessObjectFormatVersion(Integer.valueOf(0));
        businessObjectDataKey2.setBusinessObjectFormatVersion(Integer.valueOf(1));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(businessObjectDataKey1, businessObjectDataKey2));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(businessObjectDataKey2, businessObjectDataKey1));
    }

    @Test
    public void testComparePartitionValue() throws Exception {
        BusinessObjectDataKey businessObjectDataKey1 = new BusinessObjectDataKey();
        BusinessObjectDataKey businessObjectDataKey2 = new BusinessObjectDataKey();
        businessObjectDataKey1.setPartitionValue("a");
        businessObjectDataKey2.setPartitionValue("a");
        Assert.assertEquals((long)0L, (long)this.comparator.compare(businessObjectDataKey1, businessObjectDataKey2));
        businessObjectDataKey1.setPartitionValue("a");
        businessObjectDataKey2.setPartitionValue("b");
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(businessObjectDataKey1, businessObjectDataKey2));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(businessObjectDataKey2, businessObjectDataKey1));
    }

    @Test
    public void testCompareBusinessObjectDataVersion() throws Exception {
        BusinessObjectDataKey businessObjectDataKey1 = new BusinessObjectDataKey();
        BusinessObjectDataKey businessObjectDataKey2 = new BusinessObjectDataKey();
        businessObjectDataKey1.setBusinessObjectDataVersion(Integer.valueOf(0));
        businessObjectDataKey2.setBusinessObjectDataVersion(Integer.valueOf(0));
        Assert.assertEquals((long)0L, (long)this.comparator.compare(businessObjectDataKey1, businessObjectDataKey2));
        businessObjectDataKey1.setBusinessObjectDataVersion(Integer.valueOf(0));
        businessObjectDataKey2.setBusinessObjectDataVersion(Integer.valueOf(1));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(businessObjectDataKey1, businessObjectDataKey2));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(businessObjectDataKey2, businessObjectDataKey1));
    }

    @Test
    public void testCompareAllFields() throws Exception {
        BusinessObjectDataKey businessObjectDataKey1 = new BusinessObjectDataKey();
        BusinessObjectDataKey businessObjectDataKey2 = new BusinessObjectDataKey();
        businessObjectDataKey1.setBusinessObjectDefinitionName("a");
        businessObjectDataKey1.setBusinessObjectFormatUsage("a");
        businessObjectDataKey1.setBusinessObjectFormatFileType("a");
        businessObjectDataKey1.setBusinessObjectFormatVersion(Integer.valueOf(0));
        businessObjectDataKey1.setPartitionValue("a");
        businessObjectDataKey1.setBusinessObjectDataVersion(Integer.valueOf(0));
        businessObjectDataKey2.setBusinessObjectDefinitionName("a");
        businessObjectDataKey2.setBusinessObjectFormatUsage("a");
        businessObjectDataKey2.setBusinessObjectFormatFileType("a");
        businessObjectDataKey2.setBusinessObjectFormatVersion(Integer.valueOf(0));
        businessObjectDataKey2.setPartitionValue("a");
        businessObjectDataKey2.setBusinessObjectDataVersion(Integer.valueOf(0));
        Assert.assertEquals((long)0L, (long)this.comparator.compare(businessObjectDataKey1, businessObjectDataKey2));
        businessObjectDataKey1.setBusinessObjectDataVersion(Integer.valueOf(0));
        businessObjectDataKey2.setBusinessObjectDataVersion(Integer.valueOf(1));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(businessObjectDataKey1, businessObjectDataKey2));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(businessObjectDataKey2, businessObjectDataKey1));
    }
}

