/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import java.util.ArrayList;
import org.finra.herd.model.api.xml.BusinessObjectDataSearchFilter;
import org.finra.herd.model.api.xml.BusinessObjectDataSearchKey;
import org.finra.herd.model.api.xml.BusinessObjectDataSearchRequest;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class BusinessObjectDataSearchHelperTest
extends AbstractServiceTest {
    @Test
    public void testValidateBusinessObjectDataSearchRequestFilterNegative() {
        BusinessObjectDataSearchRequest request = null;
        this.handleExpectedExceptionValidateSearchRequest(request, "Null BusinessObjectDataSearchRequest should fail!");
        request = new BusinessObjectDataSearchRequest();
        this.handleExpectedExceptionValidateSearchRequest(request, "Empty BusinessObjectDataSearchRequest should fail");
        ArrayList<BusinessObjectDataSearchFilter> businessObjectDataSearchFilters = new ArrayList<BusinessObjectDataSearchFilter>();
        request = new BusinessObjectDataSearchRequest();
        request.setBusinessObjectDataSearchFilters(businessObjectDataSearchFilters);
        this.handleExpectedExceptionValidateSearchRequest(request, "No BusinessObjectDataSearchFilter should fail");
        BusinessObjectDataSearchFilter filter = new BusinessObjectDataSearchFilter();
        businessObjectDataSearchFilters.add(filter);
        request = new BusinessObjectDataSearchRequest();
        request.setBusinessObjectDataSearchFilters(businessObjectDataSearchFilters);
        this.handleExpectedExceptionValidateSearchRequest(request, "One filter with no namespace, defination name should fail!");
        BusinessObjectDataSearchFilter filter2 = new BusinessObjectDataSearchFilter();
        businessObjectDataSearchFilters.add(filter2);
        request = new BusinessObjectDataSearchRequest();
        request.setBusinessObjectDataSearchFilters(businessObjectDataSearchFilters);
        this.handleExpectedExceptionValidateSearchRequest(request, "two filters should fail!");
    }

    @Test
    public void testValidateBusinessObjectDataSearchRequestFilterTwoKeys() {
        BusinessObjectDataSearchKey key = new BusinessObjectDataSearchKey();
        BusinessObjectDataSearchKey key2 = new BusinessObjectDataSearchKey();
        ArrayList<BusinessObjectDataSearchKey> keyList = new ArrayList<BusinessObjectDataSearchKey>();
        keyList.add(key);
        keyList.add(key2);
        BusinessObjectDataSearchFilter filter = new BusinessObjectDataSearchFilter(keyList);
        ArrayList<BusinessObjectDataSearchFilter> filterList = new ArrayList<BusinessObjectDataSearchFilter>();
        filterList.add(filter);
        BusinessObjectDataSearchRequest request = new BusinessObjectDataSearchRequest(filterList);
        this.handleExpectedExceptionValidateSearchRequest(request, "One fileter with two business data search key should fail");
    }

    @Test
    public void testValidateBusinessObjectDataSearchRequestKeyNegative() {
        BusinessObjectDataSearchKey key = null;
        this.handleExpectedExceptionValidateSearchRequestKey(key, "null business data search key should fail");
        key = new BusinessObjectDataSearchKey();
        key.setNamespace(null);
        this.handleExpectedExceptionValidateSearchRequestKey(key, "null namespace in data search key should fail");
        key.setNamespace("SOME NAMESPACE");
        key.setBusinessObjectDefinitionName(null);
        this.handleExpectedExceptionValidateSearchRequestKey(key, "null business defination name in data search key should fail");
    }

    @Test
    public void testValidateBusinessObjectDataSearchRequestKeyPositiveWithRequiredFieldsOnly() {
        BusinessObjectDataSearchKey key = new BusinessObjectDataSearchKey();
        try {
            key.setNamespace("NAMESPACE");
            key.setBusinessObjectDefinitionName("DEF");
            this.businessObjectDataSearchHelper.validateBusinessObjectDataKey(key);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)("No exception should be thrown, but got " + ex.getMessage()));
        }
    }

    @Test
    public void testValidateBusinessObjectDataSearchRequestKeyPositive() {
        BusinessObjectDataSearchKey key = new BusinessObjectDataSearchKey();
        try {
            key.setNamespace("NAMESPACE");
            key.setBusinessObjectDefinitionName("DEF");
            key.setBusinessObjectFormatUsage("FORMAT");
            key.setBusinessObjectFormatUsage("PRC");
            key.setBusinessObjectFormatVersion(Integer.valueOf(0));
            this.businessObjectDataSearchHelper.validateBusinessObjectDataKey(key);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)("No exception should be thrown, but got " + ex.getMessage()));
        }
    }

    @Test
    public void testValidateBusinessObjectDataSearchRequestPositive() {
        BusinessObjectDataSearchKey key = new BusinessObjectDataSearchKey();
        key.setNamespace("NAMESPACE");
        key.setBusinessObjectDefinitionName("DEF");
        key.setBusinessObjectFormatUsage("FORMAT");
        key.setBusinessObjectFormatUsage("PRC");
        key.setBusinessObjectFormatVersion(Integer.valueOf(0));
        ArrayList<BusinessObjectDataSearchKey> keyList = new ArrayList<BusinessObjectDataSearchKey>();
        keyList.add(key);
        BusinessObjectDataSearchFilter filter = new BusinessObjectDataSearchFilter(keyList);
        ArrayList<BusinessObjectDataSearchFilter> filterList = new ArrayList<BusinessObjectDataSearchFilter>();
        filterList.add(filter);
        BusinessObjectDataSearchRequest request = new BusinessObjectDataSearchRequest(filterList);
        request.setBusinessObjectDataSearchFilters(filterList);
        try {
            this.businessObjectDataSearchHelper.validateBusinesObjectDataSearchRequest(request);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)("No exception should be thrown, but got " + ex.getMessage()));
        }
    }

    private void handleExpectedExceptionValidateSearchRequest(BusinessObjectDataSearchRequest request, String message) {
        boolean caughtException = false;
        try {
            this.businessObjectDataSearchHelper.validateBusinesObjectDataSearchRequest(request);
        }
        catch (IllegalArgumentException ex) {
            caughtException = true;
        }
        org.springframework.util.Assert.isTrue((boolean)caughtException, (String)message);
    }

    private void handleExpectedExceptionValidateSearchRequestKey(BusinessObjectDataSearchKey key, String message) {
        boolean caughtException = false;
        try {
            this.businessObjectDataSearchHelper.validateBusinessObjectDataKey(key);
        }
        catch (IllegalArgumentException ex) {
            caughtException = true;
        }
        org.springframework.util.Assert.isTrue((boolean)caughtException, (String)message);
    }
}

