/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.SqsMessageBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;

public class DefaultSqsMessageBuilderTest
extends AbstractServiceTest {
    @Autowired
    private SqsMessageBuilder defaultSqsMessageBuilder;

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessage() {
        List<String> subPartitionValues = Arrays.asList("testSubPartitionValueA", "testSubPartitionValueB", "testSubPartitionValueC", "testSubPartitionValueD");
        this.testBuildBusinessObjectDataStatusChangeMessage(subPartitionValues, "SYSTEM");
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessageNullSubpartitions() {
        List<String> subPartitionValues = null;
        this.testBuildBusinessObjectDataStatusChangeMessage(subPartitionValues, "SYSTEM");
    }

    @Test
    public void testBuildBusinessObjectDataStatusChangeMessageUserInContext() {
        Authentication originalAuthentication = SecurityContextHolder.getContext().getAuthentication();
        try {
            SecurityContextHolder.getContext().setAuthentication(new Authentication(){

                public String getName() {
                    return null;
                }

                public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
                }

                public boolean isAuthenticated() {
                    return false;
                }

                public Object getPrincipal() {
                    List authorities = Collections.emptyList();
                    return new User("testUsername", "", authorities);
                }

                public Object getDetails() {
                    return null;
                }

                public Object getCredentials() {
                    return null;
                }

                public Collection<? extends GrantedAuthority> getAuthorities() {
                    return null;
                }
            });
            List<String> subPartitionValues = Arrays.asList("testSubPartitionValueA", "testSubPartitionValueB", "testSubPartitionValueC", "testSubPartitionValueD");
            this.testBuildBusinessObjectDataStatusChangeMessage(subPartitionValues, "testUsername");
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(originalAuthentication);
        }
    }

    @Test
    public void testBuildSystemMonitorResponse() throws Exception {
        this.validateSystemMonitorResponse(this.defaultSqsMessageBuilder.buildSystemMonitorResponse(this.getTestSystemMonitorIncomingMessage()));
    }

    @Test
    public void testBuildSystemMonitorResponseNoVelocityTemplate() throws Exception {
        HashMap<String, Object> overrideMap = new HashMap<String, Object>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_RESPONSE_VELOCITY_TEMPLATE.getKey(), null);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            Assert.assertNull((Object)this.defaultSqsMessageBuilder.buildSystemMonitorResponse(this.getTestSystemMonitorIncomingMessage()));
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test(expected=ParseErrorException.class)
    public void testBuildSystemMonitorResponseInvalidVelocityTemplate() throws Exception {
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_RESPONSE_VELOCITY_TEMPLATE.getKey(), "#if($missingEndOfIfStatement");
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            this.defaultSqsMessageBuilder.buildSystemMonitorResponse(this.getTestSystemMonitorIncomingMessage());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testBuildSystemMonitorResponseNoXPathExpressions() throws Exception {
        HashMap<String, Object> overrideMap = new HashMap<String, Object>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_REQUEST_XPATH_PROPERTIES.getKey(), null);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            this.defaultSqsMessageBuilder.buildSystemMonitorResponse(this.getTestSystemMonitorIncomingMessage());
            Assert.fail((String)"Should throw an MethodInvocationException when the velocity template contains an undefined variable.");
        }
        catch (MethodInvocationException e) {
            Assert.assertEquals((Object)String.format("Variable $incoming_message_correlation_id has not been set at systemMonitorResponse[line 11, column 29]", new Object[0]), (Object)e.getMessage());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testBuildSystemMonitorResponseInvalidXpathExpression() throws Exception {
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_REQUEST_XPATH_PROPERTIES.getKey(), "key=///");
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            this.defaultSqsMessageBuilder.buildSystemMonitorResponse(this.getTestSystemMonitorIncomingMessage());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testBuildSystemMonitorResponseInvalidXpathProperties() throws Exception {
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_REQUEST_XPATH_PROPERTIES.getKey(), "key=\\uxxxx");
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            this.defaultSqsMessageBuilder.buildSystemMonitorResponse(this.getTestSystemMonitorIncomingMessage());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    private void testBuildBusinessObjectDataStatusChangeMessage(List<String> subPartitionValues, String triggeredByUsername) {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(subPartitionValues, NO_ATTRIBUTE_DEFINITIONS, NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        String newBusinessObjectDataStatus = "testNewBusinessObjectDataStatus";
        String oldBusinessObjectDataStatus = "testOldBusinessObjectDataStatus";
        String message = this.defaultSqsMessageBuilder.buildBusinessObjectDataStatusChangeMessage(businessObjectDataKey, newBusinessObjectDataStatus, oldBusinessObjectDataStatus);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusChangeMessage(message, businessObjectDataKey, businessObjectDataEntity.getId(), triggeredByUsername, newBusinessObjectDataStatus, oldBusinessObjectDataStatus, NO_ATTRIBUTES);
    }
}

