/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import java.sql.DataTruncation;
import java.sql.SQLException;
import javax.persistence.PersistenceException;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiClassLoadingException;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.javax.el.ELException;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.MethodNotAllowedException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.ErrorInformation;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.HerdErrorInformationExceptionHandler;
import org.hibernate.exception.ConstraintViolationException;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.access.AccessDeniedException;

public class HerdErrorInformationExceptionHandlerTest
extends AbstractServiceTest {
    @Autowired
    private HerdErrorInformationExceptionHandler exceptionHandler;
    private static final String MESSAGE = "This is a test and is not an actual error. Please ignore.";

    @Test
    public void testHandleInternalServerError() throws Exception {
        this.validateErrorInformation(this.exceptionHandler.handleInternalServerErrorException(new Exception(MESSAGE)), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @Test
    public void testHandleInternalServerErrorNoErrorMessage() throws Exception {
        ErrorInformation errorInformation = this.exceptionHandler.handleInternalServerErrorException((Exception)new NullPointerException());
        this.validateErrorInformation(errorInformation, HttpStatus.INTERNAL_SERVER_ERROR, false);
        Assert.assertEquals((Object)NullPointerException.class.getName(), (Object)errorInformation.getMessage());
    }

    @Test
    public void testDataTruncationException() throws Exception {
        this.validateErrorInformation(this.exceptionHandler.handlePersistenceException((Exception)this.getPersistenceException(new DataTruncation(1, true, true, 5, 10)), (HttpServletResponse)new MockHttpServletResponse()), HttpStatus.BAD_REQUEST, false);
    }

    @Test
    public void testDataTruncationExceptions() throws Exception {
        this.validatePersistenceException("72000", 12899);
        this.validatePersistenceException("72000", 1461);
        this.validatePersistenceException("22001", 0);
    }

    private void validatePersistenceException(String sqlState, int errorCode) {
        SQLException sqlException = new SQLException("Test Reason", sqlState, errorCode, null);
        PersistenceException persistenceException = this.getPersistenceException(sqlException);
        ErrorInformation errorInformation = this.exceptionHandler.handlePersistenceException((Exception)persistenceException, (HttpServletResponse)new MockHttpServletResponse());
        this.validateErrorInformation(errorInformation, HttpStatus.BAD_REQUEST, false);
    }

    @Test
    public void testConstraintViolationException() throws Exception {
        this.validateErrorInformation(this.exceptionHandler.handlePersistenceException((Exception)this.getPersistenceException((Exception)new ConstraintViolationException(MESSAGE, null, "testConstraint")), (HttpServletResponse)new MockHttpServletResponse()), HttpStatus.BAD_REQUEST, false);
        this.validateErrorInformation(this.exceptionHandler.handlePersistenceException((Exception)this.getPersistenceException(new SQLException(MESSAGE, "23503", 0)), (HttpServletResponse)new MockHttpServletResponse()), HttpStatus.BAD_REQUEST, false);
    }

    @Test
    public void testConstraintViolationExceptionNoWrap() throws Exception {
        this.validateErrorInformation(this.exceptionHandler.handlePersistenceException((Exception)new ConstraintViolationException(MESSAGE, null, "testConstraint"), (HttpServletResponse)new MockHttpServletResponse()), HttpStatus.BAD_REQUEST, false);
    }

    @Test
    public void testPersistenceExceptionInternalServerError() throws Exception {
        this.validateErrorInformation(this.exceptionHandler.handlePersistenceException((Exception)this.getPersistenceException(new RuntimeException(MESSAGE)), (HttpServletResponse)new MockHttpServletResponse()), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @Test
    public void testPersistenceExceptionInternalServerErrorNullException() throws Exception {
        this.validateErrorInformation(this.exceptionHandler.handlePersistenceException(null, (HttpServletResponse)new MockHttpServletResponse()), HttpStatus.INTERNAL_SERVER_ERROR, false);
    }

    @Test
    public void testHandleOperationNotAllowedFound() throws Exception {
        this.validateErrorInformation(this.exceptionHandler.handleOperationNotAllowedException((RuntimeException)new MethodNotAllowedException(MESSAGE)), HttpStatus.METHOD_NOT_ALLOWED);
    }

    @Test
    public void testHandleNotFound() throws Exception {
        this.validateErrorInformation(this.exceptionHandler.handleNotFoundException((RuntimeException)((Object)new ObjectNotFoundException(MESSAGE))), HttpStatus.NOT_FOUND);
    }

    @Test
    public void testAlreadyExists() throws Exception {
        this.validateErrorInformation(this.exceptionHandler.handleConflictException((Exception)((Object)new AlreadyExistsException(MESSAGE))), HttpStatus.CONFLICT);
    }

    @Test
    public void testIllegalArgument() throws Exception {
        this.validateErrorInformation(this.exceptionHandler.handleBadRequestException((Exception)new IllegalArgumentException(MESSAGE)), HttpStatus.BAD_REQUEST);
    }

    @Test
    public void testActivitiExceptionBadRequest() throws Exception {
        this.validateErrorInformation(this.exceptionHandler.handleActivitiException((Exception)new ActivitiClassLoadingException(ActivitiClassLoadingException.class.getName(), (Throwable)new RuntimeException(MESSAGE)), (HttpServletResponse)new MockHttpServletResponse()), HttpStatus.BAD_REQUEST, false);
        this.validateErrorInformation(this.exceptionHandler.handleActivitiException((Exception)new ELException(MESSAGE), (HttpServletResponse)new MockHttpServletResponse()), HttpStatus.BAD_REQUEST);
    }

    @Test
    public void testActivitiExceptionInternalServerError() throws Exception {
        this.validateErrorInformation(this.exceptionHandler.handleActivitiException((Exception)new ActivitiException(MESSAGE), (HttpServletResponse)new MockHttpServletResponse()), HttpStatus.INTERNAL_SERVER_ERROR, false);
    }

    @Test
    public void testAccessDeniedException() throws Exception {
        this.validateErrorInformation(this.exceptionHandler.handleAccessDeniedException((Exception)new AccessDeniedException(MESSAGE)), HttpStatus.FORBIDDEN, false);
    }

    @Test
    public void testIsReportableErrorThrowable() throws Exception {
        Assert.assertTrue((boolean)this.exceptionHandler.isReportableError(new Throwable(MESSAGE)));
    }

    @Test
    public void testGetErrorWithCause() throws Exception {
        Exception ex = new Exception();
        ErrorInformation errorInformation = this.exceptionHandler.handleBadRequestException(ex);
        Assert.assertTrue((errorInformation.getMessageDetails().size() == 0 ? 1 : 0) != 0);
        ex = new Exception(new Exception("cause_1_exception", new Exception("cause_2_exception")));
        errorInformation = this.exceptionHandler.handleBadRequestException(ex);
        Assert.assertTrue((errorInformation.getMessageDetails().size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"cause_1_exception", errorInformation.getMessageDetails().get(0));
        Assert.assertEquals((Object)"cause_2_exception", errorInformation.getMessageDetails().get(1));
    }

    private void validateErrorInformation(ErrorInformation errorInformation, HttpStatus expectedStatus) {
        this.validateErrorInformation(errorInformation, expectedStatus, true);
    }

    private PersistenceException getPersistenceException(Exception childException) {
        return new PersistenceException("Persistence Error", (Throwable)childException);
    }

    private void validateErrorInformation(ErrorInformation errorInformation, HttpStatus expectedStatus, boolean checkMessage) {
        if (checkMessage) {
            Assert.assertEquals((Object)MESSAGE, (Object)errorInformation.getMessage());
        }
        Assert.assertEquals((long)expectedStatus.value(), (long)errorInformation.getStatusCode());
        Assert.assertEquals((Object)expectedStatus.getReasonPhrase(), (Object)errorInformation.getStatusDescription());
    }
}

