/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.HerdJmsDestinationResolver;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class HerdJmsDestinationResolverTest
extends AbstractServiceTest {
    @Autowired
    HerdJmsDestinationResolver herdJmsDestinationResolver;

    @Test
    public void testResolveDestinationNameNoExists() throws Exception {
        try {
            this.herdJmsDestinationResolver.resolveDestinationName(null, "queue_not_exists", false);
            Assert.fail((String)"Should throw an IllegalStateException.");
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)String.format("Failed to resolve the SQS queue: \"%s\".", ""), (Object)ex.getMessage());
        }
    }

    @Test
    public void testResolveDestinationNameNoQueueExists() throws Exception {
        try {
            this.herdJmsDestinationResolver.resolveDestinationName(null, "herd_incoming_queue", false);
            Assert.fail((String)"Should throw an IllegalStateException.");
        }
        catch (IllegalStateException ex) {
            Assert.assertTrue((String)"\"Failed to resolve the SQS queue:\" error message doesn't match", (boolean)ex.getMessage().startsWith("Failed to resolve the SQS queue:"));
        }
    }

    @Test
    public void testResolveDestinationNameNoConfig() throws Exception {
        this.removeReloadablePropertySourceFromEnvironment();
        try {
            this.herdJmsDestinationResolver.resolveDestinationName(null, "herd_incoming_queue", false);
            Assert.fail((String)"Should throw an IllegalStateException.");
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)String.format("SQS queue name not found. Ensure the \"%s\" configuration entry is configured.", ConfigurationValue.HERD_NOTIFICATION_SQS_INCOMING_QUEUE_NAME.getKey()), (Object)ex.getMessage());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }
}

