/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import com.amazonaws.services.s3.event.S3EventNotification;
import java.util.ArrayList;
import org.finra.herd.core.helper.LogLevel;
import org.finra.herd.dao.helper.JsonHelper;
import org.finra.herd.model.api.xml.StorageFile;
import org.finra.herd.model.api.xml.StorageUnit;
import org.finra.herd.model.api.xml.UploadSingleInitiationResponse;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.UploadDownloadService;
import org.finra.herd.service.helper.HerdJmsMessageListener;
import org.finra.herd.service.impl.UploadDownloadHelperServiceImpl;
import org.finra.herd.service.impl.UploadDownloadServiceImpl;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class HerdJmsMessageListenerTest
extends AbstractServiceTest {
    @Autowired
    HerdJmsMessageListener herdJmsMessageListener;
    @Autowired
    JsonHelper jsonHelper;
    @Autowired
    UploadDownloadService uploadDownloadService;

    @Test
    public void testSystemMonitorMessage() throws Exception {
        this.executeWithoutLogging(HerdJmsMessageListener.class, () -> this.herdJmsMessageListener.processMessage(this.getTestSystemMonitorIncomingMessage(), null));
    }

    @Test
    public void testS3Message() throws Exception {
        this.setLogLevel(UploadDownloadHelperServiceImpl.class, LogLevel.OFF);
        this.uploadDownloadServiceTestHelper.createDatabaseEntitiesForUploadDownloadTesting();
        UploadSingleInitiationResponse resultUploadSingleInitiationResponse = this.uploadDownloadService.initiateUploadSingle(this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest());
        String filePath = ((StorageFile)((StorageUnit)resultUploadSingleInitiationResponse.getSourceBusinessObjectData().getStorageUnits().get(0)).getStorageFiles().get(0)).getFilePath();
        S3EventNotification.S3Entity s3Entity = new S3EventNotification.S3Entity(null, null, new S3EventNotification.S3ObjectEntity(filePath, Long.valueOf(0L), null, null), null);
        ArrayList<S3EventNotification.S3EventNotificationRecord> records = new ArrayList<S3EventNotification.S3EventNotificationRecord>();
        records.add(new S3EventNotification.S3EventNotificationRecord(null, null, null, null, null, null, null, s3Entity, null));
        S3EventNotification s3EventNotification = new S3EventNotification(records);
        this.setLogLevel(UploadDownloadServiceImpl.class, LogLevel.OFF);
        this.setLogLevel(HerdJmsMessageListener.class, LogLevel.OFF);
        this.herdJmsMessageListener.processMessage(this.jsonHelper.objectToJson((Object)s3EventNotification), null);
    }

    @Test
    public void testS3MessageS3FileNoExists() throws Exception {
        this.setLogLevel(UploadDownloadHelperServiceImpl.class, LogLevel.OFF);
        this.uploadDownloadServiceTestHelper.createDatabaseEntitiesForUploadDownloadTesting();
        UploadSingleInitiationResponse resultUploadSingleInitiationResponse = this.uploadDownloadService.initiateUploadSingle(this.uploadDownloadServiceTestHelper.createUploadSingleInitiationRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, NAMESPACE, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, TARGET_S3_KEY));
        String filePath = ((StorageFile)((StorageUnit)resultUploadSingleInitiationResponse.getSourceBusinessObjectData().getStorageUnits().get(0)).getStorageFiles().get(0)).getFilePath();
        S3EventNotification.S3Entity s3Entity = new S3EventNotification.S3Entity(null, null, new S3EventNotification.S3ObjectEntity(filePath, Long.valueOf(0L), null, null), null);
        ArrayList<S3EventNotification.S3EventNotificationRecord> records = new ArrayList<S3EventNotification.S3EventNotificationRecord>();
        records.add(new S3EventNotification.S3EventNotificationRecord(null, null, null, null, null, null, null, s3Entity, null));
        S3EventNotification s3EventNotification = new S3EventNotification(records);
        this.setLogLevel(UploadDownloadServiceImpl.class, LogLevel.OFF);
        this.setLogLevel(HerdJmsMessageListener.class, LogLevel.OFF);
        this.herdJmsMessageListener.processMessage(this.jsonHelper.objectToJson((Object)s3EventNotification), null);
    }

    @Test
    public void testS3MessageNoKey() throws Exception {
        S3EventNotification.S3Entity s3Entity = new S3EventNotification.S3Entity(null, null, new S3EventNotification.S3ObjectEntity("key_does_not_exist", Long.valueOf(0L), null, null), null);
        ArrayList<S3EventNotification.S3EventNotificationRecord> records = new ArrayList<S3EventNotification.S3EventNotificationRecord>();
        records.add(new S3EventNotification.S3EventNotificationRecord(null, null, null, null, null, null, null, s3Entity, null));
        S3EventNotification s3EventNotification = new S3EventNotification(records);
        this.setLogLevel(UploadDownloadServiceImpl.class, LogLevel.OFF);
        this.setLogLevel(HerdJmsMessageListener.class, LogLevel.OFF);
        this.herdJmsMessageListener.processMessage(this.jsonHelper.objectToJson((Object)s3EventNotification), null);
    }

    @Test
    public void testS3MessageWrongMessage() throws Exception {
        this.setLogLevel(UploadDownloadServiceImpl.class, LogLevel.OFF);
        this.setLogLevel(HerdJmsMessageListener.class, LogLevel.OFF);
        this.herdJmsMessageListener.processMessage("WRONG_MESSAGE", null);
    }
}

