/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import java.util.HashMap;
import java.util.regex.Pattern;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.JobDefinitionAlternateKeyDto;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class JobDefinitionHelperTest
extends AbstractServiceTest {
    @Test
    public void testGetActivitiJobDefinitionTemplateUsingConfiguredActivitiIdTemplate() throws Exception {
        String testActivitiIdTemplate = "testActivitiIdTemplate";
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.ACTIVITI_JOB_DEFINITION_ID_TEMPLATE.getKey(), testActivitiIdTemplate);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            Assert.assertEquals((Object)testActivitiIdTemplate, (Object)this.jobDefinitionHelper.getActivitiJobDefinitionTemplate());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testGetActivitiJobDefinitionTemplateUsingDefaultActivitiIdTemplate() {
        Assert.assertEquals((Object)"~namespace~.~jobName~", (Object)this.jobDefinitionHelper.getActivitiJobDefinitionTemplate());
    }

    @Test
    public void testGetJobDefinitionKey() {
        String testProcessDefinitionKey = String.format("%s.%s", NAMESPACE, JOB_NAME);
        Assert.assertEquals((Object)new JobDefinitionAlternateKeyDto(NAMESPACE, JOB_NAME), (Object)this.jobDefinitionHelper.getJobDefinitionKey(testProcessDefinitionKey));
    }

    @Test
    public void testGetJobDefinitionKeyInvalidProcessDefinitionKey() {
        String testProcessDefinitionKey = "INVALID_PROCESS_DEFINITION_KEY";
        Pattern pattern = this.jobDefinitionHelper.getNamespaceAndJobNameRegexPattern();
        try {
            this.jobDefinitionHelper.getJobDefinitionKey(testProcessDefinitionKey, pattern);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Process definition key \"%s\" does not match the expected pattern \"%s\".", testProcessDefinitionKey, pattern.toString()), (Object)e.getMessage());
        }
    }
}

