/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.NotificationRegistrationKey;
import org.finra.herd.model.jpa.NotificationEventTypeEntity;
import org.finra.herd.model.jpa.NotificationRegistrationEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class NotificationRegistrationDaoHelperTest
extends AbstractServiceTest {
    @Test
    public void testGetNotificationRegistrationAssertReturnEntityWhenEntityExists() {
        NotificationRegistrationKey businessObjectDataNotificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, BDEF_NAME);
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(businessObjectDataNotificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        NotificationRegistrationEntity notificationRegistrationEntity = this.notificationRegistrationDaoHelper.getNotificationRegistration(NAMESPACE, BDEF_NAME);
        Assert.assertNotNull((Object)notificationRegistrationEntity);
        Assert.assertEquals((Object)NAMESPACE, (Object)notificationRegistrationEntity.getNamespace().getCode());
        Assert.assertEquals((Object)BDEF_NAME, (Object)notificationRegistrationEntity.getName());
    }

    @Test
    public void testGetNotificationRegistrationAssertThrowWhenEntityNotExist() {
        NotificationRegistrationKey businessObjectDataNotificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, BDEF_NAME);
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(businessObjectDataNotificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.notificationRegistrationDaoHelper.getNotificationRegistration(NAMESPACE, "DOES_NOT_EXIST");
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(ObjectNotFoundException.class, e.getClass());
            Assert.assertEquals((Object)("The notification registration with namespace \"" + NAMESPACE + "\" and name \"DOES_NOT_EXIST\" was not found."), (Object)e.getMessage());
        }
    }
}

