/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import org.finra.herd.model.api.xml.S3PropertiesLocation;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class S3PropertiesLocationHelperTest
extends AbstractServiceTest {
    @Test
    public void testValidateNoErrorsAndTrimmed() {
        S3PropertiesLocation s3PropertiesLocation = this.getS3PropertiesLocation();
        String expectedBucketName = s3PropertiesLocation.getBucketName();
        String expectedKey = s3PropertiesLocation.getKey();
        s3PropertiesLocation.setBucketName("      \t\t " + s3PropertiesLocation.getBucketName() + "      \t\t ");
        s3PropertiesLocation.setKey("      \t\t " + s3PropertiesLocation.getKey() + "      \t\t ");
        try {
            this.s3PropertiesLocationHelper.validate(s3PropertiesLocation);
            Assert.assertEquals((String)"s3PropertiesLocation bucketName", (Object)expectedBucketName, (Object)s3PropertiesLocation.getBucketName());
            Assert.assertEquals((String)"s3PropertiesLocation key", (Object)expectedKey, (Object)s3PropertiesLocation.getKey());
        }
        catch (Exception e) {
            Assert.fail((String)("unexpected exception was thrown. " + e));
        }
    }

    @Test
    public void testValidateWhenBucketNameIsBlankThrowsError() {
        S3PropertiesLocation s3PropertiesLocation = this.getS3PropertiesLocation();
        s3PropertiesLocation.setBucketName("      \t\t ");
        this.testValidateThrowsError(s3PropertiesLocation, IllegalArgumentException.class, "S3 properties location bucket name must be specified.");
    }

    @Test
    public void testValidateWhenObjectKeyIsBlankThrowsError() {
        S3PropertiesLocation s3PropertiesLocation = this.getS3PropertiesLocation();
        s3PropertiesLocation.setKey("      \t\t ");
        this.testValidateThrowsError(s3PropertiesLocation, IllegalArgumentException.class, "S3 properties location object key must be specified.");
    }

    private void testValidateThrowsError(S3PropertiesLocation s3PropertiesLocation, Class<? extends Exception> expectedExceptionType, String expectedMessage) {
        try {
            this.s3PropertiesLocationHelper.validate(s3PropertiesLocation);
            Assert.fail((String)("expected " + expectedExceptionType.getSimpleName() + ", but no exception was thrown"));
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", expectedExceptionType, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)expectedMessage, (Object)e.getMessage());
        }
    }

    private S3PropertiesLocation getS3PropertiesLocation() {
        S3PropertiesLocation s3PropertiesLocation = new S3PropertiesLocation();
        s3PropertiesLocation.setBucketName("testBucketName");
        s3PropertiesLocation.setKey("testKey");
        return s3PropertiesLocation;
    }
}

