/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import java.util.ArrayList;
import java.util.Arrays;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.Storage;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class StorageHelperTest
extends AbstractServiceTest {
    @Test
    public void testGetStorageAttributeValueByNameFromStorage() {
        String testStorageName = "MY_TEST_STORAGE";
        String testAttributeNameNoExists = "I_DO_NOT_EXIST";
        Storage testStorage = new Storage();
        testStorage.setName("MY_TEST_STORAGE");
        testStorage.setAttributes(this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        Assert.assertEquals((Object)"Attribute Value 1", (Object)this.storageHelper.getStorageAttributeValueByName("Attribute Name 1", testStorage, Boolean.FALSE));
        Assert.assertEquals((Object)"   Attribute Value 2  ", (Object)this.storageHelper.getStorageAttributeValueByName("Attribute Name 2", testStorage, Boolean.TRUE));
        Assert.assertEquals((Object)"Attribute Value 1", (Object)this.storageHelper.getStorageAttributeValueByName("Attribute Name 1".toLowerCase(), testStorage, Boolean.TRUE));
        Assert.assertEquals((Object)"Attribute Value 1", (Object)this.storageHelper.getStorageAttributeValueByName("Attribute Name 1".toUpperCase(), testStorage, Boolean.TRUE));
        Assert.assertNull((Object)this.storageHelper.getStorageAttributeValueByName("I_DO_NOT_EXIST", testStorage, Boolean.FALSE));
        try {
            this.storageHelper.getStorageAttributeValueByName("I_DO_NOT_EXIST", testStorage, Boolean.TRUE);
            Assert.fail((String)"Suppose to throw a RuntimeException when required storage attribute does not exist or has a blank value.");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)String.format("Attribute \"%s\" for \"%s\" storage must be configured.", "I_DO_NOT_EXIST", testStorage.getName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetStorageAttributeValueByNameFromStorageEntity() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("Attribute Name 1", "Attribute Value 1"));
        attributes.add(new Attribute("Attribute Name 2", "      \t\t "));
        attributes.add(new Attribute("Attribute Name 3", null));
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3", attributes);
        Assert.assertEquals((Object)"Attribute Value 1", (Object)this.storageHelper.getStorageAttributeValueByName("Attribute Name 1", storageEntity, false));
        Assert.assertEquals((Object)"      \t\t ", (Object)this.storageHelper.getStorageAttributeValueByName("Attribute Name 2", storageEntity, false));
        Assert.assertNull((Object)this.storageHelper.getStorageAttributeValueByName("Attribute Name 3", storageEntity, false));
        Assert.assertEquals((Object)"Attribute Value 1", (Object)this.storageHelper.getStorageAttributeValueByName("Attribute Name 1".toUpperCase(), storageEntity, false));
        Assert.assertEquals((Object)"Attribute Value 1", (Object)this.storageHelper.getStorageAttributeValueByName("Attribute Name 1".toLowerCase(), storageEntity, false));
        Assert.assertEquals((Object)"Attribute Value 1", (Object)this.storageHelper.getStorageAttributeValueByName("Attribute Name 1", storageEntity, true));
        String attributeNoExist = "I_DO_NOT_EXIST";
        for (String attributeName : Arrays.asList(attributeNoExist, "Attribute Name 2", "Attribute Name 3")) {
            try {
                this.storageHelper.getStorageAttributeValueByName(attributeName, storageEntity, true);
            }
            catch (IllegalStateException e) {
                if (attributeName.equals(attributeNoExist)) {
                    Assert.assertEquals((Object)String.format("Attribute \"%s\" for \"%s\" storage must be configured.", attributeName, STORAGE_NAME), (Object)e.getMessage());
                    continue;
                }
                Assert.assertEquals((Object)String.format("Attribute \"%s\" for \"%s\" storage must have a value that is not blank.", attributeName, STORAGE_NAME), (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testGetStorageAttributeIntegerValueByName_1() {
        String attributeName = "test";
        String attributeValue = "1234";
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntityWithAttributes(attributeName, attributeValue);
        boolean attributeRequired = false;
        boolean attributeValueRequiredIfExists = true;
        Integer value = this.storageHelper.getStorageAttributeIntegerValueByName(attributeName, storageEntity, attributeRequired, attributeValueRequiredIfExists);
        Assert.assertEquals((Object)new Integer(attributeValue), (Object)value);
    }

    @Test
    public void testGetStorageAttributeIntegerValueByName_2() {
        String attributeName = "test";
        String attributeValue = "1234";
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntityWithAttributes(attributeName, attributeValue);
        boolean attributeRequired = true;
        boolean attributeValueRequiredIfExists = false;
        Integer value = this.storageHelper.getStorageAttributeIntegerValueByName(attributeName, storageEntity, attributeRequired, attributeValueRequiredIfExists);
        Assert.assertEquals((Object)new Integer(attributeValue), (Object)value);
    }

    @Test
    public void testGetStorageAttributeIntegerValueByName_3() {
        String attributeName = "test";
        String attributeValue = "1234";
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntityWithAttributes(attributeName, attributeValue);
        boolean attributeRequired = false;
        boolean attributeValueRequiredIfExists = false;
        Integer value = this.storageHelper.getStorageAttributeIntegerValueByName(attributeName, storageEntity, attributeRequired, attributeValueRequiredIfExists);
        Assert.assertEquals((Object)new Integer(attributeValue), (Object)value);
    }

    @Test
    public void testGetStorageAttributeIntegerValueByName_4() {
        String attributeName = "test";
        String attributeValue = "abcd";
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntityWithAttributes(attributeName, attributeValue);
        boolean attributeRequired = false;
        boolean attributeValueRequiredIfExists = false;
        try {
            this.storageHelper.getStorageAttributeIntegerValueByName(attributeName, storageEntity, attributeRequired, attributeValueRequiredIfExists);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalStateException.class, e.getClass());
            Assert.assertEquals((Object)("Storage attribute \"" + attributeName + "\" must be a valid integer. Actual value is \"" + attributeValue + "\""), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetStorageAttributeIntegerValueByName_5() {
        String attributeName = "test";
        String attributeValue = "      \t\t ";
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntityWithAttributes(attributeName, attributeValue);
        boolean attributeRequired = false;
        boolean attributeValueRequiredIfExists = true;
        try {
            this.storageHelper.getStorageAttributeIntegerValueByName(attributeName, storageEntity, attributeRequired, attributeValueRequiredIfExists);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalStateException.class, e.getClass());
            Assert.assertEquals((Object)("Attribute \"" + attributeName + "\" for \"" + storageEntity.getName() + "\" storage must have a value that is not blank."), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetStorageAttributeIntegerValueByName_6() {
        String attributeName = "test";
        String attributeValue = "      \t\t ";
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntityWithAttributes(attributeName, attributeValue);
        boolean attributeRequired = true;
        boolean attributeValueRequiredIfExists = false;
        try {
            this.storageHelper.getStorageAttributeIntegerValueByName(attributeName, storageEntity, attributeRequired, attributeValueRequiredIfExists);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalStateException.class, e.getClass());
            Assert.assertEquals((Object)("Storage attribute \"" + attributeName + "\" must be a valid integer. Actual value is \"" + attributeValue + "\""), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetStorageAttributeIntegerValueByName_7() {
        String attributeName = "test";
        String attributeValue = "      \t\t ";
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntityWithAttributes(attributeName, attributeValue);
        boolean attributeRequired = false;
        boolean attributeValueRequiredIfExists = false;
        try {
            this.storageHelper.getStorageAttributeIntegerValueByName(attributeName, storageEntity, attributeRequired, attributeValueRequiredIfExists);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalStateException.class, e.getClass());
            Assert.assertEquals((Object)("Storage attribute \"" + attributeName + "\" must be a valid integer. Actual value is \"" + attributeValue + "\""), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetStorageAttributeIntegerValueByName_8() {
        String attributeName = "test";
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity();
        boolean attributeRequired = false;
        boolean attributeValueRequiredIfExists = true;
        Integer value = this.storageHelper.getStorageAttributeIntegerValueByName(attributeName, storageEntity, attributeRequired, attributeValueRequiredIfExists);
        Assert.assertEquals(null, (Object)value);
    }

    @Test
    public void testGetStorageAttributeIntegerValueByName_9() {
        String attributeName = "test";
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity();
        boolean attributeRequired = true;
        boolean attributeValueRequiredIfExists = false;
        try {
            this.storageHelper.getStorageAttributeIntegerValueByName(attributeName, storageEntity, attributeRequired, attributeValueRequiredIfExists);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalStateException.class, e.getClass());
            Assert.assertEquals((Object)("Attribute \"" + attributeName + "\" for \"" + storageEntity.getName() + "\" storage must be configured."), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetStorageAttributeIntegerValueByName_10() {
        String attributeName = "test";
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity();
        boolean attributeRequired = false;
        boolean attributeValueRequiredIfExists = true;
        Integer value = this.storageHelper.getStorageAttributeIntegerValueByName(attributeName, storageEntity, attributeRequired, attributeValueRequiredIfExists);
        Assert.assertEquals(null, (Object)value);
    }

    @Test
    public void testGetStorageAttributeIntegerValueByName_11() {
        String attributeName = "test";
        String attributeValue = null;
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntityWithAttributes(attributeName, attributeValue);
        boolean attributeRequired = false;
        boolean attributeValueRequiredIfExists = true;
        try {
            this.storageHelper.getStorageAttributeIntegerValueByName(attributeName, storageEntity, attributeRequired, attributeValueRequiredIfExists);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalStateException.class, e.getClass());
            Assert.assertEquals((Object)("Attribute \"" + attributeName + "\" for \"" + storageEntity.getName() + "\" storage must have a value that is not blank."), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetStorageAttributeIntegerValueByName_12() {
        String attributeName = "test";
        String attributeValue = null;
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntityWithAttributes(attributeName, attributeValue);
        boolean attributeRequired = true;
        boolean attributeValueRequiredIfExists = false;
        Integer value = this.storageHelper.getStorageAttributeIntegerValueByName(attributeName, storageEntity, attributeRequired, attributeValueRequiredIfExists);
        Assert.assertEquals(attributeValue, (Object)value);
    }

    @Test
    public void testGetStorageAttributeIntegerValueByName_13() {
        String attributeName = "test";
        String attributeValue = null;
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntityWithAttributes(attributeName, attributeValue);
        boolean attributeRequired = true;
        boolean attributeValueRequiredIfExists = false;
        Assert.assertEquals(attributeValue, (Object)this.storageHelper.getStorageAttributeIntegerValueByName(attributeName, storageEntity, attributeRequired, attributeValueRequiredIfExists));
    }

    @Test
    public void testGetStorageAttributeIntegerValueByNameWithDefault_1() {
        String attributeName = "test";
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity();
        Integer defaultValue = 2345;
        Integer value = this.storageHelper.getStorageAttributeIntegerValueByName(attributeName, storageEntity, defaultValue);
        Assert.assertEquals((Object)defaultValue, (Object)value);
    }

    @Test
    public void testGetStorageAttributeIntegerValueByNameWithDefault_2() {
        String attributeName = "test";
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity();
        Integer defaultValue = null;
        Integer value = this.storageHelper.getStorageAttributeIntegerValueByName(attributeName, storageEntity, defaultValue);
        Assert.assertEquals(defaultValue, (Object)value);
    }

    @Test
    public void testGetStorageAttributeIntegerValueByNameWithDefault_3() {
        String attributeName = "test";
        String attributeValue = "1234";
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntityWithAttributes(attributeName, attributeValue);
        Integer defaultValue = 2345;
        Integer value = this.storageHelper.getStorageAttributeIntegerValueByName(attributeName, storageEntity, defaultValue);
        Assert.assertEquals((Object)new Integer(attributeValue), (Object)value);
    }

    @Test
    public void testGetStorageAttributeIntegerValueByNameWithDefault_4() {
        String attributeName = "test";
        String attributeValue = "1234";
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntityWithAttributes(attributeName, attributeValue);
        Integer defaultValue = null;
        Integer value = this.storageHelper.getStorageAttributeIntegerValueByName(attributeName, storageEntity, defaultValue);
        Assert.assertEquals((Object)new Integer(attributeValue), (Object)value);
    }

    @Test
    public void testGetStorageAttributeIntegerValueByNameWithDefault_5() {
        String attributeName = "test";
        String attributeValue = "abcd";
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntityWithAttributes(attributeName, attributeValue);
        Integer defaultValue = 2345;
        try {
            this.storageHelper.getStorageAttributeIntegerValueByName(attributeName, storageEntity, defaultValue);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalStateException.class, e.getClass());
            Assert.assertEquals((Object)("Storage attribute \"" + attributeName + "\" must be a valid integer. Actual value is \"" + attributeValue + "\""), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetStorageAttributeIntegerValueByNameWithDefault_6() {
        String attributeName = "test";
        String attributeValue = "abcd";
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntityWithAttributes(attributeName, attributeValue);
        Integer defaultValue = null;
        try {
            this.storageHelper.getStorageAttributeIntegerValueByName(attributeName, storageEntity, defaultValue);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalStateException.class, e.getClass());
            Assert.assertEquals((Object)("Storage attribute \"" + attributeName + "\" must be a valid integer. Actual value is \"" + attributeValue + "\""), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetStorageAttributeIntegerValueByNameWithDefault_7() {
        String attributeName = "test";
        String attributeValue = "      \t\t ";
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntityWithAttributes(attributeName, attributeValue);
        Integer defaultValue = 2345;
        try {
            this.storageHelper.getStorageAttributeIntegerValueByName(attributeName, storageEntity, defaultValue);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalStateException.class, e.getClass());
            Assert.assertEquals((Object)("Storage attribute \"" + attributeName + "\" must be a valid integer. Actual value is \"" + attributeValue + "\""), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetStorageAttributeIntegerValueByNameWithDefault_8() {
        String attributeName = "test";
        String attributeValue = "      \t\t ";
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntityWithAttributes(attributeName, attributeValue);
        Integer defaultValue = null;
        try {
            this.storageHelper.getStorageAttributeIntegerValueByName(attributeName, storageEntity, defaultValue);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalStateException.class, e.getClass());
            Assert.assertEquals((Object)("Storage attribute \"" + attributeName + "\" must be a valid integer. Actual value is \"" + attributeValue + "\""), (Object)e.getMessage());
        }
    }
}

