/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.StorageFile;
import org.finra.herd.model.api.xml.StoragePolicyKey;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.dto.StoragePolicySelection;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.StorageFileHelper;
import org.finra.herd.service.helper.StoragePolicyProcessorJmsMessageListener;
import org.fusesource.hawtbuf.ByteArrayInputStream;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class StoragePolicyProcessorJmsMessageListenerTest
extends AbstractServiceTest {
    @Autowired
    private StorageFileHelper storageFileHelper;
    @Autowired
    StoragePolicyProcessorJmsMessageListener storagePolicyProcessorJmsMessageListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessMessage() throws Exception {
        String s3KeyPrefix = StoragePolicyProcessorJmsMessageListenerTest.getExpectedS3KeyPrefix(BDEF_NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, null, null, DATA_VERSION);
        S3FileTransferRequestParamsDto sourceS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME).s3KeyPrefix(s3KeyPrefix + "/").build();
        S3FileTransferRequestParamsDto destinationS3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().s3BucketName(S3_BUCKET_NAME_2).s3KeyPrefix(S3_BUCKET_NAME + "/" + s3KeyPrefix + "/").build();
        this.storagePolicyServiceTestHelper.createDatabaseEntitiesForStoragePolicyTesting(STORAGE_POLICY_NAMESPACE_CD, Arrays.asList(STORAGE_POLICY_RULE_TYPE), BDEF_NAMESPACE, BDEF_NAME, Arrays.asList(FORMAT_FILE_TYPE_CODE), Arrays.asList(STORAGE_NAME), Arrays.asList(STORAGE_NAME_2));
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        StorageUnitEntity sourceStorageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKey, LATEST_VERSION_FLAG_SET, "VALID", "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        for (String filePath : LOCAL_FILES) {
            this.storageFileDaoTestHelper.createStorageFileEntity(sourceStorageUnitEntity, s3KeyPrefix + "/" + filePath, Long.valueOf(1024L), Long.valueOf(1000L));
        }
        List sourceStorageFiles = this.storageFileHelper.createStorageFilesFromEntities(sourceStorageUnitEntity.getStorageFiles());
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.storagePolicyDaoTestHelper.createStoragePolicyEntity(storagePolicyKey, STORAGE_POLICY_RULE_TYPE, STORAGE_POLICY_RULE_VALUE, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, STORAGE_NAME, STORAGE_NAME_2, "ENABLED", INITIAL_VERSION, LATEST_VERSION_FLAG_SET);
        try {
            for (StorageFile storageFile : sourceStorageFiles) {
                this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME, storageFile.getFilePath(), (InputStream)new ByteArrayInputStream(new byte[storageFile.getFileSizeBytes().intValue()]), null), null);
            }
            this.storagePolicyProcessorJmsMessageListener.processMessage(this.jsonHelper.objectToJson((Object)new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION)), null);
            Assert.assertEquals((Object)"DISABLED", (Object)sourceStorageUnitEntity.getStatus().getCode());
            StorageUnitEntity destinationStorageUnitEntity = this.storageUnitDao.getStorageUnitByBusinessObjectDataAndStorageName(sourceStorageUnitEntity.getBusinessObjectData(), STORAGE_NAME_2);
            Assert.assertEquals((Object)"ENABLED", (Object)destinationStorageUnitEntity.getStatus().getCode());
            Assert.assertEquals((long)0L, (long)destinationStorageUnitEntity.getStorageFiles().size());
            Assert.assertTrue((boolean)this.s3Dao.listDirectory(sourceS3FileTransferRequestParamsDto).isEmpty());
            Assert.assertEquals((long)sourceStorageFiles.size(), (long)this.s3Dao.listDirectory(destinationS3FileTransferRequestParamsDto).size());
        }
        catch (Throwable throwable) {
            for (S3FileTransferRequestParamsDto params : Arrays.asList(sourceS3FileTransferRequestParamsDto, destinationS3FileTransferRequestParamsDto)) {
                if (this.s3Dao.listDirectory(params).isEmpty()) continue;
                this.s3Dao.deleteDirectory(params);
            }
            this.s3Operations.rollback();
            throw throwable;
        }
        for (S3FileTransferRequestParamsDto params : Arrays.asList(sourceS3FileTransferRequestParamsDto, destinationS3FileTransferRequestParamsDto)) {
            if (this.s3Dao.listDirectory(params).isEmpty()) continue;
            this.s3Dao.deleteDirectory(params);
        }
        this.s3Operations.rollback();
    }

    @Test
    public void testProcessMessageBusinessObjectDataNoExists() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        this.executeWithoutLogging(StoragePolicyProcessorJmsMessageListener.class, () -> this.storagePolicyProcessorJmsMessageListener.processMessage(this.jsonHelper.objectToJson((Object)new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, INITIAL_VERSION)), null));
    }
}

