/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class StorageUnitDaoHelperTest
extends AbstractServiceTest {
    @Test
    public void testGetStorageUnitEntity() {
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS, STORAGE_UNIT_STATUS, NO_STORAGE_DIRECTORY_PATH);
        BusinessObjectDataEntity businessObjectDataEntity = storageUnitEntity.getBusinessObjectData();
        try {
            this.storageUnitDaoHelper.getStorageUnitEntity("I_DO_NOT_EXIST", businessObjectDataEntity);
            Assert.fail((String)"Should throw an ObjectNotFoundException.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Could not find storage unit in \"I_DO_NOT_EXIST\" storage for the business object data {%s}.", this.businessObjectDataHelper.businessObjectDataKeyToString(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION))), (Object)e.getMessage());
        }
        StorageUnitEntity resultStorageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity);
        Assert.assertNotNull((Object)resultStorageUnitEntity);
        Assert.assertEquals((Object)storageUnitEntity.getId(), (Object)resultStorageUnitEntity.getId());
    }

    @Test
    public void testUpdateStorageUnitStatus() {
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, BDATA_STATUS, STORAGE_UNIT_STATUS, NO_STORAGE_DIRECTORY_PATH);
        this.storageUnitStatusDaoTestHelper.createStorageUnitStatusEntity(STORAGE_UNIT_STATUS_2);
        this.storageUnitDaoHelper.updateStorageUnitStatus(storageUnitEntity, STORAGE_UNIT_STATUS_2, REASON);
        Assert.assertEquals((Object)STORAGE_UNIT_STATUS_2, (Object)storageUnitEntity.getStatus().getCode());
    }
}

