/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import java.util.ArrayList;
import org.apache.commons.collections4.IterableUtils;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.core.helper.WildcardHelper;
import org.finra.herd.dao.NamespaceDao;
import org.finra.herd.dao.UserDao;
import org.finra.herd.dao.UserNamespaceAuthorizationDao;
import org.finra.herd.model.api.xml.NamespaceAuthorization;
import org.finra.herd.model.dto.ApplicationUser;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.model.jpa.UserNamespaceAuthorizationEntity;
import org.finra.herd.service.helper.UserNamespaceAuthorizationHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class UserNamespaceAuthorizationHelperTest {
    @InjectMocks
    private UserNamespaceAuthorizationHelper userNamespaceAuthorizationHelper;
    @Mock
    private NamespaceDao namespaceDao;
    @Mock
    private ConfigurationHelper configurationHelper;
    @Mock
    private UserDao userDao;
    @Mock
    private UserNamespaceAuthorizationDao userNamespaceAuthorizationDao;
    @Mock
    private WildcardHelper wildcardHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testBuildNamespaceAuthorizationsAssertAuthLookupByUserId() {
        ApplicationUser applicationUser = new ApplicationUser(this.getClass());
        String userId = "userId";
        applicationUser.setUserId(userId);
        Mockito.when((Object)this.configurationHelper.getBooleanProperty((ConfigurationValue)Matchers.any())).thenReturn((Object)true);
        ArrayList<UserNamespaceAuthorizationEntity> userNamespaceAuthorizationEntities = new ArrayList<UserNamespaceAuthorizationEntity>();
        UserNamespaceAuthorizationEntity userNamespaceAuthorizationEntity = new UserNamespaceAuthorizationEntity();
        userNamespaceAuthorizationEntity.setUserId("userNamespaceAuthorizationEntityUserId");
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode("namespace");
        userNamespaceAuthorizationEntity.setNamespace(namespaceEntity);
        userNamespaceAuthorizationEntities.add(userNamespaceAuthorizationEntity);
        Mockito.when((Object)this.userNamespaceAuthorizationDao.getUserNamespaceAuthorizationsByUserId((String)Matchers.any())).thenReturn(userNamespaceAuthorizationEntities);
        this.userNamespaceAuthorizationHelper.buildNamespaceAuthorizations(applicationUser);
        Assert.assertEquals((long)1L, (long)applicationUser.getNamespaceAuthorizations().size());
        NamespaceAuthorization namespaceAuthorization = (NamespaceAuthorization)IterableUtils.get((Iterable)applicationUser.getNamespaceAuthorizations(), (int)0);
        Assert.assertEquals((Object)namespaceEntity.getCode(), (Object)namespaceAuthorization.getNamespace());
        ((UserNamespaceAuthorizationDao)Mockito.verify((Object)this.userNamespaceAuthorizationDao)).getUserNamespaceAuthorizationsByUserId((String)Matchers.eq((Object)userId));
        ((UserNamespaceAuthorizationDao)Mockito.verify((Object)this.userNamespaceAuthorizationDao)).getUserNamespaceAuthorizationsByUserIdStartsWith((String)Matchers.eq((Object)"*"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.userNamespaceAuthorizationDao, this.wildcardHelper});
    }

    @Test
    public void testBuildNamespaceAuthorizationsAssertWildcardQueryExecuted() {
        ApplicationUser applicationUser = new ApplicationUser(this.getClass());
        String userId = "userId";
        applicationUser.setUserId(userId);
        Mockito.when((Object)this.configurationHelper.getBooleanProperty((ConfigurationValue)Matchers.any())).thenReturn((Object)true);
        ArrayList<UserNamespaceAuthorizationEntity> wildcardEntities = new ArrayList<UserNamespaceAuthorizationEntity>();
        UserNamespaceAuthorizationEntity wildcardEntity = new UserNamespaceAuthorizationEntity();
        wildcardEntity.setUserId("wildcardEntityUserId");
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode("namespace");
        wildcardEntity.setNamespace(namespaceEntity);
        wildcardEntities.add(wildcardEntity);
        Mockito.when((Object)this.userNamespaceAuthorizationDao.getUserNamespaceAuthorizationsByUserIdStartsWith((String)Matchers.any())).thenReturn(wildcardEntities);
        Mockito.when((Object)this.wildcardHelper.matches((String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)true);
        this.userNamespaceAuthorizationHelper.buildNamespaceAuthorizations(applicationUser);
        Assert.assertEquals((long)1L, (long)applicationUser.getNamespaceAuthorizations().size());
        NamespaceAuthorization namespaceAuthorization = (NamespaceAuthorization)IterableUtils.get((Iterable)applicationUser.getNamespaceAuthorizations(), (int)0);
        Assert.assertEquals((Object)namespaceEntity.getCode(), (Object)namespaceAuthorization.getNamespace());
        ((UserNamespaceAuthorizationDao)Mockito.verify((Object)this.userNamespaceAuthorizationDao)).getUserNamespaceAuthorizationsByUserId((String)Matchers.eq((Object)userId));
        ((UserNamespaceAuthorizationDao)Mockito.verify((Object)this.userNamespaceAuthorizationDao)).getUserNamespaceAuthorizationsByUserIdStartsWith((String)Matchers.eq((Object)"*"));
        ((WildcardHelper)Mockito.verify((Object)this.wildcardHelper)).matches((String)Matchers.eq((Object)userId.toUpperCase()), (String)Matchers.eq((Object)wildcardEntity.getUserId().toUpperCase()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.userNamespaceAuthorizationDao, this.wildcardHelper});
    }

    @Test
    public void testBuildNamespaceAuthorizationsAssertWildcardEntityNotAddedIfMatchFails() {
        ApplicationUser applicationUser = new ApplicationUser(this.getClass());
        String userId = "userId";
        applicationUser.setUserId(userId);
        Mockito.when((Object)this.configurationHelper.getBooleanProperty((ConfigurationValue)Matchers.any())).thenReturn((Object)true);
        ArrayList<UserNamespaceAuthorizationEntity> wildcardEntities = new ArrayList<UserNamespaceAuthorizationEntity>();
        UserNamespaceAuthorizationEntity wildcardEntity = new UserNamespaceAuthorizationEntity();
        wildcardEntity.setUserId("wildcardEntityUserId");
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        namespaceEntity.setCode("namespace");
        wildcardEntity.setNamespace(namespaceEntity);
        wildcardEntities.add(wildcardEntity);
        Mockito.when((Object)this.userNamespaceAuthorizationDao.getUserNamespaceAuthorizationsByUserIdStartsWith((String)Matchers.any())).thenReturn(wildcardEntities);
        Mockito.when((Object)this.wildcardHelper.matches((String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)false);
        this.userNamespaceAuthorizationHelper.buildNamespaceAuthorizations(applicationUser);
        Assert.assertEquals((long)0L, (long)applicationUser.getNamespaceAuthorizations().size());
        ((UserNamespaceAuthorizationDao)Mockito.verify((Object)this.userNamespaceAuthorizationDao)).getUserNamespaceAuthorizationsByUserId((String)Matchers.eq((Object)userId));
        ((UserNamespaceAuthorizationDao)Mockito.verify((Object)this.userNamespaceAuthorizationDao)).getUserNamespaceAuthorizationsByUserIdStartsWith((String)Matchers.eq((Object)"*"));
        ((WildcardHelper)Mockito.verify((Object)this.wildcardHelper)).matches((String)Matchers.eq((Object)userId.toUpperCase()), (String)Matchers.eq((Object)wildcardEntity.getUserId().toUpperCase()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.userNamespaceAuthorizationDao, this.wildcardHelper});
    }
}

