/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectDataAttribute;
import org.finra.herd.model.api.xml.BusinessObjectDataAttributeCreateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataAttributeKey;
import org.finra.herd.model.api.xml.BusinessObjectDataAttributeKeys;
import org.finra.herd.model.api.xml.BusinessObjectDataAttributeUpdateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.jpa.BusinessObjectDataAttributeEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.impl.BusinessObjectDataAttributeServiceImpl;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BusinessObjectDataAttributeServiceTest
extends AbstractServiceTest {
    @Autowired
    @Qualifier(value="businessObjectDataAttributeServiceImpl")
    private BusinessObjectDataAttributeServiceImpl businessObjectDataAttributeServiceImpl;

    @Test
    public void testCreateBusinessObjectDataAttribute() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectDataAttribute resultBusinessObjectDataAttribute = this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1"));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1", resultBusinessObjectDataAttribute);
    }

    @Test
    public void testCreateBusinessObjectDataAttributeMissingRequiredParameters() {
        try {
            this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeCreateRequest(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeCreateRequest(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "      \t\t ", SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList("      \t\t "), DATA_VERSION, "Attribute Name 1", "Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, null, "Attribute Name 1", "Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data version must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "      \t\t ", "Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data attribute name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data attribute name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataAttributeTrimParameters() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectDataAttribute resultBusinessObjectDataAttribute = this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeCreateRequest(NAMESPACE, this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, this.addWhitespace(PARTITION_VALUE), this.addWhitespace(SUBPARTITION_VALUES), DATA_VERSION, this.addWhitespace("Attribute Name 1"), this.addWhitespace("Attribute Value 1")));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", this.addWhitespace("Attribute Value 1"), resultBusinessObjectDataAttribute);
    }

    @Test
    public void testCreateBusinessObjectDataAttributeUpperCaseParameters() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), this.convertListToLowerCase(SUBPARTITION_VALUES), DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectDataAttribute resultBusinessObjectDataAttribute = this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeCreateRequest(NAMESPACE, BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), this.convertListToLowerCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toUpperCase(), "Attribute Value 1".toUpperCase()));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(null, NAMESPACE, BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), this.convertListToLowerCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toUpperCase(), "Attribute Value 1".toUpperCase(), resultBusinessObjectDataAttribute);
    }

    @Test
    public void testCreateBusinessObjectDataAttributeLowerCaseParameters() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), this.convertListToUpperCase(SUBPARTITION_VALUES), DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectDataAttribute resultBusinessObjectDataAttribute = this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeCreateRequest(NAMESPACE, BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), this.convertListToUpperCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toLowerCase(), "Attribute Value 1".toLowerCase()));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(null, NAMESPACE, BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), this.convertListToUpperCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toLowerCase(), "Attribute Value 1".toLowerCase(), resultBusinessObjectDataAttribute);
    }

    @Test
    public void testCreateBusinessObjectDataAttributeInvalidParameters() {
        try {
            this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(new BusinessObjectDataAttributeCreateRequest(new BusinessObjectDataAttributeKey(this.addSlash(BDEF_NAMESPACE), BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"), "Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Namespace can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(new BusinessObjectDataAttributeCreateRequest(new BusinessObjectDataAttributeKey(BDEF_NAMESPACE, this.addSlash(BDEF_NAME), FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"), "Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object definition name can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(new BusinessObjectDataAttributeCreateRequest(new BusinessObjectDataAttributeKey(BDEF_NAMESPACE, BDEF_NAME, this.addSlash(FORMAT_USAGE_CODE), FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"), "Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object format usage can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(new BusinessObjectDataAttributeCreateRequest(new BusinessObjectDataAttributeKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, this.addSlash(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"), "Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object format file type can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(new BusinessObjectDataAttributeCreateRequest(new BusinessObjectDataAttributeKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, this.addSlash(PARTITION_VALUE), SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"), "Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Partition value can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(new BusinessObjectDataAttributeCreateRequest(new BusinessObjectDataAttributeKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(this.addSlash(PARTITION_VALUE_2)), DATA_VERSION, "Attribute Name 1"), "Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when sub-partition value contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Subpartition value can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(new BusinessObjectDataAttributeCreateRequest(new BusinessObjectDataAttributeKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, this.addSlash("Attribute Name 1")), "Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when attribute name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Business object data attribute name can not contain a forward slash character.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataAttributeBusinessObjectFormatNoExists() {
        try {
            this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1"));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object format does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object format with namespace \"%s\", business object definition name \"%s\", format usage \"%s\", format file type \"%s\", and format version \"%d\" doesn't exist.", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataAttributeBusinessObjectDataNoExists() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, Boolean.valueOf(true), PARTITION_KEY);
        try {
            this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1"));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, null), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataAttributeBusinessObjectDataAttributeAlreadyExists() {
        this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1".toUpperCase(), "Attribute Value 1");
        try {
            this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1".toLowerCase(), "   Attribute Value 2  "));
            Assert.fail((String)"Should throw an AlreadyExistsException when business object data attribute already exists.");
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Unable to create business object data attribute with name \"%s\" because it already exists for the business object data {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, businessObjectDataPartitionValue: \"%s\", businessObjectDataSubPartitionValues: \"%s,%s,%s,%s\", businessObjectDataVersion: %d}.", "Attribute Name 1".toLowerCase(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES.get(0), SUBPARTITION_VALUES.get(1), SUBPARTITION_VALUES.get(2), SUBPARTITION_VALUES.get(3), DATA_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataAttributeBlankValue() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectDataAttribute resultBusinessObjectDataAttribute = this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "      \t\t "));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "      \t\t ", resultBusinessObjectDataAttribute);
    }

    @Test
    public void testCreateBusinessObjectDataAttributeNullValue() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectDataAttribute resultBusinessObjectDataAttribute = this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", null));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", null, resultBusinessObjectDataAttribute);
    }

    @Test
    public void testCreateBusinessObjectDataAttributeRequiredAttribute() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectDataAttributeDefinitionEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "Attribute Name 1");
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectDataAttribute resultBusinessObjectDataAttribute = this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1"));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(null, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1", resultBusinessObjectDataAttribute);
    }

    @Test
    public void testCreateBusinessObjectDataAttributeRequiredAttributeMissingValue() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectDataAttributeDefinitionEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "Attribute Name 1");
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        try {
            this.businessObjectDataAttributeService.createBusinessObjectDataAttribute(this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeCreateRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data attribute value is not specified for a required attribute.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("A business object data attribute value must be specified since \"%s\" is a required attribute for business object format {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d}.", "Attribute Name 1", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDataAttribute() {
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1");
        BusinessObjectDataAttribute resultBusinessObjectDataAttribute = this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(businessObjectDataAttributeEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1", resultBusinessObjectDataAttribute);
    }

    @Test
    public void testGetBusinessObjectDataAttributeMissingRequiredParameters() {
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "      \t\t ", SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList("      \t\t ", (String)SUBPARTITION_VALUES.get(1), (String)SUBPARTITION_VALUES.get(2), (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when 1st subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), "      \t\t ", (String)SUBPARTITION_VALUES.get(2), (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when 2nd subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), (String)SUBPARTITION_VALUES.get(1), "      \t\t ", (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when 3rd subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), (String)SUBPARTITION_VALUES.get(1), (String)SUBPARTITION_VALUES.get(2), "      \t\t "), DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when 4th subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, null, "Attribute Name 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data version must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data attribute name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data attribute name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDataAttributeMissingOptionalParameters() {
        for (int i = 0; i <= 4; ++i) {
            List<String> subPartitionValues = SUBPARTITION_VALUES.subList(0, i);
            BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, subPartitionValues, DATA_VERSION, "Attribute Name 1", "Attribute Value 1");
            BusinessObjectDataAttribute resultBusinessObjectDataAttribute = null;
            switch (i) {
                case 0: {
                    resultBusinessObjectDataAttribute = this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
                    break;
                }
                case 1: {
                    resultBusinessObjectDataAttribute = this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(subPartitionValues.get(0)), DATA_VERSION, "Attribute Name 1"));
                    break;
                }
                case 2: {
                    resultBusinessObjectDataAttribute = this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(subPartitionValues.get(0), subPartitionValues.get(1)), DATA_VERSION, "Attribute Name 1"));
                    break;
                }
                case 3: {
                    resultBusinessObjectDataAttribute = this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(subPartitionValues.get(0), subPartitionValues.get(1), subPartitionValues.get(2)), DATA_VERSION, "Attribute Name 1"));
                    break;
                }
                case 4: {
                    resultBusinessObjectDataAttribute = this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(subPartitionValues.get(0), subPartitionValues.get(1), subPartitionValues.get(2), subPartitionValues.get(3)), DATA_VERSION, "Attribute Name 1"));
                }
            }
            this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(businessObjectDataAttributeEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, subPartitionValues, DATA_VERSION, "Attribute Name 1", "Attribute Value 1", resultBusinessObjectDataAttribute);
        }
    }

    @Test
    public void testGetBusinessObjectDataAttributeTrimParameters() {
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1");
        BusinessObjectDataAttribute resultBusinessObjectDataAttribute = this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, this.addWhitespace(PARTITION_VALUE), this.addWhitespace(SUBPARTITION_VALUES), DATA_VERSION, this.addWhitespace("Attribute Name 1")));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(businessObjectDataAttributeEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1", resultBusinessObjectDataAttribute);
    }

    @Test
    public void testGetBusinessObjectDataAttributeUpperCaseParameters() {
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), this.convertListToLowerCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toLowerCase(), "Attribute Value 1".toLowerCase());
        BusinessObjectDataAttribute resultBusinessObjectDataAttribute = this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), this.convertListToLowerCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toUpperCase()));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(businessObjectDataAttributeEntity.getId(), NAMESPACE, BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), this.convertListToLowerCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toLowerCase(), "Attribute Value 1".toLowerCase(), resultBusinessObjectDataAttribute);
    }

    @Test
    public void testGetBusinessObjectDataAttributeLowerCaseParameters() {
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), this.convertListToUpperCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toUpperCase(), "Attribute Value 1".toUpperCase());
        BusinessObjectDataAttribute resultBusinessObjectDataAttribute = this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), this.convertListToUpperCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toLowerCase()));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(businessObjectDataAttributeEntity.getId(), NAMESPACE, BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), this.convertListToUpperCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toUpperCase(), "Attribute Value 1".toUpperCase(), resultBusinessObjectDataAttribute);
    }

    @Test
    public void testGetBusinessObjectDataAttributeBusinessObjectDataNoExists() {
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, null), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDataAttributeBusinessObjectDataAttributeNoExists() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data attribute does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Attribute with name \"%s\" does not exist for business object data {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, businessObjectDataPartitionValue: \"%s\", businessObjectDataSubPartitionValues: \"%s,%s,%s,%s\", businessObjectDataVersion: %d}.", "Attribute Name 1", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES.get(0), SUBPARTITION_VALUES.get(1), SUBPARTITION_VALUES.get(2), SUBPARTITION_VALUES.get(3), DATA_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDataAttributes() {
        List<String> testBusinessObjectDataAttributeNames = Arrays.asList("Attribute Name 1", "Attribute Name 2");
        for (String businessObjectDataAttributeName : testBusinessObjectDataAttributeNames) {
            this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, businessObjectDataAttributeName, "Attribute Value 1");
        }
        BusinessObjectDataAttributeKeys resultBusinessObjectDataAttributeKeys = this.businessObjectDataAttributeService.getBusinessObjectDataAttributes(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
        Assert.assertNotNull((Object)resultBusinessObjectDataAttributeKeys);
        Assert.assertEquals((long)testBusinessObjectDataAttributeNames.size(), (long)resultBusinessObjectDataAttributeKeys.getBusinessObjectDataAttributeKeys().size());
        for (int i = 0; i < testBusinessObjectDataAttributeNames.size(); ++i) {
            this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, testBusinessObjectDataAttributeNames.get(i), (BusinessObjectDataAttributeKey)resultBusinessObjectDataAttributeKeys.getBusinessObjectDataAttributeKeys().get(i));
        }
    }

    @Test
    public void testGetBusinessObjectDataAttributesMissingRequiredParameters() {
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttributes(new BusinessObjectDataKey(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttributes(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttributes(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttributes(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttributes(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "      \t\t ", SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttributes(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList("      \t\t ", (String)SUBPARTITION_VALUES.get(1), (String)SUBPARTITION_VALUES.get(2), (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when 1st subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttributes(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), "      \t\t ", (String)SUBPARTITION_VALUES.get(2), (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when 2nd subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttributes(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), (String)SUBPARTITION_VALUES.get(1), "      \t\t ", (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when 3rd subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttributes(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), (String)SUBPARTITION_VALUES.get(1), (String)SUBPARTITION_VALUES.get(2), "      \t\t "), DATA_VERSION));
            Assert.fail((String)"Should throw an IllegalArgumentException when 4th subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttributes(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, null));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data version must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDataAttributesMissingOptionalParameters() {
        List<String> testBusinessObjectDataAttributeNames = Arrays.asList("Attribute Name 1", "Attribute Name 2");
        for (int i = 0; i <= 4; ++i) {
            List<String> subPartitionValues = SUBPARTITION_VALUES.subList(0, i);
            for (String businessObjectDataAttributeName : testBusinessObjectDataAttributeNames) {
                this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, subPartitionValues, DATA_VERSION, businessObjectDataAttributeName, "Attribute Value 1");
            }
            BusinessObjectDataAttributeKeys resultBusinessObjectDataAttributeKeys = null;
            switch (i) {
                case 0: {
                    resultBusinessObjectDataAttributeKeys = this.businessObjectDataAttributeService.getBusinessObjectDataAttributes(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION));
                    break;
                }
                case 1: {
                    resultBusinessObjectDataAttributeKeys = this.businessObjectDataAttributeService.getBusinessObjectDataAttributes(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0)), DATA_VERSION));
                    break;
                }
                case 2: {
                    resultBusinessObjectDataAttributeKeys = this.businessObjectDataAttributeService.getBusinessObjectDataAttributes(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), (String)SUBPARTITION_VALUES.get(1)), DATA_VERSION));
                    break;
                }
                case 3: {
                    resultBusinessObjectDataAttributeKeys = this.businessObjectDataAttributeService.getBusinessObjectDataAttributes(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), (String)SUBPARTITION_VALUES.get(1), (String)SUBPARTITION_VALUES.get(2)), DATA_VERSION));
                    break;
                }
                case 4: {
                    resultBusinessObjectDataAttributeKeys = this.businessObjectDataAttributeService.getBusinessObjectDataAttributes(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
                }
            }
            Assert.assertNotNull(resultBusinessObjectDataAttributeKeys);
            Assert.assertEquals((long)testBusinessObjectDataAttributeNames.size(), (long)resultBusinessObjectDataAttributeKeys.getBusinessObjectDataAttributeKeys().size());
            for (int j = 0; j < testBusinessObjectDataAttributeNames.size(); ++j) {
                this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, subPartitionValues, DATA_VERSION, testBusinessObjectDataAttributeNames.get(j), (BusinessObjectDataAttributeKey)resultBusinessObjectDataAttributeKeys.getBusinessObjectDataAttributeKeys().get(j));
            }
        }
    }

    @Test
    public void testGetBusinessObjectDataAttributesTrimParameters() {
        List<String> testBusinessObjectDataAttributeNames = Arrays.asList("Attribute Name 1", "Attribute Name 2");
        for (String businessObjectDataAttributeName : testBusinessObjectDataAttributeNames) {
            this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, businessObjectDataAttributeName, "Attribute Value 1");
        }
        BusinessObjectDataAttributeKeys resultBusinessObjectDataAttributeKeys = this.businessObjectDataAttributeService.getBusinessObjectDataAttributes(new BusinessObjectDataKey(NAMESPACE, this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, this.addWhitespace(PARTITION_VALUE), this.addWhitespace(SUBPARTITION_VALUES), DATA_VERSION));
        Assert.assertNotNull((Object)resultBusinessObjectDataAttributeKeys);
        Assert.assertEquals((long)testBusinessObjectDataAttributeNames.size(), (long)resultBusinessObjectDataAttributeKeys.getBusinessObjectDataAttributeKeys().size());
        for (int i = 0; i < testBusinessObjectDataAttributeNames.size(); ++i) {
            this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, testBusinessObjectDataAttributeNames.get(i), (BusinessObjectDataAttributeKey)resultBusinessObjectDataAttributeKeys.getBusinessObjectDataAttributeKeys().get(i));
        }
    }

    @Test
    public void testGetBusinessObjectDataAttributesUpperCaseParameters() {
        List<String> testBusinessObjectDataAttributeNames = Arrays.asList("Attribute Name 1", "Attribute Name 2");
        for (String businessObjectDataAttributeName : testBusinessObjectDataAttributeNames) {
            this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), this.convertListToLowerCase(SUBPARTITION_VALUES), DATA_VERSION, businessObjectDataAttributeName.toLowerCase(), "Attribute Value 1".toLowerCase());
        }
        BusinessObjectDataAttributeKeys resultBusinessObjectDataAttributeKeys = this.businessObjectDataAttributeService.getBusinessObjectDataAttributes(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), this.convertListToLowerCase(SUBPARTITION_VALUES), DATA_VERSION));
        Assert.assertNotNull((Object)resultBusinessObjectDataAttributeKeys);
        Assert.assertEquals((long)testBusinessObjectDataAttributeNames.size(), (long)resultBusinessObjectDataAttributeKeys.getBusinessObjectDataAttributeKeys().size());
        for (int i = 0; i < testBusinessObjectDataAttributeNames.size(); ++i) {
            this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), this.convertListToLowerCase(SUBPARTITION_VALUES), DATA_VERSION, testBusinessObjectDataAttributeNames.get(i).toLowerCase(), (BusinessObjectDataAttributeKey)resultBusinessObjectDataAttributeKeys.getBusinessObjectDataAttributeKeys().get(i));
        }
    }

    @Test
    public void testGetBusinessObjectDataAttributesLowerCaseParameters() {
        List<String> testBusinessObjectDataAttributeNames = Arrays.asList("Attribute Name 1", "Attribute Name 2");
        for (String businessObjectDataAttributeName : testBusinessObjectDataAttributeNames) {
            this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), this.convertListToUpperCase(SUBPARTITION_VALUES), DATA_VERSION, businessObjectDataAttributeName.toUpperCase(), "Attribute Value 1".toUpperCase());
        }
        BusinessObjectDataAttributeKeys resultBusinessObjectDataAttributeKeys = this.businessObjectDataAttributeService.getBusinessObjectDataAttributes(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), this.convertListToUpperCase(SUBPARTITION_VALUES), DATA_VERSION));
        Assert.assertNotNull((Object)resultBusinessObjectDataAttributeKeys);
        Assert.assertEquals((long)testBusinessObjectDataAttributeNames.size(), (long)resultBusinessObjectDataAttributeKeys.getBusinessObjectDataAttributeKeys().size());
        for (int i = 0; i < testBusinessObjectDataAttributeNames.size(); ++i) {
            this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), this.convertListToUpperCase(SUBPARTITION_VALUES), DATA_VERSION, testBusinessObjectDataAttributeNames.get(i).toUpperCase(), (BusinessObjectDataAttributeKey)resultBusinessObjectDataAttributeKeys.getBusinessObjectDataAttributeKeys().get(i));
        }
    }

    @Test
    public void testGetBusinessObjectDataAttributesBusinessObjectDataNoExists() {
        try {
            this.businessObjectDataAttributeService.getBusinessObjectDataAttributes(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object format does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, null), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDataAttributesBusinessObjectDataAttributesNoExist() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        BusinessObjectDataAttributeKeys resultBusinessObjectDataAttributeKeys = this.businessObjectDataAttributeService.getBusinessObjectDataAttributes(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
        Assert.assertNotNull((Object)resultBusinessObjectDataAttributeKeys);
        Assert.assertEquals((long)0L, (long)resultBusinessObjectDataAttributeKeys.getBusinessObjectDataAttributeKeys().size());
    }

    @Test
    public void testUpdateBusinessObjectDataAttribute() {
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1");
        BusinessObjectDataAttribute updatedBusinessObjectDataAttribute = this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("   Attribute Value 2  "));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(businessObjectDataAttributeEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "   Attribute Value 2  ", updatedBusinessObjectDataAttribute);
    }

    @Test
    public void testUpdateBusinessObjectDataAttributeMissingRequiredParameters() {
        try {
            this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "      \t\t ", NO_SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList("      \t\t ", (String)SUBPARTITION_VALUES.get(1), (String)SUBPARTITION_VALUES.get(2), (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when 1st subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), "      \t\t ", (String)SUBPARTITION_VALUES.get(2), (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when 2nd subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), (String)SUBPARTITION_VALUES.get(1), "      \t\t ", (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when 3rd subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), (String)SUBPARTITION_VALUES.get(1), (String)SUBPARTITION_VALUES.get(2), "      \t\t "), DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when 4th subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, null, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data version must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "      \t\t "), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("Attribute Value 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data attribute name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data attribute name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDataAttributeMissingOptionalParameters() {
        for (int i = 0; i <= 4; ++i) {
            List<String> subPartitionValues = SUBPARTITION_VALUES.subList(0, i);
            BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, subPartitionValues, DATA_VERSION, "Attribute Name 1", "Attribute Value 1");
            BusinessObjectDataAttribute updatedBusinessObjectDataAttribute = null;
            switch (i) {
                case 0: {
                    updatedBusinessObjectDataAttribute = this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("   Attribute Value 2  "));
                    break;
                }
                case 1: {
                    updatedBusinessObjectDataAttribute = this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(subPartitionValues.get(0)), DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("   Attribute Value 2  "));
                    break;
                }
                case 2: {
                    updatedBusinessObjectDataAttribute = this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(subPartitionValues.get(0), subPartitionValues.get(1)), DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("   Attribute Value 2  "));
                    break;
                }
                case 3: {
                    updatedBusinessObjectDataAttribute = this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(subPartitionValues.get(0), subPartitionValues.get(1), subPartitionValues.get(2)), DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("   Attribute Value 2  "));
                    break;
                }
                case 4: {
                    updatedBusinessObjectDataAttribute = this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("   Attribute Value 2  "));
                }
            }
            this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(businessObjectDataAttributeEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, subPartitionValues, DATA_VERSION, "Attribute Name 1", "   Attribute Value 2  ", updatedBusinessObjectDataAttribute);
        }
    }

    @Test
    public void testUpdateBusinessObjectDataAttributeTrimParameters() {
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1");
        BusinessObjectDataAttribute updatedBusinessObjectDataAttribute = this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(this.addWhitespace(NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, this.addWhitespace(PARTITION_VALUE), this.addWhitespace(SUBPARTITION_VALUES), DATA_VERSION, this.addWhitespace("Attribute Name 1")), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest(this.addWhitespace("   Attribute Value 2  ")));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(businessObjectDataAttributeEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", this.addWhitespace("   Attribute Value 2  "), updatedBusinessObjectDataAttribute);
    }

    @Test
    public void testUpdateBusinessObjectDataAttributeUpperCaseParameters() {
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), this.convertListToLowerCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toLowerCase(), "Attribute Value 1".toLowerCase());
        BusinessObjectDataAttribute updatedBusinessObjectDataAttribute = this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), this.convertListToLowerCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toUpperCase()), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("   Attribute Value 2  ".toUpperCase()));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(businessObjectDataAttributeEntity.getId(), NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), this.convertListToLowerCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toLowerCase(), "   Attribute Value 2  ".toUpperCase(), updatedBusinessObjectDataAttribute);
    }

    @Test
    public void testUpdateBusinessObjectDataAttributeLowerCaseParameters() {
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), this.convertListToUpperCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toUpperCase(), "Attribute Value 1".toUpperCase());
        BusinessObjectDataAttribute updatedBusinessObjectDataAttribute = this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), this.convertListToUpperCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toLowerCase()), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("   Attribute Value 2  ".toLowerCase()));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(businessObjectDataAttributeEntity.getId(), NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), this.convertListToUpperCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toUpperCase(), "   Attribute Value 2  ".toLowerCase(), updatedBusinessObjectDataAttribute);
    }

    @Test
    public void testUpdateBusinessObjectDataAttributeBusinessObjectFormatNoExists() {
        try {
            this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("Attribute Value 1"));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object format does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object format with namespace \"%s\", business object definition name \"%s\", format usage \"%s\", format file type \"%s\", and format version \"%d\" doesn't exist.", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDataAttributeBusinessObjectDataNoExists() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, Boolean.valueOf(true), PARTITION_KEY);
        try {
            this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("Attribute Value 1"));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, null), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDataAttributeBusinessObjectDataAttributeNoExists() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        try {
            this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("Attribute Value 1"));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data attribute does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Attribute with name \"%s\" does not exist for business object data {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, businessObjectDataPartitionValue: \"%s\", businessObjectDataSubPartitionValues: \"%s,%s,%s,%s\", businessObjectDataVersion: %d}.", "Attribute Name 1", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES.get(0), SUBPARTITION_VALUES.get(1), SUBPARTITION_VALUES.get(2), SUBPARTITION_VALUES.get(3), DATA_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDataAttributeBlankValue() {
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1");
        BusinessObjectDataAttribute updatedBusinessObjectDataAttribute = this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("      \t\t "));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(businessObjectDataAttributeEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "      \t\t ", updatedBusinessObjectDataAttribute);
    }

    @Test
    public void testUpdateBusinessObjectDataAttributeNullValue() {
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1");
        BusinessObjectDataAttribute updatedBusinessObjectDataAttribute = this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest(null));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(businessObjectDataAttributeEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", null, updatedBusinessObjectDataAttribute);
    }

    @Test
    public void testUpdateBusinessObjectDataAttributeRequiredAttribute() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectDataAttributeDefinitionEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "Attribute Name 1");
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1");
        BusinessObjectDataAttribute updatedBusinessObjectDataAttribute = this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("   Attribute Value 2  "));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(businessObjectDataAttributeEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "   Attribute Value 2  ", updatedBusinessObjectDataAttribute);
    }

    @Test
    public void testUpdateBusinessObjectDataAttributeRequiredAttributeMissingValue() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectDataAttributeDefinitionEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "Attribute Name 1");
        this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1");
        try {
            this.businessObjectDataAttributeService.updateBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"), this.businessObjectDataAttributeServiceTestHelper.createBusinessObjectDataAttributeUpdateRequest("      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data attribute value is not specified for a required attribute.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("A business object data attribute value must be specified since \"%s\" is a required attribute for business object format {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d}.", "Attribute Name 1", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDataAttribute() {
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1");
        this.businessObjectDataAttributeDaoHelper.getBusinessObjectDataAttributeEntity(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
        BusinessObjectDataAttribute deletedBusinessObjectDataAttribute = this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(businessObjectDataAttributeEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1", deletedBusinessObjectDataAttribute);
        try {
            this.businessObjectDataAttributeDaoHelper.getBusinessObjectDataAttributeEntity(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data attribute does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Attribute with name \"%s\" does not exist for business object data {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, businessObjectDataPartitionValue: \"%s\", businessObjectDataSubPartitionValues: \"%s,%s,%s,%s\", businessObjectDataVersion: %d}.", "Attribute Name 1", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES.get(0), SUBPARTITION_VALUES.get(1), SUBPARTITION_VALUES.get(2), SUBPARTITION_VALUES.get(3), DATA_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDataAttributeMissingRequiredParameters() {
        try {
            this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "      \t\t ", FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "      \t\t ", SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList("      \t\t ", (String)SUBPARTITION_VALUES.get(1), (String)SUBPARTITION_VALUES.get(2), (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when 1st subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), "      \t\t ", (String)SUBPARTITION_VALUES.get(2), (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when 2nd subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), (String)SUBPARTITION_VALUES.get(1), "      \t\t ", (String)SUBPARTITION_VALUES.get(3)), DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when 3rd subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList((String)SUBPARTITION_VALUES.get(0), (String)SUBPARTITION_VALUES.get(1), (String)SUBPARTITION_VALUES.get(2), "      \t\t "), DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when 4th subpartition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A subpartition value must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, null, "Attribute Name 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data version is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data version must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data attribute name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data attribute name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDataAttributeMissingOptionalParameters() {
        for (int i = 0; i <= 4; ++i) {
            List<String> subPartitionValues = SUBPARTITION_VALUES.subList(0, i);
            BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, subPartitionValues, DATA_VERSION, "Attribute Name 1", "Attribute Value 1");
            this.businessObjectDataAttributeDaoHelper.getBusinessObjectDataAttributeEntity(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, subPartitionValues, DATA_VERSION, "Attribute Name 1"));
            BusinessObjectDataAttribute deletedBusinessObjectDataAttribute = null;
            switch (i) {
                case 0: {
                    deletedBusinessObjectDataAttribute = this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
                    break;
                }
                case 1: {
                    deletedBusinessObjectDataAttribute = this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(subPartitionValues.get(0)), DATA_VERSION, "Attribute Name 1"));
                    break;
                }
                case 2: {
                    deletedBusinessObjectDataAttribute = this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(subPartitionValues.get(0), subPartitionValues.get(1)), DATA_VERSION, "Attribute Name 1"));
                    break;
                }
                case 3: {
                    deletedBusinessObjectDataAttribute = this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(subPartitionValues.get(0), subPartitionValues.get(1), subPartitionValues.get(2)), DATA_VERSION, "Attribute Name 1"));
                    break;
                }
                case 4: {
                    deletedBusinessObjectDataAttribute = this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
                }
            }
            this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(businessObjectDataAttributeEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, subPartitionValues, DATA_VERSION, "Attribute Name 1", "Attribute Value 1", deletedBusinessObjectDataAttribute);
            try {
                this.businessObjectDataAttributeDaoHelper.getBusinessObjectDataAttributeEntity(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, subPartitionValues, DATA_VERSION, "Attribute Name 1"));
                Assert.fail((String)"Should throw an ObjectNotFoundException when business object data attribute does not exist.");
                continue;
            }
            catch (ObjectNotFoundException e) {
                Assert.assertEquals((Object)String.format("Attribute with name \"%s\" does not exist for business object data {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, businessObjectDataPartitionValue: \"%s\", businessObjectDataSubPartitionValues: \"%s\", businessObjectDataVersion: %d}.", "Attribute Name 1", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, StringUtils.join(subPartitionValues, (String)","), DATA_VERSION), (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testDeleteBusinessObjectDataAttributeTrimParameters() {
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1");
        this.businessObjectDataAttributeDaoHelper.getBusinessObjectDataAttributeEntity(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
        BusinessObjectDataAttribute deletedBusinessObjectDataAttribute = this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, this.addWhitespace(PARTITION_VALUE), this.addWhitespace(SUBPARTITION_VALUES), DATA_VERSION, this.addWhitespace("Attribute Name 1")));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(businessObjectDataAttributeEntity.getId(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1", deletedBusinessObjectDataAttribute);
        try {
            this.businessObjectDataAttributeDaoHelper.getBusinessObjectDataAttributeEntity(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data attribute does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Attribute with name \"%s\" does not exist for business object data {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, businessObjectDataPartitionValue: \"%s\", businessObjectDataSubPartitionValues: \"%s,%s,%s,%s\", businessObjectDataVersion: %d}.", "Attribute Name 1", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES.get(0), SUBPARTITION_VALUES.get(1), SUBPARTITION_VALUES.get(2), SUBPARTITION_VALUES.get(3), DATA_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDataAttributeUpperCaseParameters() {
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), this.convertListToLowerCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toLowerCase(), "Attribute Value 1".toLowerCase());
        this.businessObjectDataAttributeDaoHelper.getBusinessObjectDataAttributeEntity(new BusinessObjectDataAttributeKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), this.convertListToLowerCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toLowerCase()));
        BusinessObjectDataAttribute deletedBusinessObjectDataAttribute = this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), this.convertListToLowerCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toUpperCase()));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(businessObjectDataAttributeEntity.getId(), NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), this.convertListToLowerCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toLowerCase(), "Attribute Value 1".toLowerCase(), deletedBusinessObjectDataAttribute);
        try {
            this.businessObjectDataAttributeDaoHelper.getBusinessObjectDataAttributeEntity(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), this.convertListToLowerCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toLowerCase()));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data attribute does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Attribute with name \"%s\" does not exist for business object data {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, businessObjectDataPartitionValue: \"%s\", businessObjectDataSubPartitionValues: \"%s,%s,%s,%s\", businessObjectDataVersion: %d}.", "Attribute Name 1".toLowerCase(), NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toLowerCase(), ((String)SUBPARTITION_VALUES.get(0)).toLowerCase(), ((String)SUBPARTITION_VALUES.get(1)).toLowerCase(), ((String)SUBPARTITION_VALUES.get(2)).toLowerCase(), ((String)SUBPARTITION_VALUES.get(3)).toLowerCase(), DATA_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDataAttributeLowerCaseParameters() {
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), this.convertListToUpperCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toUpperCase(), "Attribute Value 1".toUpperCase());
        this.businessObjectDataAttributeDaoHelper.getBusinessObjectDataAttributeEntity(new BusinessObjectDataAttributeKey(NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), this.convertListToUpperCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toUpperCase()));
        BusinessObjectDataAttribute deletedBusinessObjectDataAttribute = this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), this.convertListToUpperCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toLowerCase()));
        this.businessObjectDataAttributeServiceTestHelper.validateBusinessObjectDataAttribute(businessObjectDataAttributeEntity.getId(), NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), this.convertListToUpperCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toUpperCase(), "Attribute Value 1".toUpperCase(), deletedBusinessObjectDataAttribute);
        try {
            this.businessObjectDataAttributeDaoHelper.getBusinessObjectDataAttributeEntity(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), this.convertListToUpperCase(SUBPARTITION_VALUES), DATA_VERSION, "Attribute Name 1".toUpperCase()));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data attribute does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Attribute with name \"%s\" does not exist for business object data {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, businessObjectDataPartitionValue: \"%s\", businessObjectDataSubPartitionValues: \"%s,%s,%s,%s\", businessObjectDataVersion: %d}.", "Attribute Name 1".toUpperCase(), NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, PARTITION_VALUE.toUpperCase(), ((String)SUBPARTITION_VALUES.get(0)).toUpperCase(), ((String)SUBPARTITION_VALUES.get(1)).toUpperCase(), ((String)SUBPARTITION_VALUES.get(2)).toUpperCase(), ((String)SUBPARTITION_VALUES.get(3)).toUpperCase(), DATA_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDataAttributeBusinessObjectFormatNoExists() {
        try {
            this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object format does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object format with namespace \"%s\", business object definition name \"%s\", format usage \"%s\", format file type \"%s\", and format version \"%d\" doesn't exist.", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDataAttributeBusinessObjectDataNoExists() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, Boolean.valueOf(true), PARTITION_KEY);
        try {
            this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, null), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDataAttributeBusinessObjectDataAttributeNoExists() {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        try {
            this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data attribute does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Attribute with name \"%s\" does not exist for business object data {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, businessObjectDataPartitionValue: \"%s\", businessObjectDataSubPartitionValues: \"%s,%s,%s,%s\", businessObjectDataVersion: %d}.", "Attribute Name 1", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES.get(0), SUBPARTITION_VALUES.get(1), SUBPARTITION_VALUES.get(2), SUBPARTITION_VALUES.get(3), DATA_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDataAttributeRequiredAttribute() {
        this.businessObjectFormatDaoTestHelper.createBusinessObjectDataAttributeDefinitionEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "Attribute Name 1");
        this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1", "Attribute Value 1");
        try {
            this.businessObjectDataAttributeService.deleteBusinessObjectDataAttribute(new BusinessObjectDataAttributeKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, "Attribute Name 1"));
            Assert.fail((String)"Should throw an IllegalArgumentException when deleting a required business object data attribute.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Cannot delete \"%s\" attribute since it is a required attribute for business object format {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d}.", "Attribute Name 1", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testBusinessObjectDataAttributeServiceMethodsNewTransactionPropagation() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataAttributeKey businessObjectDataAttributeKey = this.businessObjectDataAttributeHelper.getBusinessObjectDataAttributeKey(businessObjectDataKey, "Attribute Name 1");
        try {
            this.businessObjectDataAttributeServiceImpl.createBusinessObjectDataAttribute(new BusinessObjectDataAttributeCreateRequest(businessObjectDataAttributeKey, "Attribute Value 1"));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeServiceImpl.getBusinessObjectDataAttribute(businessObjectDataAttributeKey);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(businessObjectDataKey, NO_BDATA_STATUS), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeServiceImpl.updateBusinessObjectDataAttribute(businessObjectDataAttributeKey, new BusinessObjectDataAttributeUpdateRequest("   Attribute Value 2  "));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            this.businessObjectDataAttributeServiceImpl.deleteBusinessObjectDataAttribute(businessObjectDataAttributeKey);
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object format.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION), (Object)e.getMessage());
        }
        try {
            Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.businessObjectDataAttributeServiceImpl.getBusinessObjectDataAttributes(businessObjectDataKey).getBusinessObjectDataAttributeKeys()));
            Assert.fail((String)"Should throw an ObjectNotFoundException when not able to find business object data.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(businessObjectDataKey, NO_BDATA_STATUS), (Object)e.getMessage());
        }
    }
}

