/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.StorageClass;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageUnitKey;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.StorageFileEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.impl.BusinessObjectDataFinalizeRestoreServiceImpl;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BusinessObjectDataFinalizeRestoreServiceTest
extends AbstractServiceTest {
    @Autowired
    @Qualifier(value="businessObjectDataFinalizeRestoreServiceImpl")
    private BusinessObjectDataFinalizeRestoreServiceImpl businessObjectDataFinalizeRestoreServiceImpl;

    @Test
    public void testBusinessObjectDataFinalizeRestoreServiceMethodsNewTransactionPropagation() {
        Assert.assertEquals((long)0L, (long)this.businessObjectDataFinalizeRestoreServiceImpl.getS3StorageUnitsToRestore(MAX_RESULT.intValue()).size());
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataStorageUnitKey storageUnitKey = this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME);
        try {
            this.businessObjectDataFinalizeRestoreServiceImpl.finalizeRestore(storageUnitKey);
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataNotFoundErrorMessage(businessObjectDataKey, NO_BDATA_STATUS), (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinalizeRestore() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        String s3KeyPrefix = AbstractServiceTest.getExpectedS3KeyPrefix(businessObjectDataKey, AbstractServiceTest.DATA_PROVIDER_NAME, AbstractServiceTest.PARTITION_KEY, AbstractServiceTest.NO_SUB_PARTITION_KEYS);
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().withS3BucketName(S3_BUCKET_NAME).withS3KeyPrefix(s3KeyPrefix + "/").build();
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForFinalizeRestoreTesting(businessObjectDataKey);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity);
        BusinessObjectDataStorageUnitKey storageUnitKey = this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME);
        try {
            for (StorageFileEntity storageFileEntity : storageUnitEntity.getStorageFiles()) {
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setHeader("x-amz-storage-class", (Object)StorageClass.Glacier);
                metadata.setOngoingRestore(false);
                this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME, storageFileEntity.getPath(), (InputStream)new ByteArrayInputStream(new byte[storageFileEntity.getFileSizeBytes().intValue()]), metadata), NO_S3_CLIENT);
            }
            this.businessObjectDataFinalizeRestoreService.finalizeRestore(storageUnitKey);
            Assert.assertEquals((Object)"RESTORED", (Object)storageUnitEntity.getStatus().getCode());
            Assert.assertEquals((long)storageUnitEntity.getStorageFiles().size(), (long)this.s3Dao.listDirectory(s3FileTransferRequestParamsDto).size());
        }
        finally {
            if (!this.s3Dao.listDirectory(s3FileTransferRequestParamsDto).isEmpty()) {
                this.s3Dao.deleteDirectory(s3FileTransferRequestParamsDto);
            }
            this.s3Operations.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinalizeRestoreAmazonServiceException() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        String s3KeyPrefix = AbstractServiceTest.getExpectedS3KeyPrefix(businessObjectDataKey, AbstractServiceTest.DATA_PROVIDER_NAME, AbstractServiceTest.PARTITION_KEY, AbstractServiceTest.NO_SUB_PARTITION_KEYS);
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = S3FileTransferRequestParamsDto.builder().withS3BucketName(S3_BUCKET_NAME).withS3KeyPrefix(s3KeyPrefix + "/").build();
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForFinalizeRestoreTesting(businessObjectDataKey);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity);
        this.storageFileDaoTestHelper.createStorageFileEntity(storageUnitEntity, String.format("%s/%s", s3KeyPrefix, "mock_s3_file_name_service_exception"), Long.valueOf(1024L), ROW_COUNT);
        BusinessObjectDataStorageUnitKey storageUnitKey = this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME);
        try {
            for (StorageFileEntity storageFileEntity : storageUnitEntity.getStorageFiles()) {
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setHeader("x-amz-storage-class", (Object)StorageClass.Glacier);
                metadata.setOngoingRestore(false);
                this.s3Operations.putObject(new PutObjectRequest(S3_BUCKET_NAME, storageFileEntity.getPath(), (InputStream)new ByteArrayInputStream(new byte[storageFileEntity.getFileSizeBytes().intValue()]), metadata), null);
            }
            try {
                this.businessObjectDataFinalizeRestoreService.finalizeRestore(storageUnitKey);
                Assert.fail((String)"Should throw an IllegalStateException when a get S3 object metadata operation fails.");
            }
            catch (IllegalStateException e) {
                Assert.assertEquals((Object)String.format("Fail to check restore status for \"%s/%s\" key in \"%s\" bucket. Reason: InternalError (Service: null; Status Code: 0; Error Code: InternalError; Request ID: null)", s3KeyPrefix, "mock_s3_file_name_service_exception", S3_BUCKET_NAME), (Object)e.getMessage());
            }
            Assert.assertEquals((Object)"RESTORING", (Object)storageUnitEntity.getStatus().getCode());
            Assert.assertEquals((long)storageUnitEntity.getStorageFiles().size(), (long)this.s3Dao.listDirectory(s3FileTransferRequestParamsDto).size());
        }
        finally {
            if (!this.s3Dao.listDirectory(s3FileTransferRequestParamsDto).isEmpty()) {
                this.s3Dao.deleteDirectory(s3FileTransferRequestParamsDto);
            }
            this.s3Operations.rollback();
        }
    }

    @Test
    public void testGetS3StorageUnitsToRestore() throws Exception {
        List<BusinessObjectDataKey> businessObjectDataKeys = Arrays.asList(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE_2, SUBPARTITION_VALUES, DATA_VERSION));
        for (BusinessObjectDataKey businessObjectDataKey : businessObjectDataKeys) {
            this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, businessObjectDataKey, "RESTORING");
        }
        List resultStorageUnitKeys = this.businessObjectDataFinalizeRestoreService.getS3StorageUnitsToRestore(MAX_RESULT.intValue());
        Assert.assertEquals((long)businessObjectDataKeys.size(), (long)resultStorageUnitKeys.size());
        for (BusinessObjectDataKey businessObjectDataKey : businessObjectDataKeys) {
            Assert.assertTrue((boolean)resultStorageUnitKeys.contains(this.storageUnitHelper.createStorageUnitKey(businessObjectDataKey, STORAGE_NAME)));
        }
        Assert.assertEquals((long)1L, (long)this.businessObjectDataFinalizeRestoreService.getS3StorageUnitsToRestore(1).size());
    }
}

