/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Arrays;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectDataNotificationFilter;
import org.finra.herd.model.api.xml.BusinessObjectDataNotificationRegistration;
import org.finra.herd.model.api.xml.BusinessObjectDataNotificationRegistrationCreateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataNotificationRegistrationKeys;
import org.finra.herd.model.api.xml.BusinessObjectDataNotificationRegistrationUpdateRequest;
import org.finra.herd.model.api.xml.JobAction;
import org.finra.herd.model.api.xml.NotificationRegistrationKey;
import org.finra.herd.model.jpa.BusinessObjectDataNotificationRegistrationEntity;
import org.finra.herd.model.jpa.NotificationEventTypeEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class BusinessObjectDataNotificationRegistrationServiceTest
extends AbstractServiceTest {
    @Test
    public void testCreateBusinessObjectDataNotificationRegistrationForBusinessObjectDataRegistration() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataNotificationRegistrationTesting();
        BusinessObjectDataNotificationRegistration result = this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(new BusinessObjectDataNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, NO_BDATA_STATUS), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"));
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(result.getId(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, NO_BDATA_STATUS), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"), (Object)result);
    }

    @Test
    public void testCreateBusinessObjectDataNotificationRegistrationForBusinessObjectDataStatusChange() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataNotificationRegistrationTesting();
        BusinessObjectDataNotificationRegistration result = this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(new BusinessObjectDataNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "DISABLED"));
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(result.getId(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "DISABLED"), (Object)result);
    }

    @Test
    public void testCreateBusinessObjectDataNotificationRegistrationMissingRequiredParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(new BusinessObjectDataNotificationRegistrationCreateRequest(new NotificationRegistrationKey("      \t\t ", NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(new BusinessObjectDataNotificationRegistrationCreateRequest(new NotificationRegistrationKey(NAMESPACE, "      \t\t "), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when notification name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A notification name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(new BusinessObjectDataNotificationRegistrationCreateRequest(notificationRegistrationKey, "      \t\t ", new BusinessObjectDataNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object data notification event type is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data event type must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(new BusinessObjectDataNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(NAMESPACE, "      \t\t ", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(new BusinessObjectDataNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), null, "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when job actions are not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least one notification action must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(new BusinessObjectDataNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), Arrays.asList(new JobAction("      \t\t ", JOB_NAME, CORRELATION_DATA)), "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when job action namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A job action namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(new BusinessObjectDataNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), Arrays.asList(new JobAction(NAMESPACE, "      \t\t ", CORRELATION_DATA)), "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when job action job name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A job action job name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataNotificationRegistrationMissingOptionalParametersPassedAsWhitespace() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataNotificationRegistrationTesting();
        BusinessObjectDataNotificationRegistration resultBusinessObjectDataNotificationRegistration = this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(new BusinessObjectDataNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, "      \t\t ", "      \t\t ", null, "      \t\t ", "      \t\t ", "      \t\t "), Arrays.asList(new JobAction(JOB_NAMESPACE, JOB_NAME, "      \t\t ")), "      \t\t "));
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(resultBusinessObjectDataNotificationRegistration.getId(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, null, null, null, null, null, null), Arrays.asList(new JobAction(JOB_NAMESPACE, JOB_NAME, "      \t\t ")), "ENABLED"), (Object)resultBusinessObjectDataNotificationRegistration);
    }

    @Test
    public void testCreateBusinessObjectDataNotificationRegistrationMissingOptionalParametersPassedAsNulls() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataNotificationRegistrationTesting();
        BusinessObjectDataNotificationRegistration resultBusinessObjectDataNotificationRegistration = this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(new BusinessObjectDataNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, null, null, null, null, null, null), Arrays.asList(new JobAction(JOB_NAMESPACE, JOB_NAME, null)), null));
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(resultBusinessObjectDataNotificationRegistration.getId(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, null, null, null, null, null, null), Arrays.asList(new JobAction(JOB_NAMESPACE, JOB_NAME, null)), "ENABLED"), (Object)resultBusinessObjectDataNotificationRegistration);
    }

    @Test
    public void testCreateBusinessObjectDataNotificationRegistrationTrimParameters() {
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataNotificationRegistrationTesting();
        BusinessObjectDataNotificationRegistration resultBusinessObjectDataNotificationRegistration = this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(new BusinessObjectDataNotificationRegistrationCreateRequest(new NotificationRegistrationKey(this.addWhitespace(NAMESPACE), this.addWhitespace(NOTIFICATION_NAME)), this.addWhitespace(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name()), new BusinessObjectDataNotificationFilter(this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), FORMAT_VERSION, this.addWhitespace(STORAGE_NAME), this.addWhitespace(BDATA_STATUS), this.addWhitespace(BDATA_STATUS_2)), Arrays.asList(new JobAction(this.addWhitespace(JOB_NAMESPACE), this.addWhitespace(JOB_NAME), this.addWhitespace(CORRELATION_DATA))), this.addWhitespace("ENABLED")));
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(resultBusinessObjectDataNotificationRegistration.getId(), new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), Arrays.asList(new JobAction(JOB_NAMESPACE, JOB_NAME, this.addWhitespace(CORRELATION_DATA))), "ENABLED"), (Object)resultBusinessObjectDataNotificationRegistration);
    }

    @Test
    public void testCreateBusinessObjectDataNotificationRegistrationUpperCaseParameters() {
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataNotificationRegistrationTesting(NAMESPACE.toLowerCase(), Arrays.asList(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name()), BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), Arrays.asList(FORMAT_FILE_TYPE_CODE.toLowerCase()), Arrays.asList(STORAGE_NAME.toLowerCase()), Arrays.asList(BDATA_STATUS.toLowerCase(), BDATA_STATUS_2.toLowerCase()), Arrays.asList(new JobAction(NAMESPACE.toLowerCase(), JOB_NAME.toLowerCase(), "      \t\t ")));
        BusinessObjectDataNotificationRegistration resultBusinessObjectDataNotificationRegistration = this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(new BusinessObjectDataNotificationRegistrationCreateRequest(new NotificationRegistrationKey(NAMESPACE.toUpperCase(), NOTIFICATION_NAME.toUpperCase()), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name().toUpperCase(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, STORAGE_NAME.toUpperCase(), BDATA_STATUS.toUpperCase(), BDATA_STATUS_2.toUpperCase()), Arrays.asList(new JobAction(NAMESPACE.toUpperCase(), JOB_NAME.toUpperCase(), CORRELATION_DATA.toUpperCase())), "ENABLED".toUpperCase()));
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(resultBusinessObjectDataNotificationRegistration.getId(), new NotificationRegistrationKey(NAMESPACE.toLowerCase(), NOTIFICATION_NAME.toUpperCase()), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, STORAGE_NAME.toLowerCase(), BDATA_STATUS.toLowerCase(), BDATA_STATUS_2.toLowerCase()), Arrays.asList(new JobAction(NAMESPACE.toLowerCase(), JOB_NAME.toLowerCase(), CORRELATION_DATA.toUpperCase())), "ENABLED"), (Object)resultBusinessObjectDataNotificationRegistration);
    }

    @Test
    public void testCreateBusinessObjectDataNotificationRegistrationLowerCaseParameters() {
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataNotificationRegistrationTesting(NAMESPACE.toUpperCase(), Arrays.asList(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name()), BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), Arrays.asList(FORMAT_FILE_TYPE_CODE.toUpperCase()), Arrays.asList(STORAGE_NAME.toUpperCase()), Arrays.asList(BDATA_STATUS.toUpperCase(), BDATA_STATUS_2.toUpperCase()), Arrays.asList(new JobAction(NAMESPACE.toUpperCase(), JOB_NAME.toUpperCase(), "      \t\t ")));
        BusinessObjectDataNotificationRegistration resultBusinessObjectDataNotificationRegistration = this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(new BusinessObjectDataNotificationRegistrationCreateRequest(new NotificationRegistrationKey(NAMESPACE.toLowerCase(), NOTIFICATION_NAME.toLowerCase()), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name().toLowerCase(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, STORAGE_NAME.toLowerCase(), BDATA_STATUS.toLowerCase(), BDATA_STATUS_2.toLowerCase()), Arrays.asList(new JobAction(NAMESPACE.toLowerCase(), JOB_NAME.toLowerCase(), CORRELATION_DATA.toLowerCase())), "ENABLED".toLowerCase()));
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(resultBusinessObjectDataNotificationRegistration.getId(), new NotificationRegistrationKey(NAMESPACE.toUpperCase(), NOTIFICATION_NAME.toLowerCase()), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, STORAGE_NAME.toUpperCase(), BDATA_STATUS.toUpperCase(), BDATA_STATUS_2.toUpperCase()), Arrays.asList(new JobAction(NAMESPACE.toUpperCase(), JOB_NAME.toUpperCase(), CORRELATION_DATA.toLowerCase())), "ENABLED"), (Object)resultBusinessObjectDataNotificationRegistration);
    }

    @Test
    public void testCreateBusinessObjectDataNotificationRegistrationInvalidParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataNotificationRegistrationTesting();
        BusinessObjectDataNotificationRegistrationCreateRequest request = new BusinessObjectDataNotificationRegistrationCreateRequest(new NotificationRegistrationKey("I_DO_NOT_EXIST", NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing namespace.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Namespace \"%s\" doesn't exist.", request.getBusinessObjectDataNotificationRegistrationKey().getNamespace()), (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationCreateRequest(new NotificationRegistrationKey(this.addSlash(NAMESPACE), NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Namespace can not contain a forward slash character.", (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationCreateRequest(new NotificationRegistrationKey(NAMESPACE, this.addSlash(NOTIFICATION_NAME)), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when notification name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Notification name can not contain a forward slash character.", (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationCreateRequest(notificationRegistrationKey, "I_DO_NOT_EXIST", new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing notification event type.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Notification event type with code \"%s\" doesn't exist.", request.getBusinessObjectDataEventType()), (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationCreateRequest(notificationRegistrationKey, NOTIFICATION_EVENT_TYPE, new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when using non-supported notification event type.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Notification event type \"%s\" is not supported for business object data notification registration.", request.getBusinessObjectDataEventType()), (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing business object definition name.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", request.getBusinessObjectDataNotificationFilter().getBusinessObjectDefinitionName(), request.getBusinessObjectDataNotificationFilter().getNamespace()), (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing business object format file type.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("File type with code \"%s\" doesn't exist.", request.getBusinessObjectDataNotificationFilter().getBusinessObjectFormatFileType()), (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "I_DO_NOT_EXIST", BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing storage name.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage with name \"%s\" doesn't exist.", request.getBusinessObjectDataNotificationFilter().getStorageName()), (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, "I_DO_NOT_EXIST", BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing new business object data status.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object data status \"%s\" doesn't exist.", request.getBusinessObjectDataNotificationFilter().getNewBusinessObjectDataStatus()), (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, "I_DO_NOT_EXIST"), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing old business object data status.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object data status \"%s\" doesn't exist.", request.getBusinessObjectDataNotificationFilter().getOldBusinessObjectDataStatus()), (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS.toUpperCase(), BDATA_STATUS.toLowerCase()), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when using new and old business object data statuses that are the same");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The new business object data status is the same as the old one.", (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when old business object data status is specified for a business object data registration notification event type.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The old business object data status cannot be specified with a business object data registration event type.", (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), Arrays.asList(new JobAction(NAMESPACE, "I_DO_NOT_EXIST", CORRELATION_DATA)), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing job definition.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Job definition with namespace \"%s\" and job name \"%s\" doesn't exist.", ((JobAction)request.getJobActions().get(0)).getNamespace(), ((JobAction)request.getJobActions().get(0)).getJobName()), (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationCreateRequest(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "I_DO_NOT_EXIST");
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing notification registration status.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("The notification registration status \"%s\" doesn't exist.", request.getNotificationRegistrationStatus()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataNotificationRegistrationDuplicateJobActions() {
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataNotificationRegistrationTesting();
        BusinessObjectDataNotificationRegistrationCreateRequest request = new BusinessObjectDataNotificationRegistrationCreateRequest(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), Arrays.asList(new JobAction(NAMESPACE.toLowerCase(), JOB_NAME.toLowerCase(), CORRELATION_DATA), new JobAction(NAMESPACE.toUpperCase(), JOB_NAME.toUpperCase(), CORRELATION_DATA)), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when create request contains duplicate job actions.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Duplicate job action {namespace: \"%s\", jobName: \"%s\"} found.", ((JobAction)request.getJobActions().get(1)).getNamespace(), ((JobAction)request.getJobActions().get(1)).getJobName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateBusinessObjectDataNotificationRegistrationAlreadyExists() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.createBusinessObjectDataNotificationRegistration(new BusinessObjectDataNotificationRegistrationCreateRequest(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"));
            Assert.fail((String)"Should throw an AlreadyExistsException when business object data notification already exists.");
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Unable to create business object data notification with name \"%s\" because it already exists for namespace \"%s\".", notificationRegistrationKey.getNotificationName(), notificationRegistrationKey.getNamespace()), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDataNotificationRegistration() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        BusinessObjectDataNotificationRegistration resultBusinessObjectDataNotificationRegistration = this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistration(notificationRegistrationKey);
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(resultBusinessObjectDataNotificationRegistration.getId(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"), (Object)resultBusinessObjectDataNotificationRegistration);
    }

    @Test
    public void testGetBusinessObjectDataNotificationRegistrationMissingRequiredParameters() {
        try {
            this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistration(new NotificationRegistrationKey("      \t\t ", NOTIFICATION_NAME));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistration(new NotificationRegistrationKey(NAMESPACE, "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when notification name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A notification name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDataNotificationRegistrationTrimParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        BusinessObjectDataNotificationRegistrationEntity businessObjectDataNotificationRegistrationEntity = this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        BusinessObjectDataNotificationRegistration resultBusinessObjectDataNotificationRegistration = this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistration(new NotificationRegistrationKey(this.addWhitespace(NAMESPACE), this.addWhitespace(NOTIFICATION_NAME)));
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(businessObjectDataNotificationRegistrationEntity.getId().intValue(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"), (Object)resultBusinessObjectDataNotificationRegistration);
    }

    @Test
    public void testGetBusinessObjectDataNotificationRegistrationUpperCaseParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE.toLowerCase(), NOTIFICATION_NAME.toLowerCase());
        BusinessObjectDataNotificationRegistrationEntity businessObjectDataNotificationRegistrationEntity = this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        BusinessObjectDataNotificationRegistration resultBusinessObjectDataNotificationRegistration = this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistration(new NotificationRegistrationKey(NAMESPACE.toUpperCase(), NOTIFICATION_NAME.toUpperCase()));
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(businessObjectDataNotificationRegistrationEntity.getId().intValue(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"), (Object)resultBusinessObjectDataNotificationRegistration);
    }

    @Test
    public void testGetBusinessObjectDataNotificationRegistrationLowerCaseParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE.toUpperCase(), NOTIFICATION_NAME.toUpperCase());
        BusinessObjectDataNotificationRegistrationEntity businessObjectDataNotificationRegistrationEntity = this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        BusinessObjectDataNotificationRegistration resultBusinessObjectDataNotificationRegistration = this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistration(new NotificationRegistrationKey(NAMESPACE.toLowerCase(), NOTIFICATION_NAME.toLowerCase()));
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(businessObjectDataNotificationRegistrationEntity.getId().intValue(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"), (Object)resultBusinessObjectDataNotificationRegistration);
    }

    @Test
    public void testGetBusinessObjectDataNotificationRegistrationNoExists() {
        try {
            this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistration(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME));
            Assert.fail((String)"Should throw an ObjectNotFoundException when trying to retrieve a non-existing business object data notification.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object data notification registration with name \"%s\" does not exist for \"%s\" namespace.", NOTIFICATION_NAME, NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDataNotificationRegistration() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataNotificationRegistrationTesting(NAMESPACE, Arrays.asList(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name()), BDEF_NAMESPACE_2, BDEF_NAME_2, Arrays.asList(FORMAT_FILE_TYPE_CODE, FORMAT_FILE_TYPE_CODE_2), Arrays.asList(STORAGE_NAME, STORAGE_NAME_2), Arrays.asList(BDATA_STATUS, BDATA_STATUS_2, BDATA_STATUS_3, BDATA_STATUS_4), this.notificationRegistrationDaoTestHelper.getTestJobActions2());
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        BusinessObjectDataNotificationRegistration resultBusinessObjectDataNotificationRegistration = this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), new BusinessObjectDataNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, STORAGE_NAME_2, BDATA_STATUS_3, NO_BDATA_STATUS), this.notificationRegistrationDaoTestHelper.getTestJobActions2(), "DISABLED"));
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(resultBusinessObjectDataNotificationRegistration.getId(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, STORAGE_NAME_2, BDATA_STATUS_3, NO_BDATA_STATUS), this.notificationRegistrationDaoTestHelper.getTestJobActions2(), "DISABLED"), (Object)resultBusinessObjectDataNotificationRegistration);
    }

    @Test
    public void testUpdateBusinessObjectDataNotificationRegistrationWithDisabledStatus() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataNotificationRegistrationTesting(NAMESPACE, Arrays.asList(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name()), BDEF_NAMESPACE_2, BDEF_NAME_2, Arrays.asList(FORMAT_FILE_TYPE_CODE, FORMAT_FILE_TYPE_CODE_2), Arrays.asList(STORAGE_NAME, STORAGE_NAME_2), Arrays.asList(BDATA_STATUS, BDATA_STATUS_2, BDATA_STATUS_3, BDATA_STATUS_4), this.notificationRegistrationDaoTestHelper.getTestJobActions2());
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        BusinessObjectDataNotificationRegistration resultBusinessObjectDataNotificationRegistration = this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), new BusinessObjectDataNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, STORAGE_NAME_2, BDATA_STATUS_3, NO_BDATA_STATUS), this.notificationRegistrationDaoTestHelper.getTestJobActions2(), "DISABLED"));
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(resultBusinessObjectDataNotificationRegistration.getId(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, STORAGE_NAME_2, BDATA_STATUS_3, NO_BDATA_STATUS), this.notificationRegistrationDaoTestHelper.getTestJobActions2(), "DISABLED"), (Object)resultBusinessObjectDataNotificationRegistration);
    }

    @Test
    public void testUpdateBusinessObjectDataNotificationRegistrationMissingRequiredParameters() {
        try {
            this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(new NotificationRegistrationKey("      \t\t ", NOTIFICATION_NAME), new BusinessObjectDataNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, STORAGE_NAME_2, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions2(), "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(new NotificationRegistrationKey(NAMESPACE, "      \t\t "), new BusinessObjectDataNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, STORAGE_NAME_2, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions2(), "ENABLED"));
            Assert.fail((String)"Should throw an IllegalArgumentException when notification name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A notification name must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), new BusinessObjectDataNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, STORAGE_NAME_2, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions2(), "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when notification registration status is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A notification registration status must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDataNotificationRegistrationMissingOptionalParametersPassedAsWhitespace() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataNotificationRegistrationTesting(NAMESPACE, Arrays.asList(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name()), BDEF_NAMESPACE_2, BDEF_NAME_2, null, null, Arrays.asList(BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions());
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        BusinessObjectDataNotificationRegistration resultBusinessObjectDataNotificationRegistration = this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(notificationRegistrationKey, new BusinessObjectDataNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, "      \t\t ", "      \t\t ", null, "      \t\t ", "      \t\t ", "      \t\t "), Arrays.asList(new JobAction(JOB_NAMESPACE_2, JOB_NAME_2, "      \t\t ")), "ENABLED"));
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(resultBusinessObjectDataNotificationRegistration.getId(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, null, null, null, null, null, null), Arrays.asList(new JobAction(JOB_NAMESPACE_2, JOB_NAME_2, "      \t\t ")), "ENABLED"), (Object)resultBusinessObjectDataNotificationRegistration);
    }

    @Test
    public void testUpdateBusinessObjectDataNotificationRegistrationMissingOptionalParametersPassedAsNulls() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataNotificationRegistrationTesting(NAMESPACE, Arrays.asList(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name()), BDEF_NAMESPACE_2, BDEF_NAME_2, null, null, Arrays.asList(BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions());
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        BusinessObjectDataNotificationRegistration resultBusinessObjectDataNotificationRegistration = this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(notificationRegistrationKey, new BusinessObjectDataNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, null, null, null, null, null, null), Arrays.asList(new JobAction(JOB_NAMESPACE_2, JOB_NAME_2, null)), "ENABLED"));
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(resultBusinessObjectDataNotificationRegistration.getId(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, null, null, null, null, null, null), Arrays.asList(new JobAction(JOB_NAMESPACE_2, JOB_NAME_2, null)), "ENABLED"), (Object)resultBusinessObjectDataNotificationRegistration);
    }

    @Test
    public void testUpdateBusinessObjectDataNotificationRegistrationTrimParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataNotificationRegistrationTesting(NAMESPACE, Arrays.asList(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name()), BDEF_NAMESPACE_2, BDEF_NAME_2, Arrays.asList(FORMAT_FILE_TYPE_CODE, FORMAT_FILE_TYPE_CODE_2), Arrays.asList(STORAGE_NAME, STORAGE_NAME_2), Arrays.asList(BDATA_STATUS, BDATA_STATUS_2, BDATA_STATUS_3, BDATA_STATUS_4), this.notificationRegistrationDaoTestHelper.getTestJobActions2());
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        BusinessObjectDataNotificationRegistration resultBusinessObjectDataNotificationRegistration = this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(new NotificationRegistrationKey(this.addWhitespace(NAMESPACE), this.addWhitespace(NOTIFICATION_NAME)), new BusinessObjectDataNotificationRegistrationUpdateRequest(this.addWhitespace(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name()), new BusinessObjectDataNotificationFilter(this.addWhitespace(BDEF_NAMESPACE_2), this.addWhitespace(BDEF_NAME_2), this.addWhitespace(FORMAT_USAGE_CODE_2), this.addWhitespace(FORMAT_FILE_TYPE_CODE_2), FORMAT_VERSION_2, this.addWhitespace(STORAGE_NAME_2), this.addWhitespace(BDATA_STATUS_3), NO_BDATA_STATUS), Arrays.asList(new JobAction(this.addWhitespace(JOB_NAMESPACE_2), this.addWhitespace(JOB_NAME_2), this.addWhitespace(CORRELATION_DATA_2))), "      \t\t ENABLED      \t\t "));
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(resultBusinessObjectDataNotificationRegistration.getId(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, STORAGE_NAME_2, BDATA_STATUS_3, NO_BDATA_STATUS), Arrays.asList(new JobAction(JOB_NAMESPACE_2, JOB_NAME_2, this.addWhitespace(CORRELATION_DATA_2))), "ENABLED"), (Object)resultBusinessObjectDataNotificationRegistration);
    }

    @Test
    public void testUpdateBusinessObjectDataNotificationRegistrationUpperCaseParameters() {
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataNotificationRegistrationTesting(NAMESPACE.toLowerCase(), Arrays.asList(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name().toLowerCase(), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name().toLowerCase()), BDEF_NAMESPACE_2.toLowerCase(), BDEF_NAME_2.toLowerCase(), Arrays.asList(FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE_2.toLowerCase()), Arrays.asList(STORAGE_NAME.toLowerCase(), STORAGE_NAME_2.toLowerCase()), Arrays.asList(BDATA_STATUS.toLowerCase(), BDATA_STATUS_2.toLowerCase(), BDATA_STATUS_3.toLowerCase(), BDATA_STATUS_4.toLowerCase()), Arrays.asList(new JobAction(JOB_NAMESPACE_2.toLowerCase(), JOB_NAME_2.toLowerCase(), null)));
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE.toLowerCase(), NOTIFICATION_NAME.toLowerCase());
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name().toLowerCase(), BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), FORMAT_VERSION, STORAGE_NAME.toLowerCase(), BDATA_STATUS.toLowerCase(), BDATA_STATUS_2.toLowerCase(), Arrays.asList(new JobAction(JOB_NAMESPACE.toLowerCase(), JOB_NAME.toLowerCase(), CORRELATION_DATA)), "ENABLED");
        BusinessObjectDataNotificationRegistration resultBusinessObjectDataNotificationRegistration = this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(new NotificationRegistrationKey(NAMESPACE.toUpperCase(), NOTIFICATION_NAME.toUpperCase()), new BusinessObjectDataNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name().toUpperCase(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE_2.toUpperCase(), BDEF_NAME_2.toUpperCase(), FORMAT_USAGE_CODE_2.toUpperCase(), FORMAT_FILE_TYPE_CODE_2.toUpperCase(), FORMAT_VERSION_2, STORAGE_NAME_2.toUpperCase(), BDATA_STATUS_3.toUpperCase(), NO_BDATA_STATUS), Arrays.asList(new JobAction(JOB_NAMESPACE_2.toUpperCase(), JOB_NAME_2.toUpperCase(), CORRELATION_DATA_2.toUpperCase())), "ENABLED"));
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(resultBusinessObjectDataNotificationRegistration.getId(), new NotificationRegistrationKey(NAMESPACE.toLowerCase(), NOTIFICATION_NAME.toLowerCase()), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name().toLowerCase(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE_2.toLowerCase(), BDEF_NAME_2.toLowerCase(), FORMAT_USAGE_CODE_2.toUpperCase(), FORMAT_FILE_TYPE_CODE_2.toLowerCase(), FORMAT_VERSION_2, STORAGE_NAME_2.toLowerCase(), BDATA_STATUS_3.toLowerCase(), NO_BDATA_STATUS), Arrays.asList(new JobAction(JOB_NAMESPACE_2.toLowerCase(), JOB_NAME_2.toLowerCase(), CORRELATION_DATA_2.toUpperCase())), "ENABLED"), (Object)resultBusinessObjectDataNotificationRegistration);
    }

    @Test
    public void testUpdateBusinessObjectDataNotificationRegistrationLowerCaseParameters() {
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataNotificationRegistrationTesting(NAMESPACE.toUpperCase(), Arrays.asList(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name().toUpperCase(), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name().toUpperCase()), BDEF_NAMESPACE_2.toUpperCase(), BDEF_NAME_2.toUpperCase(), Arrays.asList(FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE_2.toUpperCase()), Arrays.asList(STORAGE_NAME.toUpperCase(), STORAGE_NAME_2.toUpperCase()), Arrays.asList(BDATA_STATUS.toUpperCase(), BDATA_STATUS_2.toUpperCase(), BDATA_STATUS_3.toUpperCase(), BDATA_STATUS_4.toUpperCase()), Arrays.asList(new JobAction(JOB_NAMESPACE_2.toUpperCase(), JOB_NAME_2.toUpperCase(), null)));
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE.toUpperCase(), NOTIFICATION_NAME.toUpperCase());
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name().toUpperCase(), BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), FORMAT_VERSION, STORAGE_NAME.toUpperCase(), BDATA_STATUS.toUpperCase(), BDATA_STATUS_2.toUpperCase(), Arrays.asList(new JobAction(JOB_NAMESPACE.toUpperCase(), JOB_NAME.toUpperCase(), CORRELATION_DATA)), "ENABLED");
        BusinessObjectDataNotificationRegistration resultBusinessObjectDataNotificationRegistration = this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(new NotificationRegistrationKey(NAMESPACE.toLowerCase(), NOTIFICATION_NAME.toLowerCase()), new BusinessObjectDataNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name().toLowerCase(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE_2.toLowerCase(), BDEF_NAME_2.toLowerCase(), FORMAT_USAGE_CODE_2.toLowerCase(), FORMAT_FILE_TYPE_CODE_2.toLowerCase(), FORMAT_VERSION_2, STORAGE_NAME_2.toLowerCase(), BDATA_STATUS_3.toLowerCase(), NO_BDATA_STATUS), Arrays.asList(new JobAction(JOB_NAMESPACE_2.toLowerCase(), JOB_NAME_2.toLowerCase(), CORRELATION_DATA_2.toLowerCase())), "enabled"));
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(resultBusinessObjectDataNotificationRegistration.getId(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name().toUpperCase(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE_2.toUpperCase(), BDEF_NAME_2.toUpperCase(), FORMAT_USAGE_CODE_2.toLowerCase(), FORMAT_FILE_TYPE_CODE_2.toUpperCase(), FORMAT_VERSION_2, STORAGE_NAME_2.toUpperCase(), BDATA_STATUS_3.toUpperCase(), NO_BDATA_STATUS), Arrays.asList(new JobAction(JOB_NAMESPACE_2.toUpperCase(), JOB_NAME_2.toUpperCase(), CORRELATION_DATA_2.toLowerCase())), "ENABLED"), (Object)resultBusinessObjectDataNotificationRegistration);
    }

    @Test
    public void testUpdateBusinessObjectDataNotificationRegistrationInvalidParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataNotificationRegistrationTesting(NAMESPACE, Arrays.asList(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), NOTIFICATION_EVENT_TYPE), BDEF_NAMESPACE_2, BDEF_NAME_2, Arrays.asList(FORMAT_FILE_TYPE_CODE, FORMAT_FILE_TYPE_CODE_2), Arrays.asList(STORAGE_NAME, STORAGE_NAME_2), Arrays.asList(BDATA_STATUS, BDATA_STATUS_2, BDATA_STATUS_3, BDATA_STATUS_4), this.notificationRegistrationDaoTestHelper.getTestJobActions2());
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        BusinessObjectDataNotificationRegistrationUpdateRequest request = new BusinessObjectDataNotificationRegistrationUpdateRequest("I_DO_NOT_EXIST", new BusinessObjectDataNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(notificationRegistrationKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing notification event type.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Notification event type with code \"%s\" doesn't exist.", request.getBusinessObjectDataEventType()), (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationUpdateRequest(NOTIFICATION_EVENT_TYPE, new BusinessObjectDataNotificationFilter(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(notificationRegistrationKey, request);
            Assert.fail((String)"Should throw an IllegalArgumentException when using non-supported notification event type.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Notification event type \"%s\" is not supported for business object data notification registration.", request.getBusinessObjectDataEventType()), (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(NAMESPACE, "I_DO_NOT_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(notificationRegistrationKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing business object definition name.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", request.getBusinessObjectDataNotificationFilter().getBusinessObjectDefinitionName(), request.getBusinessObjectDataNotificationFilter().getNamespace()), (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(notificationRegistrationKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing business object format file type.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("File type with code \"%s\" doesn't exist.", request.getBusinessObjectDataNotificationFilter().getBusinessObjectFormatFileType()), (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, "I_DO_NOT_EXIST", BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(notificationRegistrationKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing storage name.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage with name \"%s\" doesn't exist.", request.getBusinessObjectDataNotificationFilter().getStorageName()), (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, "I_DO_NOT_EXIST", BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(notificationRegistrationKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing new business object data status.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object data status \"%s\" doesn't exist.", request.getBusinessObjectDataNotificationFilter().getNewBusinessObjectDataStatus()), (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, "I_DO_NOT_EXIST"), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(notificationRegistrationKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing old business object data status.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object data status \"%s\" doesn't exist.", request.getBusinessObjectDataNotificationFilter().getOldBusinessObjectDataStatus()), (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS.toUpperCase(), BDATA_STATUS.toLowerCase()), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(notificationRegistrationKey, request);
            Assert.fail((String)"Should throw an IllegalArgumentException when using new and old business object data statuses that are the same");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The new business object data status is the same as the old one.", (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(notificationRegistrationKey, request);
            Assert.fail((String)"Should throw an IllegalArgumentException when old business object data status is specified for a business object data registration notification event type.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The old business object data status cannot be specified with a business object data registration event type.", (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), Arrays.asList(new JobAction(NAMESPACE, "I_DO_NOT_EXIST", CORRELATION_DATA)), "ENABLED");
        try {
            this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(notificationRegistrationKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing job definition.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Job definition with namespace \"%s\" and job name \"%s\" doesn't exist.", ((JobAction)request.getJobActions().get(0)).getNamespace(), ((JobAction)request.getJobActions().get(0)).getJobName()), (Object)e.getMessage());
        }
        request = new BusinessObjectDataNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "I_DO_NOT_EXIST");
        try {
            this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(notificationRegistrationKey, request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing notification registration status.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("The notification registration status \"%s\" doesn't exist.", request.getNotificationRegistrationStatus()), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateBusinessObjectDataNotificationRegistrationNoExists() {
        try {
            this.businessObjectDataNotificationRegistrationService.updateBusinessObjectDataNotificationRegistration(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), new BusinessObjectDataNotificationRegistrationUpdateRequest(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE_2, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, STORAGE_NAME_2, BDATA_STATUS, NO_BDATA_STATUS), this.notificationRegistrationDaoTestHelper.getTestJobActions2(), "ENABLED"));
            Assert.fail((String)"Should throw an ObjectNotFoundException when trying to update a non-existing business object data notification.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object data notification registration with name \"%s\" does not exist for \"%s\" namespace.", NOTIFICATION_NAME, NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDataNotificationRegistration() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        BusinessObjectDataNotificationRegistrationEntity businessObjectDataNotificationRegistrationEntity = this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        Assert.assertNotNull((Object)this.businessObjectDataNotificationRegistrationDao.getBusinessObjectDataNotificationRegistrationByAltKey(notificationRegistrationKey));
        BusinessObjectDataNotificationRegistration deletedBusinessObjectDataNotificationRegistration = this.businessObjectDataNotificationRegistrationService.deleteBusinessObjectDataNotificationRegistration(notificationRegistrationKey);
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(businessObjectDataNotificationRegistrationEntity.getId().intValue(), new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"), (Object)deletedBusinessObjectDataNotificationRegistration);
        Assert.assertNull((Object)this.businessObjectDataNotificationRegistrationDao.getBusinessObjectDataNotificationRegistrationByAltKey(notificationRegistrationKey));
    }

    @Test
    public void testDeleteBusinessObjectDataNotificationRegistrationMissingRequiredParameters() {
        try {
            this.businessObjectDataNotificationRegistrationService.deleteBusinessObjectDataNotificationRegistration(new NotificationRegistrationKey("      \t\t ", NOTIFICATION_NAME));
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataNotificationRegistrationService.deleteBusinessObjectDataNotificationRegistration(new NotificationRegistrationKey(NAMESPACE, "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when notification name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A notification name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteBusinessObjectDataNotificationRegistrationTrimParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        BusinessObjectDataNotificationRegistrationEntity businessObjectDataNotificationRegistrationEntity = this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        Assert.assertNotNull((Object)this.businessObjectDataNotificationRegistrationDao.getBusinessObjectDataNotificationRegistrationByAltKey(notificationRegistrationKey));
        BusinessObjectDataNotificationRegistration deletedBusinessObjectDataNotificationRegistration = this.businessObjectDataNotificationRegistrationService.deleteBusinessObjectDataNotificationRegistration(new NotificationRegistrationKey(this.addWhitespace(NAMESPACE), this.addWhitespace(NOTIFICATION_NAME)));
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(businessObjectDataNotificationRegistrationEntity.getId().intValue(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"), (Object)deletedBusinessObjectDataNotificationRegistration);
        Assert.assertNull((Object)this.businessObjectDataNotificationRegistrationDao.getBusinessObjectDataNotificationRegistrationByAltKey(notificationRegistrationKey));
    }

    @Test
    public void testDeleteBusinessObjectDataNotificationRegistrationUpperCaseParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE.toLowerCase(), NOTIFICATION_NAME.toLowerCase());
        BusinessObjectDataNotificationRegistrationEntity businessObjectDataNotificationRegistrationEntity = this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        Assert.assertNotNull((Object)this.businessObjectDataNotificationRegistrationDao.getBusinessObjectDataNotificationRegistrationByAltKey(notificationRegistrationKey));
        BusinessObjectDataNotificationRegistration deletedBusinessObjectDataNotificationRegistration = this.businessObjectDataNotificationRegistrationService.deleteBusinessObjectDataNotificationRegistration(new NotificationRegistrationKey(NAMESPACE.toUpperCase(), NOTIFICATION_NAME.toUpperCase()));
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(businessObjectDataNotificationRegistrationEntity.getId().intValue(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"), (Object)deletedBusinessObjectDataNotificationRegistration);
        Assert.assertNull((Object)this.businessObjectDataNotificationRegistrationDao.getBusinessObjectDataNotificationRegistrationByAltKey(notificationRegistrationKey));
    }

    @Test
    public void testDeleteBusinessObjectDataNotificationRegistrationLowerCaseParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE.toUpperCase(), NOTIFICATION_NAME.toUpperCase());
        BusinessObjectDataNotificationRegistrationEntity businessObjectDataNotificationRegistrationEntity = this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        Assert.assertNotNull((Object)this.businessObjectDataNotificationRegistrationDao.getBusinessObjectDataNotificationRegistrationByAltKey(notificationRegistrationKey));
        BusinessObjectDataNotificationRegistration deletedBusinessObjectDataNotificationRegistration = this.businessObjectDataNotificationRegistrationService.deleteBusinessObjectDataNotificationRegistration(new NotificationRegistrationKey(NAMESPACE.toLowerCase(), NOTIFICATION_NAME.toLowerCase()));
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistration(businessObjectDataNotificationRegistrationEntity.getId().intValue(), notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2), this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED"), (Object)deletedBusinessObjectDataNotificationRegistration);
        Assert.assertNull((Object)this.businessObjectDataNotificationRegistrationDao.getBusinessObjectDataNotificationRegistrationByAltKey(notificationRegistrationKey));
    }

    @Test
    public void testDeleteBusinessObjectDataNotificationRegistrationBusinessObjectDataNotificationNoExists() {
        try {
            this.businessObjectDataNotificationRegistrationService.deleteBusinessObjectDataNotificationRegistration(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME));
            Assert.fail((String)"Should throw an ObjectNotFoundException when trying to delete a non-existing business object data notification.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object data notification registration with name \"%s\" does not exist for \"%s\" namespace.", NOTIFICATION_NAME, NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDataNotificationRegistrationsByNamespace() {
        for (NotificationRegistrationKey notificationRegistrationKey : this.notificationRegistrationDaoTestHelper.getTestNotificationRegistrationKeys()) {
            this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, null, null, null, null, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        }
        BusinessObjectDataNotificationRegistrationKeys resultKeys = this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistrationsByNamespace(NAMESPACE);
        Assert.assertEquals((Object)this.notificationRegistrationDaoTestHelper.getExpectedNotificationRegistrationKeys(), (Object)resultKeys.getBusinessObjectDataNotificationRegistrationKeys());
    }

    @Test
    public void testGetBusinessObjectDataNotificationRegistrationsByNamespaceMissingRequiredParameters() {
        try {
            this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistrationsByNamespace("      \t\t ");
            Assert.fail((String)"Should throw an IllegalArgumentException when namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDataNotificationRegistrationsByNamespaceTrimParameters() {
        for (NotificationRegistrationKey notificationRegistrationKey : this.notificationRegistrationDaoTestHelper.getTestNotificationRegistrationKeys()) {
            this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        }
        BusinessObjectDataNotificationRegistrationKeys resultKeys = this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistrationsByNamespace(this.addWhitespace(NAMESPACE));
        Assert.assertEquals((Object)this.notificationRegistrationDaoTestHelper.getExpectedNotificationRegistrationKeys(), (Object)resultKeys.getBusinessObjectDataNotificationRegistrationKeys());
    }

    @Test
    public void testGetBusinessObjectDataNotificationRegistrationsByNamespaceUpperCaseParameters() {
        for (NotificationRegistrationKey notificationRegistrationKey : this.notificationRegistrationDaoTestHelper.getTestNotificationRegistrationKeys()) {
            NotificationRegistrationKey notificationRegistrationKeyLowerCase = new NotificationRegistrationKey(notificationRegistrationKey.getNamespace().toLowerCase(), notificationRegistrationKey.getNotificationName().toLowerCase());
            this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKeyLowerCase, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        }
        BusinessObjectDataNotificationRegistrationKeys resultKeys = this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistrationsByNamespace(NAMESPACE.toUpperCase());
        ArrayList<NotificationRegistrationKey> expectedKeys = new ArrayList<NotificationRegistrationKey>();
        for (NotificationRegistrationKey origKey : this.notificationRegistrationDaoTestHelper.getExpectedNotificationRegistrationKeys()) {
            NotificationRegistrationKey expectedKey = new NotificationRegistrationKey();
            expectedKeys.add(expectedKey);
            expectedKey.setNamespace(origKey.getNamespace().toLowerCase());
            expectedKey.setNotificationName(origKey.getNotificationName().toLowerCase());
        }
        Assert.assertEquals(expectedKeys, (Object)resultKeys.getBusinessObjectDataNotificationRegistrationKeys());
    }

    @Test
    public void testGetBusinessObjectDataNotificationRegistrationsByNamespaceLowerCaseParameters() {
        for (NotificationRegistrationKey notificationRegistrationKey : this.notificationRegistrationDaoTestHelper.getTestNotificationRegistrationKeys()) {
            NotificationRegistrationKey notificationRegistrationKeyUpperCase = new NotificationRegistrationKey(notificationRegistrationKey.getNamespace().toUpperCase(), notificationRegistrationKey.getNotificationName().toUpperCase());
            this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKeyUpperCase, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        }
        BusinessObjectDataNotificationRegistrationKeys resultKeys = this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistrationsByNamespace(NAMESPACE.toLowerCase());
        ArrayList<NotificationRegistrationKey> expectedKeys = new ArrayList<NotificationRegistrationKey>();
        for (NotificationRegistrationKey origKey : this.notificationRegistrationDaoTestHelper.getExpectedNotificationRegistrationKeys()) {
            NotificationRegistrationKey expectedKey = new NotificationRegistrationKey();
            expectedKeys.add(expectedKey);
            expectedKey.setNamespace(origKey.getNamespace().toUpperCase());
            expectedKey.setNotificationName(origKey.getNotificationName().toUpperCase());
        }
        Assert.assertEquals(expectedKeys, (Object)resultKeys.getBusinessObjectDataNotificationRegistrationKeys());
    }

    @Test
    public void testGetBusinessObjectDataNotificationRegistrationsByNamespaceNamespaceNoExists() {
        try {
            this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistrationsByNamespace(NAMESPACE);
            Assert.fail((String)"Should throw an ObjectNotFoundException when using non-existing namespace.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Namespace \"%s\" doesn't exist.", NAMESPACE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDataNotificationRegistrationsByNamespaceBusinessObjectDataNotificationsNoExist() {
        this.notificationRegistrationServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataNotificationRegistrationTesting();
        BusinessObjectDataNotificationRegistrationKeys resultKeys = this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistrationsByNamespace(NAMESPACE);
        Assert.assertEquals(new ArrayList(), (Object)resultKeys.getBusinessObjectDataNotificationRegistrationKeys());
    }

    @Test
    public void testGetBusinessObjectDataNotificationRegistrationsByNotificationFilter() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistrationKeys(Arrays.asList(notificationRegistrationKey)), (Object)this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistrationsByNotificationFilter(new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_BDATA_STATUS, NO_BDATA_STATUS)));
    }

    @Test
    public void testGetBusinessObjectDataNotificationRegistrationsByNotificationFilterMissingRequiredParameters() {
        try {
            this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistrationsByNotificationFilter(new BusinessObjectDataNotificationFilter(NO_BDEF_NAMESPACE, BDEF_NAME, NO_FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_BDATA_STATUS, NO_BDATA_STATUS));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition namespace is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistrationsByNotificationFilter(new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, NO_BDEF_NAME, NO_FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_BDATA_STATUS, NO_BDATA_STATUS));
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetBusinessObjectDataNotificationRegistrationsByNotificationFilterMissingOptionalParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistrationKeys(Arrays.asList(notificationRegistrationKey)), (Object)this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistrationsByNotificationFilter(new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, NO_FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_BDATA_STATUS, NO_BDATA_STATUS)));
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistrationKeys(Arrays.asList(notificationRegistrationKey)), (Object)this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistrationsByNotificationFilter(new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, NO_FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_BDATA_STATUS, NO_BDATA_STATUS)));
    }

    @Test
    public void testGetBusinessObjectDataNotificationRegistrationsByNotificationFilterTrimParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistrationKeys(Arrays.asList(notificationRegistrationKey)), (Object)this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistrationsByNotificationFilter(new BusinessObjectDataNotificationFilter(this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(FORMAT_FILE_TYPE_CODE), NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_BDATA_STATUS, NO_BDATA_STATUS)));
    }

    @Test
    public void testGetBusinessObjectDataNotificationRegistrationsByNotificationFilterUpperCaseParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistrationKeys(Arrays.asList(notificationRegistrationKey)), (Object)this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistrationsByNotificationFilter(new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE.toUpperCase(), BDEF_NAME.toUpperCase(), FORMAT_USAGE_CODE.toUpperCase(), FORMAT_FILE_TYPE_CODE.toUpperCase(), NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_BDATA_STATUS, NO_BDATA_STATUS)));
    }

    @Test
    public void testGetBusinessObjectDataNotificationRegistrationsByNotificationFilterLowerCaseParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistrationKeys(Arrays.asList(notificationRegistrationKey)), (Object)this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistrationsByNotificationFilter(new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE.toLowerCase(), BDEF_NAME.toLowerCase(), FORMAT_USAGE_CODE.toLowerCase(), FORMAT_FILE_TYPE_CODE.toLowerCase(), NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_BDATA_STATUS, NO_BDATA_STATUS)));
    }

    @Test
    public void testGetBusinessObjectDataNotificationRegistrationsByNotificationFilterInvalidParameters() {
        NotificationRegistrationKey notificationRegistrationKey = new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME);
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(notificationRegistrationKey, NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, BDATA_STATUS_2, this.notificationRegistrationDaoTestHelper.getTestJobActions(), "ENABLED");
        Assert.assertEquals((Object)new BusinessObjectDataNotificationRegistrationKeys(Arrays.asList(notificationRegistrationKey)), (Object)this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistrationsByNotificationFilter(new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_BDATA_STATUS, NO_BDATA_STATUS)));
        Assert.assertTrue((boolean)this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistrationsByNotificationFilter(new BusinessObjectDataNotificationFilter("I_DO_NO_EXIST", BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_BDATA_STATUS, NO_BDATA_STATUS)).getBusinessObjectDataNotificationRegistrationKeys().isEmpty());
        Assert.assertTrue((boolean)this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistrationsByNotificationFilter(new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, "I_DO_NO_EXIST", FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_BDATA_STATUS, NO_BDATA_STATUS)).getBusinessObjectDataNotificationRegistrationKeys().isEmpty());
        Assert.assertTrue((boolean)this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistrationsByNotificationFilter(new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, "I_DO_NO_EXIST", FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_BDATA_STATUS, NO_BDATA_STATUS)).getBusinessObjectDataNotificationRegistrationKeys().isEmpty());
        Assert.assertTrue((boolean)this.businessObjectDataNotificationRegistrationService.getBusinessObjectDataNotificationRegistrationsByNotificationFilter(new BusinessObjectDataNotificationFilter(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "I_DO_NO_EXIST", NO_FORMAT_VERSION, NO_STORAGE_NAME, NO_BDATA_STATUS, NO_BDATA_STATUS)).getBusinessObjectDataNotificationRegistrationKeys().isEmpty());
    }
}

