/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.AttributeValueFilter;
import org.finra.herd.model.api.xml.BusinessObjectData;
import org.finra.herd.model.api.xml.BusinessObjectDataSearchFilter;
import org.finra.herd.model.api.xml.BusinessObjectDataSearchKey;
import org.finra.herd.model.api.xml.BusinessObjectDataSearchRequest;
import org.finra.herd.model.api.xml.PartitionValueFilter;
import org.finra.herd.model.dto.BusinessObjectDataSearchResultPagingInfoDto;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class BusinessObjectDataSearchServiceTest
extends AbstractServiceTest {
    private static final Integer DEFAULT_PAGE_NUMBER = 1;
    private static final Integer DEFAULT_PAGE_SIZE = (Integer)ConfigurationValue.BUSINESS_OBJECT_DATA_SEARCH_MAX_PAGE_SIZE.getDefaultValue();
    private static final Integer PAGE_SIZE = 100;

    @Test
    public void testSearchBusinessObjectData() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataSearchTesting();
        BusinessObjectDataSearchRequest request = new BusinessObjectDataSearchRequest();
        ArrayList<BusinessObjectDataSearchFilter> filters = new ArrayList<BusinessObjectDataSearchFilter>();
        ArrayList<BusinessObjectDataSearchKey> businessObjectDataSearchKeys = new ArrayList<BusinessObjectDataSearchKey>();
        BusinessObjectDataSearchKey key = new BusinessObjectDataSearchKey();
        key.setNamespace(NAMESPACE);
        key.setBusinessObjectDefinitionName(BDEF_NAME);
        businessObjectDataSearchKeys.add(key);
        BusinessObjectDataSearchFilter filter = new BusinessObjectDataSearchFilter(businessObjectDataSearchKeys);
        filters.add(filter);
        request.setBusinessObjectDataSearchFilters(filters);
        BusinessObjectDataSearchResultPagingInfoDto result = this.businessObjectDataService.searchBusinessObjectData(DEFAULT_PAGE_NUMBER, PAGE_SIZE, request);
        Assert.assertTrue((result.getBusinessObjectDataSearchResult().getBusinessObjectDataElements().size() == 2 ? 1 : 0) != 0);
        for (BusinessObjectData data : result.getBusinessObjectDataSearchResult().getBusinessObjectDataElements()) {
            Assert.assertEquals((Object)NAMESPACE, (Object)data.getNamespace());
            Assert.assertEquals((Object)BDEF_NAME, (Object)data.getBusinessObjectDefinitionName());
        }
        Assert.assertEquals((Object)DEFAULT_PAGE_NUMBER, (Object)result.getPageNum());
        Assert.assertEquals((Object)PAGE_SIZE, (Object)result.getPageSize());
        Assert.assertEquals((Object)1L, (Object)result.getPageCount());
        Assert.assertEquals((Object)2L, (Object)result.getTotalRecordsOnPage());
        Assert.assertEquals((Object)2L, (Object)result.getTotalRecordCount());
        Assert.assertEquals((Object)DEFAULT_PAGE_SIZE, (Object)result.getMaxResultsPerPage());
    }

    @Test
    public void testSearchBusinessObjectDataWithPartitionFilterValues() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataSearchTesting();
        BusinessObjectDataSearchRequest request = new BusinessObjectDataSearchRequest();
        ArrayList<BusinessObjectDataSearchFilter> filters = new ArrayList<BusinessObjectDataSearchFilter>();
        ArrayList<BusinessObjectDataSearchKey> businessObjectDataSearchKeys = new ArrayList<BusinessObjectDataSearchKey>();
        BusinessObjectDataSearchKey key = new BusinessObjectDataSearchKey();
        key.setNamespace(NAMESPACE);
        key.setBusinessObjectDefinitionName(BDEF_NAME);
        ArrayList<PartitionValueFilter> partitionValueFilters = new ArrayList<PartitionValueFilter>();
        PartitionValueFilter partitionValueFilter = new PartitionValueFilter();
        partitionValueFilters.add(partitionValueFilter);
        partitionValueFilter.setPartitionKey(PARTITION_KEY);
        ArrayList<String> values = new ArrayList<String>();
        values.add(PARTITION_VALUE);
        partitionValueFilter.setPartitionValues(values);
        key.setPartitionValueFilters(partitionValueFilters);
        businessObjectDataSearchKeys.add(key);
        BusinessObjectDataSearchFilter filter = new BusinessObjectDataSearchFilter(businessObjectDataSearchKeys);
        filters.add(filter);
        request.setBusinessObjectDataSearchFilters(filters);
        BusinessObjectDataSearchResultPagingInfoDto result = this.businessObjectDataService.searchBusinessObjectData(DEFAULT_PAGE_NUMBER, PAGE_SIZE, request);
        Assert.assertEquals((long)0L, (long)result.getBusinessObjectDataSearchResult().getBusinessObjectDataElements().size());
        Assert.assertEquals((Object)DEFAULT_PAGE_NUMBER, (Object)result.getPageNum());
        Assert.assertEquals((Object)PAGE_SIZE, (Object)result.getPageSize());
        Assert.assertEquals((Object)0L, (Object)result.getPageCount());
        Assert.assertEquals((Object)0L, (Object)result.getTotalRecordsOnPage());
        Assert.assertEquals((Object)0L, (Object)result.getTotalRecordCount());
        Assert.assertEquals((Object)DEFAULT_PAGE_SIZE, (Object)result.getMaxResultsPerPage());
    }

    @Test
    public void testSearchBusinessObjectDataWithPartitionFilterBadRequest() {
        try {
            this.businessObjectDataService.searchBusinessObjectData(DEFAULT_PAGE_NUMBER, PAGE_SIZE, new BusinessObjectDataSearchRequest(Collections.singletonList(new BusinessObjectDataSearchFilter(Collections.singletonList(new BusinessObjectDataSearchKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Collections.singletonList(new PartitionValueFilter(NO_PARTITION_KEY, NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_ATTRIBUTE_VALUE_FILTERS, NO_FILTER_ON_LATEST_VALID_VERSION, NO_FILTER_ON_RETENTION_EXPIRATION))))));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition key must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testSearchBusinessObjectDataWithAttributeFilterBadRequest() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataSearchTesting();
        BusinessObjectDataSearchRequest request = new BusinessObjectDataSearchRequest();
        ArrayList<BusinessObjectDataSearchFilter> filters = new ArrayList<BusinessObjectDataSearchFilter>();
        ArrayList<BusinessObjectDataSearchKey> businessObjectDataSearchKeys = new ArrayList<BusinessObjectDataSearchKey>();
        BusinessObjectDataSearchKey businessObjectDataSearchKey = new BusinessObjectDataSearchKey();
        businessObjectDataSearchKey.setNamespace(NAMESPACE);
        businessObjectDataSearchKey.setBusinessObjectDefinitionName(BDEF_NAME);
        businessObjectDataSearchKeys.add(businessObjectDataSearchKey);
        BusinessObjectDataSearchFilter filter = new BusinessObjectDataSearchFilter(businessObjectDataSearchKeys);
        filters.add(filter);
        request.setBusinessObjectDataSearchFilters(filters);
        ArrayList<AttributeValueFilter> attributeValueFilters = new ArrayList<AttributeValueFilter>();
        attributeValueFilters.add(new AttributeValueFilter(null, null));
        businessObjectDataSearchKey.setAttributeValueFilters(attributeValueFilters);
        try {
            this.businessObjectDataService.searchBusinessObjectData(DEFAULT_PAGE_NUMBER, PAGE_SIZE, request);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"Either attribute name or attribute value filter must be specified.", (Object)ex.getMessage());
        }
        attributeValueFilters = new ArrayList();
        attributeValueFilters.add(new AttributeValueFilter(" ", null));
        businessObjectDataSearchKey.setAttributeValueFilters(attributeValueFilters);
        try {
            this.businessObjectDataService.searchBusinessObjectData(DEFAULT_PAGE_NUMBER, PAGE_SIZE, request);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"Either attribute name or attribute value filter must be specified.", (Object)ex.getMessage());
        }
        attributeValueFilters = new ArrayList();
        attributeValueFilters.add(new AttributeValueFilter(" ", ""));
        businessObjectDataSearchKey.setAttributeValueFilters(attributeValueFilters);
        try {
            this.businessObjectDataService.searchBusinessObjectData(DEFAULT_PAGE_NUMBER, PAGE_SIZE, request);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"Either attribute name or attribute value filter must be specified.", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSearchBusinessObjectDataWithAttributeFilterValues() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataSearchTesting();
        this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, "Attribute Name 1", "Attribute Value 1");
        BusinessObjectDataSearchRequest request = new BusinessObjectDataSearchRequest();
        ArrayList<BusinessObjectDataSearchFilter> filters = new ArrayList<BusinessObjectDataSearchFilter>();
        ArrayList<BusinessObjectDataSearchKey> businessObjectDataSearchKeys = new ArrayList<BusinessObjectDataSearchKey>();
        BusinessObjectDataSearchKey key = new BusinessObjectDataSearchKey();
        key.setNamespace(NAMESPACE);
        key.setBusinessObjectDefinitionName(BDEF_NAME);
        ArrayList<AttributeValueFilter> attributeValueFilters = new ArrayList<AttributeValueFilter>();
        attributeValueFilters.add(new AttributeValueFilter("Attribute Name 1", "Attribute Value 1"));
        key.setAttributeValueFilters(attributeValueFilters);
        businessObjectDataSearchKeys.add(key);
        BusinessObjectDataSearchFilter filter = new BusinessObjectDataSearchFilter(businessObjectDataSearchKeys);
        filters.add(filter);
        request.setBusinessObjectDataSearchFilters(filters);
        BusinessObjectDataSearchResultPagingInfoDto result = this.businessObjectDataService.searchBusinessObjectData(DEFAULT_PAGE_NUMBER, PAGE_SIZE, request);
        List resultList = result.getBusinessObjectDataSearchResult().getBusinessObjectDataElements();
        Assert.assertEquals((long)1L, (long)resultList.size());
        for (BusinessObjectData data : resultList) {
            Assert.assertEquals((Object)NAMESPACE, (Object)data.getNamespace());
            Assert.assertEquals((Object)BDEF_NAME, (Object)data.getBusinessObjectDefinitionName());
            Assert.assertEquals((Object)"Attribute Name 1", (Object)((Attribute)data.getAttributes().get(0)).getName());
            Assert.assertEquals((Object)"Attribute Value 1", (Object)((Attribute)data.getAttributes().get(0)).getValue());
        }
        Assert.assertEquals((Object)DEFAULT_PAGE_NUMBER, (Object)result.getPageNum());
        Assert.assertEquals((Object)PAGE_SIZE, (Object)result.getPageSize());
        Assert.assertEquals((Object)1L, (Object)result.getPageCount());
        Assert.assertEquals((Object)1L, (Object)result.getTotalRecordsOnPage());
        Assert.assertEquals((Object)1L, (Object)result.getTotalRecordCount());
        Assert.assertEquals((Object)DEFAULT_PAGE_SIZE, (Object)result.getMaxResultsPerPage());
    }

    @Test
    public void testSearchBusinessObjectDataWithAttributeFilterValuesWithMixedCaseAndSpace() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataSearchTesting();
        this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, "Attribute Name 1", "Attribute Value 1");
        BusinessObjectDataSearchRequest request = new BusinessObjectDataSearchRequest();
        ArrayList<BusinessObjectDataSearchFilter> filters = new ArrayList<BusinessObjectDataSearchFilter>();
        ArrayList<BusinessObjectDataSearchKey> businessObjectDataSearchKeys = new ArrayList<BusinessObjectDataSearchKey>();
        BusinessObjectDataSearchKey key = new BusinessObjectDataSearchKey();
        key.setNamespace(NAMESPACE);
        key.setBusinessObjectDefinitionName(BDEF_NAME);
        ArrayList<AttributeValueFilter> attributeValueFilters = new ArrayList<AttributeValueFilter>();
        attributeValueFilters.add(new AttributeValueFilter("  " + "Attribute Name 1".toLowerCase() + "  ", "Attribute Value 1"));
        key.setAttributeValueFilters(attributeValueFilters);
        businessObjectDataSearchKeys.add(key);
        BusinessObjectDataSearchFilter filter = new BusinessObjectDataSearchFilter(businessObjectDataSearchKeys);
        filters.add(filter);
        request.setBusinessObjectDataSearchFilters(filters);
        BusinessObjectDataSearchResultPagingInfoDto result = this.businessObjectDataService.searchBusinessObjectData(DEFAULT_PAGE_NUMBER, PAGE_SIZE, request);
        List resultList = result.getBusinessObjectDataSearchResult().getBusinessObjectDataElements();
        Assert.assertEquals((long)1L, (long)resultList.size());
        for (BusinessObjectData data : resultList) {
            Assert.assertEquals((Object)NAMESPACE, (Object)data.getNamespace());
            Assert.assertEquals((Object)BDEF_NAME, (Object)data.getBusinessObjectDefinitionName());
            Assert.assertEquals((Object)"Attribute Name 1", (Object)((Attribute)data.getAttributes().get(0)).getName());
            Assert.assertEquals((Object)"Attribute Value 1", (Object)((Attribute)data.getAttributes().get(0)).getValue());
        }
        Assert.assertEquals((Object)DEFAULT_PAGE_NUMBER, (Object)result.getPageNum());
        Assert.assertEquals((Object)PAGE_SIZE, (Object)result.getPageSize());
        Assert.assertEquals((Object)1L, (Object)result.getPageCount());
        Assert.assertEquals((Object)1L, (Object)result.getTotalRecordsOnPage());
        Assert.assertEquals((Object)1L, (Object)result.getTotalRecordCount());
        Assert.assertEquals((Object)DEFAULT_PAGE_SIZE, (Object)result.getMaxResultsPerPage());
    }

    @Test
    public void testSearchBusinessObjectDataWithAttributeFilterValuesWithMultipleFilters() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataSearchTesting();
        this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, "Attribute Name 1", "Attribute Value 1");
        this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, "Attribute Name 2", "   Attribute Value 2  ");
        this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, "Attribute Name 3", "Attribute Value 3");
        this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, "Attribute Name 1", "Attribute Value 1");
        BusinessObjectDataSearchRequest request = new BusinessObjectDataSearchRequest();
        ArrayList<BusinessObjectDataSearchFilter> filters = new ArrayList<BusinessObjectDataSearchFilter>();
        ArrayList<BusinessObjectDataSearchKey> businessObjectDataSearchKeys = new ArrayList<BusinessObjectDataSearchKey>();
        BusinessObjectDataSearchKey key = new BusinessObjectDataSearchKey();
        key.setNamespace(NAMESPACE);
        key.setBusinessObjectDefinitionName(BDEF_NAME);
        ArrayList<AttributeValueFilter> attributeValueFilters = new ArrayList<AttributeValueFilter>();
        attributeValueFilters.add(new AttributeValueFilter("Attribute Name 1", "Attribute Value 1"));
        attributeValueFilters.add(new AttributeValueFilter("Attribute Name 2", null));
        key.setAttributeValueFilters(attributeValueFilters);
        businessObjectDataSearchKeys.add(key);
        BusinessObjectDataSearchFilter filter = new BusinessObjectDataSearchFilter(businessObjectDataSearchKeys);
        filters.add(filter);
        request.setBusinessObjectDataSearchFilters(filters);
        BusinessObjectDataSearchResultPagingInfoDto result = this.businessObjectDataService.searchBusinessObjectData(DEFAULT_PAGE_NUMBER, PAGE_SIZE, request);
        List resultList = result.getBusinessObjectDataSearchResult().getBusinessObjectDataElements();
        Assert.assertEquals((long)1L, (long)resultList.size());
        for (BusinessObjectData data : resultList) {
            Assert.assertEquals((Object)NAMESPACE, (Object)data.getNamespace());
            Assert.assertEquals((Object)BDEF_NAME, (Object)data.getBusinessObjectDefinitionName());
            Assert.assertEquals((long)2L, (long)data.getAttributes().size());
            boolean foundCase1 = false;
            boolean foundCase2 = false;
            for (int i = 0; i < data.getAttributes().size(); ++i) {
                if ("Attribute Name 1".equals(((Attribute)data.getAttributes().get(i)).getName())) {
                    Assert.assertEquals((Object)"Attribute Value 1", (Object)((Attribute)data.getAttributes().get(i)).getValue());
                    foundCase1 = true;
                }
                if (!"Attribute Name 2".equals(((Attribute)data.getAttributes().get(i)).getName())) continue;
                Assert.assertEquals((Object)"   Attribute Value 2  ", (Object)((Attribute)data.getAttributes().get(i)).getValue());
                foundCase2 = true;
            }
            Assert.assertTrue((foundCase1 && foundCase2 ? 1 : 0) != 0);
        }
        Assert.assertEquals((Object)DEFAULT_PAGE_NUMBER, (Object)result.getPageNum());
        Assert.assertEquals((Object)PAGE_SIZE, (Object)result.getPageSize());
        Assert.assertEquals((Object)1L, (Object)result.getPageCount());
        Assert.assertEquals((Object)1L, (Object)result.getTotalRecordsOnPage());
        Assert.assertEquals((Object)1L, (Object)result.getTotalRecordCount());
        Assert.assertEquals((Object)DEFAULT_PAGE_SIZE, (Object)result.getMaxResultsPerPage());
    }

    @Test
    public void testSearchBusinessObjectDataWithPageNumPageSize() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataSearchTesting();
        BusinessObjectDataSearchRequest request = this.businessObjectDataServiceTestHelper.createSimpleBusinessObjectDataSearchRequest(NAMESPACE, BDEF_NAME);
        BusinessObjectDataSearchResultPagingInfoDto result = this.businessObjectDataService.searchBusinessObjectData(Integer.valueOf(1), Integer.valueOf(1), request);
        Assert.assertEquals((long)1L, (long)result.getBusinessObjectDataSearchResult().getBusinessObjectDataElements().size());
        for (BusinessObjectData data : result.getBusinessObjectDataSearchResult().getBusinessObjectDataElements()) {
            Assert.assertEquals((Object)NAMESPACE, (Object)data.getNamespace());
            Assert.assertEquals((Object)BDEF_NAME, (Object)data.getBusinessObjectDefinitionName());
            Assert.assertEquals((Object)FORMAT_FILE_TYPE_CODE, (Object)data.getBusinessObjectFormatFileType());
            Assert.assertEquals((Object)FORMAT_USAGE_CODE, (Object)data.getBusinessObjectFormatUsage());
        }
        Assert.assertEquals((Object)1L, (Object)result.getPageNum());
        Assert.assertEquals((Object)1L, (Object)result.getPageSize());
        Assert.assertEquals((Object)2L, (Object)result.getPageCount());
        Assert.assertEquals((Object)1L, (Object)result.getTotalRecordsOnPage());
        Assert.assertEquals((Object)2L, (Object)result.getTotalRecordCount());
        Assert.assertEquals((Object)DEFAULT_PAGE_SIZE, (Object)result.getMaxResultsPerPage());
        result = this.businessObjectDataService.searchBusinessObjectData(Integer.valueOf(2), Integer.valueOf(1), request);
        Assert.assertEquals((long)1L, (long)result.getBusinessObjectDataSearchResult().getBusinessObjectDataElements().size());
        for (BusinessObjectData data : result.getBusinessObjectDataSearchResult().getBusinessObjectDataElements()) {
            Assert.assertEquals((Object)NAMESPACE, (Object)data.getNamespace());
            Assert.assertEquals((Object)BDEF_NAME, (Object)data.getBusinessObjectDefinitionName());
            Assert.assertEquals((Object)FORMAT_FILE_TYPE_CODE, (Object)data.getBusinessObjectFormatFileType());
            Assert.assertEquals((Object)FORMAT_USAGE_CODE_2, (Object)data.getBusinessObjectFormatUsage());
        }
        Assert.assertEquals((Object)2L, (Object)result.getPageNum());
        Assert.assertEquals((Object)1L, (Object)result.getPageSize());
        Assert.assertEquals((Object)2L, (Object)result.getPageCount());
        Assert.assertEquals((Object)1L, (Object)result.getTotalRecordsOnPage());
        Assert.assertEquals((Object)2L, (Object)result.getTotalRecordCount());
        Assert.assertEquals((Object)DEFAULT_PAGE_SIZE, (Object)result.getMaxResultsPerPage());
        result = this.businessObjectDataService.searchBusinessObjectData(Integer.valueOf(1), Integer.valueOf(3), request);
        Assert.assertEquals((long)2L, (long)result.getBusinessObjectDataSearchResult().getBusinessObjectDataElements().size());
        Assert.assertEquals((Object)1L, (Object)result.getPageNum());
        Assert.assertEquals((Object)3L, (Object)result.getPageSize());
        Assert.assertEquals((Object)1L, (Object)result.getPageCount());
        Assert.assertEquals((Object)2L, (Object)result.getTotalRecordsOnPage());
        Assert.assertEquals((Object)2L, (Object)result.getTotalRecordCount());
        Assert.assertEquals((Object)DEFAULT_PAGE_SIZE, (Object)result.getMaxResultsPerPage());
        result = this.businessObjectDataService.searchBusinessObjectData(Integer.valueOf(3), Integer.valueOf(1), request);
        Assert.assertEquals((long)0L, (long)result.getBusinessObjectDataSearchResult().getBusinessObjectDataElements().size());
        Assert.assertEquals((Object)3L, (Object)result.getPageNum());
        Assert.assertEquals((Object)1L, (Object)result.getPageSize());
        Assert.assertEquals((Object)2L, (Object)result.getPageCount());
        Assert.assertEquals((Object)0L, (Object)result.getTotalRecordsOnPage());
        Assert.assertEquals((Object)2L, (Object)result.getTotalRecordCount());
        Assert.assertEquals((Object)DEFAULT_PAGE_SIZE, (Object)result.getMaxResultsPerPage());
    }

    @Test
    public void testSearchBusinessObjectDataWithPageSizeGreaterThanMaximumPageSize() {
        int maxPageSize = (Integer)this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_DATA_SEARCH_MAX_PAGE_SIZE, Integer.class);
        try {
            this.businessObjectDataService.searchBusinessObjectData(DEFAULT_PAGE_NUMBER, Integer.valueOf(maxPageSize + 1), this.businessObjectDataServiceTestHelper.createSimpleBusinessObjectDataSearchRequest(NAMESPACE, BDEF_NAME));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("A pageSize less than %d must be specified.", maxPageSize), (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSearchBusinessObjectDataWithMaxRecordsExceeded() throws Exception {
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, Boolean.valueOf(true), "VALID");
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, null, DATA_VERSION, Boolean.valueOf(true), "INVALID");
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION_2, PARTITION_VALUE, null, DATA_VERSION, Boolean.valueOf(true), "INVALID");
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, PARTITION_VALUE, null, DATA_VERSION, Boolean.valueOf(true), "VALID");
        int maxBusinessObjectDataSearchResultCount = 2;
        HashMap<String, Integer> overrideMap = new HashMap<String, Integer>();
        overrideMap.put(ConfigurationValue.BUSINESS_OBJECT_DATA_SEARCH_MAX_RESULT_COUNT.getKey(), maxBusinessObjectDataSearchResultCount);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            this.businessObjectDataService.searchBusinessObjectData(DEFAULT_PAGE_NUMBER, DEFAULT_PAGE_SIZE, new BusinessObjectDataSearchRequest(Collections.singletonList(new BusinessObjectDataSearchFilter(Collections.singletonList(new BusinessObjectDataSearchKey(NAMESPACE, BDEF_NAME, NO_FORMAT_USAGE_CODE, NO_FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, NO_PARTITION_VALUE_FILTERS, NO_ATTRIBUTE_VALUE_FILTERS, NO_FILTER_ON_LATEST_VALID_VERSION, NO_FILTER_ON_RETENTION_EXPIRATION))))));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Result limit of %d exceeded. Total result size %d. Modify filters to further limit results.", maxBusinessObjectDataSearchResultCount, 3), (Object)e.getMessage());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }
}

