/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.BusinessObjectDataDdl;
import org.finra.herd.model.api.xml.BusinessObjectDataDdlOutputFormatEnum;
import org.finra.herd.model.api.xml.BusinessObjectDataDdlRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.LatestAfterPartitionValue;
import org.finra.herd.model.api.xml.LatestBeforePartitionValue;
import org.finra.herd.model.api.xml.PartitionValueFilter;
import org.finra.herd.model.api.xml.PartitionValueRange;
import org.finra.herd.model.api.xml.SchemaColumn;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class BusinessObjectDataServiceGenerateBusinessObjectDataDdlTest
extends AbstractServiceTest {
    @Test
    public void testGenerateBusinessObjectDataDdlPartitionValueList() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting();
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES, CUSTOM_DDL_NAME);
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(), resultDdl);
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES, CUSTOM_DDL_NAME);
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValues().add(UNSORTED_PARTITION_VALUES.get(0));
        resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(), resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlPartitionValueListStandalonePartitionValueFilter() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting();
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES, CUSTOM_DDL_NAME);
        request.setPartitionValueFilter((PartitionValueFilter)request.getPartitionValueFilters().get(0));
        request.setPartitionValueFilters(null);
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(), resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlPartitionValueRange() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting();
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueProcessDatesForApril2014(PARTITION_KEY_GROUP);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest("2014-04-02", "2014-04-08", CUSTOM_DDL_NAME);
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", 1, PROCESS_DATE_AVAILABLE_PARTITION_VALUES, SUBPARTITION_VALUES, false, true, true);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest("2014-04-02", "2014-04-02", CUSTOM_DDL_NAME);
        resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", 1, Arrays.asList("2014-04-02"), SUBPARTITION_VALUES, false, true, true);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlLatestBeforePartitionValue() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting(PARTITION_VALUE);
        for (String upperBoundPartitionValue : Arrays.asList(PARTITION_VALUE, PARTITION_VALUE_2)) {
            BusinessObjectDataDdl resultBusinessObjectDataDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, new LatestBeforePartitionValue(upperBoundPartitionValue), NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS, NO_SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
            Assert.assertEquals((Object)new BusinessObjectDataDdl(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, new LatestBeforePartitionValue(upperBoundPartitionValue), NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_VALUE)), (Object)resultBusinessObjectDataDdl);
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlLatestAfterPartitionValue() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting(PARTITION_VALUE_2);
        for (String lowerBoundPartitionValue : Arrays.asList(PARTITION_VALUE, PARTITION_VALUE_2)) {
            BusinessObjectDataDdl resultBusinessObjectDataDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, new LatestAfterPartitionValue(lowerBoundPartitionValue))), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS, NO_SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
            Assert.assertEquals((Object)new BusinessObjectDataDdl(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, new LatestAfterPartitionValue(lowerBoundPartitionValue))), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_VALUE_2)), (Object)resultBusinessObjectDataDdl);
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlMissingRequiredParameters() {
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        request.setBusinessObjectDefinitionName("      \t\t ");
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object definition name parameter is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        request.setBusinessObjectFormatUsage("      \t\t ");
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format usage parameter is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        request.setBusinessObjectFormatFileType("      \t\t ");
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format file type parameter is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format file type must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionKey("      \t\t ");
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition key is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition key must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest("      \t\t ", "2014-04-08");
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when start partition values is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A start partition value for the partition value range must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest("2014-04-02", "      \t\t ", null);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when end partition values is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An end partition value for the partition value range must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(new ArrayList<String>());
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value list has no partition values specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least one partition value must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValues().add("      \t\t ");
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when one of the partition values in the partition value list is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(NO_PARTITION_VALUES);
        for (String partitionValue : Arrays.asList(null, "      \t\t ")) {
            ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setLatestBeforePartitionValue(new LatestBeforePartitionValue(partitionValue));
            try {
                this.businessObjectDataService.generateBusinessObjectDataDdl(request);
                Assert.fail((String)"Should throw an IllegalArgumentException when the latest before partition value filter option has no partition value specified.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)"A partition value must be specified.", (Object)e.getMessage());
            }
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(NO_PARTITION_VALUES);
        for (String partitionValue : Arrays.asList(null, "      \t\t ")) {
            ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setLatestAfterPartitionValue(new LatestAfterPartitionValue(partitionValue));
            try {
                this.businessObjectDataService.generateBusinessObjectDataDdl(request);
                Assert.fail((String)"Should throw an IllegalArgumentException when the latest after partition value filter option has no partition value specified.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)"A partition value must be specified.", (Object)e.getMessage());
            }
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        request.setStorageName("      \t\t ");
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when standalone storage name parameter is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage name must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        request.setStorageName(null);
        request.setStorageNames(Arrays.asList("      \t\t "));
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when storage name parameter in the list of storage names is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage name must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        request.setOutputFormat(null);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when output format parameter is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An output format must be specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        request.setTableName("      \t\t ");
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when table name parameter is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A table name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlMissingOptionalParametersPartitionValueList() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", "PRTN_CLMN001", PARTITION_KEY_GROUP, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns(), false, CUSTOM_DDL_NAME, true, NO_ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(STORAGE_1_AVAILABLE_PARTITION_VALUES);
        request.setBusinessObjectFormatVersion(null);
        request.setBusinessObjectDataVersion(null);
        request.setStorageName(null);
        request.setIncludeDropTableStatement(null);
        request.setIncludeIfNotExistsOption(null);
        request.setAllowMissingData(null);
        request.setIncludeAllRegisteredSubPartitions(null);
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, SUBPARTITION_VALUES, false, false, false);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlMissingOptionalParametersPartitionValueListStandalonePartitionValueFilter() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", "PRTN_CLMN001", PARTITION_KEY_GROUP, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns(), false, CUSTOM_DDL_NAME, true, NO_ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(STORAGE_1_AVAILABLE_PARTITION_VALUES);
        request.setPartitionValueFilter((PartitionValueFilter)request.getPartitionValueFilters().get(0));
        request.setPartitionValueFilters(null);
        request.setBusinessObjectFormatVersion(null);
        request.setBusinessObjectDataVersion(null);
        request.getPartitionValueFilter().setPartitionKey("      \t\t ");
        request.setStorageName(null);
        request.setIncludeDropTableStatement(null);
        request.setIncludeIfNotExistsOption(null);
        request.setAllowMissingData(null);
        request.setIncludeAllRegisteredSubPartitions(null);
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, SUBPARTITION_VALUES, false, false, false);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlMissingOptionalParametersPartitionValueRange() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", "PRTN_CLMN001", PARTITION_KEY_GROUP, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns(), false, CUSTOM_DDL_NAME, true, NO_ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueProcessDatesForApril2014(PARTITION_KEY_GROUP);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest("2014-04-02", "2014-04-08");
        request.setBusinessObjectFormatVersion(null);
        request.setBusinessObjectDataVersion(null);
        request.setStorageName(null);
        request.setIncludeDropTableStatement(null);
        request.setIncludeIfNotExistsOption(null);
        request.setIncludeAllRegisteredSubPartitions(null);
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", 1, PROCESS_DATE_AVAILABLE_PARTITION_VALUES, SUBPARTITION_VALUES, false, false, false);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlLatestBeforePartitionValueNoStorage() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting(PARTITION_VALUE);
        for (String upperBoundPartitionValue : Arrays.asList(PARTITION_VALUE, PARTITION_VALUE_2)) {
            BusinessObjectDataDdl resultBusinessObjectDataDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, new LatestBeforePartitionValue(upperBoundPartitionValue), NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS, NO_SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
            Assert.assertEquals((Object)new BusinessObjectDataDdl(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, new LatestBeforePartitionValue(upperBoundPartitionValue), NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_VALUE)), (Object)resultBusinessObjectDataDdl);
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlLatestAfterPartitionValueNoStorage() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting(PARTITION_VALUE_2);
        for (String lowerBoundPartitionValue : Arrays.asList(PARTITION_VALUE, PARTITION_VALUE_2)) {
            BusinessObjectDataDdl resultBusinessObjectDataDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, new LatestAfterPartitionValue(lowerBoundPartitionValue))), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS, NO_SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
            Assert.assertEquals((Object)new BusinessObjectDataDdl(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, new LatestAfterPartitionValue(lowerBoundPartitionValue))), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_VALUE_2)), (Object)resultBusinessObjectDataDdl);
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlTrimParametersPartitionValueList() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting();
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES, CUSTOM_DDL_NAME);
        request.setBusinessObjectDefinitionName(this.addWhitespace(request.getBusinessObjectDefinitionName()));
        request.setBusinessObjectFormatUsage(this.addWhitespace(request.getBusinessObjectFormatUsage()));
        request.setBusinessObjectFormatFileType(this.addWhitespace(request.getBusinessObjectFormatFileType()));
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionKey(this.addWhitespace(((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionKey()));
        for (int i = 0; i < ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValues().size(); ++i) {
            ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValues().set(i, this.addWhitespace((String)((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValues().get(i)));
        }
        request.setStorageName(this.addWhitespace(request.getStorageName()));
        request.setTableName(this.addWhitespace(request.getTableName()));
        request.setCustomDdlName(this.addWhitespace(request.getCustomDdlName()));
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(), resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlTrimParametersPartitionValueRange() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting();
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueProcessDatesForApril2014(PARTITION_KEY_GROUP);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(this.addWhitespace("2014-04-02"), this.addWhitespace("2014-04-08"), this.addWhitespace(CUSTOM_DDL_NAME));
        request.setBusinessObjectDefinitionName(this.addWhitespace(request.getBusinessObjectDefinitionName()));
        request.setBusinessObjectFormatUsage(this.addWhitespace(request.getBusinessObjectFormatUsage()));
        request.setBusinessObjectFormatFileType(this.addWhitespace(request.getBusinessObjectFormatFileType()));
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionKey(this.addWhitespace(((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionKey()));
        request.setStorageName(this.addWhitespace(request.getStorageName()));
        request.setTableName(this.addWhitespace(request.getTableName()));
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", 1, PROCESS_DATE_AVAILABLE_PARTITION_VALUES, SUBPARTITION_VALUES, false, true, true);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlUpperCaseParameters() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting();
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES, CUSTOM_DDL_NAME);
        request.setBusinessObjectDefinitionName(request.getBusinessObjectDefinitionName().toUpperCase());
        request.setBusinessObjectFormatUsage(request.getBusinessObjectFormatUsage().toUpperCase());
        request.setBusinessObjectFormatFileType(request.getBusinessObjectFormatFileType().toUpperCase());
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionKey(((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionKey().toUpperCase());
        request.setStorageName(request.getStorageName().toUpperCase());
        request.setCustomDdlName(request.getCustomDdlName().toUpperCase());
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(), resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlLowerCaseParameters() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting();
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES, CUSTOM_DDL_NAME);
        request.setBusinessObjectDefinitionName(request.getBusinessObjectDefinitionName().toLowerCase());
        request.setBusinessObjectFormatUsage(request.getBusinessObjectFormatUsage().toLowerCase());
        request.setBusinessObjectFormatFileType(request.getBusinessObjectFormatFileType().toLowerCase());
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionKey(((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionKey().toLowerCase());
        request.setStorageName(request.getStorageName().toLowerCase());
        request.setCustomDdlName(request.getCustomDdlName().toLowerCase());
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(), resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlInvalidParameters() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting();
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES, CUSTOM_DDL_NAME);
        request.setBusinessObjectDefinitionName("I_DO_NOT_EXIST");
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when non-existing business object format is used.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatNotFoundErrorMessage(request.getNamespace(), request.getBusinessObjectDefinitionName(), request.getBusinessObjectFormatUsage(), request.getBusinessObjectFormatFileType(), request.getBusinessObjectFormatVersion()), (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES, CUSTOM_DDL_NAME);
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionKey("I_DO_NOT_EXIST");
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when non-existing partition key is used.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("The partition key \"%s\" does not exist in first %d partition columns in the schema for business object format {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d}.", ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionKey(), 5, request.getNamespace(), request.getBusinessObjectDefinitionName(), request.getBusinessObjectFormatUsage(), request.getBusinessObjectFormatFileType(), request.getBusinessObjectFormatVersion()), (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES, CUSTOM_DDL_NAME);
        request.setPartitionValueFilter(new PartitionValueFilter("PRTN_CLMN001".toUpperCase(), new ArrayList(UNSORTED_PARTITION_VALUES), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE));
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when both a list of partition value filters and a standalone partition value filter are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A list of partition value filters and a standalone partition value filter cannot be both specified.", (Object)e.getMessage());
        }
        for (PartitionValueFilter partitionValueFilter : this.businessObjectDataServiceTestHelper.getInvalidPartitionValueFilters()) {
            request = new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(partitionValueFilter), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, NO_INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS, NO_SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS);
            try {
                this.businessObjectDataService.generateBusinessObjectDataDdl(request);
                Assert.fail((String)"Should throw an IllegalArgumentException when partition value filter has more than one partition value filter option.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)"Exactly one partition value filter option must be specified.", (Object)e.getMessage());
            }
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest("${maximum.partition.value}", "2014-04-08");
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value token is specified with a partition value range.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value token cannot be specified with a partition value range.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest("${minimum.partition.value}", "2014-04-08");
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value token is specified with a partition value range.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value token cannot be specified with a partition value range.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest("2014-04-02", "${maximum.partition.value}");
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value token is specified with a partition value range.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value token cannot be specified with a partition value range.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest("2014-04-08", "${minimum.partition.value}");
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value token is specified with a partition value range.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value token cannot be specified with a partition value range.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest("2014-04-08", "2014-04-02", CUSTOM_DDL_NAME);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when start partition value which is greater than the end partition value.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("The start partition value \"%s\" cannot be greater than the end partition value \"%s\".", "2014-04-08", "2014-04-02"), (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest("I_DO_NOT_EXIST_1", "I_DO_NOT_EXIST_2", null, CUSTOM_DDL_NAME);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value filter has specifies a range that results in no valid partition values.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Partition value range [\"%s\", \"%s\"] contains no valid partition values in partition key group \"%s\". Business object format:\u00a0{%s}", ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValueRange().getStartPartitionValue(), ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValueRange().getEndPartitionValue(), PARTITION_KEY_GROUP, this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatKeyAsString(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION)), (Object)e.getMessage());
        }
        String invalidPartitionValue = "INVALID_PARTITION_VALUE_/";
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(Arrays.asList(invalidPartitionValue), CUSTOM_DDL_NAME);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value contains a '/' character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Partition value \"%s\" can not contain a '/' character.", ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValues().get(0)), (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(Arrays.asList("${maximum.partition.value}"), CUSTOM_DDL_NAME);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value token is specified as a partition value.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value token cannot be specified as one of partition values.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(Arrays.asList("${minimum.partition.value}"), CUSTOM_DDL_NAME);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value token is specified as a partition value.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value token cannot be specified as one of partition values.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        request.setStorageName("      \t\t ");
        request.setStorageNames(STORAGE_NAMES);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when both a list of storage names and standalone storage name are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A list of storage names and a standalone storage name cannot be both specified.", (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES, CUSTOM_DDL_NAME);
        request.setStorageName("I_DO_NOT_EXIST");
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when non-existing storage is used as a standalone storage name.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage with name \"%s\" doesn't exist.", request.getStorageName()), (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        request.setStorageName(null);
        request.setStorageNames(Arrays.asList("I_DO_NOT_EXIST"));
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when non-existing storage is used in the list of storage names.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage with name \"%s\" doesn't exist.", request.getStorageNames().get(0)), (Object)e.getMessage());
        }
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES, CUSTOM_DDL_NAME);
        request.setCustomDdlName("I_DO_NOT_EXIST");
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when non-existing custom ddl is used.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Custom DDL with name \"%s\" does not exist for business object format with namespace \"%s\", business object definition name \"%s\", format usage \"%s\", format file type \"%s\", and format version \"%d\".", request.getCustomDdlName(), request.getNamespace(), request.getBusinessObjectDefinitionName(), request.getBusinessObjectFormatUsage(), request.getBusinessObjectFormatFileType(), request.getBusinessObjectFormatVersion()), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlTwoPartitionValueRanges() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting();
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES, CUSTOM_DDL_NAME);
        ArrayList<PartitionValueFilter> partitionValueFilters = new ArrayList<PartitionValueFilter>();
        request.setPartitionValueFilters(partitionValueFilters);
        partitionValueFilters.add(new PartitionValueFilter("PRTN_CLMN001", null, new PartitionValueRange("2014-04-02", "2014-04-08"), NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE));
        partitionValueFilters.add(new PartitionValueFilter("PRTN_CLMN001", null, new PartitionValueRange("2014-04-02", "2014-04-08"), NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE));
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when more than one partition value range is specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Cannot specify more than one partition value range.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlDuplicatePartitionColumns() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting();
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES, CUSTOM_DDL_NAME);
        ArrayList<PartitionValueFilter> partitionValueFilters = new ArrayList<PartitionValueFilter>();
        request.setPartitionValueFilters(partitionValueFilters);
        partitionValueFilters.add(new PartitionValueFilter("PRTN_CLMN001".toUpperCase(), new ArrayList(UNSORTED_PARTITION_VALUES), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE));
        partitionValueFilters.add(new PartitionValueFilter("PRTN_CLMN001".toLowerCase(), new ArrayList(UNSORTED_PARTITION_VALUES), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE));
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition value filters use duplicate partition columns.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Partition value filters specify duplicate partition columns.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlNoCustomDdlNoSchemaExists() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", PARTITION_KEY, null, 1, UNSORTED_PARTITION_VALUES, NO_SUBPARTITION_VALUES, null, null, null, null, null, false, null, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format has no schema.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object format with namespace \"%s\", business object definition name \"%s\", format usage \"%s\", format file type \"%s\", and format version \"%s\" doesn't have schema information.", request.getNamespace(), request.getBusinessObjectDefinitionName(), request.getBusinessObjectFormatUsage(), request.getBusinessObjectFormatFileType(), request.getBusinessObjectFormatVersion()), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlNoCustomDdlPartitionColumnIsAlsoRegularColumn() {
        List schemaColumns = this.schemaColumnDaoTestHelper.getTestSchemaColumns();
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        schemaColumns.set(0, partitionColumns.get(0));
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", "PRTN_CLMN001", null, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, "|", "\\", "\\N", schemaColumns, partitionColumns, false, null, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(partitionColumns.size(), "ORGNL_PRTN_CLMN001", "DATE", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, SUBPARTITION_VALUES, false, true, true);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlPartitionValueRangeFormatWithoutPartitionKeyGroup() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", "PRTN_CLMN001", null, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns(), false, CUSTOM_DDL_NAME, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest("2014-04-02", "2014-04-08", CUSTOM_DDL_NAME);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when generating ddl for a partition value range and business object format has no partition key group.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("A partition key group, which is required to use partition value ranges, is not specified for the business object format {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d}.", request.getNamespace(), request.getBusinessObjectDefinitionName(), request.getBusinessObjectFormatUsage(), request.getBusinessObjectFormatFileType(), request.getBusinessObjectFormatVersion()), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlPartitionValueRangeExpectedPartitionValueMatchesMaxPartitionValueToken() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting();
        String startPartitionValue = "${maximum.partition.value}".replace("maximum", "a");
        String endPartitionValue = "${maximum.partition.value}".replace("maximum", "z");
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueEntities(PARTITION_KEY_GROUP, Arrays.asList(startPartitionValue, "${maximum.partition.value}", endPartitionValue));
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(startPartitionValue, endPartitionValue, CUSTOM_DDL_NAME);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when expected partition value matches to the maximum partition value token.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value token cannot be specified as one of the expected partition values.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlPartitionValueRangeExpectedPartitionValueMatchesMinPartitionValueToken() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting();
        String startPartitionValue = "${minimum.partition.value}".replace("minimum", "a");
        String endPartitionValue = "${minimum.partition.value}".replace("minimum", "z");
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueEntities(PARTITION_KEY_GROUP, Arrays.asList(startPartitionValue, "${minimum.partition.value}", endPartitionValue));
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(startPartitionValue, endPartitionValue, CUSTOM_DDL_NAME);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when expected partition value matches to the minimum partition value token.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition value token cannot be specified as one of the expected partition values.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlNoCustomDdlSingleLevelPartitioningPartitionValueList() {
        List<SchemaColumn> partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns().subList(0, 1);
        String partitionKey = ((SchemaColumn)partitionColumns.get(0)).getName();
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", partitionKey, null, 1, UNSORTED_PARTITION_VALUES, NO_SUBPARTITION_VALUES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, false, null, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(partitionColumns.size(), "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, SUBPARTITION_VALUES, false, true, true);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValues().add(UNSORTED_PARTITION_VALUES.get(0));
        resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlNoCustomDdlSingleLevelPartitioningPartitionValueRange() {
        List<SchemaColumn> partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns().subList(0, 1);
        String partitionKey = "partition";
        ((SchemaColumn)partitionColumns.get(0)).setName(partitionKey);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", partitionKey, PARTITION_KEY_GROUP, 1, UNSORTED_PARTITION_VALUES, NO_SUBPARTITION_VALUES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, false, null, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueProcessDatesForApril2014(PARTITION_KEY_GROUP);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest("2014-04-02", "2014-04-08");
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionKey(partitionKey);
        this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(partitionColumns.size(), "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", 1, PROCESS_DATE_PARTITION_VALUES, NO_SUBPARTITION_VALUES, false, true, true);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlNoPartitioning() {
        List<String> partitionValues = Arrays.asList("none");
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", "partition", null, 1, partitionValues, NO_SUBPARTITION_VALUES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), null, false, CUSTOM_DDL_NAME, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES, CUSTOM_DDL_NAME);
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionKey("partition");
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionValues(partitionValues);
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(0, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", 1, UNSORTED_PARTITION_VALUES, STORAGE_1_AVAILABLE_PARTITION_VALUES, false, true, true);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlNoCustomDdlNoPartitioning() {
        List<String> partitionValues = Arrays.asList("none");
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", "partition", null, 1, partitionValues, NO_SUBPARTITION_VALUES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), null, false, null, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionKey("partition");
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionValues(partitionValues);
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(0, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", 1, UNSORTED_PARTITION_VALUES, NO_SUBPARTITION_VALUES, false, true, true);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlSubpartitionKeysHaveHyphens() {
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String partitionKey = ((SchemaColumn)partitionColumns.get(0)).getName();
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", partitionKey, PARTITION_KEY_GROUP, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, true, CUSTOM_DDL_NAME, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES, CUSTOM_DDL_NAME);
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, SUBPARTITION_VALUES, true, true, true);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlNoCustomDdlMissingSchemaDelimiterCharacter() {
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String partitionKey = ((SchemaColumn)partitionColumns.get(0)).getName();
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", partitionKey, null, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, null, "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, false, null, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        String expectedRowFormat = "ROW FORMAT DELIMITED NULL DEFINED AS '\\N'";
        String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", expectedRowFormat, "TEXTFILE", "TXT", 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, SUBPARTITION_VALUES, false, true, true);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlNoCustomDdlMissingSchemaEscapeCharacter() {
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String partitionKey = ((SchemaColumn)partitionColumns.get(0)).getName();
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", partitionKey, null, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, "|", null, "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, false, null, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        String expectedRowFormat = "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' NULL DEFINED AS '\\N'";
        String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", expectedRowFormat, "TEXTFILE", "TXT", 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, SUBPARTITION_VALUES, false, true, true);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlNoCustomDdlMissingSchemaNullValue() {
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String partitionKey = ((SchemaColumn)partitionColumns.get(0)).getName();
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", partitionKey, null, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, "|", "\\", null, this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, false, null, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        String expectedRowFormat = "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS ''";
        String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", expectedRowFormat, "TEXTFILE", "TXT", 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, SUBPARTITION_VALUES, false, true, true);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlNoCustomDdlEscapeSingleQuoteInRowFormat() {
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String partitionKey = ((SchemaColumn)partitionColumns.get(0)).getName();
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", partitionKey, null, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, "'", "'", "'", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, false, null, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        String expectedRowFormat = "ROW FORMAT DELIMITED FIELDS TERMINATED BY '\\'' ESCAPED BY '\\'' NULL DEFINED AS '\\''";
        String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", expectedRowFormat, "TEXTFILE", "TXT", 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, SUBPARTITION_VALUES, false, true, true);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlNoCustomDdlEscapeBackslashInRowFormat() {
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String partitionKey = ((SchemaColumn)partitionColumns.get(0)).getName();
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", partitionKey, null, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, "\\", "\\", "\\", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, false, null, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        String expectedRowFormat = "ROW FORMAT DELIMITED FIELDS TERMINATED BY '\\\\' ESCAPED BY '\\\\' NULL DEFINED AS '\\'";
        String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", expectedRowFormat, "TEXTFILE", "TXT", 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, SUBPARTITION_VALUES, false, true, true);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlNoCustomDdlUnprintableCharactersInRowFormat() {
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        String partitionKey = ((SchemaColumn)partitionColumns.get(0)).getName();
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", partitionKey, null, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, String.valueOf('\u0001'), String.valueOf('\n'), String.valueOf('\u0080'), this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, false, null, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        String expectedRowFormat = "ROW FORMAT DELIMITED FIELDS TERMINATED BY '\\001' ESCAPED BY '\\012' NULL DEFINED AS '\\200'";
        String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", expectedRowFormat, "TEXTFILE", "TXT", 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, SUBPARTITION_VALUES, false, true, true);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlMissingBusinessObjectDataDoNotAllowMissingData() {
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", "PRTN_CLMN001", PARTITION_KEY_GROUP, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, false, CUSTOM_DDL_NAME, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES, CUSTOM_DDL_NAME);
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionValues(Arrays.asList("I_DO_NOT_EXIST"));
        request.setAllowMissingData(Boolean.valueOf(false));
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object data {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %s, partitionValue: \"%s\", subpartitionValues: \",,,\", businessObjectDataVersion: %d} is not available in \"%s\" storage(s).", request.getNamespace(), request.getBusinessObjectDefinitionName(), request.getBusinessObjectFormatUsage(), request.getBusinessObjectFormatFileType(), request.getBusinessObjectFormatVersion(), ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValues().get(((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValues().size() - 1), request.getBusinessObjectDataVersion(), request.getStorageName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlNotAvailableStorageUnitDoNotAllowMissingData() {
        StorageUnitEntity storageUnitEntity = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting(PARTITION_VALUE);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(Arrays.asList(PARTITION_VALUE));
        request.setIncludeDropPartitions(Boolean.valueOf(true));
        request.setAllowMissingData(Boolean.valueOf(false));
        BusinessObjectDataDdl result = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        Assert.assertEquals((Object)new BusinessObjectDataDdl(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_VALUE)), (Object)result);
        storageUnitEntity.setStatus(this.storageUnitStatusDaoTestHelper.createStorageUnitStatusEntity(STORAGE_UNIT_STATUS, DESCRIPTION, NO_STORAGE_UNIT_STATUS_AVAILABLE_FLAG_SET));
        this.herdDao.saveAndRefresh((Object)storageUnitEntity);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an ObjectNotFoundException when business object data is not available.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object data {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %s, partitionValue: \"%s\", subpartitionValues: \",,,\", businessObjectDataVersion: %d} is not available in \"%s\" storage(s).", request.getNamespace(), request.getBusinessObjectDefinitionName(), request.getBusinessObjectFormatUsage(), request.getBusinessObjectFormatFileType(), request.getBusinessObjectFormatVersion(), ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValues().get(((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValues().size() - 1), request.getBusinessObjectDataVersion(), request.getStorageName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlMissingBusinessObjectDataAllowMissingDataSomeDataNoExists() {
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", "PRTN_CLMN001", PARTITION_KEY_GROUP, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, false, CUSTOM_DDL_NAME, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES, CUSTOM_DDL_NAME);
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValues().add("I_DO_NOT_EXIST");
        Assert.assertTrue((boolean)request.isAllowMissingData());
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(), resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlMissingBusinessObjectDataAllowMissingDataAllDataNoExists() {
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", "PRTN_CLMN001", PARTITION_KEY_GROUP, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, false, CUSTOM_DDL_NAME, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(Arrays.asList("I_DO_NOT_EXIST"), CUSTOM_DDL_NAME);
        Assert.assertTrue((boolean)request.isAllowMissingData());
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", 1, null, null, false, true, true);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlMissingBusinessObjectDataAllowMissingDataIncludeDropPartitionsDataNoExists() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting(PARTITION_VALUE);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(Arrays.asList(PARTITION_VALUE_2));
        request.setIncludeDropPartitions(Boolean.valueOf(true));
        request.setAllowMissingData(Boolean.valueOf(true));
        BusinessObjectDataDdl result = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        Assert.assertEquals((Object)new BusinessObjectDataDdl(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(PARTITION_VALUE_2), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_VALUE_2, null)), (Object)result);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlNoCustomDdlNoPartitioningMissingBusinessObjectDataAllowMissingData() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", "partition", null, 1, Arrays.asList(PARTITION_VALUE), NO_SUBPARTITION_VALUES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), null, false, null, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionKey("partition");
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionValues(Arrays.asList("none"));
        Assert.assertTrue((boolean)request.isAllowMissingData());
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(0, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", 1, null, null, false, true, true);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlNoCustomDdlForwardSlashInPartitionColumnName() {
        String invalidPartitionColumnName = "INVALID_/_PRTN_CLMN";
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        ((SchemaColumn)partitionColumns.get(0)).setName(invalidPartitionColumnName);
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", PARTITION_KEY, null, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, false, null, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionKey(invalidPartitionColumnName);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition column name contains a '/' character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Partition column name \"%s\" can not contain a '/' character. Business object format: {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d}", invalidPartitionColumnName, request.getNamespace(), request.getBusinessObjectDefinitionName(), request.getBusinessObjectFormatUsage(), request.getBusinessObjectFormatFileType(), request.getBusinessObjectFormatVersion()), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlNoCustomDdlNotSupportedSchemaColumnDataType() {
        List schemaColumns = this.schemaColumnDaoTestHelper.getTestSchemaColumns();
        SchemaColumn schemaColumn = new SchemaColumn();
        schemaColumns.add(schemaColumn);
        schemaColumn.setName("COLUMN");
        schemaColumn.setType("UNKNOWN");
        String partitionKey = ((SchemaColumn)schemaColumns.get(0)).getName();
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", partitionKey, null, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, "|", "\\", "\\N", schemaColumns, this.schemaColumnDaoTestHelper.getTestPartitionColumns(), false, null, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format has a column with an unsupported data type.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Column \"%s\" has an unsupported data type \"%s\" in the schema for business object format {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d}.", schemaColumn.getName(), schemaColumn.getType(), request.getNamespace(), request.getBusinessObjectDefinitionName(), request.getBusinessObjectFormatUsage(), request.getBusinessObjectFormatFileType(), request.getBusinessObjectFormatVersion()), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlNoCustomDdlAllKnownFileTypes() {
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end")));
        HashMap<String, String> businessObjectFormatFileTypeMap = new HashMap<String, String>();
        businessObjectFormatFileTypeMap.put("BZ", "TEXTFILE");
        businessObjectFormatFileTypeMap.put("GZ", "TEXTFILE");
        businessObjectFormatFileTypeMap.put("ORC", "ORC");
        businessObjectFormatFileTypeMap.put("PARQUET", "PARQUET");
        businessObjectFormatFileTypeMap.put("TXT", "TEXTFILE");
        for (String businessObjectFormatFileType : businessObjectFormatFileTypeMap.keySet()) {
            List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns().subList(0, 1);
            String partitionKey = ((SchemaColumn)partitionColumns.get(0)).getName();
            BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, businessObjectFormatFileType, FORMAT_VERSION, FORMAT_DESCRIPTION, LATEST_VERSION_FLAG_SET, partitionKey, NO_PARTITION_KEY_GROUP, NO_ATTRIBUTES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns);
            for (String partitionValue : STORAGE_1_AVAILABLE_PARTITION_VALUES) {
                BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, businessObjectFormatFileType, FORMAT_VERSION, partitionValue, NO_SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
                String s3KeyPrefix = this.s3KeyPrefixHelper.buildS3KeyPrefix("$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end", businessObjectFormatEntity, this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity), STORAGE_NAME);
                StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntity, businessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
                for (int i = 0; i < 2; ++i) {
                    this.storageFileDaoTestHelper.createStorageFileEntity(storageUnitEntity, String.format("%s/data%d.dat", s3KeyPrefix, i), Long.valueOf(1024L), Long.valueOf(1000L));
                }
                this.herdDao.saveAndRefresh((Object)storageUnitEntity);
                this.herdDao.saveAndRefresh((Object)businessObjectDataEntity);
            }
            BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
            request.setBusinessObjectFormatFileType(businessObjectFormatFileType);
            BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            String expectedHiveFileFormat = (String)businessObjectFormatFileTypeMap.get(businessObjectFormatFileType);
            String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(partitionColumns.size(), "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", expectedHiveFileFormat, businessObjectFormatFileType, 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, SUBPARTITION_VALUES, false, true, true);
            this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlNoCustomDdlNotSupportedFileType() {
        String businessObjectFileType = "UNKNOWN";
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting(businessObjectFileType, PARTITION_KEY, null, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns(), false, null, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        request.setBusinessObjectFormatFileType(businessObjectFileType);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when business object format has an unsupported file type.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Unsupported format file type for business object format {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d}.", request.getNamespace(), request.getBusinessObjectDefinitionName(), request.getBusinessObjectFormatUsage(), request.getBusinessObjectFormatFileType(), request.getBusinessObjectFormatVersion()), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlNoDropTable() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", "PRTN_CLMN001", PARTITION_KEY_GROUP, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns(), false, CUSTOM_DDL_NAME, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES);
        request.setIncludeDropTableStatement(Boolean.valueOf(false));
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, SUBPARTITION_VALUES, false, false, true);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlFilterOnSubPartitionValues() {
        List columns = this.schemaColumnDaoTestHelper.getTestSchemaColumns();
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        for (int i = 0; i < Math.min(5, PARTITION_COLUMNS.length); ++i) {
            this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", "PRTN_CLMN001", PARTITION_KEY_GROUP, i + 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, SUBPARTITION_VALUES, "|", "\\", "\\N", columns, partitionColumns, false, null, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
            BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(STORAGE_1_AVAILABLE_PARTITION_VALUES);
            ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).setPartitionKey(((SchemaColumn)partitionColumns.get(i)).getName());
            request.setIncludeDropPartitions(INCLUDE_DROP_PARTITIONS);
            request.setAllowMissingData(NO_ALLOW_MISSING_DATA);
            BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
            String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", i + 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, SUBPARTITION_VALUES, false, true, true, INCLUDE_DROP_PARTITIONS);
            this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlUsingStorageDirectoriesNoAutoDiscovery() {
        List<SchemaColumn> partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns().subList(0, 1 + SUBPARTITION_VALUES.size());
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", "PRTN_CLMN001", PARTITION_KEY_GROUP, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns, false, CUSTOM_DDL_NAME, false, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES, CUSTOM_DDL_NAME);
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(partitionColumns.size(), "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", 1, STORAGE_1_AVAILABLE_PARTITION_VALUES, SUBPARTITION_VALUES, false, true, true);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, expectedDdl, resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlStorageDirectoryMismatchesS3KeyPrefix() {
        String invalidS3KeyPrefix = "INVALID_S3_KEY_PREFIX";
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting(PARTITION_VALUE, invalidS3KeyPrefix);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, NO_INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS, NO_SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage directory path does not match the expected S3 key prefix.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Storage directory path \"%s\" registered with business object data {%s} in \"%s\" storage does not match the expected S3 key prefix \"%s\".", invalidS3KeyPrefix, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION), STORAGE_NAME, BusinessObjectDataServiceGenerateBusinessObjectDataDdlTest.getExpectedS3KeyPrefix(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, "PRTN_CLMN001", PARTITION_VALUE, null, null, DATA_VERSION)), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlStorageDirectoryIsNull() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting(PARTITION_VALUE, null);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, NO_INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS, NO_SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
            Assert.fail((String)"Should throw an IllegalArgumentException when storage directory path is null.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Storage directory path \"%s\" registered with business object data {%s} in \"%s\" storage does not match the expected S3 key prefix \"%s\".", null, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION), STORAGE_NAME, BusinessObjectDataServiceGenerateBusinessObjectDataDdlTest.getExpectedS3KeyPrefix(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, "PRTN_CLMN001", PARTITION_VALUE, null, null, DATA_VERSION)), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlLatestFormatVersionDataNotAvailableInStorage() {
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns().subList(0, 1 + SUBPARTITION_VALUES.size());
        BusinessObjectFormatEntity businessObjectFormatV0Entity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, NO_LATEST_VERSION_FLAG_SET, "PRTN_CLMN001", PARTITION_KEY_GROUP, NO_ATTRIBUTES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns);
        BusinessObjectFormatEntity businessObjectFormatV1Entity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", SECOND_FORMAT_VERSION, FORMAT_DESCRIPTION, LATEST_VERSION_FLAG_SET, "PRTN_CLMN001", PARTITION_KEY_GROUP, NO_ATTRIBUTES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), partitionColumns);
        StorageEntity storage1Entity = this.storageDao.getStorageByName("S3_MANAGED");
        StorageEntity storage2Entity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_2);
        BusinessObjectDataEntity businessObjectDataV0V0Entity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", INITIAL_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        String s3KeyPrefix = this.s3KeyPrefixHelper.buildS3KeyPrefix("$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end", businessObjectFormatV0Entity, this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataV0V0Entity), storage1Entity.getName());
        for (StorageEntity storageEntity : Arrays.asList(storage1Entity, storage2Entity)) {
            StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntity, businessObjectDataV0V0Entity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
            storageUnitEntity.setDirectoryPath(s3KeyPrefix);
            this.herdDao.saveAndRefresh((Object)storageUnitEntity);
        }
        this.herdDao.saveAndRefresh((Object)businessObjectDataV0V0Entity);
        BusinessObjectDataEntity businessObjectDataV1V0Entity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", SECOND_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, INITIAL_DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        s3KeyPrefix = this.s3KeyPrefixHelper.buildS3KeyPrefix("$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end", businessObjectFormatV1Entity, this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataV1V0Entity), storage2Entity.getName());
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(storage2Entity, businessObjectDataV1V0Entity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        storageUnitEntity.setDirectoryPath(s3KeyPrefix);
        this.herdDao.saveAndRefresh((Object)storageUnitEntity);
        this.herdDao.saveAndRefresh((Object)businessObjectDataV1V0Entity);
        BusinessObjectDataDdlRequest request = new BusinessObjectDataDdlRequest();
        request.setNamespace(NAMESPACE);
        request.setBusinessObjectDefinitionName(BDEF_NAME);
        request.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE);
        request.setBusinessObjectFormatFileType("TXT");
        request.setBusinessObjectFormatVersion(null);
        PartitionValueFilter partitionValueFilter = new PartitionValueFilter();
        request.setPartitionValueFilter(partitionValueFilter);
        partitionValueFilter.setPartitionKey("PRTN_CLMN001");
        partitionValueFilter.setPartitionValues(Arrays.asList(PARTITION_VALUE));
        request.setBusinessObjectDataVersion(INITIAL_DATA_VERSION);
        request.setStorageName("S3_MANAGED");
        request.setOutputFormat(BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL);
        request.setTableName(TABLE_NAME);
        request.setCustomDdlName(null);
        request.setIncludeDropTableStatement(Boolean.valueOf(true));
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        Assert.assertNotNull((Object)resultDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlLargePartitionValueListPrimaryPartitionOnly() {
        int PRIMARY_PARTITION_VALUES_SIZE = 10000;
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting();
        ArrayList<String> partitionValues = new ArrayList<String>();
        for (int i = 0; i < 10000; ++i) {
            partitionValues.add(String.format("%s-%s", PARTITION_VALUE, i));
        }
        partitionValues.addAll(UNSORTED_PARTITION_VALUES);
        BusinessObjectDataDdlRequest request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(partitionValues, CUSTOM_DDL_NAME);
        BusinessObjectDataDdl resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(), resultDdl);
        request = this.businessObjectDataServiceTestHelper.getTestBusinessObjectDataDdlRequest(UNSORTED_PARTITION_VALUES, CUSTOM_DDL_NAME);
        ((PartitionValueFilter)request.getPartitionValueFilters().get(0)).getPartitionValues().add(UNSORTED_PARTITION_VALUES.get(0));
        resultDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(request);
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataDdl(request, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(), resultDdl);
    }

    @Test
    @Ignore
    public void testGenerateBusinessObjectDataDdlLargePartitionValueListWithAutoDiscovery() {
        int PRIMARY_PARTITION_VALUE_LIST_SIZE = 10000;
        boolean SECOND_LEVEL_PARTITION_VALUES_PER_BUSINESS_OBJECT_DATA = true;
        boolean STORAGE_FILES_PER_PARTITION = true;
        ArrayList<SchemaColumn> schemaColumns = new ArrayList<SchemaColumn>();
        schemaColumns.add(new SchemaColumn(PARTITION_KEY, "DATE", NO_COLUMN_SIZE, COLUMN_REQUIRED, NO_COLUMN_DEFAULT_VALUE, NO_COLUMN_DESCRIPTION));
        schemaColumns.add(new SchemaColumn(COLUMN_NAME, "NUMBER", COLUMN_SIZE, NO_COLUMN_REQUIRED, NO_COLUMN_DEFAULT_VALUE, COLUMN_DESCRIPTION));
        schemaColumns.add(new SchemaColumn(COLUMN_NAME_2, "STRING", NO_COLUMN_SIZE, NO_COLUMN_REQUIRED, NO_COLUMN_DEFAULT_VALUE, NO_COLUMN_DESCRIPTION));
        List partitionColumns = schemaColumns.subList(0, 2);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, FORMAT_DESCRIPTION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, NO_PARTITION_KEY_GROUP, NO_ATTRIBUTES, "|", "\\", "\\N", schemaColumns, partitionColumns);
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3", this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME);
        ArrayList<String> partitionValues = new ArrayList<String>();
        for (int i = 0; i < 10000; ++i) {
            String partitionValue = String.format("%s-%03d", PARTITION_VALUE, i);
            partitionValues.add(partitionValue);
            BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectFormatEntity, partitionValue, NO_SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), "VALID");
            String s3KeyPrefix = BusinessObjectDataServiceGenerateBusinessObjectDataDdlTest.getExpectedS3KeyPrefix(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, PARTITION_KEY, partitionValue, null, null, DATA_VERSION);
            StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntity, businessObjectDataEntity, "ENABLED", s3KeyPrefix);
            for (int j = 0; j < 1; ++j) {
                String storageFileDirectoryPath = String.format("%s/%s=%s-%03d", s3KeyPrefix, COLUMN_NAME, PARTITION_VALUE_2, j);
                for (int k = 0; k < 1; ++k) {
                    String storageFilePath = String.format("%s/%03d.data", storageFileDirectoryPath, k);
                    this.storageFileDaoTestHelper.createStorageFileEntity(storageUnitEntity, storageFilePath, Long.valueOf(1024L), Long.valueOf(1000L));
                }
            }
            this.herdDao.saveAndRefresh((Object)storageUnitEntity);
        }
        BusinessObjectDataDdl businessObjectDataDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, partitionValues, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, NO_INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS, NO_SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
        Assert.assertNotNull((Object)businessObjectDataDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlLatestBeforePartitionValueNoExists() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting(PARTITION_VALUE_2);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, new LatestBeforePartitionValue(PARTITION_VALUE), NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, NO_INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS, NO_SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
            Assert.fail((String)"Suppose to throw an ObjectNotFoundException when failed to find the latest before partition value.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Failed to find partition value which is the latest before partition value = \"%s\" for partition key = \"%s\" due to no available business object data in \"%s\" storage that satisfies the search criteria. Business object data {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, businessObjectDataVersion: %d}", PARTITION_VALUE, "PRTN_CLMN001", STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, DATA_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlLatestAfterPartitionValueNoExists() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting(PARTITION_VALUE);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", NO_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, new LatestAfterPartitionValue(PARTITION_VALUE_2))), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, NO_INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS, NO_SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
            Assert.fail((String)"Suppose to throw an ObjectNotFoundException when failed to find the latest after partition value.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Failed to find partition value which is the latest after partition value = \"%s\" for partition key = \"%s\" due to no available business object data in \"%s\" storage that satisfies the search criteria. Business object data {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, businessObjectDataVersion: %d}", PARTITION_VALUE_2, "PRTN_CLMN001", STORAGE_NAME, NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, DATA_VERSION), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlMultipleStorages() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", "PRTN_CLMN001", PARTITION_KEY_GROUP, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns(), false, CUSTOM_DDL_NAME, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        BusinessObjectDataDdl resultBusinessObjectDataDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", UNSORTED_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, STORAGE_NAMES, NO_STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, NO_INCLUDE_DROP_PARTITIONS, ALLOW_MISSING_DATA, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS, NO_SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
        String expectedDdl = this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdl(PARTITION_COLUMNS.length, "COLUMN001", "TINYINT", "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ESCAPED BY '\\\\' NULL DEFINED AS '\\N'", "TEXTFILE", "TXT", 1, MULTI_STORAGE_AVAILABLE_PARTITION_VALUES_UNION, SUBPARTITION_VALUES, false, true, true);
        Assert.assertEquals((Object)new BusinessObjectDataDdl(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", UNSORTED_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, STORAGE_NAMES, NO_STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, expectedDdl), (Object)resultBusinessObjectDataDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlNoStorageNamesAndSameBusinessObjectDataInMultipleStorages() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTesting("TXT", "PRTN_CLMN001", PARTITION_KEY_GROUP, 1, UNSORTED_PARTITION_VALUES, SUBPARTITION_VALUES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns(), false, CUSTOM_DDL_NAME, true, ALLOW_DUPLICATE_BUSINESS_OBJECT_DATA);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", UNSORTED_PARTITION_VALUES, NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, DATA_VERSION, NO_STORAGE_NAMES, NO_STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, NO_INCLUDE_DROP_PARTITIONS, ALLOW_MISSING_DATA, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS, NO_SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
            Assert.fail((String)"Suppose to throw an IllegalArgumentException when business object data registered in more than one storage.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Found business object data registered in more than one storage. Please specify storage(s) in the request to resolve this. Business object data {%s}", this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, (String)MULTI_STORAGE_AVAILABLE_PARTITION_VALUES_INTERSECTION.get(0), SUBPARTITION_VALUES, DATA_VERSION)), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlLatestFormatHasLessPartitionColumnsThenBusinessObjectData() {
        ArrayList<SchemaColumn> schemaColumns = new ArrayList<SchemaColumn>();
        schemaColumns.add(new SchemaColumn(PARTITION_KEY, "DATE", NO_COLUMN_SIZE, COLUMN_REQUIRED, NO_COLUMN_DEFAULT_VALUE, NO_COLUMN_DESCRIPTION));
        schemaColumns.add(new SchemaColumn(COLUMN_NAME, "NUMBER", COLUMN_SIZE, NO_COLUMN_REQUIRED, COLUMN_DEFAULT_VALUE, COLUMN_DESCRIPTION));
        List partitionColumns1 = schemaColumns.subList(0, 2);
        List partitionColumns2 = schemaColumns.subList(0, 1);
        BusinessObjectFormatEntity businessObjectFormatEntity1 = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, NO_LATEST_VERSION_FLAG_SET, PARTITION_KEY, NO_PARTITION_KEY_GROUP, NO_ATTRIBUTES, "|", "\\", "\\N", schemaColumns, partitionColumns1);
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", SECOND_FORMAT_VERSION, FORMAT_DESCRIPTION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, NO_PARTITION_KEY_GROUP, NO_ATTRIBUTES, "|", "\\", "\\N", schemaColumns, partitionColumns2);
        List subPartitionColumns = partitionColumns1.subList(1, 2);
        List<String> subPartitionValues = Arrays.asList((String)SUBPARTITION_VALUES.get(0));
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectFormatEntity1, PARTITION_VALUE, subPartitionValues, DATA_VERSION, Boolean.valueOf(true), "VALID");
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end")));
        String s3KeyPrefix = BusinessObjectDataServiceGenerateBusinessObjectDataDdlTest.getExpectedS3KeyPrefix(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, subPartitionColumns.toArray(new SchemaColumn[subPartitionColumns.size()]), subPartitionValues.toArray(new String[subPartitionValues.size()]), DATA_VERSION);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntity, businessObjectDataEntity, "ENABLED", s3KeyPrefix);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", null, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, null, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS, NO_SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
            Assert.fail((String)"Suppose to throw an IllegalArgumentException when business object data has more or equal sub-partition values then the latest business object format version.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Number of subpartition values specified for the business object data is greater than or equal to the number of partition columns defined in the schema of the business object format selected for DDL generation. Business object data: {%s},  business object format: {%s}", this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", INITIAL_FORMAT_VERSION, PARTITION_VALUE, subPartitionValues, DATA_VERSION), this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatKeyAsString(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", SECOND_FORMAT_VERSION)), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlIncludeAllRegisteredSubPartitionsSecondSubPartitionValid() {
        List<List<String>> testPartitions = Arrays.asList(Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_1), Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_2));
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTestingTwoPartitionLevels(testPartitions);
        BusinessObjectDataDdl resultBusinessObjectDataDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, INCLUDE_ALL_REGISTERED_SUBPARTITIONS, NO_SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataDdl(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdlTwoPartitionLevels(testPartitions)), (Object)resultBusinessObjectDataDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlIncludeAllRegisteredSubPartitionsSecondSubPartitionDeleted() {
        List<StorageUnitEntity> storageUnitEntities = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTestingTwoPartitionLevels(Arrays.asList(Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_1), Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_2)));
        storageUnitEntities.get(1).getBusinessObjectData().setStatus(this.businessObjectDataStatusDao.getBusinessObjectDataStatusByCode("DELETED"));
        BusinessObjectDataDdl resultBusinessObjectDataDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, INCLUDE_ALL_REGISTERED_SUBPARTITIONS, NO_SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataDdl(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdlTwoPartitionLevels(Arrays.asList(Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_1)))), (Object)resultBusinessObjectDataDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlIncludeAllRegisteredSubPartitionsSecondSubPartitionInvalid() {
        List<StorageUnitEntity> storageUnitEntities = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTestingTwoPartitionLevels(Arrays.asList(Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_1), Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_2)));
        storageUnitEntities.get(1).getBusinessObjectData().setStatus(this.businessObjectDataStatusDao.getBusinessObjectDataStatusByCode("INVALID"));
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, INCLUDE_ALL_REGISTERED_SUBPARTITIONS, NO_SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
            Assert.fail((String)"Suppose to throw an ObjectNotFoundException when second sub-partition has an INVALID status.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object data {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, partitionValue: \"%s\", subpartitionValues: \"%s\", businessObjectDataVersion: %d} is not available in \"%s\" storage(s).", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, PARTITION_VALUE, SUB_PARTITION_VALUE_2, DATA_VERSION, STORAGE_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlIncludeAllRegisteredSubPartitionsSecondSubPartitionValidNonAvailableStorageUnit() {
        List<StorageUnitEntity> storageUnitEntities = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTestingTwoPartitionLevels(Arrays.asList(Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_1), Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_2)));
        storageUnitEntities.get(1).setStatus(this.storageUnitStatusDao.getStorageUnitStatusByCode("DISABLED"));
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, INCLUDE_ALL_REGISTERED_SUBPARTITIONS, NO_SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
            Assert.fail((String)"Suppose to throw an ObjectNotFoundException when second sub-partition has a non-available storage unit status.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object data {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, partitionValue: \"%s\", subpartitionValues: \"%s\", businessObjectDataVersion: %d} is not available in \"%s\" storage(s).", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, PARTITION_VALUE, SUB_PARTITION_VALUE_2, DATA_VERSION, STORAGE_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlIncludeAllRegisteredSubPartitionsSecondSubPartitionValidNonAvailableStorageUnitBdataArchived() {
        List<StorageUnitEntity> storageUnitEntities = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTestingTwoPartitionLevels(Arrays.asList(Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_1), Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_2)));
        storageUnitEntities.get(1).setStatus(this.storageUnitStatusDao.getStorageUnitStatusByCode("ARCHIVED"));
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, INCLUDE_ALL_REGISTERED_SUBPARTITIONS, NO_SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
            Assert.fail((String)"Suppose to throw an ObjectNotFoundException when second sub-partition has a non-available storage unit status.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object data {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, partitionValue: \"%s\", subpartitionValues: \"%s\", businessObjectDataVersion: %d} is not available in \"%s\" storage(s).", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, PARTITION_VALUE, SUB_PARTITION_VALUE_2, DATA_VERSION, STORAGE_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlIncludeAllRegisteredSubPartitionsSecondSubPartitionInvalidBdataArchived() {
        List<StorageUnitEntity> storageUnitEntities = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTestingTwoPartitionLevels(Arrays.asList(Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_1), Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_2)));
        storageUnitEntities.get(1).getBusinessObjectData().setStatus(this.businessObjectDataStatusDao.getBusinessObjectDataStatusByCode("INVALID"));
        storageUnitEntities.get(1).setStatus(this.storageUnitStatusDao.getStorageUnitStatusByCode("ARCHIVED"));
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, INCLUDE_ALL_REGISTERED_SUBPARTITIONS, NO_SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
            Assert.fail((String)"Suppose to throw an ObjectNotFoundException when second sub-partition has a non-available storage unit status.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object data {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, partitionValue: \"%s\", subpartitionValues: \"%s\", businessObjectDataVersion: %d} is not available in \"%s\" storage(s).", NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, PARTITION_VALUE, SUB_PARTITION_VALUE_2, DATA_VERSION, STORAGE_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlIncludeAllRegisteredSubPartitionsSecondSubPartitionDeletedBdataArchived() {
        List<StorageUnitEntity> storageUnitEntities = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTestingTwoPartitionLevels(Arrays.asList(Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_1), Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_2)));
        storageUnitEntities.get(1).getBusinessObjectData().setStatus(this.businessObjectDataStatusDao.getBusinessObjectDataStatusByCode("DELETED"));
        storageUnitEntities.get(1).setStatus(this.storageUnitStatusDao.getStorageUnitStatusByCode("ARCHIVED"));
        BusinessObjectDataDdl resultBusinessObjectDataDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, INCLUDE_ALL_REGISTERED_SUBPARTITIONS, NO_SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataDdl(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdlTwoPartitionLevels(Arrays.asList(Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_1)))), (Object)resultBusinessObjectDataDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlDoNotIncludeAllRegisteredSubPartitionsSecondSubPartitionInvalid() {
        List<StorageUnitEntity> storageUnitEntities = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTestingTwoPartitionLevels(Arrays.asList(Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_1), Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_2)));
        storageUnitEntities.get(1).getBusinessObjectData().setStatus(this.businessObjectDataStatusDao.getBusinessObjectDataStatusByCode("INVALID"));
        BusinessObjectDataDdl resultBusinessObjectDataDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS, NO_SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataDdl(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdlTwoPartitionLevels(Arrays.asList(Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_1)))), (Object)resultBusinessObjectDataDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlSuppressScanForUnregisteredSubPartitions() {
        this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTestingTwoPartitionLevels(Arrays.asList(Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_1), Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_2)));
        BusinessObjectDataDdl resultBusinessObjectDataDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS, SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataDdl(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdlTwoPartitionLevels(Arrays.asList(Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_1), Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_2)))), (Object)resultBusinessObjectDataDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlSuppressScanForUnregisteredSubPartitionsNoDirectoryPath() {
        List<StorageUnitEntity> storageUnitEntities = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTestingTwoPartitionLevels(Arrays.asList(Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_1), Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_2)));
        for (StorageUnitEntity storageUnitEntity : storageUnitEntities) {
            storageUnitEntity.setDirectoryPath(NO_STORAGE_DIRECTORY_PATH);
        }
        BusinessObjectDataDdl resultBusinessObjectDataDdl = this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS, SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
        Assert.assertEquals((Object)new BusinessObjectDataDdl(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataDdlTwoPartitionLevels(Arrays.asList(Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_1), Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_2)))), (Object)resultBusinessObjectDataDdl);
    }

    @Test
    public void testGenerateBusinessObjectDataDdlSuppressScanForUnregisteredSubPartitionsDirectoryPathMismatchS3KeyPrefix() {
        List<StorageUnitEntity> storageUnitEntities = this.businessObjectDataServiceTestHelper.createDatabaseEntitiesForBusinessObjectDataDdlTestingTwoPartitionLevels(Arrays.asList(Arrays.asList(PARTITION_VALUE, SUB_PARTITION_VALUE_1)));
        String originalS3KeyPrefix = storageUnitEntities.get(0).getDirectoryPath();
        storageUnitEntities.get(0).setDirectoryPath("      \t\t ");
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, Arrays.asList(new PartitionValueFilter("PRTN_CLMN001", Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, NO_DATA_VERSION, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS, SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Storage directory path \"%s\" registered with business object data {%s} in \"%s\" storage does not match the expected S3 key prefix \"%s\".", "      \t\t ", this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", FORMAT_VERSION, PARTITION_VALUE, Arrays.asList(SUB_PARTITION_VALUE_1), DATA_VERSION)), STORAGE_NAME, originalS3KeyPrefix), (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateBusinessObjectDataDdlSuppressScanForUnregisteredSubPartitionsLatestFormatHasLessPartitionColumnsThenBusinessObjectData() {
        ArrayList<SchemaColumn> schemaColumns = new ArrayList<SchemaColumn>();
        schemaColumns.add(new SchemaColumn(PARTITION_KEY, "DATE", NO_COLUMN_SIZE, COLUMN_REQUIRED, NO_COLUMN_DEFAULT_VALUE, NO_COLUMN_DESCRIPTION));
        schemaColumns.add(new SchemaColumn(COLUMN_NAME, "NUMBER", COLUMN_SIZE, NO_COLUMN_REQUIRED, COLUMN_DEFAULT_VALUE, COLUMN_DESCRIPTION));
        List partitionColumns1 = schemaColumns.subList(0, 2);
        List partitionColumns2 = schemaColumns.subList(0, 1);
        BusinessObjectFormatEntity businessObjectFormatEntity1 = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, NO_LATEST_VERSION_FLAG_SET, PARTITION_KEY, NO_PARTITION_KEY_GROUP, NO_ATTRIBUTES, "|", "\\", "\\N", schemaColumns, partitionColumns1);
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", SECOND_FORMAT_VERSION, FORMAT_DESCRIPTION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, NO_PARTITION_KEY_GROUP, NO_ATTRIBUTES, "|", "\\", "\\N", schemaColumns, partitionColumns2);
        List subPartitionColumns = partitionColumns1.subList(1, 2);
        List<String> subPartitionValues = Arrays.asList((String)SUBPARTITION_VALUES.get(0));
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectFormatEntity1, PARTITION_VALUE, subPartitionValues, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID");
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end")));
        String s3KeyPrefix = BusinessObjectDataServiceGenerateBusinessObjectDataDdlTest.getExpectedS3KeyPrefix(NAMESPACE, DATA_PROVIDER_NAME, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", INITIAL_FORMAT_VERSION, PARTITION_KEY, PARTITION_VALUE, subPartitionColumns.toArray(new SchemaColumn[subPartitionColumns.size()]), subPartitionValues.toArray(new String[subPartitionValues.size()]), DATA_VERSION);
        this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntity, businessObjectDataEntity, "ENABLED", s3KeyPrefix);
        try {
            this.businessObjectDataService.generateBusinessObjectDataDdl(new BusinessObjectDataDdlRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", null, Arrays.asList(new PartitionValueFilter(PARTITION_KEY, Arrays.asList(PARTITION_VALUE), NO_PARTITION_VALUE_RANGE, NO_LATEST_BEFORE_PARTITION_VALUE, NO_LATEST_AFTER_PARTITION_VALUE)), NO_STANDALONE_PARTITION_VALUE_FILTER, null, NO_STORAGE_NAMES, STORAGE_NAME, BusinessObjectDataDdlOutputFormatEnum.HIVE_13_DDL, TABLE_NAME, NO_CUSTOM_DDL_NAME, INCLUDE_DROP_TABLE_STATEMENT, INCLUDE_IF_NOT_EXISTS_OPTION, INCLUDE_DROP_PARTITIONS, NO_ALLOW_MISSING_DATA, NO_INCLUDE_ALL_REGISTERED_SUBPARTITIONS, SUPPRESS_SCAN_FOR_UNREGISTERED_SUBPARTITIONS));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Number of primary and sub-partition values (2) specified for the business object data is not equal to the number of partition columns (1) defined in the schema of the business object format selected for DDL generation. Business object data: {%s},  business object format: {%s}", this.businessObjectDataServiceTestHelper.getExpectedBusinessObjectDataKeyAsString(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", INITIAL_FORMAT_VERSION, PARTITION_VALUE, subPartitionValues, DATA_VERSION), this.businessObjectFormatServiceTestHelper.getExpectedBusinessObjectFormatKeyAsString(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "TXT", SECOND_FORMAT_VERSION)), (Object)e.getMessage());
        }
    }
}

