/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.Arrays;
import java.util.List;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.dao.BusinessObjectDataDao;
import org.finra.herd.dao.StorageUnitDao;
import org.finra.herd.dao.helper.JsonHelper;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectDataKeys;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKey;
import org.finra.herd.model.api.xml.BusinessObjectFormatKey;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.jpa.BusinessObjectDefinitionEntity;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.BusinessObjectDataInitiateRestoreHelperService;
import org.finra.herd.service.NotificationEventService;
import org.finra.herd.service.S3Service;
import org.finra.herd.service.helper.BusinessObjectDataDaoHelper;
import org.finra.herd.service.helper.BusinessObjectDataHelper;
import org.finra.herd.service.helper.BusinessObjectDataInvalidateUnregisteredHelper;
import org.finra.herd.service.helper.BusinessObjectDataRetryStoragePolicyTransitionHelper;
import org.finra.herd.service.helper.BusinessObjectDataSearchHelper;
import org.finra.herd.service.helper.BusinessObjectDataStatusDaoHelper;
import org.finra.herd.service.helper.BusinessObjectDefinitionDaoHelper;
import org.finra.herd.service.helper.BusinessObjectDefinitionHelper;
import org.finra.herd.service.helper.BusinessObjectFormatDaoHelper;
import org.finra.herd.service.helper.BusinessObjectFormatHelper;
import org.finra.herd.service.helper.CustomDdlDaoHelper;
import org.finra.herd.service.helper.DdlGeneratorFactory;
import org.finra.herd.service.helper.S3KeyPrefixHelper;
import org.finra.herd.service.helper.StorageDaoHelper;
import org.finra.herd.service.helper.StorageHelper;
import org.finra.herd.service.helper.StorageUnitHelper;
import org.finra.herd.service.impl.BusinessObjectDataServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class BusinessObjectDataServiceGetAllBusinessObjectDataTest
extends AbstractServiceTest {
    @Mock
    private BusinessObjectDataDao businessObjectDataDao;
    @Mock
    private BusinessObjectDataDaoHelper businessObjectDataDaoHelper;
    @Mock
    private BusinessObjectDataHelper businessObjectDataHelper;
    @Mock
    private BusinessObjectDataInitiateRestoreHelperService businessObjectDataInitiateRestoreHelperService;
    @Mock
    private BusinessObjectDataInvalidateUnregisteredHelper businessObjectDataInvalidateUnregisteredHelper;
    @Mock
    private BusinessObjectDataRetryStoragePolicyTransitionHelper businessObjectDataRetryStoragePolicyTransitionHelper;
    @Mock
    private BusinessObjectDataSearchHelper businessObjectDataSearchHelper;
    @InjectMocks
    private BusinessObjectDataServiceImpl businessObjectDataService;
    @Mock
    private BusinessObjectDataStatusDaoHelper businessObjectDataStatusDaoHelper;
    @Mock
    private BusinessObjectDefinitionDaoHelper businessObjectDefinitionDaoHelper;
    @Mock
    private BusinessObjectDefinitionHelper businessObjectDefinitionHelper;
    @Mock
    private BusinessObjectFormatDaoHelper businessObjectFormatDaoHelper;
    @Mock
    private BusinessObjectFormatHelper businessObjectFormatHelper;
    @Mock
    private ConfigurationHelper configurationHelper;
    @Mock
    private CustomDdlDaoHelper customDdlDaoHelper;
    @Mock
    private DdlGeneratorFactory ddlGeneratorFactory;
    @Mock
    private JsonHelper jsonHelper;
    @Mock
    private NotificationEventService notificationEventService;
    @Mock
    private S3KeyPrefixHelper s3KeyPrefixHelper;
    @Mock
    private S3Service s3Service;
    @Mock
    private StorageDaoHelper storageDaoHelper;
    @Mock
    private StorageHelper storageHelper;
    @Mock
    private StorageUnitDao storageUnitDao;
    @Mock
    private StorageUnitHelper storageUnitHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testGetAllBusinessObjectDataByBusinessObjectDefinition() {
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME);
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(businessObjectDefinitionKey, DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        List<BusinessObjectDataKey> businessObjectDataKeys = Arrays.asList(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
        Mockito.when((Object)this.businessObjectDefinitionDaoHelper.getBusinessObjectDefinitionEntity(businessObjectDefinitionKey)).thenReturn((Object)businessObjectDefinitionEntity);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_DATA_SEARCH_MAX_RESULTS, Integer.class)).thenReturn((Object)MAX_RESULTS_1);
        Mockito.when((Object)this.businessObjectDataDao.getBusinessObjectDataByBusinessObjectDefinition(businessObjectDefinitionEntity, MAX_RESULTS_1)).thenReturn(businessObjectDataKeys);
        BusinessObjectDataKeys response = this.businessObjectDataService.getAllBusinessObjectDataByBusinessObjectDefinition(businessObjectDefinitionKey);
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper)).validateBusinessObjectDefinitionKey(businessObjectDefinitionKey);
        ((BusinessObjectDefinitionDaoHelper)Mockito.verify((Object)this.businessObjectDefinitionDaoHelper)).getBusinessObjectDefinitionEntity(businessObjectDefinitionKey);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.BUSINESS_OBJECT_DATA_SEARCH_MAX_RESULTS, Integer.class);
        ((BusinessObjectDataDao)Mockito.verify((Object)this.businessObjectDataDao)).getBusinessObjectDataByBusinessObjectDefinition(businessObjectDefinitionEntity, MAX_RESULTS_1);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new BusinessObjectDataKeys(businessObjectDataKeys), (Object)response);
    }

    @Test
    public void testGetAllBusinessObjectDataByBusinessObjectFormat() {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION);
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(businessObjectFormatKey, FORMAT_DESCRIPTION, NO_LATEST_VERSION_FLAG_SET, PARTITION_KEY);
        List<BusinessObjectDataKey> businessObjectDataKeys = Arrays.asList(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION));
        Mockito.when((Object)this.businessObjectFormatDaoHelper.getBusinessObjectFormatEntity(businessObjectFormatKey)).thenReturn((Object)businessObjectFormatEntity);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_DATA_SEARCH_MAX_RESULTS, Integer.class)).thenReturn((Object)MAX_RESULTS_1);
        Mockito.when((Object)this.businessObjectDataDao.getBusinessObjectDataByBusinessObjectFormat(businessObjectFormatEntity, MAX_RESULTS_1)).thenReturn(businessObjectDataKeys);
        BusinessObjectDataKeys response = this.businessObjectDataService.getAllBusinessObjectDataByBusinessObjectFormat(businessObjectFormatKey);
        ((BusinessObjectFormatHelper)Mockito.verify((Object)this.businessObjectFormatHelper)).validateBusinessObjectFormatKey(businessObjectFormatKey, Boolean.valueOf(true));
        ((BusinessObjectFormatDaoHelper)Mockito.verify((Object)this.businessObjectFormatDaoHelper)).getBusinessObjectFormatEntity(businessObjectFormatKey);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.BUSINESS_OBJECT_DATA_SEARCH_MAX_RESULTS, Integer.class);
        ((BusinessObjectDataDao)Mockito.verify((Object)this.businessObjectDataDao)).getBusinessObjectDataByBusinessObjectFormat(businessObjectFormatEntity, MAX_RESULTS_1);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new BusinessObjectDataKeys(businessObjectDataKeys), (Object)response);
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDataDao, this.businessObjectDataDaoHelper, this.businessObjectDataHelper, this.businessObjectDataInitiateRestoreHelperService, this.businessObjectDataInvalidateUnregisteredHelper, this.businessObjectDataRetryStoragePolicyTransitionHelper, this.businessObjectDataSearchHelper, this.businessObjectDataStatusDaoHelper, this.businessObjectDefinitionDaoHelper, this.businessObjectDefinitionHelper, this.businessObjectFormatDaoHelper, this.businessObjectFormatHelper, this.configurationHelper, this.customDdlDaoHelper, this.ddlGeneratorFactory, this.jsonHelper, this.notificationEventService, this.s3KeyPrefixHelper, this.s3Service, this.storageDaoHelper, this.storageHelper, this.storageUnitDao, this.storageUnitHelper});
    }
}

