/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.commons.collections.CollectionUtils;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.dao.BusinessObjectDefinitionDao;
import org.finra.herd.dao.BusinessObjectDefinitionIndexSearchDao;
import org.finra.herd.dao.IndexFunctionsDao;
import org.finra.herd.dao.helper.JsonHelper;
import org.finra.herd.model.api.xml.BusinessObjectDefinition;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionIndexSearchRequest;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionIndexSearchResponse;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionSearchFilter;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionSearchKey;
import org.finra.herd.model.api.xml.Facet;
import org.finra.herd.model.api.xml.TagKey;
import org.finra.herd.model.dto.BusinessObjectDefinitionIndexSearchResponseDto;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.DataProvider;
import org.finra.herd.model.dto.ElasticsearchResponseDto;
import org.finra.herd.model.dto.Namespace;
import org.finra.herd.model.dto.SearchIndexUpdateDto;
import org.finra.herd.model.dto.TagIndexSearchResponseDto;
import org.finra.herd.model.dto.TagTypeIndexSearchResponseDto;
import org.finra.herd.model.jpa.BusinessObjectDefinitionEntity;
import org.finra.herd.model.jpa.TagEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.functional.QuadConsumer;
import org.finra.herd.service.helper.BusinessObjectDefinitionHelper;
import org.finra.herd.service.helper.ConfigurationDaoHelper;
import org.finra.herd.service.helper.SearchIndexDaoHelper;
import org.finra.herd.service.helper.TagDaoHelper;
import org.finra.herd.service.helper.TagHelper;
import org.finra.herd.service.impl.BusinessObjectDefinitionServiceImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class BusinessObjectDefinitionServiceIndexTest
extends AbstractServiceTest {
    @Mock
    private BusinessObjectDefinitionDao businessObjectDefinitionDao;
    @Mock
    private BusinessObjectDefinitionHelper businessObjectDefinitionHelper;
    @Mock
    private BusinessObjectDefinitionIndexSearchDao businessObjectDefinitionIndexSearchDao;
    @InjectMocks
    private BusinessObjectDefinitionServiceImpl businessObjectDefinitionService;
    @Mock
    private ConfigurationDaoHelper configurationDaoHelper;
    @Mock
    private ConfigurationHelper configurationHelper;
    @Mock
    private IndexFunctionsDao indexFunctionsDao;
    @Mock
    private JsonHelper jsonHelper;
    @Mock
    private TagDaoHelper tagDaoHelper;
    @Mock
    private TagHelper tagHelper;
    @Mock
    private SearchIndexDaoHelper searchIndexDaoHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testIndexValidateBusinessObjectDefinitions() throws Exception {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        ArrayList<String> businessObjectDefinitionEntityIdList = new ArrayList<String>();
        businessObjectDefinitionEntityIdList.add("123456");
        businessObjectDefinitionEntityIdList.add("654321");
        businessObjectDefinitionEntityIdList.add("789012");
        Mockito.when((Object)this.businessObjectDefinitionDao.getAllBusinessObjectDefinitions()).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.businessObjectDefinitionHelper.safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class))).thenReturn((Object)JSON_STRING);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.indexFunctionsDao.getIdsInIndex((String)Matchers.any(), (String)Matchers.any())).thenReturn(businessObjectDefinitionEntityIdList);
        Future future = this.businessObjectDefinitionService.indexValidateAllBusinessObjectDefinitions(SEARCH_INDEX_NAME);
        MatcherAssert.assertThat((String)"Business object definition service index all business object definitions method returned null value.", (Object)future, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((String)"Business object definition service index all business object definitions method return value is not instance of future.", (Object)future, (Matcher)CoreMatchers.instanceOf(Future.class));
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getAllBusinessObjectDefinitions();
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).getIdsInIndex((String)Matchers.any(), (String)Matchers.any());
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper)).executeFunctionForBusinessObjectDefinitionEntities((String)Matchers.eq((Object)SEARCH_INDEX_NAME), (String)Matchers.eq((Object)SEARCH_INDEX_DOCUMENT_TYPE), (List)Matchers.eq(businessObjectDefinitionEntityList), (QuadConsumer)Matchers.any());
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)businessObjectDefinitionEntityIdList.size()))).deleteDocumentById((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSizeCheckValidationBusinessObjectDefinitions() throws Exception {
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.indexFunctionsDao.getNumberOfTypesInIndex((String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)100L);
        Mockito.when((Object)this.businessObjectDefinitionDao.getCountOfAllBusinessObjectDefinitions()).thenReturn((Object)100L);
        boolean isIndexSizeValid = this.businessObjectDefinitionService.indexSizeCheckValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME);
        MatcherAssert.assertThat((String)"Business object definition service index size validation is false when it should have been true.", (Object)isIndexSizeValid, (Matcher)CoreMatchers.is((Object)true));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).getNumberOfTypesInIndex((String)Matchers.any(), (String)Matchers.any());
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getCountOfAllBusinessObjectDefinitions();
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSizeCheckValidationBusinessObjectDefinitionsFalse() throws Exception {
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.indexFunctionsDao.getNumberOfTypesInIndex((String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)100L);
        Mockito.when((Object)this.businessObjectDefinitionDao.getCountOfAllBusinessObjectDefinitions()).thenReturn((Object)200L);
        boolean isIndexSizeValid = this.businessObjectDefinitionService.indexSizeCheckValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME);
        MatcherAssert.assertThat((String)"Business object definition service index size validation is true when it should have been false.", (Object)isIndexSizeValid, (Matcher)CoreMatchers.is((Object)false));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).getNumberOfTypesInIndex((String)Matchers.any(), (String)Matchers.any());
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getCountOfAllBusinessObjectDefinitions();
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSpotCheckPercentageValidationBusinessObjectDefinitions() throws Exception {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_PERCENTAGE, Double.class)).thenReturn((Object)0.05);
        Mockito.when((Object)this.businessObjectDefinitionDao.getPercentageOfAllBusinessObjectDefinitions(0.05)).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.businessObjectDefinitionHelper.safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class))).thenReturn((Object)JSON_STRING);
        Mockito.when((Object)this.indexFunctionsDao.isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)true);
        boolean isSpotCheckPercentageValid = this.businessObjectDefinitionService.indexSpotCheckPercentageValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME);
        MatcherAssert.assertThat((String)"Business object definition service index spot check random validation is false when it should have been true.", (Object)isSpotCheckPercentageValid, (Matcher)CoreMatchers.is((Object)true));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_PERCENTAGE, Double.class);
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getPercentageOfAllBusinessObjectDefinitions(0.05);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)2))).isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSpotCheckPercentageValidationBusinessObjectDefinitionsFalse() throws Exception {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_PERCENTAGE, Double.class)).thenReturn((Object)0.05);
        Mockito.when((Object)this.businessObjectDefinitionDao.getPercentageOfAllBusinessObjectDefinitions(0.05)).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.businessObjectDefinitionHelper.safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class))).thenReturn((Object)JSON_STRING);
        Mockito.when((Object)this.indexFunctionsDao.isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)false);
        boolean isSpotCheckPercentageValid = this.businessObjectDefinitionService.indexSpotCheckPercentageValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME);
        MatcherAssert.assertThat((String)"Business object definition service index spot check random validation is true when it should have been false.", (Object)isSpotCheckPercentageValid, (Matcher)CoreMatchers.is((Object)false));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_PERCENTAGE, Double.class);
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getPercentageOfAllBusinessObjectDefinitions(0.05);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)2))).isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSpotCheckPercentageValidationBusinessObjectDefinitionsObjectMappingException() throws Exception {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_PERCENTAGE, Double.class)).thenReturn((Object)0.05);
        Mockito.when((Object)this.businessObjectDefinitionDao.getPercentageOfAllBusinessObjectDefinitions(0.05)).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.jsonHelper.objectToJson(Matchers.any())).thenThrow(new Throwable[]{new IllegalStateException((Throwable)new JsonParseException("Failed to Parse", new JsonLocation((Object)"SRC", 100L, 1, 2)))});
        Mockito.when((Object)this.indexFunctionsDao.isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)false);
        boolean isSpotCheckPercentageValid = this.businessObjectDefinitionService.indexSpotCheckPercentageValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME);
        MatcherAssert.assertThat((String)"Business object definition service index spot check random validation is true when it should have been false.", (Object)isSpotCheckPercentageValid, (Matcher)CoreMatchers.is((Object)false));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_PERCENTAGE, Double.class);
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getPercentageOfAllBusinessObjectDefinitions(0.05);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)2))).isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSpotCheckMostRecentValidationBusinessObjectDefinitions() throws Exception {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_MOST_RECENT_NUMBER, Integer.class)).thenReturn((Object)100);
        Mockito.when((Object)this.businessObjectDefinitionDao.getMostRecentBusinessObjectDefinitions(100)).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.businessObjectDefinitionHelper.safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class))).thenReturn((Object)JSON_STRING);
        Mockito.when((Object)this.indexFunctionsDao.isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)true);
        boolean isSpotCheckPercentageValid = this.businessObjectDefinitionService.indexSpotCheckMostRecentValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME);
        MatcherAssert.assertThat((String)"Business object definition service index spot check most recent validation is false when it should have been true.", (Object)isSpotCheckPercentageValid, (Matcher)CoreMatchers.is((Object)true));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_MOST_RECENT_NUMBER, Integer.class);
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getMostRecentBusinessObjectDefinitions(100);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)2))).isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSpotCheckMostRecentValidationBusinessObjectDefinitionsFalse() throws Exception {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_MOST_RECENT_NUMBER, Integer.class)).thenReturn((Object)100);
        Mockito.when((Object)this.businessObjectDefinitionDao.getMostRecentBusinessObjectDefinitions(100)).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.businessObjectDefinitionHelper.safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class))).thenReturn((Object)JSON_STRING);
        Mockito.when((Object)this.indexFunctionsDao.isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)false);
        boolean isSpotCheckPercentageValid = this.businessObjectDefinitionService.indexSpotCheckMostRecentValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME);
        MatcherAssert.assertThat((String)"Business object definition service index spot check most recent validation is true when it should have been false.", (Object)isSpotCheckPercentageValid, (Matcher)CoreMatchers.is((Object)false));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_MOST_RECENT_NUMBER, Integer.class);
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getMostRecentBusinessObjectDefinitions(100);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)2))).isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSpotCheckMostRecentValidationBusinessObjectDefinitionsObjectMappingException() throws Exception {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_MOST_RECENT_NUMBER, Integer.class)).thenReturn((Object)100);
        Mockito.when((Object)this.businessObjectDefinitionDao.getMostRecentBusinessObjectDefinitions(100)).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.jsonHelper.objectToJson(Matchers.any())).thenThrow(new Throwable[]{new IllegalStateException((Throwable)new JsonParseException("Failed to Parse", new JsonLocation((Object)"SRC", 100L, 1, 2)))});
        Mockito.when((Object)this.indexFunctionsDao.isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)false);
        boolean isSpotCheckPercentageValid = this.businessObjectDefinitionService.indexSpotCheckMostRecentValidationBusinessObjectDefinitions(SEARCH_INDEX_NAME);
        MatcherAssert.assertThat((String)"Business object definition service index spot check most recent validation is true when it should have been false.", (Object)isSpotCheckPercentageValid, (Matcher)CoreMatchers.is((Object)false));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_SPOT_CHECK_MOST_RECENT_NUMBER, Integer.class);
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getMostRecentBusinessObjectDefinitions(100);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)2))).isValidDocumentIndex((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSearchBusinessObjectDefinitionsIncludeTagHierarchy() {
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        BusinessObjectDefinitionSearchKey businessObjectDefinitionSearchKey = new BusinessObjectDefinitionSearchKey(tagKey, INCLUDE_TAG_HIERARCHY);
        ArrayList<BusinessObjectDefinitionSearchKey> businessObjectDefinitionSearchKeyList = new ArrayList<BusinessObjectDefinitionSearchKey>();
        businessObjectDefinitionSearchKeyList.add(businessObjectDefinitionSearchKey);
        ArrayList<BusinessObjectDefinitionSearchFilter> businessObjectDefinitionSearchFilterList = new ArrayList<BusinessObjectDefinitionSearchFilter>();
        businessObjectDefinitionSearchFilterList.add(new BusinessObjectDefinitionSearchFilter(NO_EXCLUSION_SEARCH_FILTER, businessObjectDefinitionSearchKeyList));
        BusinessObjectDefinitionIndexSearchRequest businessObjectDefinitionIndexSearchRequest = new BusinessObjectDefinitionIndexSearchRequest(businessObjectDefinitionSearchFilterList, new ArrayList());
        HashSet fields = Sets.newHashSet((Object[])new String[]{"dataProviderName", "displayName", "shortDescription"});
        TagEntity tagEntity = new TagEntity();
        tagEntity.setTagCode(TAG_CODE);
        TagEntity tagChildEntity = new TagEntity();
        tagChildEntity.setTagCode(TAG_CODE_2);
        ArrayList<TagEntity> tagChildrenEntityList = new ArrayList<TagEntity>();
        tagChildrenEntityList.add(tagChildEntity);
        ArrayList<BusinessObjectDefinitionIndexSearchResponseDto> businessObjectDefinitionIndexSearchResponseDtoList = new ArrayList<BusinessObjectDefinitionIndexSearchResponseDto>();
        BusinessObjectDefinitionIndexSearchResponseDto businessObjectDefinitionIndexSearchResponseDto1 = new BusinessObjectDefinitionIndexSearchResponseDto(new DataProvider(DATA_PROVIDER_NAME), BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, BDEF_NAME, new Namespace(NAMESPACE));
        BusinessObjectDefinitionIndexSearchResponseDto businessObjectDefinitionIndexSearchResponseDto2 = new BusinessObjectDefinitionIndexSearchResponseDto(new DataProvider(DATA_PROVIDER_NAME_2), BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, BDEF_NAME_2, new Namespace(NAMESPACE));
        businessObjectDefinitionIndexSearchResponseDtoList.add(businessObjectDefinitionIndexSearchResponseDto1);
        businessObjectDefinitionIndexSearchResponseDtoList.add(businessObjectDefinitionIndexSearchResponseDto2);
        ElasticsearchResponseDto elasticsearchResponseDto = new ElasticsearchResponseDto();
        elasticsearchResponseDto.setBusinessObjectDefinitionIndexSearchResponseDtos(businessObjectDefinitionIndexSearchResponseDtoList);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_DEFINITION_SHORT_DESCRIPTION_LENGTH, Integer.class)).thenReturn((Object)300);
        Mockito.when((Object)this.searchIndexDaoHelper.getActiveSearchIndex(SEARCH_INDEX_TYPE_BDEF)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.tagDaoHelper.getTagEntity(businessObjectDefinitionSearchKey.getTagKey())).thenReturn((Object)tagEntity);
        Mockito.when((Object)this.tagDaoHelper.getTagChildrenEntities(tagEntity)).thenReturn(tagChildrenEntityList);
        Mockito.when((Object)this.businessObjectDefinitionIndexSearchDao.searchBusinessObjectDefinitionsByTags((String)Matchers.any(), (String)Matchers.any(), (List)Matchers.any(), (Set)Matchers.any())).thenReturn((Object)elasticsearchResponseDto);
        BusinessObjectDefinitionIndexSearchResponse businessObjectDefinitionSearchResponse = this.businessObjectDefinitionService.indexSearchBusinessObjectDefinitions(businessObjectDefinitionIndexSearchRequest, (Set)fields);
        MatcherAssert.assertThat((String)"Business object definition service index search business object definitions method response is null, but it should not be.", (Object)businessObjectDefinitionSearchResponse, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((String)"The first business object definition name in the search response is not correct.", (Object)((BusinessObjectDefinition)businessObjectDefinitionSearchResponse.getBusinessObjectDefinitions().get(0)).getBusinessObjectDefinitionName(), (Matcher)CoreMatchers.is((Object)BDEF_NAME));
        MatcherAssert.assertThat((String)"The second business object definition name in the search response is not correct.", (Object)((BusinessObjectDefinition)businessObjectDefinitionSearchResponse.getBusinessObjectDefinitions().get(1)).getBusinessObjectDefinitionName(), (Matcher)CoreMatchers.is((Object)BDEF_NAME_2));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper, (VerificationMode)Mockito.times((int)2))).getProperty(ConfigurationValue.BUSINESS_OBJECT_DEFINITION_SHORT_DESCRIPTION_LENGTH, Integer.class);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((SearchIndexDaoHelper)Mockito.verify((Object)this.searchIndexDaoHelper)).getActiveSearchIndex(SEARCH_INDEX_TYPE_BDEF);
        ((TagHelper)Mockito.verify((Object)this.tagHelper)).validateTagKey(tagKey);
        ((TagDaoHelper)Mockito.verify((Object)this.tagDaoHelper)).getTagEntity(businessObjectDefinitionSearchKey.getTagKey());
        ((TagDaoHelper)Mockito.verify((Object)this.tagDaoHelper)).getTagChildrenEntities(tagEntity);
        ((BusinessObjectDefinitionIndexSearchDao)Mockito.verify((Object)this.businessObjectDefinitionIndexSearchDao)).searchBusinessObjectDefinitionsByTags((String)Matchers.any(), (String)Matchers.any(), (List)Matchers.any(), (Set)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSearchBusinessObjectDefinitionsDoNotIncludeTagHierarchy() {
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        BusinessObjectDefinitionSearchKey businessObjectDefinitionSearchKey = new BusinessObjectDefinitionSearchKey(tagKey, NOT_INCLUDE_TAG_HIERARCHY);
        ArrayList<BusinessObjectDefinitionSearchKey> businessObjectDefinitionSearchKeyList = new ArrayList<BusinessObjectDefinitionSearchKey>();
        businessObjectDefinitionSearchKeyList.add(businessObjectDefinitionSearchKey);
        ArrayList<BusinessObjectDefinitionSearchFilter> businessObjectDefinitionSearchFilterList = new ArrayList<BusinessObjectDefinitionSearchFilter>();
        businessObjectDefinitionSearchFilterList.add(new BusinessObjectDefinitionSearchFilter(NO_EXCLUSION_SEARCH_FILTER, businessObjectDefinitionSearchKeyList));
        BusinessObjectDefinitionIndexSearchRequest businessObjectDefinitionIndexSearchRequest = new BusinessObjectDefinitionIndexSearchRequest(businessObjectDefinitionSearchFilterList, new ArrayList());
        HashSet fields = Sets.newHashSet((Object[])new String[]{"dataProviderName", "displayName", "shortDescription"});
        TagEntity tagEntity = new TagEntity();
        tagEntity.setTagCode(TAG_CODE);
        ArrayList<BusinessObjectDefinitionIndexSearchResponseDto> businessObjectDefinitionIndexSearchResponseDtoList = new ArrayList<BusinessObjectDefinitionIndexSearchResponseDto>();
        BusinessObjectDefinitionIndexSearchResponseDto businessObjectDefinitionIndexSearchResponseDto1 = new BusinessObjectDefinitionIndexSearchResponseDto(new DataProvider(DATA_PROVIDER_NAME), BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, BDEF_NAME, new Namespace(NAMESPACE));
        BusinessObjectDefinitionIndexSearchResponseDto businessObjectDefinitionIndexSearchResponseDto2 = new BusinessObjectDefinitionIndexSearchResponseDto(new DataProvider(DATA_PROVIDER_NAME_2), BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, BDEF_NAME_2, new Namespace(NAMESPACE));
        businessObjectDefinitionIndexSearchResponseDtoList.add(businessObjectDefinitionIndexSearchResponseDto1);
        businessObjectDefinitionIndexSearchResponseDtoList.add(businessObjectDefinitionIndexSearchResponseDto2);
        ElasticsearchResponseDto elasticsearchResponseDto = new ElasticsearchResponseDto();
        elasticsearchResponseDto.setBusinessObjectDefinitionIndexSearchResponseDtos(businessObjectDefinitionIndexSearchResponseDtoList);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_DEFINITION_SHORT_DESCRIPTION_LENGTH, Integer.class)).thenReturn((Object)300);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.tagDaoHelper.getTagEntity(businessObjectDefinitionSearchKey.getTagKey())).thenReturn((Object)tagEntity);
        Mockito.when((Object)this.businessObjectDefinitionIndexSearchDao.searchBusinessObjectDefinitionsByTags((String)Matchers.any(), (String)Matchers.any(), (List)Matchers.any(), (Set)Matchers.any())).thenReturn((Object)elasticsearchResponseDto);
        BusinessObjectDefinitionIndexSearchResponse businessObjectDefinitionSearchResponse = this.businessObjectDefinitionService.indexSearchBusinessObjectDefinitions(businessObjectDefinitionIndexSearchRequest, (Set)fields);
        MatcherAssert.assertThat((String)"Business object definition service index search business object definitions method response is null, but it should not be.", (Object)businessObjectDefinitionSearchResponse, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((String)"The first business object definition name in the search response is not correct.", (Object)((BusinessObjectDefinition)businessObjectDefinitionSearchResponse.getBusinessObjectDefinitions().get(0)).getBusinessObjectDefinitionName(), (Matcher)CoreMatchers.is((Object)BDEF_NAME));
        MatcherAssert.assertThat((String)"The second business object definition name in the search response is not correct.", (Object)((BusinessObjectDefinition)businessObjectDefinitionSearchResponse.getBusinessObjectDefinitions().get(1)).getBusinessObjectDefinitionName(), (Matcher)CoreMatchers.is((Object)BDEF_NAME_2));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper, (VerificationMode)Mockito.times((int)2))).getProperty(ConfigurationValue.BUSINESS_OBJECT_DEFINITION_SHORT_DESCRIPTION_LENGTH, Integer.class);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((TagHelper)Mockito.verify((Object)this.tagHelper)).validateTagKey(tagKey);
        ((TagDaoHelper)Mockito.verify((Object)this.tagDaoHelper)).getTagEntity(businessObjectDefinitionSearchKey.getTagKey());
        ((BusinessObjectDefinitionIndexSearchDao)Mockito.verify((Object)this.businessObjectDefinitionIndexSearchDao)).searchBusinessObjectDefinitionsByTags((String)Matchers.any(), (String)Matchers.any(), (List)Matchers.any(), (Set)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSearchBusinessObjectDefinitionWithFacetFieldTag() {
        ArrayList<String> facetFields = new ArrayList<String>();
        facetFields.add("TAG");
        this.indexSearchBusinessObjectDefinitionsFacetFields(facetFields);
    }

    @Test
    public void testIndexSearchBusinessObjectDefinitionWithFacetFieldTagWhiteSpace() {
        ArrayList<String> facetFields = new ArrayList<String>();
        facetFields.add(this.addWhitespace("TAG"));
        this.indexSearchBusinessObjectDefinitionsFacetFields(facetFields);
    }

    @Test
    public void testIndexSearchBusinessObjectDefinitionWithFacetFieldTagMixedCase() {
        ArrayList<String> facetFields = new ArrayList<String>();
        facetFields.add("TaG");
        this.indexSearchBusinessObjectDefinitionsFacetFields(facetFields);
    }

    @Test
    public void testIndexSearchBusinessObjectDefinitionReturnsEmptyResponseForEmptyTagEntities() {
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        TagEntity tagEntity = new TagEntity();
        BusinessObjectDefinitionSearchKey businessObjectDefinitionSearchKey = new BusinessObjectDefinitionSearchKey(tagKey, NOT_INCLUDE_TAG_HIERARCHY);
        ArrayList<BusinessObjectDefinitionSearchKey> businessObjectDefinitionSearchKeyList = new ArrayList<BusinessObjectDefinitionSearchKey>();
        businessObjectDefinitionSearchKeyList.add(businessObjectDefinitionSearchKey);
        ArrayList<BusinessObjectDefinitionSearchFilter> businessObjectDefinitionSearchFilterList = new ArrayList<BusinessObjectDefinitionSearchFilter>();
        businessObjectDefinitionSearchFilterList.add(new BusinessObjectDefinitionSearchFilter(NO_EXCLUSION_SEARCH_FILTER, businessObjectDefinitionSearchKeyList));
        BusinessObjectDefinitionIndexSearchRequest businessObjectDefinitionIndexSearchRequest = new BusinessObjectDefinitionIndexSearchRequest(businessObjectDefinitionSearchFilterList, new ArrayList());
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_DEFINITION_SHORT_DESCRIPTION_LENGTH, Integer.class)).thenReturn((Object)300);
        Mockito.when((Object)this.searchIndexDaoHelper.getActiveSearchIndex(SEARCH_INDEX_TYPE_BDEF)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.tagDaoHelper.getTagEntity(tagKey)).thenReturn((Object)tagEntity);
        Mockito.when((Object)this.businessObjectDefinitionIndexSearchDao.searchBusinessObjectDefinitionsByTags((String)Matchers.any(), (String)Matchers.any(), (List)Matchers.any(), (Set)Matchers.any())).thenReturn((Object)new ElasticsearchResponseDto());
        BusinessObjectDefinitionIndexSearchResponse businessObjectDefinitionSearchResponse = this.businessObjectDefinitionService.indexSearchBusinessObjectDefinitions(businessObjectDefinitionIndexSearchRequest, new HashSet());
        MatcherAssert.assertThat((String)"Expected empty response", (boolean)CollectionUtils.isEmpty((Collection)businessObjectDefinitionSearchResponse.getBusinessObjectDefinitions()));
        ((SearchIndexDaoHelper)Mockito.verify((Object)this.searchIndexDaoHelper)).getActiveSearchIndex(SEARCH_INDEX_TYPE_BDEF);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((TagHelper)Mockito.verify((Object)this.tagHelper)).validateTagKey(tagKey);
        ((TagDaoHelper)Mockito.verify((Object)this.tagDaoHelper)).getTagEntity(tagKey);
        ((BusinessObjectDefinitionIndexSearchDao)Mockito.verify((Object)this.businessObjectDefinitionIndexSearchDao)).searchBusinessObjectDefinitionsByTags((String)Matchers.any(), (String)Matchers.any(), (List)Matchers.any(), (Set)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSearchBusinessObjectDefinitionWithFacetsReturnsEmptyResponseForEmptyTagEntities() {
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        TagEntity tagEntity = new TagEntity();
        BusinessObjectDefinitionSearchKey businessObjectDefinitionSearchKey = new BusinessObjectDefinitionSearchKey(tagKey, NOT_INCLUDE_TAG_HIERARCHY);
        ArrayList<BusinessObjectDefinitionSearchKey> businessObjectDefinitionSearchKeyList = new ArrayList<BusinessObjectDefinitionSearchKey>();
        businessObjectDefinitionSearchKeyList.add(businessObjectDefinitionSearchKey);
        ArrayList<BusinessObjectDefinitionSearchFilter> businessObjectDefinitionSearchFilterList = new ArrayList<BusinessObjectDefinitionSearchFilter>();
        businessObjectDefinitionSearchFilterList.add(new BusinessObjectDefinitionSearchFilter(NO_EXCLUSION_SEARCH_FILTER, businessObjectDefinitionSearchKeyList));
        BusinessObjectDefinitionIndexSearchRequest businessObjectDefinitionIndexSearchRequest = new BusinessObjectDefinitionIndexSearchRequest(businessObjectDefinitionSearchFilterList, Collections.singletonList("TAG"));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_DEFINITION_SHORT_DESCRIPTION_LENGTH, Integer.class)).thenReturn((Object)300);
        Mockito.when((Object)this.searchIndexDaoHelper.getActiveSearchIndex(SEARCH_INDEX_TYPE_BDEF)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.tagDaoHelper.getTagEntity(tagKey)).thenReturn((Object)tagEntity);
        Mockito.when((Object)this.businessObjectDefinitionIndexSearchDao.searchBusinessObjectDefinitionsByTags((String)Matchers.any(), (String)Matchers.any(), (List)Matchers.any(), (Set)Matchers.any())).thenReturn((Object)new ElasticsearchResponseDto());
        BusinessObjectDefinitionIndexSearchResponse businessObjectDefinitionSearchResponse = this.businessObjectDefinitionService.indexSearchBusinessObjectDefinitions(businessObjectDefinitionIndexSearchRequest, new HashSet());
        MatcherAssert.assertThat((String)"Expected empty response", (boolean)CollectionUtils.isEmpty((Collection)businessObjectDefinitionSearchResponse.getBusinessObjectDefinitions()));
        ((SearchIndexDaoHelper)Mockito.verify((Object)this.searchIndexDaoHelper)).getActiveSearchIndex(SEARCH_INDEX_TYPE_BDEF);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((TagHelper)Mockito.verify((Object)this.tagHelper)).validateTagKey(tagKey);
        ((TagDaoHelper)Mockito.verify((Object)this.tagDaoHelper)).getTagEntity(tagKey);
        ((BusinessObjectDefinitionIndexSearchDao)Mockito.verify((Object)this.businessObjectDefinitionIndexSearchDao)).searchBusinessObjectDefinitionsByTags((String)Matchers.any(), (String)Matchers.any(), (List)Matchers.any(), (Set)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSearchBusinessObjectDefinitionsWithMultipleTagsIncludeTagHierarchy() {
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        TagKey tagKeyTwo = new TagKey(TAG_TYPE_2, TAG_CODE_2);
        BusinessObjectDefinitionSearchKey businessObjectDefinitionSearchKey = new BusinessObjectDefinitionSearchKey(tagKey, INCLUDE_TAG_HIERARCHY);
        BusinessObjectDefinitionSearchKey businessObjectDefinitionSearchKeyTwo = new BusinessObjectDefinitionSearchKey(tagKeyTwo, INCLUDE_TAG_HIERARCHY);
        ArrayList<BusinessObjectDefinitionSearchKey> businessObjectDefinitionSearchKeyList = new ArrayList<BusinessObjectDefinitionSearchKey>();
        businessObjectDefinitionSearchKeyList.add(businessObjectDefinitionSearchKey);
        businessObjectDefinitionSearchKeyList.add(businessObjectDefinitionSearchKeyTwo);
        ArrayList<BusinessObjectDefinitionSearchFilter> businessObjectDefinitionSearchFilterList = new ArrayList<BusinessObjectDefinitionSearchFilter>();
        businessObjectDefinitionSearchFilterList.add(new BusinessObjectDefinitionSearchFilter(NO_EXCLUSION_SEARCH_FILTER, businessObjectDefinitionSearchKeyList));
        BusinessObjectDefinitionIndexSearchRequest businessObjectDefinitionIndexSearchRequest = new BusinessObjectDefinitionIndexSearchRequest(businessObjectDefinitionSearchFilterList, new ArrayList());
        HashSet fields = Sets.newHashSet((Object[])new String[]{"dataProviderName", "displayName", "shortDescription"});
        TagEntity tagEntity = new TagEntity();
        tagEntity.setTagCode(TAG_CODE);
        TagEntity tagEntityTwo = new TagEntity();
        tagEntity.setTagCode(TAG_CODE_2);
        TagEntity tagChildEntity = new TagEntity();
        tagChildEntity.setTagCode(TAG_CODE_2);
        ArrayList<TagEntity> tagChildrenEntityList = new ArrayList<TagEntity>();
        tagChildrenEntityList.add(tagChildEntity);
        ArrayList<BusinessObjectDefinitionIndexSearchResponseDto> businessObjectDefinitionIndexSearchResponseDtoList = new ArrayList<BusinessObjectDefinitionIndexSearchResponseDto>();
        BusinessObjectDefinitionIndexSearchResponseDto businessObjectDefinitionIndexSearchResponseDto1 = new BusinessObjectDefinitionIndexSearchResponseDto(new DataProvider(DATA_PROVIDER_NAME), BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, BDEF_NAME, new Namespace(NAMESPACE));
        BusinessObjectDefinitionIndexSearchResponseDto businessObjectDefinitionIndexSearchResponseDto2 = new BusinessObjectDefinitionIndexSearchResponseDto(new DataProvider(DATA_PROVIDER_NAME_2), BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, BDEF_NAME_2, new Namespace(NAMESPACE));
        businessObjectDefinitionIndexSearchResponseDtoList.add(businessObjectDefinitionIndexSearchResponseDto1);
        businessObjectDefinitionIndexSearchResponseDtoList.add(businessObjectDefinitionIndexSearchResponseDto2);
        ElasticsearchResponseDto elasticsearchResponseDto = new ElasticsearchResponseDto();
        elasticsearchResponseDto.setBusinessObjectDefinitionIndexSearchResponseDtos(businessObjectDefinitionIndexSearchResponseDtoList);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_DEFINITION_SHORT_DESCRIPTION_LENGTH, Integer.class)).thenReturn((Object)300);
        Mockito.when((Object)this.searchIndexDaoHelper.getActiveSearchIndex(SEARCH_INDEX_TYPE_BDEF)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.tagDaoHelper.getTagEntity(businessObjectDefinitionSearchKey.getTagKey())).thenReturn((Object)tagEntity);
        Mockito.when((Object)this.tagDaoHelper.getTagEntity(businessObjectDefinitionSearchKeyTwo.getTagKey())).thenReturn((Object)tagEntityTwo);
        Mockito.when((Object)this.tagDaoHelper.getTagChildrenEntities(tagEntity)).thenReturn(tagChildrenEntityList);
        Mockito.when((Object)this.businessObjectDefinitionIndexSearchDao.searchBusinessObjectDefinitionsByTags((String)Matchers.any(), (String)Matchers.any(), (List)Matchers.any(), (Set)Matchers.any())).thenReturn((Object)elasticsearchResponseDto);
        BusinessObjectDefinitionIndexSearchResponse businessObjectDefinitionSearchResponse = this.businessObjectDefinitionService.indexSearchBusinessObjectDefinitions(businessObjectDefinitionIndexSearchRequest, (Set)fields);
        MatcherAssert.assertThat((String)"Business object definition service index search business object definitions method response is null, but it should not be.", (Object)businessObjectDefinitionSearchResponse, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((String)"The first business object definition name in the search response is not correct.", (Object)((BusinessObjectDefinition)businessObjectDefinitionSearchResponse.getBusinessObjectDefinitions().get(0)).getBusinessObjectDefinitionName(), (Matcher)CoreMatchers.is((Object)BDEF_NAME));
        MatcherAssert.assertThat((String)"The second business object definition name in the search response is not correct.", (Object)((BusinessObjectDefinition)businessObjectDefinitionSearchResponse.getBusinessObjectDefinitions().get(1)).getBusinessObjectDefinitionName(), (Matcher)CoreMatchers.is((Object)BDEF_NAME_2));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper, (VerificationMode)Mockito.times((int)2))).getProperty(ConfigurationValue.BUSINESS_OBJECT_DEFINITION_SHORT_DESCRIPTION_LENGTH, Integer.class);
        ((SearchIndexDaoHelper)Mockito.verify((Object)this.searchIndexDaoHelper)).getActiveSearchIndex(SEARCH_INDEX_TYPE_BDEF);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((TagHelper)Mockito.verify((Object)this.tagHelper)).validateTagKey(businessObjectDefinitionSearchKey.getTagKey());
        ((TagHelper)Mockito.verify((Object)this.tagHelper)).validateTagKey(businessObjectDefinitionSearchKeyTwo.getTagKey());
        ((TagDaoHelper)Mockito.verify((Object)this.tagDaoHelper)).getTagEntity(businessObjectDefinitionSearchKey.getTagKey());
        ((TagDaoHelper)Mockito.verify((Object)this.tagDaoHelper)).getTagEntity(businessObjectDefinitionSearchKeyTwo.getTagKey());
        ((TagDaoHelper)Mockito.verify((Object)this.tagDaoHelper)).getTagChildrenEntities(tagEntity);
        ((TagDaoHelper)Mockito.verify((Object)this.tagDaoHelper)).getTagChildrenEntities(tagEntityTwo);
        ((BusinessObjectDefinitionIndexSearchDao)Mockito.verify((Object)this.businessObjectDefinitionIndexSearchDao)).searchBusinessObjectDefinitionsByTags((String)Matchers.any(), (String)Matchers.any(), (List)Matchers.any(), (Set)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSearchBusinessObjectDefinitionsWithMultipleTagsDoNotIncludeTagHierarchy() {
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        TagKey tagKeyTwo = new TagKey(TAG_TYPE_2, TAG_CODE_2);
        BusinessObjectDefinitionSearchKey businessObjectDefinitionSearchKey = new BusinessObjectDefinitionSearchKey(tagKey, NOT_INCLUDE_TAG_HIERARCHY);
        BusinessObjectDefinitionSearchKey businessObjectDefinitionSearchKeyTwo = new BusinessObjectDefinitionSearchKey(tagKeyTwo, NOT_INCLUDE_TAG_HIERARCHY);
        ArrayList<BusinessObjectDefinitionSearchKey> businessObjectDefinitionSearchKeyList = new ArrayList<BusinessObjectDefinitionSearchKey>();
        businessObjectDefinitionSearchKeyList.add(businessObjectDefinitionSearchKey);
        businessObjectDefinitionSearchKeyList.add(businessObjectDefinitionSearchKeyTwo);
        ArrayList<BusinessObjectDefinitionSearchFilter> businessObjectDefinitionSearchFilterList = new ArrayList<BusinessObjectDefinitionSearchFilter>();
        businessObjectDefinitionSearchFilterList.add(new BusinessObjectDefinitionSearchFilter(NO_EXCLUSION_SEARCH_FILTER, businessObjectDefinitionSearchKeyList));
        BusinessObjectDefinitionIndexSearchRequest businessObjectDefinitionIndexSearchRequest = new BusinessObjectDefinitionIndexSearchRequest(businessObjectDefinitionSearchFilterList, new ArrayList());
        HashSet fields = Sets.newHashSet((Object[])new String[]{"dataProviderName", "displayName", "shortDescription"});
        TagEntity tagEntity = new TagEntity();
        tagEntity.setTagCode(TAG_CODE);
        TagEntity tagEntityTwo = new TagEntity();
        tagEntity.setTagCode(TAG_CODE_2);
        ArrayList<BusinessObjectDefinitionIndexSearchResponseDto> businessObjectDefinitionIndexSearchResponseDtoList = new ArrayList<BusinessObjectDefinitionIndexSearchResponseDto>();
        BusinessObjectDefinitionIndexSearchResponseDto businessObjectDefinitionIndexSearchResponseDto1 = new BusinessObjectDefinitionIndexSearchResponseDto(new DataProvider(DATA_PROVIDER_NAME), BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, BDEF_NAME, new Namespace(NAMESPACE));
        BusinessObjectDefinitionIndexSearchResponseDto businessObjectDefinitionIndexSearchResponseDto2 = new BusinessObjectDefinitionIndexSearchResponseDto(new DataProvider(DATA_PROVIDER_NAME_2), BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, BDEF_NAME_2, new Namespace(NAMESPACE));
        businessObjectDefinitionIndexSearchResponseDtoList.add(businessObjectDefinitionIndexSearchResponseDto1);
        businessObjectDefinitionIndexSearchResponseDtoList.add(businessObjectDefinitionIndexSearchResponseDto2);
        ElasticsearchResponseDto elasticsearchResponseDto = new ElasticsearchResponseDto();
        elasticsearchResponseDto.setBusinessObjectDefinitionIndexSearchResponseDtos(businessObjectDefinitionIndexSearchResponseDtoList);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_DEFINITION_SHORT_DESCRIPTION_LENGTH, Integer.class)).thenReturn((Object)300);
        Mockito.when((Object)this.searchIndexDaoHelper.getActiveSearchIndex(SEARCH_INDEX_TYPE_BDEF)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.tagDaoHelper.getTagEntity(businessObjectDefinitionSearchKey.getTagKey())).thenReturn((Object)tagEntity);
        Mockito.when((Object)this.tagDaoHelper.getTagEntity(businessObjectDefinitionSearchKeyTwo.getTagKey())).thenReturn((Object)tagEntityTwo);
        Mockito.when((Object)this.businessObjectDefinitionIndexSearchDao.searchBusinessObjectDefinitionsByTags((String)Matchers.any(), (String)Matchers.any(), (List)Matchers.any(), (Set)Matchers.any())).thenReturn((Object)elasticsearchResponseDto);
        BusinessObjectDefinitionIndexSearchResponse businessObjectDefinitionSearchResponse = this.businessObjectDefinitionService.indexSearchBusinessObjectDefinitions(businessObjectDefinitionIndexSearchRequest, (Set)fields);
        MatcherAssert.assertThat((String)"Business object definition service index search business object definitions method response is null, but it should not be.", (Object)businessObjectDefinitionSearchResponse, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((String)"The first business object definition name in the search response is not correct.", (Object)((BusinessObjectDefinition)businessObjectDefinitionSearchResponse.getBusinessObjectDefinitions().get(0)).getBusinessObjectDefinitionName(), (Matcher)CoreMatchers.is((Object)BDEF_NAME));
        MatcherAssert.assertThat((String)"The second business object definition name in the search response is not correct.", (Object)((BusinessObjectDefinition)businessObjectDefinitionSearchResponse.getBusinessObjectDefinitions().get(1)).getBusinessObjectDefinitionName(), (Matcher)CoreMatchers.is((Object)BDEF_NAME_2));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper, (VerificationMode)Mockito.times((int)2))).getProperty(ConfigurationValue.BUSINESS_OBJECT_DEFINITION_SHORT_DESCRIPTION_LENGTH, Integer.class);
        ((SearchIndexDaoHelper)Mockito.verify((Object)this.searchIndexDaoHelper)).getActiveSearchIndex(SEARCH_INDEX_TYPE_BDEF);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((TagHelper)Mockito.verify((Object)this.tagHelper)).validateTagKey(businessObjectDefinitionSearchKey.getTagKey());
        ((TagHelper)Mockito.verify((Object)this.tagHelper)).validateTagKey(businessObjectDefinitionSearchKeyTwo.getTagKey());
        ((TagDaoHelper)Mockito.verify((Object)this.tagDaoHelper)).getTagEntity(businessObjectDefinitionSearchKey.getTagKey());
        ((TagDaoHelper)Mockito.verify((Object)this.tagDaoHelper)).getTagEntity(businessObjectDefinitionSearchKeyTwo.getTagKey());
        ((BusinessObjectDefinitionIndexSearchDao)Mockito.verify((Object)this.businessObjectDefinitionIndexSearchDao)).searchBusinessObjectDefinitionsByTags((String)Matchers.any(), (String)Matchers.any(), (List)Matchers.any(), (Set)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSearchBusinessObjectDefinitionsWithMultipleTagsWithIsExclusionSearchFilter() {
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        TagKey tagKeyTwo = new TagKey(TAG_TYPE_2, TAG_CODE_2);
        BusinessObjectDefinitionSearchKey businessObjectDefinitionSearchKey = new BusinessObjectDefinitionSearchKey(tagKey, NOT_INCLUDE_TAG_HIERARCHY);
        BusinessObjectDefinitionSearchKey businessObjectDefinitionSearchKeyTwo = new BusinessObjectDefinitionSearchKey(tagKeyTwo, NOT_INCLUDE_TAG_HIERARCHY);
        ArrayList<BusinessObjectDefinitionSearchKey> businessObjectDefinitionSearchKeyList = new ArrayList<BusinessObjectDefinitionSearchKey>();
        businessObjectDefinitionSearchKeyList.add(businessObjectDefinitionSearchKey);
        businessObjectDefinitionSearchKeyList.add(businessObjectDefinitionSearchKeyTwo);
        ArrayList<BusinessObjectDefinitionSearchFilter> businessObjectDefinitionSearchFilterList = new ArrayList<BusinessObjectDefinitionSearchFilter>();
        businessObjectDefinitionSearchFilterList.add(new BusinessObjectDefinitionSearchFilter(Boolean.valueOf(true), businessObjectDefinitionSearchKeyList));
        BusinessObjectDefinitionIndexSearchRequest businessObjectDefinitionIndexSearchRequest = new BusinessObjectDefinitionIndexSearchRequest(businessObjectDefinitionSearchFilterList, new ArrayList());
        HashSet fields = Sets.newHashSet((Object[])new String[]{"dataProviderName", "displayName", "shortDescription"});
        TagEntity tagEntity = new TagEntity();
        tagEntity.setTagCode(TAG_CODE);
        TagEntity tagEntityTwo = new TagEntity();
        tagEntity.setTagCode(TAG_CODE_2);
        ArrayList<BusinessObjectDefinitionIndexSearchResponseDto> businessObjectDefinitionIndexSearchResponseDtoList = new ArrayList<BusinessObjectDefinitionIndexSearchResponseDto>();
        BusinessObjectDefinitionIndexSearchResponseDto businessObjectDefinitionIndexSearchResponseDto1 = new BusinessObjectDefinitionIndexSearchResponseDto(new DataProvider(DATA_PROVIDER_NAME), BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, BDEF_NAME, new Namespace(NAMESPACE));
        BusinessObjectDefinitionIndexSearchResponseDto businessObjectDefinitionIndexSearchResponseDto2 = new BusinessObjectDefinitionIndexSearchResponseDto(new DataProvider(DATA_PROVIDER_NAME_2), BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, BDEF_NAME_2, new Namespace(NAMESPACE));
        businessObjectDefinitionIndexSearchResponseDtoList.add(businessObjectDefinitionIndexSearchResponseDto1);
        businessObjectDefinitionIndexSearchResponseDtoList.add(businessObjectDefinitionIndexSearchResponseDto2);
        ElasticsearchResponseDto elasticsearchResponseDto = new ElasticsearchResponseDto();
        elasticsearchResponseDto.setBusinessObjectDefinitionIndexSearchResponseDtos(businessObjectDefinitionIndexSearchResponseDtoList);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_DEFINITION_SHORT_DESCRIPTION_LENGTH, Integer.class)).thenReturn((Object)300);
        Mockito.when((Object)this.searchIndexDaoHelper.getActiveSearchIndex(SEARCH_INDEX_TYPE_BDEF)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.tagDaoHelper.getTagEntity(businessObjectDefinitionSearchKey.getTagKey())).thenReturn((Object)tagEntity);
        Mockito.when((Object)this.tagDaoHelper.getTagEntity(businessObjectDefinitionSearchKeyTwo.getTagKey())).thenReturn((Object)tagEntityTwo);
        Mockito.when((Object)this.businessObjectDefinitionIndexSearchDao.searchBusinessObjectDefinitionsByTags((String)Matchers.any(), (String)Matchers.any(), (List)Matchers.any(), (Set)Matchers.any())).thenReturn((Object)elasticsearchResponseDto);
        BusinessObjectDefinitionIndexSearchResponse businessObjectDefinitionSearchResponse = this.businessObjectDefinitionService.indexSearchBusinessObjectDefinitions(businessObjectDefinitionIndexSearchRequest, (Set)fields);
        MatcherAssert.assertThat((String)"Business object definition service index search business object definitions method response is null, but it should not be.", (Object)businessObjectDefinitionSearchResponse, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((String)"The first business object definition name in the search response is not correct.", (Object)((BusinessObjectDefinition)businessObjectDefinitionSearchResponse.getBusinessObjectDefinitions().get(0)).getBusinessObjectDefinitionName(), (Matcher)CoreMatchers.is((Object)BDEF_NAME));
        MatcherAssert.assertThat((String)"The second business object definition name in the search response is not correct.", (Object)((BusinessObjectDefinition)businessObjectDefinitionSearchResponse.getBusinessObjectDefinitions().get(1)).getBusinessObjectDefinitionName(), (Matcher)CoreMatchers.is((Object)BDEF_NAME_2));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper, (VerificationMode)Mockito.times((int)2))).getProperty(ConfigurationValue.BUSINESS_OBJECT_DEFINITION_SHORT_DESCRIPTION_LENGTH, Integer.class);
        ((SearchIndexDaoHelper)Mockito.verify((Object)this.searchIndexDaoHelper)).getActiveSearchIndex(SEARCH_INDEX_TYPE_BDEF);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((TagHelper)Mockito.verify((Object)this.tagHelper)).validateTagKey(businessObjectDefinitionSearchKey.getTagKey());
        ((TagHelper)Mockito.verify((Object)this.tagHelper)).validateTagKey(businessObjectDefinitionSearchKeyTwo.getTagKey());
        ((TagDaoHelper)Mockito.verify((Object)this.tagDaoHelper)).getTagEntity(businessObjectDefinitionSearchKey.getTagKey());
        ((TagDaoHelper)Mockito.verify((Object)this.tagDaoHelper)).getTagEntity(businessObjectDefinitionSearchKeyTwo.getTagKey());
        ((BusinessObjectDefinitionIndexSearchDao)Mockito.verify((Object)this.businessObjectDefinitionIndexSearchDao)).searchBusinessObjectDefinitionsByTags((String)Matchers.any(), (String)Matchers.any(), (List)Matchers.any(), (Set)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSearchBusinessObjectDefinitionsInvalidFacet() {
        ArrayList businessObjectDefinitionSearchFilterList = new ArrayList();
        ArrayList<String> facetFields = new ArrayList<String>();
        facetFields.add("Invalid");
        BusinessObjectDefinitionIndexSearchRequest businessObjectDefinitionIndexSearchRequest = new BusinessObjectDefinitionIndexSearchRequest(businessObjectDefinitionSearchFilterList, facetFields);
        HashSet fields = Sets.newHashSet((Object[])new String[]{"dataProviderName", "displayName", "shortDescription"});
        Mockito.when((Object)this.searchIndexDaoHelper.getActiveSearchIndex(SEARCH_INDEX_TYPE_BDEF)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        try {
            this.businessObjectDefinitionService.indexSearchBusinessObjectDefinitions(businessObjectDefinitionIndexSearchRequest, (Set)fields);
            Assert.fail((String)"Should have caught an exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MatcherAssert.assertThat((String)"The IllegalArgumentException message is not correct.", (Object)illegalArgumentException.getMessage(), (Matcher)CoreMatchers.is((Object)"Facet field \"invalid\" is not supported."));
        }
        ((SearchIndexDaoHelper)Mockito.verify((Object)this.searchIndexDaoHelper)).getActiveSearchIndex(SEARCH_INDEX_TYPE_BDEF);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        this.verifyNoMoreInteractionsHelper();
    }

    private void indexSearchBusinessObjectDefinitionsFacetFields(List<String> facetFields) {
        ArrayList businessObjectDefinitionSearchFilterList = new ArrayList();
        BusinessObjectDefinitionIndexSearchRequest businessObjectDefinitionIndexSearchRequest = new BusinessObjectDefinitionIndexSearchRequest(businessObjectDefinitionSearchFilterList, facetFields);
        HashSet fields = Sets.newHashSet((Object[])new String[]{"dataProviderName", "displayName", "shortDescription"});
        ArrayList<BusinessObjectDefinitionIndexSearchResponseDto> businessObjectDefinitionIndexSearchResponseDtoList = new ArrayList<BusinessObjectDefinitionIndexSearchResponseDto>();
        BusinessObjectDefinitionIndexSearchResponseDto businessObjectDefinitionIndexSearchResponseDto1 = new BusinessObjectDefinitionIndexSearchResponseDto(new DataProvider(DATA_PROVIDER_NAME), BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, BDEF_NAME, new Namespace(NAMESPACE));
        BusinessObjectDefinitionIndexSearchResponseDto businessObjectDefinitionIndexSearchResponseDto2 = new BusinessObjectDefinitionIndexSearchResponseDto(new DataProvider(DATA_PROVIDER_NAME_2), BDEF_DESCRIPTION_2, BDEF_DISPLAY_NAME_2, BDEF_NAME_2, new Namespace(NAMESPACE));
        businessObjectDefinitionIndexSearchResponseDtoList.add(businessObjectDefinitionIndexSearchResponseDto1);
        businessObjectDefinitionIndexSearchResponseDtoList.add(businessObjectDefinitionIndexSearchResponseDto2);
        ArrayList<TagTypeIndexSearchResponseDto> tagTypeIndexSearchResponseDtos = new ArrayList<TagTypeIndexSearchResponseDto>();
        ArrayList<TagIndexSearchResponseDto> tagIndexSearchResponseDtos = new ArrayList<TagIndexSearchResponseDto>();
        tagIndexSearchResponseDtos.add(new TagIndexSearchResponseDto(TAG_CODE, 120L, TAG_DISPLAY_NAME));
        tagIndexSearchResponseDtos.add(new TagIndexSearchResponseDto(TAG_CODE_2, 120L, TAG_DISPLAY_NAME_2));
        TagTypeIndexSearchResponseDto tagTypeIndexSearchResponseDto = new TagTypeIndexSearchResponseDto(TAG_TYPE, tagIndexSearchResponseDtos, TAG_TYPE_DISPLAY_NAME);
        tagTypeIndexSearchResponseDtos.add(tagTypeIndexSearchResponseDto);
        ElasticsearchResponseDto elasticsearchResponseDto = new ElasticsearchResponseDto();
        elasticsearchResponseDto.setBusinessObjectDefinitionIndexSearchResponseDtos(businessObjectDefinitionIndexSearchResponseDtoList);
        elasticsearchResponseDto.setTagTypeIndexSearchResponseDtos(tagTypeIndexSearchResponseDtos);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_DEFINITION_SHORT_DESCRIPTION_LENGTH, Integer.class)).thenReturn((Object)300);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.businessObjectDefinitionIndexSearchDao.findAllBusinessObjectDefinitions((String)Matchers.any(), (String)Matchers.any(), (Set)Matchers.any())).thenReturn((Object)elasticsearchResponseDto);
        BusinessObjectDefinitionIndexSearchResponse businessObjectDefinitionSearchResponse = this.businessObjectDefinitionService.indexSearchBusinessObjectDefinitions(businessObjectDefinitionIndexSearchRequest, (Set)fields);
        MatcherAssert.assertThat((String)"Business object definition service index search business object definitions method response is null, but it should not be.", (Object)businessObjectDefinitionSearchResponse, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((String)"The first business object definition name in the search response is not correct.", (Object)((BusinessObjectDefinition)businessObjectDefinitionSearchResponse.getBusinessObjectDefinitions().get(0)).getBusinessObjectDefinitionName(), (Matcher)CoreMatchers.is((Object)BDEF_NAME));
        MatcherAssert.assertThat((String)"The second business object definition name in the search response is not correct.", (Object)((BusinessObjectDefinition)businessObjectDefinitionSearchResponse.getBusinessObjectDefinitions().get(1)).getBusinessObjectDefinitionName(), (Matcher)CoreMatchers.is((Object)BDEF_NAME_2));
        MatcherAssert.assertThat((String)"The tag type code in the search response is not correct.", (Object)((Facet)businessObjectDefinitionSearchResponse.getFacets().get(0)).getFacetId(), (Matcher)CoreMatchers.is((Object)TAG_TYPE));
        MatcherAssert.assertThat((String)"The tag code in the search response is not correct.", (Object)((Facet)((Facet)businessObjectDefinitionSearchResponse.getFacets().get(0)).getFacets().get(0)).getFacetId(), (Matcher)CoreMatchers.is((Object)TAG_CODE));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper, (VerificationMode)Mockito.times((int)2))).getProperty(ConfigurationValue.BUSINESS_OBJECT_DEFINITION_SHORT_DESCRIPTION_LENGTH, Integer.class);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionIndexSearchDao)Mockito.verify((Object)this.businessObjectDefinitionIndexSearchDao)).findAllBusinessObjectDefinitions((String)Matchers.any(), (String)Matchers.any(), (Set)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateSearchIndexDocumentBusinessObjectDefinitionCreate() throws Exception {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        ArrayList businessObjectDefinitionIds = new ArrayList();
        businessObjectDefinitionEntityList.forEach(businessObjectDefinitionEntity -> businessObjectDefinitionIds.add(businessObjectDefinitionEntity.getId()));
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("BDEF", businessObjectDefinitionIds, "CREATE");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.businessObjectDefinitionDao.getAllBusinessObjectDefinitionsByIds((List)Matchers.any())).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.businessObjectDefinitionHelper.safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class))).thenReturn((Object)JSON_STRING);
        this.businessObjectDefinitionService.updateSearchIndexDocumentBusinessObjectDefinition(searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getAllBusinessObjectDefinitionsByIds((List)Matchers.any());
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).createIndexDocuments((String)Matchers.any(), (String)Matchers.any(), (Map)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateSearchIndexDocumentBusinessObjectDefinitionCreateEmpty() throws Exception {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        ArrayList businessObjectDefinitionIds = new ArrayList();
        businessObjectDefinitionEntityList.forEach(businessObjectDefinitionEntity -> businessObjectDefinitionIds.add(businessObjectDefinitionEntity.getId()));
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("BDEF", businessObjectDefinitionIds, "CREATE");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.businessObjectDefinitionDao.getAllBusinessObjectDefinitionsByIds((List)Matchers.any())).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.jsonHelper.objectToJson(Matchers.any())).thenReturn((Object)"");
        this.businessObjectDefinitionService.updateSearchIndexDocumentBusinessObjectDefinition(searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getAllBusinessObjectDefinitionsByIds((List)Matchers.any());
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).createIndexDocuments((String)Matchers.eq((Object)SEARCH_INDEX_NAME), (String)Matchers.eq((Object)SEARCH_INDEX_DOCUMENT_TYPE), (Map)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateSearchIndexDocumentBusinessObjectDefinitionUpdate() throws Exception {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        ArrayList businessObjectDefinitionIds = new ArrayList();
        businessObjectDefinitionEntityList.forEach(businessObjectDefinitionEntity -> businessObjectDefinitionIds.add(businessObjectDefinitionEntity.getId()));
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("BDEF", businessObjectDefinitionIds, "UPDATE");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.businessObjectDefinitionDao.getAllBusinessObjectDefinitionsByIds((List)Matchers.any())).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.businessObjectDefinitionHelper.safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class))).thenReturn((Object)JSON_STRING);
        this.businessObjectDefinitionService.updateSearchIndexDocumentBusinessObjectDefinition(searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class));
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getAllBusinessObjectDefinitionsByIds((List)Matchers.any());
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).updateIndexDocuments((String)Matchers.eq((Object)SEARCH_INDEX_NAME), (String)Matchers.eq((Object)SEARCH_INDEX_DOCUMENT_TYPE), (Map)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateSearchIndexDocumentBusinessObjectDefinitionUpdateEmpty() throws Exception {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        ArrayList businessObjectDefinitionIds = new ArrayList();
        businessObjectDefinitionEntityList.forEach(businessObjectDefinitionEntity -> businessObjectDefinitionIds.add(businessObjectDefinitionEntity.getId()));
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("BDEF", businessObjectDefinitionIds, "UPDATE");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.businessObjectDefinitionDao.getAllBusinessObjectDefinitionsByIds((List)Matchers.any())).thenReturn(businessObjectDefinitionEntityList);
        Mockito.when((Object)this.jsonHelper.objectToJson(Matchers.any())).thenReturn((Object)"");
        this.businessObjectDefinitionService.updateSearchIndexDocumentBusinessObjectDefinition(searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper, (VerificationMode)Mockito.times((int)2))).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)Matchers.any(BusinessObjectDefinitionEntity.class));
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getAllBusinessObjectDefinitionsByIds((List)Matchers.any());
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).updateIndexDocuments((String)Matchers.eq((Object)SEARCH_INDEX_NAME), (String)Matchers.eq((Object)SEARCH_INDEX_DOCUMENT_TYPE), (Map)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateSearchIndexDocumentBusinessObjectDefinitionUpdateIdListSizeGreaterThanChunkSize() throws Exception {
        List<List> businessObjectDefinitionEntities = Arrays.asList(Collections.singletonList(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes())), Collections.singletonList(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE_2, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2())));
        ArrayList<Integer> businessObjectDefinitionIds = new ArrayList<Integer>();
        businessObjectDefinitionIds.addAll(Collections.nCopies(101, ID));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        Mockito.when((Object)this.businessObjectDefinitionDao.getAllBusinessObjectDefinitionsByIds(businessObjectDefinitionIds.subList(0, 100))).thenReturn((Object)businessObjectDefinitionEntities.get(0));
        Mockito.when((Object)this.businessObjectDefinitionDao.getAllBusinessObjectDefinitionsByIds(businessObjectDefinitionIds.subList(100, businessObjectDefinitionIds.size()))).thenReturn((Object)businessObjectDefinitionEntities.get(1));
        Mockito.when((Object)this.businessObjectDefinitionHelper.safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)businessObjectDefinitionEntities.get(0).get(0))).thenReturn((Object)JSON_STRING);
        Mockito.when((Object)this.businessObjectDefinitionHelper.safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)businessObjectDefinitionEntities.get(1).get(0))).thenReturn((Object)JSON_STRING);
        this.businessObjectDefinitionService.updateSearchIndexDocumentBusinessObjectDefinition(new SearchIndexUpdateDto("BDEF", businessObjectDefinitionIds, "UPDATE"));
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getAllBusinessObjectDefinitionsByIds(businessObjectDefinitionIds.subList(0, 100));
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getAllBusinessObjectDefinitionsByIds(businessObjectDefinitionIds.subList(100, businessObjectDefinitionIds.size()));
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper)).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)businessObjectDefinitionEntities.get(0).get(0));
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper)).safeObjectMapperWriteValueAsString((BusinessObjectDefinitionEntity)businessObjectDefinitionEntities.get(1).get(0));
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao, (VerificationMode)Mockito.times((int)2))).updateIndexDocuments((String)Matchers.eq((Object)SEARCH_INDEX_NAME), (String)Matchers.eq((Object)SEARCH_INDEX_DOCUMENT_TYPE), (Map)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateSearchIndexDocumentBusinessObjectDefinitionDelete() throws Exception {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        ArrayList businessObjectDefinitionIds = new ArrayList();
        businessObjectDefinitionEntityList.forEach(businessObjectDefinitionEntity -> businessObjectDefinitionIds.add(businessObjectDefinitionEntity.getId()));
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("BDEF", businessObjectDefinitionIds, "DELETE");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        this.businessObjectDefinitionService.updateSearchIndexDocumentBusinessObjectDefinition(searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).deleteIndexDocuments((String)Matchers.any(), (String)Matchers.any(), (List)Matchers.any());
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateSearchIndexDocumentBusinessObjectDefinitionUnknown() throws Exception {
        ArrayList<BusinessObjectDefinitionEntity> businessObjectDefinitionEntityList = new ArrayList<BusinessObjectDefinitionEntity>();
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        businessObjectDefinitionEntityList.add(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(NAMESPACE, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()));
        ArrayList businessObjectDefinitionIds = new ArrayList();
        businessObjectDefinitionEntityList.forEach(businessObjectDefinitionEntity -> businessObjectDefinitionIds.add(businessObjectDefinitionEntity.getId()));
        SearchIndexUpdateDto searchIndexUpdateDto = new SearchIndexUpdateDto("BDEF", businessObjectDefinitionIds, "UNKNOWN");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class)).thenReturn((Object)SEARCH_INDEX_DOCUMENT_TYPE);
        this.businessObjectDefinitionService.updateSearchIndexDocumentBusinessObjectDefinition(searchIndexUpdateDto);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_INDEX_NAME, String.class);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.ELASTICSEARCH_BDEF_DOCUMENT_TYPE, String.class);
        this.verifyNoMoreInteractionsHelper();
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDefinitionDao, this.businessObjectDefinitionHelper, this.businessObjectDefinitionIndexSearchDao, this.configurationDaoHelper, this.configurationHelper, this.indexFunctionsDao, this.jsonHelper, this.tagDaoHelper, this.tagHelper});
    }
}

