/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.dao.DataProviderDaoTestHelper;
import org.finra.herd.dao.NamespaceDaoTestHelper;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.BusinessObjectDefinition;
import org.finra.herd.model.api.xml.SampleDataFile;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.jpa.BusinessObjectDefinitionEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.jsoup.Jsoup;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BusinessObjectDefinitionServiceTestHelper {
    @Autowired
    private DataProviderDaoTestHelper dataProviderDaoTestHelper;
    @Autowired
    private NamespaceDaoTestHelper namespaceDaoTestHelper;
    @Autowired
    private ConfigurationHelper configurationHelper;

    public void createDatabaseEntitiesForBusinessObjectDefinitionTesting() {
        this.createDatabaseEntitiesForBusinessObjectDefinitionTesting(AbstractServiceTest.NAMESPACE, AbstractServiceTest.DATA_PROVIDER_NAME);
    }

    public void createDatabaseEntitiesForBusinessObjectDefinitionTesting(String namespaceCode, String dataProviderName) {
        this.namespaceDaoTestHelper.createNamespaceEntity(namespaceCode);
        this.dataProviderDaoTestHelper.createDataProviderEntity(dataProviderName);
    }

    public BusinessObjectDefinition createBusinessObjectDefinitionFromEntityForSearchTesting(BusinessObjectDefinitionEntity businessObjectDefinitionEntity) {
        BusinessObjectDefinition businessObjectDefinition = new BusinessObjectDefinition();
        businessObjectDefinition.setNamespace(businessObjectDefinitionEntity.getNamespace().getCode());
        businessObjectDefinition.setBusinessObjectDefinitionName(businessObjectDefinitionEntity.getName());
        businessObjectDefinition.setDataProviderName(businessObjectDefinitionEntity.getDataProvider().getName());
        businessObjectDefinition.setDisplayName(businessObjectDefinitionEntity.getDisplayName());
        String toParse = businessObjectDefinitionEntity.getDescription() != null ? businessObjectDefinitionEntity.getDescription() : "";
        businessObjectDefinition.setShortDescription(StringUtils.left((String)Jsoup.parseBodyFragment((String)toParse).body().text(), (int)((Integer)this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_DEFINITION_SHORT_DESCRIPTION_LENGTH, Integer.class))));
        return businessObjectDefinition;
    }

    public String getExpectedBusinessObjectDefinitionKeyAsString(String namespace, String businessObjectDefinitionName) {
        return String.format("namespace: \"%s\", businessObjectDefinitionName: \"%s\"", namespace, businessObjectDefinitionName);
    }

    public String getExpectedBusinessObjectDefinitionNotFoundErrorMessage(String namespace, String businessObjectDefinitionName) {
        return String.format("Business object definition with name \"%s\" doesn't exist for namespace \"%s\".", businessObjectDefinitionName, namespace);
    }

    public List<Attribute> getNewAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("Attribute Name 1", "Attribute Value 1"));
        attributes.add(new Attribute("Attribute Name 2", "   Attribute Value 2  "));
        attributes.add(new Attribute("Attribute Name 3", "Attribute Value 3"));
        return attributes;
    }

    public List<Attribute> getNewAttributes2() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("Attribute Name 1", "Attribute Value 1 Updated"));
        attributes.add(new Attribute("Attribute Name 3", "Attribute Value 3"));
        attributes.add(new Attribute("Attribute Name 4", "Attribute Value 4"));
        return attributes;
    }

    public List<SampleDataFile> getTestSampleDataFiles() {
        ArrayList<SampleDataFile> sampleDataFiles = new ArrayList<SampleDataFile>();
        sampleDataFiles.add(new SampleDataFile(AbstractServiceTest.DIRECTORY_PATH, AbstractServiceTest.FILE_NAME));
        sampleDataFiles.add(new SampleDataFile(AbstractServiceTest.DIRECTORY_PATH, AbstractServiceTest.FILE_NAME_2));
        return sampleDataFiles;
    }

    public void validateAttributes(List<Attribute> expectedAttributes, List<Attribute> actualAttributes) {
        Assert.assertEquals((long)expectedAttributes.size(), (long)actualAttributes.size());
        for (int i = 0; i < expectedAttributes.size(); ++i) {
            Attribute expectedAttribute = expectedAttributes.get(i);
            Attribute actualAttribute = actualAttributes.get(i);
            Assert.assertEquals((Object)expectedAttribute.getName(), (Object)actualAttribute.getName());
            Assert.assertEquals((Object)expectedAttribute.getValue(), (Object)actualAttribute.getValue());
        }
    }
}

