/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.finra.herd.core.HerdDateUtils;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.BusinessObjectDataAttributeKey;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageUnitKey;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.jpa.BusinessObjectDataAttributeEntity;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.model.jpa.StorageFileEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class CleanupDestroyedBusinessObjectDataServiceImplTest
extends AbstractServiceTest {
    @Test
    public void testCleanupS3StorageUnit() {
        BusinessObjectDataStorageUnitKey businessObjectDataStorageUnitKey = this.createDatabaseEntitiesForCleanupDestroyedBusinessObjectDataTesting();
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.createBusinessObjectDataKeyFromStorageUnitKey(businessObjectDataStorageUnitKey);
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey);
        MatcherAssert.assertThat((String)"The business object data entity is null.", (Object)businessObjectDataEntity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        BusinessObjectDataAttributeKey businessObjectDataAttributeKey = this.businessObjectDataAttributeHelper.getBusinessObjectDataAttributeKey(businessObjectDataKey, ATTRIBUTE_NAME);
        MatcherAssert.assertThat((String)"The business object data attribute key is null.", (Object)businessObjectDataAttributeKey, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((String)"The business object data entity attributes size is not correct.", (Object)businessObjectDataEntity.getAttributes().size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
        BusinessObjectDataAttributeEntity businessObjectDataAttributeEntity = this.businessObjectDataAttributeDao.getBusinessObjectDataAttributeByKey(businessObjectDataAttributeKey);
        MatcherAssert.assertThat((String)"The business object data attribute entity is null.", (Object)businessObjectDataAttributeEntity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoHelper.getStorageUnitEntityByKey(businessObjectDataStorageUnitKey);
        MatcherAssert.assertThat((String)"The storage unit entity is null.", (Object)storageUnitEntity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        StorageFileEntity storageFileEntity = this.storageFileDao.getStorageFileByStorageNameAndFilePath(STORAGE_NAME, STORAGE_DIRECTORY_PATH);
        MatcherAssert.assertThat((String)"The storage file entity is null.", (Object)storageFileEntity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Collection businessObjectDataStatusHistoryEntities = businessObjectDataEntity.getHistoricalStatuses();
        MatcherAssert.assertThat((String)"The business object data status history entities size is not correct.", (Object)businessObjectDataStatusHistoryEntities.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
        MatcherAssert.assertThat((String)"The business object data children size is not correct.", (Object)businessObjectDataEntity.getBusinessObjectDataChildren().size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
        BusinessObjectDataEntity businessObjectDataEntityChild = (BusinessObjectDataEntity)businessObjectDataEntity.getBusinessObjectDataChildren().get(0);
        MatcherAssert.assertThat((String)"The business object data children is not correct.", businessObjectDataEntityChild.getBusinessObjectDataParents().get(0), (Matcher)CoreMatchers.is((Object)businessObjectDataEntity));
        MatcherAssert.assertThat((String)"The business object data parents size is not correct.", (Object)businessObjectDataEntity.getBusinessObjectDataParents().size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
        MatcherAssert.assertThat(businessObjectDataEntityChild.getBusinessObjectDataParents().get(0), (Matcher)CoreMatchers.is((Object)businessObjectDataEntity));
        BusinessObjectDataEntity businessObjectDataEntityParent = (BusinessObjectDataEntity)businessObjectDataEntity.getBusinessObjectDataParents().get(0);
        MatcherAssert.assertThat((String)"The business object data parent is not correct.", businessObjectDataEntityParent.getBusinessObjectDataChildren().get(0), (Matcher)CoreMatchers.is((Object)businessObjectDataEntity));
        this.cleanupDestroyedBusinessObjectDataService.cleanupS3StorageUnit(businessObjectDataStorageUnitKey);
        businessObjectDataEntity = this.businessObjectDataDao.getBusinessObjectDataByAltKey(businessObjectDataKey);
        MatcherAssert.assertThat((String)"The business object data entity is not null.", (Object)businessObjectDataEntity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        businessObjectDataAttributeEntity = this.businessObjectDataAttributeDao.getBusinessObjectDataAttributeByKey(businessObjectDataAttributeKey);
        MatcherAssert.assertThat((String)"The business object data attribute entity is not null.", (Object)businessObjectDataAttributeEntity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        storageUnitEntity = this.storageUnitDao.getStorageUnitByKey(businessObjectDataStorageUnitKey);
        MatcherAssert.assertThat((String)"The storage unit entity is not null.", (Object)storageUnitEntity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        storageFileEntity = this.storageFileDao.getStorageFileByStorageNameAndFilePath(STORAGE_NAME, STORAGE_DIRECTORY_PATH);
        MatcherAssert.assertThat((String)"The storage file entity is not null.", (Object)storageFileEntity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        businessObjectDataEntityChild = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.createBusinessObjectDataKeyFromEntity(businessObjectDataEntityChild));
        MatcherAssert.assertThat((String)"The business object data children size is not correct.", (Object)businessObjectDataEntityChild.getBusinessObjectDataParents().size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
        businessObjectDataEntityParent = this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(this.businessObjectDataHelper.createBusinessObjectDataKeyFromEntity(businessObjectDataEntityParent));
        MatcherAssert.assertThat((String)"The business object data parents size is not correct.", (Object)businessObjectDataEntityParent.getBusinessObjectDataChildren().size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
    }

    @Test
    public void testGetS3StorageUnitsToCleanup() {
        ArrayList<BusinessObjectDataKey> businessObjectDataKeys = new ArrayList<BusinessObjectDataKey>();
        for (int i = 0; i < 7; ++i) {
            businessObjectDataKeys.add(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, Integer.toString(i), SUBPARTITION_VALUES, DATA_VERSION));
        }
        ArrayList storageUnitEntities = Lists.newArrayList();
        storageUnitEntities.add(this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, "S3", (BusinessObjectDataKey)businessObjectDataKeys.get(0), LATEST_VERSION_FLAG_SET, "DELETED", "DISABLED", NO_STORAGE_DIRECTORY_PATH));
        storageUnitEntities.add(this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, "S3", (BusinessObjectDataKey)businessObjectDataKeys.get(1), LATEST_VERSION_FLAG_SET, "DELETED", "DISABLED", NO_STORAGE_DIRECTORY_PATH));
        storageUnitEntities.add(this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, "S3", (BusinessObjectDataKey)businessObjectDataKeys.get(2), LATEST_VERSION_FLAG_SET, "DELETED", "DISABLED", NO_STORAGE_DIRECTORY_PATH));
        storageUnitEntities.add(this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME_2, "S3", (BusinessObjectDataKey)businessObjectDataKeys.get(3), LATEST_VERSION_FLAG_SET, "DELETED", "DISABLED", NO_STORAGE_DIRECTORY_PATH));
        storageUnitEntities.add(this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, "S3", (BusinessObjectDataKey)businessObjectDataKeys.get(4), LATEST_VERSION_FLAG_SET, "ARCHIVED", "DISABLED", NO_STORAGE_DIRECTORY_PATH));
        storageUnitEntities.add(this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME, "S3", (BusinessObjectDataKey)businessObjectDataKeys.get(5), LATEST_VERSION_FLAG_SET, "DELETED", "ARCHIVED", NO_STORAGE_DIRECTORY_PATH));
        storageUnitEntities.add(this.storageUnitDaoTestHelper.createStorageUnitEntity(STORAGE_NAME_3, "strge_pltfm", (BusinessObjectDataKey)businessObjectDataKeys.get(6), LATEST_VERSION_FLAG_SET, "DELETED", "DISABLED", NO_STORAGE_DIRECTORY_PATH));
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        ((StorageUnitEntity)storageUnitEntities.get(0)).setFinalDestroyOn(null);
        ((StorageUnitEntity)storageUnitEntities.get(1)).setFinalDestroyOn(HerdDateUtils.addDays((Timestamp)currentTime, (int)1));
        ((StorageUnitEntity)storageUnitEntities.get(2)).setFinalDestroyOn(HerdDateUtils.addDays((Timestamp)currentTime, (int)-1));
        ((StorageUnitEntity)storageUnitEntities.get(3)).setFinalDestroyOn(HerdDateUtils.addDays((Timestamp)currentTime, (int)-2));
        ((StorageUnitEntity)storageUnitEntities.get(4)).setFinalDestroyOn(HerdDateUtils.addDays((Timestamp)currentTime, (int)-2));
        ((StorageUnitEntity)storageUnitEntities.get(5)).setFinalDestroyOn(HerdDateUtils.addDays((Timestamp)currentTime, (int)-2));
        ((StorageUnitEntity)storageUnitEntities.get(6)).setFinalDestroyOn(HerdDateUtils.addDays((Timestamp)currentTime, (int)-2));
        List result = this.cleanupDestroyedBusinessObjectDataService.getS3StorageUnitsToCleanup(MAX_RESULT.intValue());
        BusinessObjectDataStorageUnitKey businessObjectDataStorageUnitKey3 = this.storageUnitHelper.createStorageUnitKeyFromEntity((StorageUnitEntity)storageUnitEntities.get(3));
        BusinessObjectDataStorageUnitKey businessObjectDataStorageUnitKey2 = this.storageUnitHelper.createStorageUnitKeyFromEntity((StorageUnitEntity)storageUnitEntities.get(2));
        Assert.assertEquals(Arrays.asList(businessObjectDataStorageUnitKey3, businessObjectDataStorageUnitKey2), (Object)result);
        result = this.cleanupDestroyedBusinessObjectDataService.getS3StorageUnitsToCleanup(1);
        Assert.assertEquals(Collections.singletonList(businessObjectDataStorageUnitKey3), (Object)result);
    }

    public BusinessObjectDataStorageUnitKey createDatabaseEntitiesForCleanupDestroyedBusinessObjectDataTesting() {
        List columns = this.schemaColumnDaoTestHelper.getTestSchemaColumns();
        List partitionColumns = this.schemaColumnDaoTestHelper.getTestPartitionColumns();
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, LATEST_VERSION_FLAG_SET, PARTITION_KEY, PARTITION_KEY_GROUP, NO_ATTRIBUTES, ",", "\\", "\\N", columns, partitionColumns);
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_KEY_PREFIX_VELOCITY_TEMPLATE), "$namespace/$dataProviderName/$businessObjectFormatUsage/$businessObjectFormatFileType/$businessObjectDefinitionName/schm-v$businessObjectFormatVersion/data-v$businessObjectDataVersion/$businessObjectFormatPartitionKey=$businessObjectDataPartitionValue#if($CollectionUtils.isNotEmpty($businessObjectDataSubPartitions.keySet()))#foreach($subPartitionKey in $businessObjectDataSubPartitions.keySet())/$subPartitionKey=$businessObjectDataSubPartitions.get($subPartitionKey)#end#end")));
        BusinessObjectDataEntity businessObjectDataEntityParent = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME_3, FORMAT_USAGE_CODE_3, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE_3, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID");
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "DELETED", (List)Lists.newArrayList((Object[])new BusinessObjectDataEntity[]{businessObjectDataEntityParent}));
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME_2, FORMAT_USAGE_CODE_2, FORMAT_FILE_TYPE_CODE_2, FORMAT_VERSION_2, PARTITION_VALUE_2, SUBPARTITION_VALUES_2, DATA_VERSION_2, LATEST_VERSION_FLAG_SET, "VALID", (List)Lists.newArrayList((Object[])new BusinessObjectDataEntity[]{businessObjectDataEntity}));
        this.businessObjectDataAttributeDaoTestHelper.createBusinessObjectDataAttributeEntity(businessObjectDataEntity, ATTRIBUTE_NAME, ATTRIBUTE_VALUE);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntity, businessObjectDataEntity, "DISABLED", STORAGE_DIRECTORY_PATH);
        this.storageFileDaoTestHelper.createStorageFileEntity(storageUnitEntity, STORAGE_DIRECTORY_PATH, FILE_SIZE, ROW_COUNT);
        return this.storageUnitHelper.createStorageUnitKeyFromEntity(storageUnitEntity);
    }
}

