/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.DataProvider;
import org.finra.herd.model.api.xml.DataProviderCreateRequest;
import org.finra.herd.model.api.xml.DataProviderKey;
import org.finra.herd.model.api.xml.DataProviderKeys;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class DataProviderServiceTest
extends AbstractServiceTest {
    @Test
    public void testCreateDataProvider() throws Exception {
        DataProvider resultDataProvider = this.dataProviderService.createDataProvider(new DataProviderCreateRequest(DATA_PROVIDER_NAME));
        Assert.assertEquals((Object)new DataProvider(DATA_PROVIDER_NAME), (Object)resultDataProvider);
    }

    @Test
    public void testCreateDataProviderMissingRequiredParameters() {
        try {
            this.dataProviderService.createDataProvider(new DataProviderCreateRequest("      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when data provider name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A data provider name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateDataProviderTrimParameters() {
        DataProvider resultDataProvider = this.dataProviderService.createDataProvider(new DataProviderCreateRequest(this.addWhitespace(DATA_PROVIDER_NAME)));
        Assert.assertEquals((Object)new DataProvider(DATA_PROVIDER_NAME), (Object)resultDataProvider);
    }

    @Test
    public void testCreateDataProviderUpperCaseParameters() {
        DataProvider resultDataProvider = this.dataProviderService.createDataProvider(new DataProviderCreateRequest(DATA_PROVIDER_NAME.toUpperCase()));
        Assert.assertEquals((Object)new DataProvider(DATA_PROVIDER_NAME.toUpperCase()), (Object)resultDataProvider);
    }

    @Test
    public void testCreateDataProviderLowerCaseParameters() {
        DataProvider resultDataProvider = this.dataProviderService.createDataProvider(new DataProviderCreateRequest(DATA_PROVIDER_NAME.toLowerCase()));
        Assert.assertEquals((Object)new DataProvider(DATA_PROVIDER_NAME.toLowerCase()), (Object)resultDataProvider);
    }

    @Test
    public void testCreateDataProviderInvalidParameters() {
        try {
            this.dataProviderService.createDataProvider(new DataProviderCreateRequest(this.addSlash(DATA_PROVIDER_NAME)));
            Assert.fail((String)"Should throw an IllegalArgumentException when data provider name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Data provider name can not contain a forward slash character.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateDataProviderAlreadyExists() throws Exception {
        this.dataProviderDaoTestHelper.createDataProviderEntity(DATA_PROVIDER_NAME);
        try {
            this.dataProviderService.createDataProvider(new DataProviderCreateRequest(DATA_PROVIDER_NAME));
            Assert.fail((String)"Should throw an AlreadyExistsException when data provider already exists.");
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Unable to create data provider \"%s\" because it already exists.", DATA_PROVIDER_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetDataProvider() throws Exception {
        this.dataProviderDaoTestHelper.createDataProviderEntity(DATA_PROVIDER_NAME);
        DataProvider resultDataProvider = this.dataProviderService.getDataProvider(new DataProviderKey(DATA_PROVIDER_NAME));
        Assert.assertEquals((Object)new DataProvider(DATA_PROVIDER_NAME), (Object)resultDataProvider);
    }

    @Test
    public void testGetDataProviderMissingRequiredParameters() {
        try {
            this.dataProviderService.getDataProvider(new DataProviderKey("      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when data provider name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A data provider name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetDataProviderTrimParameters() {
        this.dataProviderDaoTestHelper.createDataProviderEntity(DATA_PROVIDER_NAME);
        DataProvider resultDataProvider = this.dataProviderService.getDataProvider(new DataProviderKey(this.addWhitespace(DATA_PROVIDER_NAME)));
        Assert.assertEquals((Object)new DataProvider(DATA_PROVIDER_NAME), (Object)resultDataProvider);
    }

    @Test
    public void testGetDataProviderUpperCaseParameters() {
        this.dataProviderDaoTestHelper.createDataProviderEntity(DATA_PROVIDER_NAME);
        DataProvider resultDataProvider = this.dataProviderService.getDataProvider(new DataProviderKey(DATA_PROVIDER_NAME.toUpperCase()));
        Assert.assertEquals((Object)new DataProvider(DATA_PROVIDER_NAME), (Object)resultDataProvider);
    }

    @Test
    public void testGetDataProviderLowerCaseParameters() {
        this.dataProviderDaoTestHelper.createDataProviderEntity(DATA_PROVIDER_NAME);
        DataProvider resultDataProvider = this.dataProviderService.getDataProvider(new DataProviderKey(DATA_PROVIDER_NAME.toLowerCase()));
        Assert.assertEquals((Object)new DataProvider(DATA_PROVIDER_NAME), (Object)resultDataProvider);
    }

    @Test
    public void testGetDataProviderNoExists() throws Exception {
        try {
            this.dataProviderService.getDataProvider(new DataProviderKey(DATA_PROVIDER_NAME));
            Assert.fail((String)"Should throw an ObjectNotFoundException when data provider doesn't exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Data provider with name \"%s\" doesn't exist.", DATA_PROVIDER_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteDataProvider() throws Exception {
        DataProviderKey dataProviderKey = new DataProviderKey(DATA_PROVIDER_NAME);
        this.dataProviderDaoTestHelper.createDataProviderEntity(DATA_PROVIDER_NAME);
        Assert.assertNotNull((Object)this.dataProviderDao.getDataProviderByKey(dataProviderKey));
        DataProvider deletedDataProvider = this.dataProviderService.deleteDataProvider(new DataProviderKey(DATA_PROVIDER_NAME));
        Assert.assertEquals((Object)new DataProvider(DATA_PROVIDER_NAME), (Object)deletedDataProvider);
        Assert.assertNull((Object)this.dataProviderDao.getDataProviderByKey(dataProviderKey));
    }

    @Test
    public void testDeleteDataProviderMissingRequiredParameters() {
        try {
            this.dataProviderService.deleteDataProvider(new DataProviderKey("      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when data provider name is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A data provider name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteDataProviderTrimParameters() {
        DataProviderKey dataProviderKey = new DataProviderKey(DATA_PROVIDER_NAME);
        this.dataProviderDaoTestHelper.createDataProviderEntity(DATA_PROVIDER_NAME);
        Assert.assertNotNull((Object)this.dataProviderDao.getDataProviderByKey(dataProviderKey));
        DataProvider deletedDataProvider = this.dataProviderService.deleteDataProvider(new DataProviderKey(this.addWhitespace(DATA_PROVIDER_NAME)));
        Assert.assertEquals((Object)new DataProvider(DATA_PROVIDER_NAME), (Object)deletedDataProvider);
        Assert.assertNull((Object)this.dataProviderDao.getDataProviderByKey(dataProviderKey));
    }

    @Test
    public void testDeleteDataProviderUpperCaseParameters() {
        DataProviderKey dataProviderKey = new DataProviderKey(DATA_PROVIDER_NAME);
        this.dataProviderDaoTestHelper.createDataProviderEntity(DATA_PROVIDER_NAME);
        Assert.assertNotNull((Object)this.dataProviderDao.getDataProviderByKey(dataProviderKey));
        DataProvider deletedDataProvider = this.dataProviderService.deleteDataProvider(new DataProviderKey(DATA_PROVIDER_NAME.toUpperCase()));
        Assert.assertEquals((Object)new DataProvider(DATA_PROVIDER_NAME), (Object)deletedDataProvider);
        Assert.assertNull((Object)this.dataProviderDao.getDataProviderByKey(dataProviderKey));
    }

    @Test
    public void testDeleteDataProviderLowerCaseParameters() {
        DataProviderKey dataProviderKey = new DataProviderKey(DATA_PROVIDER_NAME);
        this.dataProviderDaoTestHelper.createDataProviderEntity(DATA_PROVIDER_NAME);
        Assert.assertNotNull((Object)this.dataProviderDao.getDataProviderByKey(dataProviderKey));
        DataProvider deletedDataProvider = this.dataProviderService.deleteDataProvider(new DataProviderKey(DATA_PROVIDER_NAME.toLowerCase()));
        Assert.assertEquals((Object)new DataProvider(DATA_PROVIDER_NAME), (Object)deletedDataProvider);
        Assert.assertNull((Object)this.dataProviderDao.getDataProviderByKey(dataProviderKey));
    }

    @Test
    public void testDeleteDataProviderNoExists() throws Exception {
        try {
            this.dataProviderService.deleteDataProvider(new DataProviderKey(DATA_PROVIDER_NAME));
            Assert.fail((String)"Should throw an ObjectNotFoundException when data provider doesn't exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Data provider with name \"%s\" doesn't exist.", DATA_PROVIDER_NAME), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetDataProviders() throws Exception {
        for (DataProviderKey key : DATA_PROVIDER_KEYS) {
            this.dataProviderDaoTestHelper.createDataProviderEntity(key.getDataProviderName());
        }
        DataProviderKeys resultDataProviderKeys = this.dataProviderService.getDataProviders();
        Assert.assertEquals((Object)DATA_PROVIDER_KEYS, (Object)resultDataProviderKeys.getDataProviderKeys());
    }
}

