/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.finra.herd.dao.impl.MockAwsOperationsHelper;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.EmrCluster;
import org.finra.herd.model.api.xml.EmrClusterCreateRequest;
import org.finra.herd.model.api.xml.EmrClusterDefinition;
import org.finra.herd.model.api.xml.EmrHadoopJarStepAddRequest;
import org.finra.herd.model.api.xml.EmrHiveStepAddRequest;
import org.finra.herd.model.api.xml.EmrMasterSecurityGroup;
import org.finra.herd.model.api.xml.EmrMasterSecurityGroupAddRequest;
import org.finra.herd.model.api.xml.EmrPigStepAddRequest;
import org.finra.herd.model.api.xml.EmrShellStepAddRequest;
import org.finra.herd.model.dto.EmrClusterAlternateKeyDto;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.service.EmrServiceTest;
import org.finra.herd.service.helper.EmrStepHelper;
import org.junit.Assert;
import org.junit.Test;

public class EmrServiceWithAccountIdTest
extends EmrServiceTest {
    @Override
    @Test
    public void testAddSecurityGroup() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.trustingAccountDaoTestHelper.createTrustingAccountEntity(AWS_ACCOUNT_ID, AWS_ROLE_ARN);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequestWithAccountId();
        this.emrService.createCluster(request);
        EmrMasterSecurityGroupAddRequest emrMasterSecurityGroupAddRequest = this.getNewEmrAddSecurityGroupMasterRequestWithAccountId(request.getEmrClusterName());
        EmrMasterSecurityGroup emrMasterSecurityGroup = this.emrService.addSecurityGroupsToClusterMaster(emrMasterSecurityGroupAddRequest);
        Assert.assertNotNull((Object)emrMasterSecurityGroup);
        Assert.assertTrue((boolean)emrMasterSecurityGroup.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrMasterSecurityGroup.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrMasterSecurityGroup.getEmrClusterName().equals(request.getEmrClusterName()));
    }

    @Test
    public void testCreateEmrClusterWithAccountId() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.trustingAccountDaoTestHelper.createTrustingAccountEntity(AWS_ACCOUNT_ID, AWS_ROLE_ARN);
        String definitionXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition expectedEmrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, definitionXml);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, definitionXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequestWithAccountId();
        EmrClusterDefinition emrClusterDefinitionOverride = new EmrClusterDefinition();
        request.setEmrClusterDefinitionOverride(emrClusterDefinitionOverride);
        emrClusterDefinitionOverride.setAccountId(AWS_ACCOUNT_ID);
        EmrCluster emrCluster = this.emrService.createCluster(request);
        expectedEmrClusterDefinition.setAccountId(AWS_ACCOUNT_ID);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(request.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(request.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(request.getEmrClusterName()));
        Assert.assertEquals((Object)AWS_ACCOUNT_ID, (Object)emrCluster.getAccountId());
        Assert.assertNotNull((Object)emrCluster.getId());
        Assert.assertNull((Object)emrCluster.isDryRun());
        Assert.assertNotNull((Object)emrCluster.getEmrClusterDefinition());
        Assert.assertTrue((boolean)emrCluster.isEmrClusterCreated());
        Assert.assertEquals((Object)expectedEmrClusterDefinition, (Object)emrCluster.getEmrClusterDefinition());
        this.validateEmrClusterCreationLogUnique(emrCluster, expectedEmrClusterDefinition);
    }

    @Test
    public void testCreateEmrClusterWithAccountIdAccountNoExists() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String definitionXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition expectedEmrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, definitionXml);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, definitionXml);
        EmrClusterCreateRequest emrClusterCreateRequest = this.getNewEmrClusterCreateRequestWithAccountId();
        EmrClusterDefinition emrClusterDefinitionOverride = new EmrClusterDefinition();
        emrClusterCreateRequest.setEmrClusterDefinitionOverride(emrClusterDefinitionOverride);
        emrClusterDefinitionOverride.setAccountId(AWS_ACCOUNT_ID);
        try {
            this.emrService.createCluster(emrClusterCreateRequest);
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Trusting AWS account with id \"%s\" doesn't exist.", AWS_ACCOUNT_ID), (Object)e.getMessage());
        }
    }

    @Override
    @Test
    public void testEmrAddStepsAllTypes() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.trustingAccountDaoTestHelper.createTrustingAccountEntity(AWS_ACCOUNT_ID, AWS_ROLE_ARN);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequestWithAccountId();
        this.emrService.createCluster(request);
        ArrayList<Object> emrSteps = new ArrayList<Object>();
        ArrayList<String> shellScriptArgs = new ArrayList<String>();
        shellScriptArgs.add("Hello");
        shellScriptArgs.add("herd");
        shellScriptArgs.add("How Are You");
        EmrShellStepAddRequest shellStepRequest = new EmrShellStepAddRequest();
        shellStepRequest.setScriptLocation("s3://test-bucket-managed/app-a/test/test_script.sh");
        shellStepRequest.setStepName("Test Shell Script");
        shellStepRequest.setScriptArguments(shellScriptArgs);
        emrSteps.add(shellStepRequest);
        EmrHiveStepAddRequest hiveStepRequest = new EmrHiveStepAddRequest();
        ArrayList<String> scriptArgs1 = new ArrayList<String>();
        scriptArgs1.add("arg2=sampleArg");
        scriptArgs1.add("arg1=tables");
        hiveStepRequest.setStepName("Test Hive");
        hiveStepRequest.setScriptLocation("s3://test-bucket-managed/app-a/test/test_hive.hql");
        hiveStepRequest.setScriptArguments(scriptArgs1);
        emrSteps.add(hiveStepRequest);
        EmrPigStepAddRequest pigStepRequest = new EmrPigStepAddRequest();
        pigStepRequest.setStepName("Test Pig");
        pigStepRequest.setScriptArguments(shellScriptArgs);
        pigStepRequest.setScriptLocation("s3://test-bucket-managed/app-a/test/test_pig.pig");
        emrSteps.add(pigStepRequest);
        shellStepRequest = new EmrShellStepAddRequest();
        shellStepRequest.setScriptLocation("s3://test-bucket-managed/app-a/bootstrap/install_oozie.sh");
        shellStepRequest.setStepName("Install Oozie");
        ArrayList<String> shellScriptArgsOozie = new ArrayList<String>();
        shellScriptArgsOozie.add("s3://test-bucket-managed/app-a/bootstrap/oozie-4.0.1-distro.tar");
        shellStepRequest.setScriptArguments(shellScriptArgsOozie);
        emrSteps.add(shellStepRequest);
        EmrHadoopJarStepAddRequest hadoopJarStepRequest = new EmrHadoopJarStepAddRequest();
        ArrayList<String> scriptArgs2 = new ArrayList<String>();
        scriptArgs2.add("oozie_run");
        scriptArgs2.add("wordcountOutput");
        hadoopJarStepRequest.setStepName("Hadoop Jar");
        hadoopJarStepRequest.setJarLocation("s3://test-bucket-managed/app-a/test/hadoop-mapreduce-examples-2.4.0.jar");
        hadoopJarStepRequest.setMainClass("wordcount");
        hadoopJarStepRequest.setScriptArguments(scriptArgs2);
        emrSteps.add(hadoopJarStepRequest);
        for (Object e : emrSteps) {
            EmrStepHelper stepHelper = this.emrStepHelperFactory.getStepHelper(e.getClass().getName());
            stepHelper.setRequestNamespace(e, NAMESPACE);
            stepHelper.setRequestEmrClusterDefinitionName(e, EMR_CLUSTER_DEFINITION_NAME);
            stepHelper.setRequestEmrClusterName(e, request.getEmrClusterName());
            stepHelper.setRequestAccountId(e, AWS_ACCOUNT_ID);
            Object emrStep = this.emrService.addStepToCluster(e);
            Assert.assertNotNull((Object)emrStep);
            Assert.assertNotNull((Object)stepHelper.getStepId(emrStep));
            Method getNameMethod = emrStep.getClass().getMethod("getStepName", new Class[0]);
            String emrStepName = (String)getNameMethod.invoke(emrStep, new Object[0]);
            Assert.assertEquals((Object)stepHelper.getRequestStepName(e), (Object)emrStepName);
            Method isContinueOnErrorMethod = emrStep.getClass().getMethod("isContinueOnError", new Class[0]);
            Object emrStepIsContinueOnError = isContinueOnErrorMethod.invoke(emrStep, new Object[0]);
            Assert.assertEquals((Object)stepHelper.isRequestContinueOnError(e), (Object)emrStepIsContinueOnError);
        }
    }

    @Override
    @Test
    public void testGetEmrClusterById() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.trustingAccountDaoTestHelper.createTrustingAccountEntity(AWS_ACCOUNT_ID, AWS_ROLE_ARN);
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinitionMinimal.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        emrClusterDefinition.setAmiVersion(MockAwsOperationsHelper.AMAZON_CLUSTER_STATUS_WAITING);
        configXml = this.xmlHelper.objectToXml((Object)emrClusterDefinition);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, configXml);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequestWithAccountId();
        EmrCluster emrCluster = this.emrService.createCluster(request);
        EmrClusterAlternateKeyDto emrClusterAlternateKeyDto = EmrClusterAlternateKeyDto.builder().withNamespace(NAMESPACE).withEmrClusterDefinitionName(EMR_CLUSTER_DEFINITION_NAME).withEmrClusterName(request.getEmrClusterName()).build();
        EmrCluster emrClusterGet = this.emrService.getCluster(emrClusterAlternateKeyDto, emrCluster.getId(), null, true, AWS_ACCOUNT_ID, Boolean.valueOf(false));
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertNotNull((Object)emrClusterGet);
        Assert.assertTrue((boolean)emrCluster.getId().equals(emrClusterGet.getId()));
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(emrClusterGet.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(emrClusterGet.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(emrClusterGet.getEmrClusterName()));
        Assert.assertEquals((Object)emrCluster.getEmrClusterDefinition().getAccountId(), (Object)AWS_ACCOUNT_ID);
        Assert.assertEquals((Object)AWS_ACCOUNT_ID, (Object)emrCluster.getAccountId());
        this.emrService.terminateCluster(emrClusterAlternateKeyDto, true, null, AWS_ACCOUNT_ID);
        emrClusterGet = this.emrService.getCluster(emrClusterAlternateKeyDto, emrCluster.getId(), null, true, AWS_ACCOUNT_ID, Boolean.valueOf(false));
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertNotNull((Object)emrClusterGet);
        Assert.assertTrue((boolean)emrCluster.getId().equals(emrClusterGet.getId()));
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(emrClusterGet.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(emrClusterGet.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(emrClusterGet.getEmrClusterName()));
        Assert.assertEquals((Object)emrCluster.getEmrClusterDefinition().getAccountId(), (Object)AWS_ACCOUNT_ID);
    }

    @Override
    @Test
    public void testTerminateEmrCluster() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        this.trustingAccountDaoTestHelper.createTrustingAccountEntity(AWS_ACCOUNT_ID, AWS_ROLE_ARN);
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequestWithAccountId();
        EmrCluster emrCluster = this.emrService.createCluster(request);
        EmrClusterAlternateKeyDto emrClusterAlternateKeyDto = EmrClusterAlternateKeyDto.builder().withNamespace(NAMESPACE).withEmrClusterDefinitionName(EMR_CLUSTER_DEFINITION_NAME).withEmrClusterName(request.getEmrClusterName()).build();
        EmrCluster emrClusterTerminated = this.emrService.terminateCluster(emrClusterAlternateKeyDto, true, null, null);
        Assert.assertNotNull((Object)emrCluster);
        Assert.assertNotNull((Object)emrClusterTerminated);
        Assert.assertTrue((boolean)emrCluster.getNamespace().equals(emrClusterTerminated.getNamespace()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterDefinitionName().equals(emrClusterTerminated.getEmrClusterDefinitionName()));
        Assert.assertTrue((boolean)emrCluster.getEmrClusterName().equals(emrClusterTerminated.getEmrClusterName()));
        Assert.assertEquals((Object)AWS_ACCOUNT_ID, (Object)emrCluster.getAccountId());
    }

    private EmrMasterSecurityGroupAddRequest getNewEmrAddSecurityGroupMasterRequestWithAccountId(String clusterName) throws Exception {
        EmrMasterSecurityGroupAddRequest request = new EmrMasterSecurityGroupAddRequest();
        request.setNamespace(NAMESPACE);
        request.setEmrClusterDefinitionName(EMR_CLUSTER_DEFINITION_NAME);
        request.setEmrClusterName(clusterName);
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("A_TEST_SECURITY_GROUP");
        request.setSecurityGroupIds(groupIds);
        request.setAccountId(AWS_ACCOUNT_ID);
        return request;
    }

    private EmrClusterCreateRequest getNewEmrClusterCreateRequestWithAccountId() throws Exception {
        EmrClusterCreateRequest request = new EmrClusterCreateRequest();
        request.setNamespace(NAMESPACE);
        request.setEmrClusterDefinitionName(EMR_CLUSTER_DEFINITION_NAME);
        request.setEmrClusterName("UT_EMR_CLUSTER-" + Math.random());
        EmrClusterDefinition emrClusterDefinitionOverride = new EmrClusterDefinition();
        request.setEmrClusterDefinitionOverride(emrClusterDefinitionOverride);
        emrClusterDefinitionOverride.setAccountId(AWS_ACCOUNT_ID);
        return request;
    }
}

