/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.ExpectedPartitionValueInformation;
import org.finra.herd.model.api.xml.ExpectedPartitionValueKey;
import org.finra.herd.model.api.xml.ExpectedPartitionValuesCreateRequest;
import org.finra.herd.model.api.xml.ExpectedPartitionValuesDeleteRequest;
import org.finra.herd.model.api.xml.ExpectedPartitionValuesInformation;
import org.finra.herd.model.api.xml.PartitionKeyGroupKey;
import org.finra.herd.model.api.xml.PartitionValueRange;
import org.finra.herd.model.jpa.PartitionKeyGroupEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.ExpectedPartitionValueService;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ExpectedPartitionValueServiceTest
extends AbstractServiceTest {
    @Autowired
    @Qualifier(value="expectedPartitionValueServiceImpl")
    private ExpectedPartitionValueService expectedPartitionValueServiceImpl;

    @Test
    public void testCreateExpectedPartitionValues() {
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        ExpectedPartitionValuesCreateRequest request = this.expectedPartitionValueServiceTestHelper.createExpectedPartitionValuesCreateRequest(PARTITION_KEY_GROUP, this.expectedPartitionValueDaoTestHelper.getTestUnsortedExpectedPartitionValues());
        ExpectedPartitionValuesInformation resultPartitionValuesInformation = this.expectedPartitionValueService.createExpectedPartitionValues(request);
        this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValuesInformation(PARTITION_KEY_GROUP, this.expectedPartitionValueDaoTestHelper.getTestSortedExpectedPartitionValues(), resultPartitionValuesInformation);
    }

    @Test
    public void testCreateExpectedPartitionValuesMissingRequiredParameters() {
        ExpectedPartitionValuesCreateRequest request = this.expectedPartitionValueServiceTestHelper.createExpectedPartitionValuesCreateRequest("      \t\t ", this.expectedPartitionValueDaoTestHelper.getTestUnsortedExpectedPartitionValues());
        try {
            this.expectedPartitionValueService.createExpectedPartitionValues(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition key group is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition key group name must be specified.", (Object)e.getMessage());
        }
        request = this.expectedPartitionValueServiceTestHelper.createExpectedPartitionValuesCreateRequest(PARTITION_KEY_GROUP, new ArrayList<String>());
        try {
            this.expectedPartitionValueService.createExpectedPartitionValues(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when no expected partition values are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least one expected partition value must be specified.", (Object)e.getMessage());
        }
        request = this.expectedPartitionValueServiceTestHelper.createExpectedPartitionValuesCreateRequest(PARTITION_KEY_GROUP, Arrays.asList("      \t\t "));
        try {
            this.expectedPartitionValueService.createExpectedPartitionValues(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when expected partition value is missing.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An expected partition value must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateExpectedPartitionValuesTrimParameters() {
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        ExpectedPartitionValuesCreateRequest request = this.expectedPartitionValueServiceTestHelper.createExpectedPartitionValuesCreateRequest(this.addWhitespace(PARTITION_KEY_GROUP), this.expectedPartitionValueDaoTestHelper.getTestUnsortedExpectedPartitionValues());
        for (int i = 0; i < request.getExpectedPartitionValues().size(); ++i) {
            request.getExpectedPartitionValues().set(i, this.addWhitespace((String)request.getExpectedPartitionValues().get(i)));
        }
        ExpectedPartitionValuesInformation resultPartitionValuesInformation = this.expectedPartitionValueService.createExpectedPartitionValues(request);
        this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValuesInformation(PARTITION_KEY_GROUP, this.expectedPartitionValueDaoTestHelper.getTestSortedExpectedPartitionValues(), resultPartitionValuesInformation);
    }

    @Test
    public void testCreateExpectedPartitionValuesInvalidParameters() {
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        try {
            this.expectedPartitionValueService.createExpectedPartitionValues(this.expectedPartitionValueServiceTestHelper.createExpectedPartitionValuesCreateRequest(this.addSlash(PARTITION_KEY_GROUP), this.expectedPartitionValueDaoTestHelper.getTestUnsortedExpectedPartitionValues()));
            Assert.fail((String)"Should throw an IllegalArgumentException when partition key group name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Partition key group name can not contain a forward slash character.", (Object)e.getMessage());
        }
        try {
            this.expectedPartitionValueService.createExpectedPartitionValues(this.expectedPartitionValueServiceTestHelper.createExpectedPartitionValuesCreateRequest(PARTITION_KEY_GROUP, Arrays.asList(this.addSlash(PARTITION_VALUE))));
            Assert.fail((String)"Should throw an IllegalArgumentException when expected partition value contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Expected partition value can not contain a forward slash character.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateExpectedPartitionValuesDuplicatePartitionValues() {
        ExpectedPartitionValuesCreateRequest request = this.expectedPartitionValueServiceTestHelper.createExpectedPartitionValuesCreateRequest(PARTITION_KEY_GROUP, Arrays.asList(PARTITION_VALUE, PARTITION_VALUE));
        try {
            this.expectedPartitionValueService.createExpectedPartitionValues(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when create request contains duplicate expected partition values.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Duplicate expected partition value \"%s\" found.", PARTITION_VALUE), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateExpectedPartitionValuesPartitionKeyGroupNoExists() {
        ExpectedPartitionValuesCreateRequest request = this.expectedPartitionValueServiceTestHelper.createExpectedPartitionValuesCreateRequest("I_DO_NOT_EXIST", this.expectedPartitionValueDaoTestHelper.getTestUnsortedExpectedPartitionValues());
        try {
            this.expectedPartitionValueService.createExpectedPartitionValues(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition key group does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Partition key group \"%s\" doesn't exist.", request.getPartitionKeyGroupKey().getPartitionKeyGroupName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateExpectedPartitionValuesExpectedPartitionValueAlreadyExists() {
        PartitionKeyGroupEntity partitionKeyGroupEntity = this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueEntities(partitionKeyGroupEntity, Arrays.asList(PARTITION_VALUE));
        ExpectedPartitionValuesCreateRequest request = this.expectedPartitionValueServiceTestHelper.createExpectedPartitionValuesCreateRequest(PARTITION_KEY_GROUP, Arrays.asList(PARTITION_VALUE));
        try {
            this.expectedPartitionValueService.createExpectedPartitionValues(request);
            Assert.fail((String)"Should throw an AlreadyExistsException when expected partition value already exists.");
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Expected partition value \"%s\" already exists in \"%s\" partition key group.", PARTITION_VALUE, PARTITION_KEY_GROUP), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetExpectedPartitionValue() {
        PartitionKeyGroupEntity partitionKeyGroupEntity = this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueEntities(partitionKeyGroupEntity, this.expectedPartitionValueDaoTestHelper.getTestUnsortedExpectedPartitionValues());
        List testSortedExpectedPartitionValues = this.expectedPartitionValueDaoTestHelper.getTestSortedExpectedPartitionValues();
        int testExpectedPartitionValueIndex = 3;
        for (Integer offset : Arrays.asList(-2, 0, 2)) {
            ExpectedPartitionValueInformation resultPartitionValueInformation = this.expectedPartitionValueService.getExpectedPartitionValue(new ExpectedPartitionValueKey(PARTITION_KEY_GROUP, (String)testSortedExpectedPartitionValues.get(testExpectedPartitionValueIndex)), offset);
            this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValueInformation(PARTITION_KEY_GROUP, (String)testSortedExpectedPartitionValues.get(testExpectedPartitionValueIndex + offset), resultPartitionValueInformation);
        }
    }

    @Test
    public void testGetExpectedPartitionValueMissingRequiredParameters() {
        try {
            this.expectedPartitionValueService.getExpectedPartitionValue(new ExpectedPartitionValueKey("      \t\t ", PARTITION_VALUE), Integer.valueOf(0));
            Assert.fail((String)"Should throw an IllegalArgumentException when partition key group is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition key group name must be specified.", (Object)e.getMessage());
        }
        try {
            this.expectedPartitionValueService.getExpectedPartitionValue(new ExpectedPartitionValueKey(PARTITION_KEY_GROUP, "      \t\t "), Integer.valueOf(0));
            Assert.fail((String)"Should throw an IllegalArgumentException when expected partition value is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An expected partition value must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetExpectedPartitionValueMissingOptionalParameters() {
        PartitionKeyGroupEntity partitionKeyGroupEntity = this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueEntities(partitionKeyGroupEntity, this.expectedPartitionValueDaoTestHelper.getTestUnsortedExpectedPartitionValues());
        List testSortedExpectedPartitionValues = this.expectedPartitionValueDaoTestHelper.getTestSortedExpectedPartitionValues();
        int testExpectedPartitionValueIndex = 3;
        ExpectedPartitionValueInformation resultPartitionValueInformation = this.expectedPartitionValueService.getExpectedPartitionValue(new ExpectedPartitionValueKey(PARTITION_KEY_GROUP, (String)testSortedExpectedPartitionValues.get(testExpectedPartitionValueIndex)), null);
        this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValueInformation(PARTITION_KEY_GROUP, (String)testSortedExpectedPartitionValues.get(testExpectedPartitionValueIndex), resultPartitionValueInformation);
    }

    @Test
    public void testGetExpectedPartitionValueTrimParameters() {
        PartitionKeyGroupEntity partitionKeyGroupEntity = this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueEntities(partitionKeyGroupEntity, this.expectedPartitionValueDaoTestHelper.getTestUnsortedExpectedPartitionValues());
        List testSortedExpectedPartitionValues = this.expectedPartitionValueDaoTestHelper.getTestSortedExpectedPartitionValues();
        int testExpectedPartitionValueIndex = 3;
        ExpectedPartitionValueInformation resultPartitionValueInformation = this.expectedPartitionValueService.getExpectedPartitionValue(new ExpectedPartitionValueKey(this.addWhitespace(PARTITION_KEY_GROUP), this.addWhitespace((String)testSortedExpectedPartitionValues.get(testExpectedPartitionValueIndex))), Integer.valueOf(0));
        this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValueInformation(PARTITION_KEY_GROUP, (String)testSortedExpectedPartitionValues.get(testExpectedPartitionValueIndex), resultPartitionValueInformation);
    }

    @Test
    public void testGetExpectedPartitionValueUpperCaseParameters() {
        PartitionKeyGroupEntity partitionKeyGroupEntity = this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP.toLowerCase());
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueEntities(partitionKeyGroupEntity, Arrays.asList(PARTITION_VALUE.toLowerCase()));
        ExpectedPartitionValueInformation resultPartitionValueInformation = this.expectedPartitionValueService.getExpectedPartitionValue(new ExpectedPartitionValueKey(PARTITION_KEY_GROUP.toUpperCase(), PARTITION_VALUE.toLowerCase()), null);
        this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValueInformation(PARTITION_KEY_GROUP.toLowerCase(), PARTITION_VALUE.toLowerCase(), resultPartitionValueInformation);
    }

    @Test
    public void testGetExpectedPartitionValueLowerCaseParameters() {
        PartitionKeyGroupEntity partitionKeyGroupEntity = this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP.toUpperCase());
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueEntities(partitionKeyGroupEntity, Arrays.asList(PARTITION_VALUE.toUpperCase()));
        ExpectedPartitionValueInformation resultPartitionValueInformation = this.expectedPartitionValueService.getExpectedPartitionValue(new ExpectedPartitionValueKey(PARTITION_KEY_GROUP.toLowerCase(), PARTITION_VALUE.toUpperCase()), null);
        this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValueInformation(PARTITION_KEY_GROUP.toUpperCase(), PARTITION_VALUE.toUpperCase(), resultPartitionValueInformation);
    }

    @Test
    public void testGetExpectedPartitionValuePartitionKeyGroupNoExists() {
        String partitionKeyGroupName = "I_DO_NOT_EXIST";
        try {
            this.expectedPartitionValueService.getExpectedPartitionValue(new ExpectedPartitionValueKey(partitionKeyGroupName, PARTITION_VALUE), null);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition key group does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Partition key group \"%s\" doesn't exist.", partitionKeyGroupName), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetExpectedPartitionValueStartExpectedPartitionValueNoExists() {
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        String testExpectedPartitionValue = "I_DO_NOT_EXIST";
        for (Integer offset : Arrays.asList(-2, 0, 2)) {
            try {
                this.expectedPartitionValueService.getExpectedPartitionValue(new ExpectedPartitionValueKey(PARTITION_KEY_GROUP, testExpectedPartitionValue), offset);
                Assert.fail((String)"Should throw an IllegalArgumentException when the expected partition value does not exist.");
            }
            catch (ObjectNotFoundException e) {
                Assert.assertEquals((Object)String.format("Expected partition value \"%s\" doesn't exist in \"%s\" partition key group.", testExpectedPartitionValue, PARTITION_KEY_GROUP), (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testGetExpectedPartitionValueOffsetExpectedPartitionValueNoExists() {
        PartitionKeyGroupEntity partitionKeyGroupEntity = this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueEntities(partitionKeyGroupEntity, Arrays.asList(PARTITION_VALUE));
        for (Integer offset : Arrays.asList(-1, 1)) {
            try {
                this.expectedPartitionValueService.getExpectedPartitionValue(new ExpectedPartitionValueKey(PARTITION_KEY_GROUP, PARTITION_VALUE), offset);
                Assert.fail((String)"Should throw an IllegalArgumentException when the expected partition value does not exist.");
            }
            catch (ObjectNotFoundException e) {
                Assert.assertEquals((Object)String.format("Expected partition value \"%s\" with offset %d doesn't exist in \"%s\" partition key group.", PARTITION_VALUE, offset, PARTITION_KEY_GROUP), (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testGetExpectedPartitionValues() {
        PartitionKeyGroupEntity partitionKeyGroupEntity = this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueEntities(partitionKeyGroupEntity, this.expectedPartitionValueDaoTestHelper.getTestUnsortedExpectedPartitionValues());
        List testSortedExpectedPartitionValues = this.expectedPartitionValueDaoTestHelper.getTestSortedExpectedPartitionValues();
        int startExpectedPartitionValueIndex = 1;
        int endExpectedPartitionValueIndex = testSortedExpectedPartitionValues.size() - 2;
        ExpectedPartitionValuesInformation resultPartitionValuesInformation = this.expectedPartitionValueService.getExpectedPartitionValues(new PartitionKeyGroupKey(PARTITION_KEY_GROUP), new PartitionValueRange((String)testSortedExpectedPartitionValues.get(startExpectedPartitionValueIndex), (String)testSortedExpectedPartitionValues.get(endExpectedPartitionValueIndex)));
        this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValuesInformation(PARTITION_KEY_GROUP, testSortedExpectedPartitionValues.subList(startExpectedPartitionValueIndex, endExpectedPartitionValueIndex + 1), resultPartitionValuesInformation);
    }

    @Test
    public void testGetExpectedPartitionValuesMissingRequiredParameters() {
        try {
            this.expectedPartitionValueService.getExpectedPartitionValues(new PartitionKeyGroupKey("      \t\t "), new PartitionValueRange(PARTITION_VALUE, PARTITION_VALUE));
            Assert.fail((String)"Should throw an IllegalArgumentException when partition key group is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition key group name must be specified.", (Object)e.getMessage());
        }
        try {
            this.expectedPartitionValueService.getExpectedPartitionValues(new PartitionKeyGroupKey(PARTITION_KEY_GROUP), new PartitionValueRange("      \t\t ", "      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when both start and end expected partition values are not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least one start or end expected partition value must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetExpectedPartitionValuesMissingOptionalParameters() {
        PartitionKeyGroupEntity partitionKeyGroupEntity = this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueEntities(partitionKeyGroupEntity, this.expectedPartitionValueDaoTestHelper.getTestUnsortedExpectedPartitionValues());
        List testSortedExpectedPartitionValues = this.expectedPartitionValueDaoTestHelper.getTestSortedExpectedPartitionValues();
        int startExpectedPartitionValueIndex = 1;
        int endExpectedPartitionValueIndex = testSortedExpectedPartitionValues.size() - 2;
        ExpectedPartitionValuesInformation resultPartitionValuesInformation = this.expectedPartitionValueService.getExpectedPartitionValues(new PartitionKeyGroupKey(PARTITION_KEY_GROUP), new PartitionValueRange((String)testSortedExpectedPartitionValues.get(startExpectedPartitionValueIndex), "      \t\t "));
        this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValuesInformation(PARTITION_KEY_GROUP, testSortedExpectedPartitionValues.subList(startExpectedPartitionValueIndex, this.expectedPartitionValueDaoTestHelper.getTestSortedExpectedPartitionValues().size()), resultPartitionValuesInformation);
        resultPartitionValuesInformation = this.expectedPartitionValueService.getExpectedPartitionValues(new PartitionKeyGroupKey(PARTITION_KEY_GROUP), new PartitionValueRange("      \t\t ", (String)testSortedExpectedPartitionValues.get(endExpectedPartitionValueIndex)));
        this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValuesInformation(PARTITION_KEY_GROUP, testSortedExpectedPartitionValues.subList(0, endExpectedPartitionValueIndex + 1), resultPartitionValuesInformation);
    }

    @Test
    public void testGetExpectedPartitionValuesTrimParameters() {
        PartitionKeyGroupEntity partitionKeyGroupEntity = this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueEntities(partitionKeyGroupEntity, this.expectedPartitionValueDaoTestHelper.getTestUnsortedExpectedPartitionValues());
        List testSortedExpectedPartitionValues = this.expectedPartitionValueDaoTestHelper.getTestSortedExpectedPartitionValues();
        ExpectedPartitionValuesInformation resultPartitionValuesInformation = this.expectedPartitionValueService.getExpectedPartitionValues(new PartitionKeyGroupKey(this.addWhitespace(PARTITION_KEY_GROUP)), new PartitionValueRange(this.addWhitespace((String)testSortedExpectedPartitionValues.get(0)), this.addWhitespace((String)testSortedExpectedPartitionValues.get(testSortedExpectedPartitionValues.size() - 1))));
        this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValuesInformation(PARTITION_KEY_GROUP, testSortedExpectedPartitionValues, resultPartitionValuesInformation);
    }

    @Test
    public void testGetExpectedPartitionValuesUpperCaseParameters() {
        PartitionKeyGroupEntity partitionKeyGroupEntity = this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP.toLowerCase());
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueEntities(partitionKeyGroupEntity, Arrays.asList(PARTITION_VALUE.toLowerCase()));
        ExpectedPartitionValuesInformation resultPartitionValuesInformation = this.expectedPartitionValueService.getExpectedPartitionValues(new PartitionKeyGroupKey(PARTITION_KEY_GROUP.toUpperCase()), new PartitionValueRange(PARTITION_VALUE.toLowerCase(), PARTITION_VALUE.toLowerCase()));
        this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValuesInformation(PARTITION_KEY_GROUP.toLowerCase(), Arrays.asList(PARTITION_VALUE.toLowerCase()), resultPartitionValuesInformation);
    }

    @Test
    public void testGetExpectedPartitionValuesLowerCaseParameters() {
        PartitionKeyGroupEntity partitionKeyGroupEntity = this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP.toUpperCase());
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueEntities(partitionKeyGroupEntity, Arrays.asList(PARTITION_VALUE.toUpperCase()));
        ExpectedPartitionValuesInformation resultPartitionValuesInformation = this.expectedPartitionValueService.getExpectedPartitionValues(new PartitionKeyGroupKey(PARTITION_KEY_GROUP.toLowerCase()), new PartitionValueRange(PARTITION_VALUE.toUpperCase(), PARTITION_VALUE.toUpperCase()));
        this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValuesInformation(PARTITION_KEY_GROUP.toUpperCase(), Arrays.asList(PARTITION_VALUE.toUpperCase()), resultPartitionValuesInformation);
    }

    @Test
    public void testGetExpectedPartitionValuesInvalidParameters() {
        try {
            this.expectedPartitionValueService.getExpectedPartitionValues(new PartitionKeyGroupKey(PARTITION_KEY_GROUP), new PartitionValueRange(PARTITION_VALUE_2, PARTITION_VALUE));
            Assert.fail((String)"Should throw an IllegalArgumentException when the start expected partition value being greater than the end expected partition value.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("The start expected partition value \"%s\" cannot be greater than the end expected partition value \"%s\".", PARTITION_VALUE_2, PARTITION_VALUE), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetExpectedPartitionValuesPartitionKeyGroupNoExists() {
        String partitionKeyGroupName = "I_DO_NOT_EXIST";
        try {
            this.expectedPartitionValueService.getExpectedPartitionValues(new PartitionKeyGroupKey(partitionKeyGroupName), new PartitionValueRange(PARTITION_VALUE, PARTITION_VALUE));
            Assert.fail((String)"Should throw an IllegalArgumentException when partition key group does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Partition key group \"%s\" doesn't exist.", partitionKeyGroupName), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetExpectedPartitionValuesExpectedPartitionValuesNoExist() {
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        ExpectedPartitionValuesInformation resultPartitionValuesInformation = this.expectedPartitionValueService.getExpectedPartitionValues(new PartitionKeyGroupKey(PARTITION_KEY_GROUP), new PartitionValueRange(PARTITION_VALUE, PARTITION_VALUE_2));
        this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValuesInformation(PARTITION_KEY_GROUP, new ArrayList<String>(), resultPartitionValuesInformation);
    }

    @Test
    public void testDeleteExpectedPartitionValues() {
        PartitionKeyGroupEntity partitionKeyGroupEntity = this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueEntities(partitionKeyGroupEntity, this.expectedPartitionValueDaoTestHelper.getTestUnsortedExpectedPartitionValues());
        ExpectedPartitionValuesDeleteRequest request = this.expectedPartitionValueServiceTestHelper.createExpectedPartitionValuesDeleteRequest(PARTITION_KEY_GROUP, this.expectedPartitionValueDaoTestHelper.getTestUnsortedExpectedPartitionValues());
        ExpectedPartitionValuesInformation resultPartitionValuesInformation = this.expectedPartitionValueService.deleteExpectedPartitionValues(request);
        this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValuesInformation(PARTITION_KEY_GROUP, this.expectedPartitionValueDaoTestHelper.getTestSortedExpectedPartitionValues(), resultPartitionValuesInformation);
        Assert.assertEquals((long)0L, (long)partitionKeyGroupEntity.getExpectedPartitionValues().size());
    }

    @Test
    public void testDeleteExpectedPartitionValuesMissingRequiredParameters() {
        ExpectedPartitionValuesDeleteRequest request = this.expectedPartitionValueServiceTestHelper.createExpectedPartitionValuesDeleteRequest("      \t\t ", this.expectedPartitionValueDaoTestHelper.getTestUnsortedExpectedPartitionValues());
        try {
            this.expectedPartitionValueService.deleteExpectedPartitionValues(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition key group is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition key group name must be specified.", (Object)e.getMessage());
        }
        request = this.expectedPartitionValueServiceTestHelper.createExpectedPartitionValuesDeleteRequest(PARTITION_KEY_GROUP, new ArrayList<String>());
        try {
            this.expectedPartitionValueService.deleteExpectedPartitionValues(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when no expected partition values are specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least one expected partition value must be specified.", (Object)e.getMessage());
        }
        request = this.expectedPartitionValueServiceTestHelper.createExpectedPartitionValuesDeleteRequest(PARTITION_KEY_GROUP, Arrays.asList("      \t\t "));
        try {
            this.expectedPartitionValueService.deleteExpectedPartitionValues(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when expected partition value is missing.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An expected partition value must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteExpectedPartitionValuesTrimParameters() {
        PartitionKeyGroupEntity partitionKeyGroupEntity = this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueEntities(partitionKeyGroupEntity, this.expectedPartitionValueDaoTestHelper.getTestUnsortedExpectedPartitionValues());
        ExpectedPartitionValuesDeleteRequest request = this.expectedPartitionValueServiceTestHelper.createExpectedPartitionValuesDeleteRequest(this.addWhitespace(PARTITION_KEY_GROUP), this.expectedPartitionValueDaoTestHelper.getTestUnsortedExpectedPartitionValues());
        for (int i = 0; i < request.getExpectedPartitionValues().size(); ++i) {
            request.getExpectedPartitionValues().set(i, this.addWhitespace((String)request.getExpectedPartitionValues().get(i)));
        }
        ExpectedPartitionValuesInformation resultPartitionValuesInformation = this.expectedPartitionValueService.deleteExpectedPartitionValues(request);
        this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValuesInformation(PARTITION_KEY_GROUP, this.expectedPartitionValueDaoTestHelper.getTestSortedExpectedPartitionValues(), resultPartitionValuesInformation);
        Assert.assertEquals((long)0L, (long)partitionKeyGroupEntity.getExpectedPartitionValues().size());
    }

    @Test
    public void testDeleteExpectedPartitionValuesDuplicatePartitionValues() {
        ExpectedPartitionValuesDeleteRequest request = this.expectedPartitionValueServiceTestHelper.createExpectedPartitionValuesDeleteRequest(PARTITION_KEY_GROUP, Arrays.asList(PARTITION_VALUE, PARTITION_VALUE));
        try {
            this.expectedPartitionValueService.deleteExpectedPartitionValues(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when delete request contains duplicate expected partition values.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Duplicate expected partition value \"%s\" found.", PARTITION_VALUE), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteExpectedPartitionValuesPartitionKeyGroupNoExists() {
        ExpectedPartitionValuesDeleteRequest request = this.expectedPartitionValueServiceTestHelper.createExpectedPartitionValuesDeleteRequest("I_DO_NOT_EXIST", this.expectedPartitionValueDaoTestHelper.getTestUnsortedExpectedPartitionValues());
        try {
            this.expectedPartitionValueService.deleteExpectedPartitionValues(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when partition key group does not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Partition key group \"%s\" doesn't exist.", request.getPartitionKeyGroupKey().getPartitionKeyGroupName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testDeleteExpectedPartitionValuesExpectedPartitionValueNoExists() {
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        ExpectedPartitionValuesDeleteRequest request = this.expectedPartitionValueServiceTestHelper.createExpectedPartitionValuesDeleteRequest(PARTITION_KEY_GROUP, Arrays.asList("I_DO_NOT_EXIST"));
        try {
            this.expectedPartitionValueService.deleteExpectedPartitionValues(request);
            Assert.fail((String)"Should throw an IllegalArgumentException when any of the expected partition values do not exist.");
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Expected partition value \"%s\" doesn't exist in \"%s\" partition key group.", request.getExpectedPartitionValues().get(0), PARTITION_KEY_GROUP), (Object)e.getMessage());
        }
    }

    @Test
    public void testLargeNumberOfExpectedPartitionValues() {
        int MAX_PARTITION_VALUES = 1000;
        int LAST_ELEMENT_INDEX = 999;
        PartitionKeyGroupEntity partitionKeyGroupEntity = this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        List testUnsortedExpectedPartitionValues = this.expectedPartitionValueDaoTestHelper.getTestUnsortedExpectedPartitionValues(1000);
        List testSortedExpectedPartitionValues = this.expectedPartitionValueDaoTestHelper.getTestSortedExpectedPartitionValues(1000);
        ExpectedPartitionValuesCreateRequest createRequest = this.expectedPartitionValueServiceTestHelper.createExpectedPartitionValuesCreateRequest(PARTITION_KEY_GROUP, testUnsortedExpectedPartitionValues);
        ExpectedPartitionValuesInformation resultPartitionValuesInformation = this.expectedPartitionValueService.createExpectedPartitionValues(createRequest);
        this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValuesInformation(PARTITION_KEY_GROUP, testSortedExpectedPartitionValues, resultPartitionValuesInformation);
        Assert.assertEquals((long)testUnsortedExpectedPartitionValues.size(), (long)partitionKeyGroupEntity.getExpectedPartitionValues().size());
        ExpectedPartitionValueInformation resultPartitionValueInformation = this.expectedPartitionValueService.getExpectedPartitionValue(new ExpectedPartitionValueKey(PARTITION_KEY_GROUP, (String)testSortedExpectedPartitionValues.get(500)), null);
        this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValueInformation(PARTITION_KEY_GROUP, (String)testSortedExpectedPartitionValues.get(500), resultPartitionValueInformation);
        resultPartitionValueInformation = this.expectedPartitionValueService.getExpectedPartitionValue(new ExpectedPartitionValueKey(PARTITION_KEY_GROUP, (String)testSortedExpectedPartitionValues.get(0)), Integer.valueOf(999));
        this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValueInformation(PARTITION_KEY_GROUP, (String)testSortedExpectedPartitionValues.get(999), resultPartitionValueInformation);
        resultPartitionValueInformation = this.expectedPartitionValueService.getExpectedPartitionValue(new ExpectedPartitionValueKey(PARTITION_KEY_GROUP, (String)testSortedExpectedPartitionValues.get(999)), Integer.valueOf(-999));
        this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValueInformation(PARTITION_KEY_GROUP, (String)testSortedExpectedPartitionValues.get(0), resultPartitionValueInformation);
        resultPartitionValuesInformation = this.expectedPartitionValueService.getExpectedPartitionValues(new PartitionKeyGroupKey(PARTITION_KEY_GROUP), new PartitionValueRange((String)testSortedExpectedPartitionValues.get(0), (String)testSortedExpectedPartitionValues.get(999)));
        this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValuesInformation(PARTITION_KEY_GROUP, testSortedExpectedPartitionValues, resultPartitionValuesInformation);
        ExpectedPartitionValuesDeleteRequest deleteRequest = this.expectedPartitionValueServiceTestHelper.createExpectedPartitionValuesDeleteRequest(PARTITION_KEY_GROUP, testUnsortedExpectedPartitionValues);
        ExpectedPartitionValuesInformation deleteResultPartitionValuesInformation = this.expectedPartitionValueService.deleteExpectedPartitionValues(deleteRequest);
        this.expectedPartitionValueServiceTestHelper.validateExpectedPartitionValuesInformation(PARTITION_KEY_GROUP, testSortedExpectedPartitionValues, deleteResultPartitionValuesInformation);
        Assert.assertEquals((long)0L, (long)partitionKeyGroupEntity.getExpectedPartitionValues().size());
    }

    @Test
    public void testExpectedPartitionValueServiceMethodsNewTx() {
        try {
            this.expectedPartitionValueServiceImpl.getExpectedPartitionValue(null, Integer.valueOf(0));
            Assert.fail((String)"Should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"An expected partition value key must be specified.", (Object)e.getMessage());
        }
    }
}

