/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.List;
import org.finra.herd.model.api.xml.ExpectedPartitionValueInformation;
import org.finra.herd.model.api.xml.ExpectedPartitionValuesCreateRequest;
import org.finra.herd.model.api.xml.ExpectedPartitionValuesDeleteRequest;
import org.finra.herd.model.api.xml.ExpectedPartitionValuesInformation;
import org.finra.herd.service.PartitionKeyGroupServiceTestHelper;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExpectedPartitionValueServiceTestHelper {
    @Autowired
    private PartitionKeyGroupServiceTestHelper partitionKeyGroupServiceTestHelper;

    public ExpectedPartitionValuesCreateRequest createExpectedPartitionValuesCreateRequest(String partitionKeyGroupName, List<String> expectedPartitionValues) {
        ExpectedPartitionValuesCreateRequest expectedPartitionValuesCreateRequest = new ExpectedPartitionValuesCreateRequest();
        expectedPartitionValuesCreateRequest.setPartitionKeyGroupKey(this.partitionKeyGroupServiceTestHelper.createPartitionKeyGroupKey(partitionKeyGroupName));
        expectedPartitionValuesCreateRequest.setExpectedPartitionValues(expectedPartitionValues);
        return expectedPartitionValuesCreateRequest;
    }

    public ExpectedPartitionValuesDeleteRequest createExpectedPartitionValuesDeleteRequest(String partitionKeyGroupName, List<String> expectedPartitionValues) {
        ExpectedPartitionValuesDeleteRequest expectedPartitionValuesDeleteRequest = new ExpectedPartitionValuesDeleteRequest();
        expectedPartitionValuesDeleteRequest.setPartitionKeyGroupKey(this.partitionKeyGroupServiceTestHelper.createPartitionKeyGroupKey(partitionKeyGroupName));
        expectedPartitionValuesDeleteRequest.setExpectedPartitionValues(expectedPartitionValues);
        return expectedPartitionValuesDeleteRequest;
    }

    public void validateExpectedPartitionValueInformation(String expectedPartitionKeyGroupName, String expectedExpectedPartitionValue, ExpectedPartitionValueInformation actualExpectedPartitionValueInformation) {
        Assert.assertNotNull((Object)actualExpectedPartitionValueInformation);
        Assert.assertEquals((Object)expectedPartitionKeyGroupName, (Object)actualExpectedPartitionValueInformation.getExpectedPartitionValueKey().getPartitionKeyGroupName());
        Assert.assertEquals((Object)expectedExpectedPartitionValue, (Object)actualExpectedPartitionValueInformation.getExpectedPartitionValueKey().getExpectedPartitionValue());
    }

    public void validateExpectedPartitionValuesInformation(String expectedPartitionKeyGroupName, List<String> expectedExpectedPartitionValues, ExpectedPartitionValuesInformation actualExpectedPartitionValuesInformation) {
        Assert.assertNotNull((Object)actualExpectedPartitionValuesInformation);
        Assert.assertEquals((Object)expectedPartitionKeyGroupName, (Object)actualExpectedPartitionValuesInformation.getPartitionKeyGroupKey().getPartitionKeyGroupName());
        Assert.assertEquals(expectedExpectedPartitionValues, (Object)actualExpectedPartitionValuesInformation.getExpectedPartitionValues());
    }
}

