/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.Arrays;
import java.util.List;
import org.finra.herd.dao.GlobalAttributeDefinitionDao;
import org.finra.herd.dao.GlobalAttributeDefinitionLevelDao;
import org.finra.herd.model.api.xml.AttributeValueList;
import org.finra.herd.model.api.xml.AttributeValueListKey;
import org.finra.herd.model.api.xml.GlobalAttributeDefinition;
import org.finra.herd.model.api.xml.GlobalAttributeDefinitionCreateRequest;
import org.finra.herd.model.api.xml.GlobalAttributeDefinitionKey;
import org.finra.herd.model.api.xml.GlobalAttributeDefinitionKeys;
import org.finra.herd.model.jpa.AttributeValueListEntity;
import org.finra.herd.model.jpa.GlobalAttributeDefinitionEntity;
import org.finra.herd.model.jpa.GlobalAttributeDefinitionLevelEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.AttributeValueListDaoHelper;
import org.finra.herd.service.helper.AttributeValueListHelper;
import org.finra.herd.service.helper.GlobalAttributeDefinitionDaoHelper;
import org.finra.herd.service.helper.GlobalAttributeDefinitionHelper;
import org.finra.herd.service.impl.GlobalAttributeDefinitionServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

public class GlobalAttributeDefinitionServiceTest
extends AbstractServiceTest {
    @Mock
    private GlobalAttributeDefinitionDao globalAttributeDefinitionDao;
    @Mock
    private GlobalAttributeDefinitionDaoHelper globalAttributeDefinitionDaoHelper;
    @Mock
    private GlobalAttributeDefinitionHelper globalAttributeDefinitionHelper;
    @Mock
    private GlobalAttributeDefinitionLevelDao globalAttributeDefinitionLevelDao;
    @Spy
    private AttributeValueListHelper attributeValueListHelper;
    @Spy
    private AttributeValueListDaoHelper attributeValueListDaoHelper;
    @InjectMocks
    private GlobalAttributeDefinitionServiceImpl globalAttributeDefinitionService;
    private AttributeValueListKey attributeValueListKeyNull = null;
    private AttributeValueList attributeValueListNull = null;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testCreateGlobalAttributeDefinition() {
        GlobalAttributeDefinitionKey globalAttributeDefinitionKey = new GlobalAttributeDefinitionKey("BUS_OBJCT_FRMT", GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        GlobalAttributeDefinitionCreateRequest request = new GlobalAttributeDefinitionCreateRequest(globalAttributeDefinitionKey, this.attributeValueListKeyNull);
        GlobalAttributeDefinitionLevelEntity globalAttributeDefinitionLevelEntity = new GlobalAttributeDefinitionLevelEntity();
        globalAttributeDefinitionLevelEntity.setGlobalAttributeDefinitionLevel("BUS_OBJCT_FRMT");
        GlobalAttributeDefinitionEntity globalAttributeDefinitionEntity = new GlobalAttributeDefinitionEntity();
        globalAttributeDefinitionEntity.setId(GLOBAL_ATTRIBUTE_DEFINITON_ID);
        globalAttributeDefinitionEntity.setGlobalAttributeDefinitionLevel(globalAttributeDefinitionLevelEntity);
        globalAttributeDefinitionEntity.setGlobalAttributeDefinitionName(GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        Mockito.when((Object)this.globalAttributeDefinitionLevelDao.getGlobalAttributeDefinitionLevel("BUS_OBJCT_FRMT")).thenReturn((Object)globalAttributeDefinitionLevelEntity);
        Mockito.when((Object)this.globalAttributeDefinitionDao.saveAndRefresh(Matchers.any(GlobalAttributeDefinitionEntity.class))).thenReturn((Object)globalAttributeDefinitionEntity);
        GlobalAttributeDefinition response = this.globalAttributeDefinitionService.createGlobalAttributeDefinition(request);
        ((GlobalAttributeDefinitionHelper)Mockito.verify((Object)this.globalAttributeDefinitionHelper)).validateGlobalAttributeDefinitionKey(globalAttributeDefinitionKey);
        ((GlobalAttributeDefinitionDaoHelper)Mockito.verify((Object)this.globalAttributeDefinitionDaoHelper)).validateGlobalAttributeDefinitionNoExists(globalAttributeDefinitionKey);
        ((GlobalAttributeDefinitionLevelDao)Mockito.verify((Object)this.globalAttributeDefinitionLevelDao)).getGlobalAttributeDefinitionLevel("BUS_OBJCT_FRMT");
        ((GlobalAttributeDefinitionDao)Mockito.verify((Object)this.globalAttributeDefinitionDao)).saveAndRefresh(Matchers.any(GlobalAttributeDefinitionEntity.class));
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new GlobalAttributeDefinition(GLOBAL_ATTRIBUTE_DEFINITON_ID.intValue(), globalAttributeDefinitionKey, this.attributeValueListNull), (Object)response);
    }

    @Test
    public void testCreateGlobalAttributeDefinitionMissingRequiredParameters() {
        try {
            this.globalAttributeDefinitionService.createGlobalAttributeDefinition(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A global attribute definition create request must be specified.", (Object)e.getMessage());
        }
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testCreateGlobalAttributeDefinitionInvalidGlobalAttributeDefinitionLevel() {
        GlobalAttributeDefinitionKey globalAttributeDefinitionKey = new GlobalAttributeDefinitionKey("BUS_OBJECT_FORMAT", GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        GlobalAttributeDefinitionCreateRequest request = new GlobalAttributeDefinitionCreateRequest(globalAttributeDefinitionKey, this.attributeValueListKeyNull);
        try {
            this.globalAttributeDefinitionService.createGlobalAttributeDefinition(request);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Global attribute definition with level \"%s\" is not supported.", "BUS_OBJECT_FORMAT"), (Object)e.getMessage());
        }
        ((GlobalAttributeDefinitionHelper)Mockito.verify((Object)this.globalAttributeDefinitionHelper)).validateGlobalAttributeDefinitionKey(globalAttributeDefinitionKey);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testDeleteGlobalAttributeDefinition() {
        GlobalAttributeDefinitionKey globalAttributeDefinitionKey = new GlobalAttributeDefinitionKey("BUS_OBJCT_FRMT", GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        GlobalAttributeDefinitionEntity globalAttributeDefinitionEntity = this.globalAttributeDefinitionDaoTestHelper.createGlobalAttributeDefinitionEntity("BUS_OBJCT_FRMT", GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        Mockito.when((Object)this.globalAttributeDefinitionDaoHelper.getGlobalAttributeDefinitionEntity(globalAttributeDefinitionKey)).thenReturn((Object)globalAttributeDefinitionEntity);
        GlobalAttributeDefinition response = this.globalAttributeDefinitionService.deleteGlobalAttributeDefinition(globalAttributeDefinitionKey);
        ((GlobalAttributeDefinitionHelper)Mockito.verify((Object)this.globalAttributeDefinitionHelper)).validateGlobalAttributeDefinitionKey(globalAttributeDefinitionKey);
        ((GlobalAttributeDefinitionDaoHelper)Mockito.verify((Object)this.globalAttributeDefinitionDaoHelper)).getGlobalAttributeDefinitionEntity(globalAttributeDefinitionKey);
        ((GlobalAttributeDefinitionDao)Mockito.verify((Object)this.globalAttributeDefinitionDao)).delete((Object)globalAttributeDefinitionEntity);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new GlobalAttributeDefinition(response.getId(), globalAttributeDefinitionKey, this.attributeValueListNull), (Object)response);
    }

    @Test
    public void testGetGlobalAttributeDefinitions() {
        List<GlobalAttributeDefinitionKey> globalAttributeDefinitionKeys = Arrays.asList(new GlobalAttributeDefinitionKey("BUS_OBJCT_FRMT", GLOBAL_ATTRIBUTE_DEFINITON_NAME), new GlobalAttributeDefinitionKey("BUS_OBJCT_FRMT", GLOBAL_ATTRIBUTE_DEFINITON_NAME_2));
        Mockito.when((Object)this.globalAttributeDefinitionDao.getAllGlobalAttributeDefinitionKeys()).thenReturn(globalAttributeDefinitionKeys);
        GlobalAttributeDefinitionKeys response = this.globalAttributeDefinitionService.getGlobalAttributeDefinitionKeys();
        ((GlobalAttributeDefinitionDao)Mockito.verify((Object)this.globalAttributeDefinitionDao)).getAllGlobalAttributeDefinitionKeys();
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new GlobalAttributeDefinitionKeys(globalAttributeDefinitionKeys), (Object)response);
    }

    @Test
    public void testGetGlobalAttributeDefinition() {
        GlobalAttributeDefinitionKey globalAttributeDefinitionKey = new GlobalAttributeDefinitionKey("BUS_OBJCT_FRMT", GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        GlobalAttributeDefinitionEntity globalAttributeDefinitionEntity = this.globalAttributeDefinitionDaoTestHelper.createGlobalAttributeDefinitionEntity("BUS_OBJCT_FRMT", GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        AttributeValueListEntity attributeValueListEntity = this.attributeValueListDaoTestHelper.createAttributeValueListEntity("namespace_1", "list_1");
        globalAttributeDefinitionEntity.setAttributeValueList(attributeValueListEntity);
        Mockito.when((Object)this.globalAttributeDefinitionDaoHelper.getGlobalAttributeDefinitionEntity(globalAttributeDefinitionKey)).thenReturn((Object)globalAttributeDefinitionEntity);
        GlobalAttributeDefinition response = this.globalAttributeDefinitionService.getGlobalAttributeDefinition(globalAttributeDefinitionKey);
        ((GlobalAttributeDefinitionHelper)Mockito.verify((Object)this.globalAttributeDefinitionHelper)).validateGlobalAttributeDefinitionKey(globalAttributeDefinitionKey);
        ((GlobalAttributeDefinitionDaoHelper)Mockito.verify((Object)this.globalAttributeDefinitionDaoHelper)).getGlobalAttributeDefinitionEntity(globalAttributeDefinitionKey);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new GlobalAttributeDefinition(response.getId(), globalAttributeDefinitionKey, this.attributeValueListDaoHelper.createAttributeValueListFromEntity(attributeValueListEntity)), (Object)response);
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.globalAttributeDefinitionDao, this.globalAttributeDefinitionDaoHelper, this.globalAttributeDefinitionHelper, this.globalAttributeDefinitionLevelDao});
    }
}

