/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.finra.herd.dao.IndexSearchDao;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKey;
import org.finra.herd.model.api.xml.IndexSearchFilter;
import org.finra.herd.model.api.xml.IndexSearchKey;
import org.finra.herd.model.api.xml.IndexSearchRequest;
import org.finra.herd.model.api.xml.IndexSearchResponse;
import org.finra.herd.model.api.xml.IndexSearchResult;
import org.finra.herd.model.api.xml.IndexSearchResultKey;
import org.finra.herd.model.api.xml.IndexSearchResultTypeKey;
import org.finra.herd.model.api.xml.SearchIndexKey;
import org.finra.herd.model.api.xml.TagKey;
import org.finra.herd.model.jpa.SearchIndexTypeEntity;
import org.finra.herd.model.jpa.TagEntity;
import org.finra.herd.model.jpa.TagTypeEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.AlternateKeyHelper;
import org.finra.herd.service.helper.SearchIndexDaoHelper;
import org.finra.herd.service.helper.SearchIndexTypeDaoHelper;
import org.finra.herd.service.helper.TagDaoHelper;
import org.finra.herd.service.helper.TagHelper;
import org.finra.herd.service.impl.IndexSearchServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class IndexSearchServiceTest
extends AbstractServiceTest {
    @Mock
    private AlternateKeyHelper alternateKeyHelper;
    @Mock
    private IndexSearchDao indexSearchDao;
    @InjectMocks
    private IndexSearchServiceImpl indexSearchService;
    @Mock
    private SearchIndexDaoHelper searchIndexDaoHelper;
    @Mock
    private SearchIndexTypeDaoHelper searchIndexTypeDaoHelper;
    @Mock
    private TagDaoHelper tagDaoHelper;
    @Mock
    private TagHelper tagHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testIndexSearch() {
        TagKey tagKey = new TagKey(TAG_TYPE_CODE, TAG_CODE);
        IndexSearchRequest indexSearchRequest = new IndexSearchRequest("Search Term -foo foo-bar", (List)ImmutableList.of((Object)new IndexSearchFilter(EXCLUSION_SEARCH_FILTER, (List)ImmutableList.of((Object)new IndexSearchKey(tagKey, NO_INDEX_SEARCH_RESULT_TYPE_KEY))), (Object)new IndexSearchFilter(EXCLUSION_SEARCH_FILTER, (List)ImmutableList.of((Object)new IndexSearchKey(NO_TAG_KEY, new IndexSearchResultTypeKey(INDEX_SEARCH_RESULT_TYPE))))), Collections.singletonList("tag"), Boolean.valueOf(true));
        HashSet fields = Sets.newHashSet((Object[])new String[]{"displayName", "shortDescription"});
        IndexSearchResultKey indexSearchResultKeyBusinessObjectDefinition = new IndexSearchResultKey(null, new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME));
        IndexSearchResultKey indexSearchResultKeyTag = new IndexSearchResultKey(new TagKey(TAG_TYPE, TAG_CODE), null);
        IndexSearchResult indexSearchResultBusinessObjectDefinition = new IndexSearchResult(SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name(), new SearchIndexKey(BUSINESS_OBJECT_DEFINITION_SEARCH_INDEX_NAME), indexSearchResultKeyBusinessObjectDefinition, BDEF_DISPLAY_NAME, BDEF_SHORT_DESCRIPTION, null);
        IndexSearchResult indexSearchResultTag = new IndexSearchResult(SearchIndexTypeEntity.SearchIndexTypes.TAG.name(), new SearchIndexKey(TAG_SEARCH_INDEX_NAME), indexSearchResultKeyTag, TAG_DISPLAY_NAME, TAG_DESCRIPTION, null);
        ArrayList<IndexSearchResult> indexSearchResults = new ArrayList<IndexSearchResult>();
        indexSearchResults.add(indexSearchResultBusinessObjectDefinition);
        indexSearchResults.add(indexSearchResultTag);
        IndexSearchResponse indexSearchResponse = new IndexSearchResponse(TOTAL_INDEX_SEARCH_RESULTS.longValue(), indexSearchResults, null);
        SearchIndexTypeEntity searchIndexTypeEntity = new SearchIndexTypeEntity();
        searchIndexTypeEntity.setCode(SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name());
        TagTypeEntity tagTypeEntity = new TagTypeEntity();
        tagTypeEntity.setCode(tagKey.getTagTypeCode());
        TagEntity tagEntity = new TagEntity();
        tagEntity.setTagCode(tagKey.getTagCode());
        tagEntity.setTagType(tagTypeEntity);
        Mockito.when((Object)this.tagDaoHelper.getTagEntity(tagKey)).thenReturn((Object)tagEntity);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("An", "index search result type", INDEX_SEARCH_RESULT_TYPE)).thenReturn((Object)INDEX_SEARCH_RESULT_TYPE);
        Mockito.when((Object)this.searchIndexDaoHelper.getActiveSearchIndex(SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name())).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.searchIndexDaoHelper.getActiveSearchIndex(SearchIndexTypeEntity.SearchIndexTypes.TAG.name())).thenReturn((Object)SEARCH_INDEX_NAME_2);
        Mockito.when((Object)this.indexSearchDao.indexSearch(indexSearchRequest, (Set)fields, NO_MATCH, SEARCH_INDEX_NAME, SEARCH_INDEX_NAME_2)).thenReturn((Object)indexSearchResponse);
        IndexSearchResponse result = this.indexSearchService.indexSearch(indexSearchRequest, (Set)fields, NO_MATCH);
        ((TagHelper)Mockito.verify((Object)this.tagHelper)).validateTagKey(tagKey);
        ((TagDaoHelper)Mockito.verify((Object)this.tagDaoHelper)).getTagEntity(tagKey);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("An", "index search result type", INDEX_SEARCH_RESULT_TYPE);
        ((SearchIndexTypeDaoHelper)Mockito.verify((Object)this.searchIndexTypeDaoHelper)).getSearchIndexTypeEntity(INDEX_SEARCH_RESULT_TYPE);
        ((IndexSearchDao)Mockito.verify((Object)this.indexSearchDao)).indexSearch(indexSearchRequest, (Set)fields, NO_MATCH, SEARCH_INDEX_NAME, SEARCH_INDEX_NAME_2);
        ((SearchIndexDaoHelper)Mockito.verify((Object)this.searchIndexDaoHelper)).getActiveSearchIndex(SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name());
        ((SearchIndexDaoHelper)Mockito.verify((Object)this.searchIndexDaoHelper)).getActiveSearchIndex(SearchIndexTypeEntity.SearchIndexTypes.TAG.name());
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)indexSearchResponse, (Object)result);
    }

    @Test
    public void testIndexSearchWithMatch() {
        TagKey tagKey = new TagKey(TAG_TYPE_CODE, TAG_CODE);
        IndexSearchRequest indexSearchRequest = new IndexSearchRequest("Search Term -foo foo-bar", (List)ImmutableList.of((Object)new IndexSearchFilter(EXCLUSION_SEARCH_FILTER, (List)ImmutableList.of((Object)new IndexSearchKey(tagKey, NO_INDEX_SEARCH_RESULT_TYPE_KEY))), (Object)new IndexSearchFilter(EXCLUSION_SEARCH_FILTER, (List)ImmutableList.of((Object)new IndexSearchKey(NO_TAG_KEY, new IndexSearchResultTypeKey(INDEX_SEARCH_RESULT_TYPE))))), Collections.singletonList("tag"), Boolean.valueOf(true));
        HashSet fields = Sets.newHashSet((Object[])new String[]{"displayName", "shortDescription"});
        HashSet match = Sets.newHashSet((Object[])new String[]{"column"});
        IndexSearchResultKey indexSearchResultKeyBusinessObjectDefinition = new IndexSearchResultKey(null, new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME));
        IndexSearchResultKey indexSearchResultKeyTag = new IndexSearchResultKey(new TagKey(TAG_TYPE, TAG_CODE), null);
        IndexSearchResult indexSearchResultBusinessObjectDefinition = new IndexSearchResult(SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name(), new SearchIndexKey(BUSINESS_OBJECT_DEFINITION_SEARCH_INDEX_NAME), indexSearchResultKeyBusinessObjectDefinition, BDEF_DISPLAY_NAME, BDEF_SHORT_DESCRIPTION, null);
        IndexSearchResult indexSearchResultTag = new IndexSearchResult(SearchIndexTypeEntity.SearchIndexTypes.TAG.name(), new SearchIndexKey(TAG_SEARCH_INDEX_NAME), indexSearchResultKeyTag, TAG_DISPLAY_NAME, TAG_DESCRIPTION, null);
        ArrayList<IndexSearchResult> indexSearchResults = new ArrayList<IndexSearchResult>();
        indexSearchResults.add(indexSearchResultBusinessObjectDefinition);
        indexSearchResults.add(indexSearchResultTag);
        IndexSearchResponse indexSearchResponse = new IndexSearchResponse(TOTAL_INDEX_SEARCH_RESULTS.longValue(), indexSearchResults, null);
        SearchIndexTypeEntity searchIndexTypeEntity = new SearchIndexTypeEntity();
        searchIndexTypeEntity.setCode(SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name());
        TagTypeEntity tagTypeEntity = new TagTypeEntity();
        tagTypeEntity.setCode(tagKey.getTagTypeCode());
        TagEntity tagEntity = new TagEntity();
        tagEntity.setTagCode(tagKey.getTagCode());
        tagEntity.setTagType(tagTypeEntity);
        Mockito.when((Object)this.tagDaoHelper.getTagEntity(tagKey)).thenReturn((Object)tagEntity);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("An", "index search result type", INDEX_SEARCH_RESULT_TYPE)).thenReturn((Object)INDEX_SEARCH_RESULT_TYPE);
        Mockito.when((Object)this.searchIndexDaoHelper.getActiveSearchIndex(SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name())).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.searchIndexDaoHelper.getActiveSearchIndex(SearchIndexTypeEntity.SearchIndexTypes.TAG.name())).thenReturn((Object)SEARCH_INDEX_NAME_2);
        Mockito.when((Object)this.indexSearchDao.indexSearch(indexSearchRequest, (Set)fields, (Set)match, SEARCH_INDEX_NAME, SEARCH_INDEX_NAME_2)).thenReturn((Object)indexSearchResponse);
        IndexSearchResponse result = this.indexSearchService.indexSearch(indexSearchRequest, (Set)fields, (Set)match);
        ((TagHelper)Mockito.verify((Object)this.tagHelper)).validateTagKey(tagKey);
        ((TagDaoHelper)Mockito.verify((Object)this.tagDaoHelper)).getTagEntity(tagKey);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("An", "index search result type", INDEX_SEARCH_RESULT_TYPE);
        ((SearchIndexTypeDaoHelper)Mockito.verify((Object)this.searchIndexTypeDaoHelper)).getSearchIndexTypeEntity(INDEX_SEARCH_RESULT_TYPE);
        ((IndexSearchDao)Mockito.verify((Object)this.indexSearchDao)).indexSearch(indexSearchRequest, (Set)fields, (Set)match, SEARCH_INDEX_NAME, SEARCH_INDEX_NAME_2);
        ((SearchIndexDaoHelper)Mockito.verify((Object)this.searchIndexDaoHelper)).getActiveSearchIndex(SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name());
        ((SearchIndexDaoHelper)Mockito.verify((Object)this.searchIndexDaoHelper)).getActiveSearchIndex(SearchIndexTypeEntity.SearchIndexTypes.TAG.name());
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)indexSearchResponse, (Object)result);
    }

    @Test
    public void testIndexSearchEmptyIndexSearchFilterList() {
        IndexSearchRequest indexSearchRequest = new IndexSearchRequest("Search Term -foo foo-bar", new ArrayList(), NO_INDEX_SEARCH_FACET_FIELDS, NO_ENABLE_HIT_HIGHLIGHTING);
        HashSet fields = Sets.newHashSet((Object[])new String[]{"displayName", "shortDescription"});
        try {
            this.indexSearchService.indexSearch(indexSearchRequest, (Set)fields, NO_MATCH);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least one index search filter must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testIndexSearchInvalidFacet() {
        IndexSearchRequest indexSearchRequest = new IndexSearchRequest("Search Term -foo foo-bar", NO_INDEX_SEARCH_FILTERS, Collections.singletonList(INVALID_VALUE), NO_ENABLE_HIT_HIGHLIGHTING);
        HashSet fields = Sets.newHashSet((Object[])new String[]{"displayName", "shortDescription"});
        try {
            this.indexSearchService.indexSearch(indexSearchRequest, (Set)fields, NO_MATCH);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Facet field \"%s\" is not supported.", INVALID_VALUE.toLowerCase()), (Object)e.getMessage());
        }
    }

    @Test
    public void testIndexSearchInvalidIndexSearchFilter() {
        TagKey tagKey = new TagKey(TAG_TYPE_CODE, TAG_CODE);
        IndexSearchFilter indexSearchFilter = new IndexSearchFilter(NO_EXCLUSION_SEARCH_FILTER, (List)ImmutableList.of((Object)new IndexSearchKey(tagKey, NO_INDEX_SEARCH_RESULT_TYPE_KEY), (Object)new IndexSearchKey(NO_TAG_KEY, new IndexSearchResultTypeKey(INDEX_SEARCH_RESULT_TYPE))));
        IndexSearchRequest indexSearchRequest = new IndexSearchRequest("Search Term -foo foo-bar", Collections.singletonList(indexSearchFilter), NO_INDEX_SEARCH_FACET_FIELDS, NO_ENABLE_HIT_HIGHLIGHTING);
        HashSet fields = Sets.newHashSet((Object[])new String[]{"displayName", "shortDescription"});
        TagTypeEntity tagTypeEntity = new TagTypeEntity();
        tagTypeEntity.setCode(tagKey.getTagTypeCode());
        TagEntity tagEntity = new TagEntity();
        tagEntity.setTagCode(tagKey.getTagCode());
        tagEntity.setTagType(tagTypeEntity);
        Mockito.when((Object)this.tagDaoHelper.getTagEntity(tagKey)).thenReturn((Object)tagEntity);
        try {
            this.indexSearchService.indexSearch(indexSearchRequest, (Set)fields, NO_MATCH);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Index search keys should be a homogeneous list of either index search result type keys or tag keys.", (Object)e.getMessage());
        }
        ((TagHelper)Mockito.verify((Object)this.tagHelper)).validateTagKey(tagKey);
        ((TagDaoHelper)Mockito.verify((Object)this.tagDaoHelper)).getTagEntity(tagKey);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testIndexSearchInvalidIndexSearchKey() {
        IndexSearchKey indexSearchKey = new IndexSearchKey(new TagKey(TAG_TYPE_CODE, TAG_CODE), new IndexSearchResultTypeKey(INDEX_SEARCH_RESULT_TYPE));
        IndexSearchFilter indexSearchFilter = new IndexSearchFilter(NO_EXCLUSION_SEARCH_FILTER, Collections.singletonList(indexSearchKey));
        IndexSearchRequest indexSearchRequest = new IndexSearchRequest("Search Term -foo foo-bar", Collections.singletonList(indexSearchFilter), NO_INDEX_SEARCH_FACET_FIELDS, NO_ENABLE_HIT_HIGHLIGHTING);
        HashSet fields = Sets.newHashSet((Object[])new String[]{"displayName", "shortDescription"});
        try {
            this.indexSearchService.indexSearch(indexSearchRequest, (Set)fields, NO_MATCH);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Exactly one instance of index search result type key or tag key must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testIndexSearchInvalidSearchTerm() {
        IndexSearchRequest indexSearchRequest = new IndexSearchRequest("", NO_INDEX_SEARCH_FILTERS, NO_INDEX_SEARCH_FACET_FIELDS, NO_ENABLE_HIT_HIGHLIGHTING);
        HashSet fields = Sets.newHashSet((Object[])new String[]{"displayName", "shortDescription"});
        try {
            this.indexSearchService.indexSearch(indexSearchRequest, (Set)fields, NO_MATCH);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("The search term length must be at least %d characters.", 3), (Object)e.getMessage());
        }
    }

    @Test
    public void testIndexSearchMissingOptionalParameters() {
        IndexSearchRequest indexSearchRequest = new IndexSearchRequest("Search Term -foo foo-bar", NO_INDEX_SEARCH_FILTERS, NO_INDEX_SEARCH_FACET_FIELDS, NO_ENABLE_HIT_HIGHLIGHTING);
        IndexSearchResultKey indexSearchResultKeyBusinessObjectDefinition = new IndexSearchResultKey(null, new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME));
        IndexSearchResultKey indexSearchResultKeyTag = new IndexSearchResultKey(new TagKey(TAG_TYPE, TAG_CODE), null);
        IndexSearchResult indexSearchResultBusinessObjectDefinition = new IndexSearchResult(SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name(), new SearchIndexKey(BUSINESS_OBJECT_DEFINITION_SEARCH_INDEX_NAME), indexSearchResultKeyBusinessObjectDefinition, BDEF_DISPLAY_NAME, BDEF_SHORT_DESCRIPTION, null);
        IndexSearchResult indexSearchResultTag = new IndexSearchResult(SearchIndexTypeEntity.SearchIndexTypes.TAG.name(), new SearchIndexKey(TAG_SEARCH_INDEX_NAME), indexSearchResultKeyTag, TAG_DISPLAY_NAME, TAG_DESCRIPTION, null);
        ArrayList<IndexSearchResult> indexSearchResults = new ArrayList<IndexSearchResult>();
        indexSearchResults.add(indexSearchResultBusinessObjectDefinition);
        indexSearchResults.add(indexSearchResultTag);
        IndexSearchResponse indexSearchResponse = new IndexSearchResponse(TOTAL_INDEX_SEARCH_RESULTS.longValue(), indexSearchResults, null);
        SearchIndexTypeEntity searchIndexTypeEntity = new SearchIndexTypeEntity();
        searchIndexTypeEntity.setCode(SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name());
        Mockito.when((Object)this.searchIndexDaoHelper.getActiveSearchIndex(SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name())).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.searchIndexDaoHelper.getActiveSearchIndex(SearchIndexTypeEntity.SearchIndexTypes.TAG.name())).thenReturn((Object)SEARCH_INDEX_NAME_2);
        Mockito.when((Object)this.indexSearchDao.indexSearch(indexSearchRequest, NO_FIELDS, NO_MATCH, SEARCH_INDEX_NAME, SEARCH_INDEX_NAME_2)).thenReturn((Object)indexSearchResponse);
        IndexSearchResponse result = this.indexSearchService.indexSearch(indexSearchRequest, NO_FIELDS, NO_MATCH);
        ((IndexSearchDao)Mockito.verify((Object)this.indexSearchDao)).indexSearch(indexSearchRequest, NO_FIELDS, NO_MATCH, SEARCH_INDEX_NAME, SEARCH_INDEX_NAME_2);
        ((SearchIndexDaoHelper)Mockito.verify((Object)this.searchIndexDaoHelper)).getActiveSearchIndex(SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name());
        ((SearchIndexDaoHelper)Mockito.verify((Object)this.searchIndexDaoHelper)).getActiveSearchIndex(SearchIndexTypeEntity.SearchIndexTypes.TAG.name());
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)indexSearchResponse, (Object)result);
    }

    @Test
    public void testIndexSearchNoSearchTerm() {
        IndexSearchRequest indexSearchRequest = new IndexSearchRequest(null, NO_INDEX_SEARCH_FILTERS, NO_INDEX_SEARCH_FACET_FIELDS, NO_ENABLE_HIT_HIGHLIGHTING);
        HashSet fields = Sets.newHashSet((Object[])new String[]{"displayName", "shortDescription"});
        try {
            this.indexSearchService.indexSearch(indexSearchRequest, (Set)fields, NO_MATCH);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A search term must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testIndexSearchWithResultTypeFilter() {
        IndexSearchKey indexSearchKey = new IndexSearchKey();
        IndexSearchResultTypeKey resultTypeKey = new IndexSearchResultTypeKey(SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name());
        indexSearchKey.setIndexSearchResultTypeKey(resultTypeKey);
        List<IndexSearchKey> indexSearchKeys = Collections.singletonList(indexSearchKey);
        IndexSearchFilter indexSearchFilter = new IndexSearchFilter(EXCLUSION_SEARCH_FILTER, indexSearchKeys);
        List<IndexSearchFilter> indexSearchFilters = Collections.singletonList(indexSearchFilter);
        IndexSearchRequest indexSearchRequest = new IndexSearchRequest("Search Term -foo foo-bar", indexSearchFilters, null, Boolean.valueOf(false));
        HashSet fields = Sets.newHashSet((Object[])new String[]{"displayName", "shortDescription"});
        IndexSearchResultKey indexSearchResultKeyBusinessObjectDefinition = new IndexSearchResultKey(null, new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME));
        IndexSearchResultKey indexSearchResultKeyTag = new IndexSearchResultKey(new TagKey(TAG_TYPE, TAG_CODE), null);
        IndexSearchResult indexSearchResultBusinessObjectDefinition = new IndexSearchResult(SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name(), new SearchIndexKey(BUSINESS_OBJECT_DEFINITION_SEARCH_INDEX_NAME), indexSearchResultKeyBusinessObjectDefinition, BDEF_DISPLAY_NAME, BDEF_SHORT_DESCRIPTION, null);
        IndexSearchResult indexSearchResultTag = new IndexSearchResult(SearchIndexTypeEntity.SearchIndexTypes.TAG.name(), new SearchIndexKey(TAG_SEARCH_INDEX_NAME), indexSearchResultKeyTag, TAG_DISPLAY_NAME, TAG_DESCRIPTION, null);
        ArrayList<IndexSearchResult> indexSearchResults = new ArrayList<IndexSearchResult>();
        indexSearchResults.add(indexSearchResultBusinessObjectDefinition);
        indexSearchResults.add(indexSearchResultTag);
        IndexSearchResponse indexSearchResponse = new IndexSearchResponse(TOTAL_INDEX_SEARCH_RESULTS.longValue(), indexSearchResults, null);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("An", "index search result type", SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name())).thenReturn((Object)SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name());
        Mockito.when((Object)this.searchIndexDaoHelper.getActiveSearchIndex(SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name())).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.searchIndexDaoHelper.getActiveSearchIndex(SearchIndexTypeEntity.SearchIndexTypes.TAG.name())).thenReturn((Object)SEARCH_INDEX_NAME_2);
        Mockito.when((Object)this.indexSearchDao.indexSearch(indexSearchRequest, (Set)fields, NO_MATCH, SEARCH_INDEX_NAME, SEARCH_INDEX_NAME_2)).thenReturn((Object)indexSearchResponse);
        IndexSearchResponse result = this.indexSearchService.indexSearch(indexSearchRequest, (Set)fields, NO_MATCH);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("An", "index search result type", SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name());
        ((SearchIndexTypeDaoHelper)Mockito.verify((Object)this.searchIndexTypeDaoHelper)).getSearchIndexTypeEntity(SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name());
        ((SearchIndexDaoHelper)Mockito.verify((Object)this.searchIndexDaoHelper)).getActiveSearchIndex(SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name());
        ((SearchIndexDaoHelper)Mockito.verify((Object)this.searchIndexDaoHelper)).getActiveSearchIndex(SearchIndexTypeEntity.SearchIndexTypes.TAG.name());
        ((IndexSearchDao)Mockito.verify((Object)this.indexSearchDao)).indexSearch(indexSearchRequest, (Set)fields, NO_MATCH, SEARCH_INDEX_NAME, SEARCH_INDEX_NAME_2);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)indexSearchResponse, (Object)result);
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.indexSearchDao, this.searchIndexDaoHelper, this.searchIndexTypeDaoHelper, this.tagDaoHelper, this.tagHelper});
    }
}

