/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.List;
import org.finra.herd.model.api.xml.JdbcConnection;
import org.finra.herd.model.api.xml.JdbcDatabaseType;
import org.finra.herd.model.api.xml.JdbcExecutionRequest;
import org.finra.herd.model.api.xml.JdbcStatement;
import org.finra.herd.model.api.xml.JdbcStatementType;
import org.springframework.stereotype.Component;

@Component
public class JdbcServiceTestHelper {
    public JdbcConnection createDefaultJdbcConnection() {
        JdbcConnection jdbcConnection = new JdbcConnection();
        jdbcConnection.setUrl("jdbc:h2:mem:herdTestDb");
        jdbcConnection.setUsername("");
        jdbcConnection.setPassword("");
        jdbcConnection.setDatabaseType(JdbcDatabaseType.POSTGRES);
        return jdbcConnection;
    }

    public JdbcExecutionRequest createDefaultQueryJdbcExecutionRequest() {
        JdbcConnection jdbcConnection = this.createDefaultJdbcConnection();
        List<JdbcStatement> jdbcStatements = this.createDefaultQueryJdbcStatements();
        JdbcExecutionRequest jdbcExecutionRequest = this.createJdbcExecutionRequest(jdbcConnection, jdbcStatements);
        return jdbcExecutionRequest;
    }

    public JdbcExecutionRequest createDefaultUpdateJdbcExecutionRequest() {
        JdbcConnection jdbcConnection = this.createDefaultJdbcConnection();
        List<JdbcStatement> jdbcStatements = this.createDefaultUpdateJdbcStatements();
        JdbcExecutionRequest jdbcExecutionRequest = this.createJdbcExecutionRequest(jdbcConnection, jdbcStatements);
        return jdbcExecutionRequest;
    }

    public JdbcExecutionRequest createJdbcExecutionRequest(JdbcConnection jdbcConnection, List<JdbcStatement> jdbcStatements) {
        JdbcExecutionRequest jdbcExecutionRequest = new JdbcExecutionRequest();
        jdbcExecutionRequest.setConnection(jdbcConnection);
        jdbcExecutionRequest.setStatements(jdbcStatements);
        return jdbcExecutionRequest;
    }

    private List<JdbcStatement> createDefaultQueryJdbcStatements() {
        ArrayList<JdbcStatement> jdbcStatements = new ArrayList<JdbcStatement>();
        JdbcStatement jdbcStatement = new JdbcStatement();
        jdbcStatement.setType(JdbcStatementType.QUERY);
        jdbcStatement.setSql("case1");
        jdbcStatements.add(jdbcStatement);
        return jdbcStatements;
    }

    private List<JdbcStatement> createDefaultUpdateJdbcStatements() {
        ArrayList<JdbcStatement> jdbcStatements = new ArrayList<JdbcStatement>();
        JdbcStatement jdbcStatement = new JdbcStatement();
        jdbcStatement.setType(JdbcStatementType.UPDATE);
        jdbcStatement.setSql("case1");
        jdbcStatements.add(jdbcStatement);
        return jdbcStatements;
    }
}

