/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.UUID;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ScriptTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.apache.commons.io.IOUtils;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.JobDefinition;
import org.finra.herd.model.api.xml.JobDefinitionCreateRequest;
import org.finra.herd.model.api.xml.JobDefinitionUpdateRequest;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.model.api.xml.S3PropertiesLocation;
import org.finra.herd.model.jpa.JobDefinitionEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class JobDefinitionServiceTest
extends AbstractServiceTest {
    private static final String INVALID_NAME = "Herd_Invalid_Name_" + UUID.randomUUID().toString().substring(0, 3);

    @Test
    public void testCreateJobDefinition() throws Exception {
        this.jobDefinitionServiceTestHelper.createJobDefinition(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateJobDefinitionNoJobName() throws Exception {
        String invalidJobName = "testNamespace";
        this.namespaceDaoTestHelper.createNamespaceEntity("testNamespace");
        JobDefinitionCreateRequest request = this.jobDefinitionServiceTestHelper.createJobDefinitionCreateRequest();
        request.setJobName(invalidJobName);
        this.jobDefinitionService.createJobDefinition(request, false);
    }

    @Test(expected=ObjectNotFoundException.class)
    public void testCreateJobDefinitionInvalidNamespace() throws Exception {
        JobDefinitionCreateRequest request = this.jobDefinitionServiceTestHelper.createJobDefinitionCreateRequest();
        this.jobDefinitionService.createJobDefinition(request, false);
    }

    @Test(expected=AlreadyExistsException.class)
    public void testCreateJobDefinitionAlreadyExists() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity("testNamespace");
        JobDefinitionCreateRequest request = this.jobDefinitionServiceTestHelper.createJobDefinitionCreateRequest();
        this.jobDefinitionService.createJobDefinition(request, false);
        this.jobDefinitionService.createJobDefinition(request, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateJobDefinitionInvalidActivitiXml() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity("testNamespace");
        JobDefinitionCreateRequest request = this.jobDefinitionServiceTestHelper.createJobDefinitionCreateRequest();
        InputStream xmlStream = this.resourceLoader.getResource("classpath:org/finra/herd/service/testHerdWorkflow.bpmn20.xml").getInputStream();
        request.setActivitiJobXml(IOUtils.toString((InputStream)xmlStream).replaceAll("startEvent", ""));
        this.jobDefinitionService.createJobDefinition(request, false);
    }

    @Test
    public void testCreateJobDefinitionWithParams() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity("testNamespace");
        JobDefinitionCreateRequest request = this.jobDefinitionServiceTestHelper.createJobDefinitionCreateRequest();
        ArrayList<Parameter> parameterEntities = new ArrayList<Parameter>();
        Parameter parameterEntity = new Parameter();
        parameterEntity.setName("Attribute Name 1");
        parameterEntity.setValue("Attribute Value 1");
        parameterEntities.add(parameterEntity);
        request.setParameters(parameterEntities);
        this.jobDefinitionService.createJobDefinition(request, false);
    }

    @Test
    public void testCreateJobDefinitionWithNoParams() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity("testNamespace");
        JobDefinitionCreateRequest request = this.jobDefinitionServiceTestHelper.createJobDefinitionCreateRequest();
        request.setParameters(null);
        this.jobDefinitionService.createJobDefinition(request, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateJobDefinitionInvalidActivitiElement() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity("testNamespace");
        JobDefinitionCreateRequest request = this.jobDefinitionServiceTestHelper.createJobDefinitionCreateRequest();
        InputStream xmlStream = this.resourceLoader.getResource("classpath:org/finra/herd/service/testHerdWorkflow.bpmn20.xml").getInputStream();
        request.setActivitiJobXml(IOUtils.toString((InputStream)xmlStream).replaceAll("serviceTask", "invalidActivitiTask"));
        this.jobDefinitionService.createJobDefinition(request, false);
    }

    @Test
    public void testCreateJobDefinitionWithS3PropertiesLocationPersistsEntity() throws Exception {
        S3PropertiesLocation s3PropertiesLocation = this.getS3PropertiesLocation();
        this.namespaceDaoTestHelper.createNamespaceEntity("testNamespace");
        JobDefinitionCreateRequest request = this.jobDefinitionServiceTestHelper.createJobDefinitionCreateRequest();
        request.setS3PropertiesLocation(s3PropertiesLocation);
        JobDefinition jobDefinition = this.jobDefinitionService.createJobDefinition(request, false);
        Assert.assertEquals((String)"jobDefinition s3PropertiesLocation", (Object)request.getS3PropertiesLocation(), (Object)jobDefinition.getS3PropertiesLocation());
        JobDefinitionEntity jobDefinitionEntity = (JobDefinitionEntity)this.herdDao.findById(JobDefinitionEntity.class, (Object)jobDefinition.getId());
        Assert.assertNotNull((String)"jobDefinitionEntity is null", (Object)jobDefinitionEntity);
        Assert.assertEquals((String)"jobDefinitionEntity s3BucketName", (Object)s3PropertiesLocation.getBucketName(), (Object)jobDefinitionEntity.getS3BucketName());
        Assert.assertEquals((String)"jobDefinitionEntity s3ObjectKey", (Object)s3PropertiesLocation.getKey(), (Object)jobDefinitionEntity.getS3ObjectKey());
    }

    @Test
    public void testCreateJobDefinitionWithS3PropertiesLocationValidateBucketNameRequired() throws Exception {
        S3PropertiesLocation s3PropertiesLocation = this.getS3PropertiesLocation();
        s3PropertiesLocation.setBucketName(null);
        this.testCreateJobDefinitionWithS3PropertiesLocationValidate(s3PropertiesLocation, IllegalArgumentException.class, "S3 properties location bucket name must be specified.");
    }

    @Test
    public void testCreateJobDefinitionWithS3PropertiesLocationValidateObjectKeyRequired() throws Exception {
        S3PropertiesLocation s3PropertiesLocation = this.getS3PropertiesLocation();
        s3PropertiesLocation.setKey(null);
        this.testCreateJobDefinitionWithS3PropertiesLocationValidate(s3PropertiesLocation, IllegalArgumentException.class, "S3 properties location object key must be specified.");
    }

    @Test
    public void testGetJobDefinition() throws Exception {
        JobDefinition jobDefinition = this.createJobDefinition();
        jobDefinition = this.jobDefinitionService.getJobDefinition(jobDefinition.getNamespace(), jobDefinition.getJobName());
        this.validateJobDefinition(jobDefinition);
    }

    @Test(expected=ObjectNotFoundException.class)
    public void testGetJobDefinitionNoExist() throws Exception {
        this.jobDefinitionService.getJobDefinition(INVALID_NAME, INVALID_NAME);
    }

    @Test
    public void testUpdateJobDefinition() throws Exception {
        JobDefinitionCreateRequest createRequest = this.jobDefinitionServiceTestHelper.createJobDefinitionCreateRequest();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        createRequest.setParameters(parameters);
        Parameter parameter = new Parameter("Attribute Name 1", "Attribute Value 1");
        parameters.add(parameter);
        parameter = new Parameter("Attribute Name 2", "   Attribute Value 2  ");
        parameters.add(parameter);
        this.namespaceDaoTestHelper.createNamespaceEntity("testNamespace");
        JobDefinition jobDefinition = this.jobDefinitionService.createJobDefinition(createRequest, false);
        JobDefinitionUpdateRequest updateRequest = this.createUpdateRequest(createRequest);
        JobDefinition updatedJobDefinition = this.jobDefinitionService.updateJobDefinition(createRequest.getNamespace(), createRequest.getJobName(), updateRequest, false);
        Assert.assertEquals((Object)new JobDefinition(jobDefinition.getId(), jobDefinition.getNamespace(), jobDefinition.getJobName(), updateRequest.getDescription(), updateRequest.getActivitiJobXml(), updateRequest.getParameters(), jobDefinition.getS3PropertiesLocation(), "SYSTEM"), (Object)updatedJobDefinition);
    }

    @Test(expected=ObjectNotFoundException.class)
    public void testUpdateJobDefinitionNamespaceNoExist() throws Exception {
        JobDefinitionUpdateRequest updateRequest = this.createUpdateRequest(this.jobDefinitionServiceTestHelper.createJobDefinitionCreateRequest());
        updateRequest.setActivitiJobXml(updateRequest.getActivitiJobXml().replace("testNamespace.testHerdWorkflow", INVALID_NAME + "." + INVALID_NAME));
        this.jobDefinitionService.updateJobDefinition(INVALID_NAME, INVALID_NAME, updateRequest, false);
    }

    @Test(expected=ObjectNotFoundException.class)
    public void testUpdateJobDefinitionJobNameNoExist() throws Exception {
        JobDefinitionUpdateRequest updateRequest = this.createUpdateRequest(this.jobDefinitionServiceTestHelper.createJobDefinitionCreateRequest());
        updateRequest.setActivitiJobXml(updateRequest.getActivitiJobXml().replace("testNamespace.testHerdWorkflow", "testNamespace." + INVALID_NAME));
        this.namespaceDaoTestHelper.createNamespaceEntity("testNamespace");
        this.jobDefinitionService.updateJobDefinition("testNamespace", INVALID_NAME, updateRequest, false);
    }

    @Test
    public void testUpdateJobDefinitionWithS3Properties() throws Exception {
        S3PropertiesLocation s3PropertiesLocation = this.getS3PropertiesLocation();
        this.namespaceDaoTestHelper.createNamespaceEntity("testNamespace");
        JobDefinitionCreateRequest createRequest = this.jobDefinitionServiceTestHelper.createJobDefinitionCreateRequest();
        JobDefinition jobDefinition = this.jobDefinitionService.createJobDefinition(createRequest, false);
        JobDefinitionUpdateRequest updateRequest = this.createUpdateRequest(createRequest);
        updateRequest.setS3PropertiesLocation(s3PropertiesLocation);
        JobDefinition updatedJobDefinition = this.jobDefinitionService.updateJobDefinition(createRequest.getNamespace(), createRequest.getJobName(), updateRequest, false);
        JobDefinitionEntity updatedJobDefinitionEntity = (JobDefinitionEntity)this.herdDao.findById(JobDefinitionEntity.class, (Object)updatedJobDefinition.getId());
        Assert.assertEquals((Object)new JobDefinition(jobDefinition.getId(), jobDefinition.getNamespace(), jobDefinition.getJobName(), updateRequest.getDescription(), updateRequest.getActivitiJobXml(), updateRequest.getParameters(), s3PropertiesLocation, "SYSTEM"), (Object)updatedJobDefinition);
        Assert.assertEquals((String)"updatedJobDefinitionEntity s3BucketName", (Object)s3PropertiesLocation.getBucketName(), (Object)updatedJobDefinitionEntity.getS3BucketName());
        Assert.assertEquals((String)"updatedJobDefinitionEntity s3ObjectKey", (Object)s3PropertiesLocation.getKey(), (Object)updatedJobDefinitionEntity.getS3ObjectKey());
    }

    @Test
    public void testUpdateJobDefinitionWithS3PropertiesClear() throws Exception {
        S3PropertiesLocation s3PropertiesLocation = this.getS3PropertiesLocation();
        this.namespaceDaoTestHelper.createNamespaceEntity("testNamespace");
        JobDefinitionCreateRequest createRequest = this.jobDefinitionServiceTestHelper.createJobDefinitionCreateRequest();
        createRequest.setS3PropertiesLocation(s3PropertiesLocation);
        JobDefinition jobDefinition = this.jobDefinitionService.createJobDefinition(createRequest, false);
        JobDefinitionUpdateRequest updateRequest = this.createUpdateRequest(createRequest);
        JobDefinition updatedJobDefinition = this.jobDefinitionService.updateJobDefinition(createRequest.getNamespace(), createRequest.getJobName(), updateRequest, false);
        JobDefinitionEntity updatedJobDefinitionEntity = (JobDefinitionEntity)this.herdDao.findById(JobDefinitionEntity.class, (Object)updatedJobDefinition.getId());
        Assert.assertEquals((Object)new JobDefinition(jobDefinition.getId(), jobDefinition.getNamespace(), jobDefinition.getJobName(), updateRequest.getDescription(), updateRequest.getActivitiJobXml(), updateRequest.getParameters(), null, "SYSTEM"), (Object)updatedJobDefinition);
        Assert.assertNull((String)"updatedJobDefinitionEntity s3BucketName", (Object)updatedJobDefinitionEntity.getS3BucketName());
        Assert.assertNull((String)"updatedJobDefinitionEntity s3ObjectKey", (Object)updatedJobDefinitionEntity.getS3ObjectKey());
    }

    @Test
    public void testCreateJobDefinitionAssertSuccessWhenFirstTaskAsync() throws Exception {
        String namespace = NAMESPACE;
        String jobName = JOB_NAME;
        BpmnModel bpmnModel = new BpmnModel();
        Process process = new Process();
        process.setId(namespace + '.' + jobName);
        StartEvent element = new StartEvent();
        element.setId("start");
        process.addFlowElement((FlowElement)element);
        element = new ScriptTask();
        element.setId("script");
        element.setScriptFormat("js");
        element.setScript("// do nothing");
        element.setAsynchronous(true);
        process.addFlowElement((FlowElement)element);
        element = new EndEvent();
        element.setId("end");
        process.addFlowElement((FlowElement)element);
        process.addFlowElement((FlowElement)new SequenceFlow("start", "script"));
        process.addFlowElement((FlowElement)new SequenceFlow("script", "end"));
        bpmnModel.addProcess(process);
        String activitiJobXml = this.getActivitiXmlFromBpmnModel(bpmnModel);
        this.namespaceDaoTestHelper.createNamespaceEntity(namespace);
        this.jobDefinitionService.createJobDefinition(new JobDefinitionCreateRequest(namespace, jobName, null, activitiJobXml, null, null), true);
    }

    @Test
    public void testCreateJobDefinitionAssertThrowErrorWhenFirstTaskNotAsync() throws Exception {
        String namespace = NAMESPACE;
        String jobName = JOB_NAME;
        BpmnModel bpmnModel = new BpmnModel();
        Process process = new Process();
        process.setId(namespace + '.' + jobName);
        StartEvent element = new StartEvent();
        element.setId("start");
        process.addFlowElement((FlowElement)element);
        element = new ScriptTask();
        element.setId("script");
        element.setScriptFormat("js");
        element.setScript("// do nothing");
        process.addFlowElement((FlowElement)element);
        element = new EndEvent();
        element.setId("end");
        process.addFlowElement((FlowElement)element);
        process.addFlowElement((FlowElement)new SequenceFlow("start", "script"));
        process.addFlowElement((FlowElement)new SequenceFlow("script", "end"));
        bpmnModel.addProcess(process);
        String activitiJobXml = this.getActivitiXmlFromBpmnModel(bpmnModel);
        this.namespaceDaoTestHelper.createNamespaceEntity(namespace);
        try {
            this.jobDefinitionService.createJobDefinition(new JobDefinitionCreateRequest(namespace, jobName, null, activitiJobXml, null, null), true);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)"Element with id \"script\" must be set to activiti:async=true. All tasks which start the workflow must be asynchronous to prevent certain undesired transactional behavior, such as records of workflow not being saved on errors. Please refer to Activiti and herd documentations for details.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateJobDefinitionAssertSuccessWhenFirstTaskNotAsyncable() throws Exception {
        String namespace = NAMESPACE;
        String jobName = JOB_NAME;
        BpmnModel bpmnModel = new BpmnModel();
        Process process = new Process();
        process.setId(namespace + '.' + jobName);
        StartEvent element = new StartEvent();
        element.setId("start");
        process.addFlowElement((FlowElement)element);
        element = new EndEvent();
        element.setId("end");
        process.addFlowElement((FlowElement)element);
        process.addFlowElement((FlowElement)new SequenceFlow("start", "end"));
        bpmnModel.addProcess(process);
        String activitiJobXml = this.getActivitiXmlFromBpmnModel(bpmnModel);
        this.namespaceDaoTestHelper.createNamespaceEntity(namespace);
        this.jobDefinitionService.createJobDefinition(new JobDefinitionCreateRequest(namespace, jobName, null, activitiJobXml, null, null), true);
    }

    @Test
    public void testUpdateJobDefinitionAssertSuccessWhenFirstTaskAsync() throws Exception {
        String namespace = NAMESPACE;
        String jobName = JOB_NAME;
        BpmnModel bpmnModel = new BpmnModel();
        Process process = new Process();
        process.setId(namespace + '.' + jobName);
        StartEvent element = new StartEvent();
        element.setId("start");
        process.addFlowElement((FlowElement)element);
        element = new ScriptTask();
        element.setId("script");
        element.setScriptFormat("js");
        element.setScript("// do nothing");
        element.setAsynchronous(true);
        process.addFlowElement((FlowElement)element);
        element = new EndEvent();
        element.setId("end");
        process.addFlowElement((FlowElement)element);
        process.addFlowElement((FlowElement)new SequenceFlow("start", "script"));
        process.addFlowElement((FlowElement)new SequenceFlow("script", "end"));
        bpmnModel.addProcess(process);
        String activitiJobXml = this.getActivitiXmlFromBpmnModel(bpmnModel);
        this.namespaceDaoTestHelper.createNamespaceEntity(namespace);
        this.jobDefinitionService.createJobDefinition(new JobDefinitionCreateRequest(namespace, jobName, null, activitiJobXml, null, null), true);
        this.jobDefinitionService.updateJobDefinition(namespace, jobName, new JobDefinitionUpdateRequest(null, activitiJobXml, null, null), true);
    }

    private JobDefinitionUpdateRequest createUpdateRequest(JobDefinitionCreateRequest createRequest) {
        JobDefinitionUpdateRequest updateRequest = new JobDefinitionUpdateRequest();
        updateRequest.setDescription(createRequest.getDescription() + "2");
        updateRequest.setActivitiJobXml(createRequest.getActivitiJobXml().replace("Unit Test", "Unit Test 2"));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        updateRequest.setParameters(parameters);
        Parameter parameter = new Parameter("Attribute Name 2", "   Attribute Value 2  2");
        parameters.add(parameter);
        parameter = new Parameter("Attribute Name 3", "Attribute Value 3");
        parameters.add(parameter);
        return updateRequest;
    }

    private JobDefinition createJobDefinition() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity("testNamespace");
        JobDefinitionCreateRequest request = this.jobDefinitionServiceTestHelper.createJobDefinitionCreateRequest();
        JobDefinition jobDefinition = this.jobDefinitionService.createJobDefinition(request, false);
        this.validateJobDefinition(jobDefinition);
        return jobDefinition;
    }

    private void validateJobDefinition(JobDefinition jobDefinition) {
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertEquals((Object)"testNamespace", (Object)jobDefinition.getNamespace());
        Assert.assertEquals((Object)"testHerdWorkflow", (Object)jobDefinition.getJobName());
        Assert.assertEquals((Object)JOB_DESCRIPTION, (Object)jobDefinition.getDescription());
        Assert.assertTrue((jobDefinition.getParameters().size() == 1 ? 1 : 0) != 0);
        Parameter parameter = (Parameter)jobDefinition.getParameters().get(0);
        Assert.assertEquals((Object)"Attribute Name 1", (Object)parameter.getName());
        Assert.assertEquals((Object)"Attribute Value 1", (Object)parameter.getValue());
        Assert.assertEquals((Object)"SYSTEM", (Object)jobDefinition.getLastUpdatedByUserId());
    }

    private S3PropertiesLocation getS3PropertiesLocation() {
        S3PropertiesLocation s3PropertiesLocation = new S3PropertiesLocation();
        s3PropertiesLocation.setBucketName("testBucketName");
        s3PropertiesLocation.setKey("testKey");
        return s3PropertiesLocation;
    }

    private void testCreateJobDefinitionWithS3PropertiesLocationValidate(S3PropertiesLocation s3PropertiesLocation, Class<? extends Exception> exceptionType, String exceptionMessage) {
        this.namespaceDaoTestHelper.createNamespaceEntity("testNamespace");
        JobDefinitionCreateRequest request = this.jobDefinitionServiceTestHelper.createJobDefinitionCreateRequest();
        request.setS3PropertiesLocation(s3PropertiesLocation);
        try {
            this.jobDefinitionService.createJobDefinition(request, false);
            Assert.fail((String)("expected " + exceptionType + ", but no exception was thrown"));
        }
        catch (Exception e) {
            Assert.assertEquals((String)"thrown exception type", exceptionType, e.getClass());
            Assert.assertEquals((String)"thrown exception message", (Object)exceptionMessage, (Object)e.getMessage());
        }
    }
}

