/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.finra.herd.dao.NamespaceDaoTestHelper;
import org.finra.herd.model.api.xml.JobDefinition;
import org.finra.herd.model.api.xml.JobDefinitionCreateRequest;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.JobDefinitionService;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Component
public class JobDefinitionServiceTestHelper {
    @Autowired
    private JobDefinitionService jobDefinitionService;
    @Autowired
    private NamespaceDaoTestHelper namespaceDaoTestHelper;
    @Autowired
    private ResourceLoader resourceLoader;

    public JobDefinition createJobDefinition(String activitiXmlClasspathResourceName) throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity("testNamespace");
        JobDefinitionCreateRequest jobDefinitionCreateRequest = this.createJobDefinitionCreateRequest(activitiXmlClasspathResourceName);
        JobDefinition jobDefinition = this.jobDefinitionService.createJobDefinition(jobDefinitionCreateRequest, false);
        Assert.assertEquals((Object)new JobDefinition(jobDefinition.getId(), jobDefinitionCreateRequest.getNamespace(), jobDefinitionCreateRequest.getJobName(), jobDefinitionCreateRequest.getDescription(), jobDefinitionCreateRequest.getActivitiJobXml(), jobDefinitionCreateRequest.getParameters(), jobDefinitionCreateRequest.getS3PropertiesLocation(), "SYSTEM"), (Object)jobDefinition);
        return jobDefinition;
    }

    public JobDefinitionCreateRequest createJobDefinitionCreateRequest() {
        return this.createJobDefinitionCreateRequest(null);
    }

    public JobDefinitionCreateRequest createJobDefinitionCreateRequest(String activitiXmlClasspathResourceName) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter parameter = new Parameter("Attribute Name 1", "Attribute Value 1");
        parameters.add(parameter);
        if (activitiXmlClasspathResourceName == null) {
            activitiXmlClasspathResourceName = "classpath:org/finra/herd/service/testHerdWorkflow.bpmn20.xml";
        }
        try {
            return this.createJobDefinitionCreateRequest("testNamespace", "testHerdWorkflow", AbstractServiceTest.JOB_DESCRIPTION, IOUtils.toString((InputStream)this.resourceLoader.getResource(activitiXmlClasspathResourceName).getInputStream()), parameters);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to load Activiti XML from classpath resource: " + activitiXmlClasspathResourceName);
        }
    }

    public JobDefinitionCreateRequest createJobDefinitionCreateRequest(String namespaceCd, String jobName, String jobDescription, String activitiXml, List<Parameter> parameters) {
        JobDefinitionCreateRequest request = new JobDefinitionCreateRequest();
        request.setNamespace(namespaceCd);
        request.setJobName(jobName);
        request.setDescription(jobDescription);
        request.setActivitiJobXml(activitiXml);
        request.setParameters(parameters);
        return request;
    }

    public JobDefinitionCreateRequest createJobDefinitionCreateRequestFromActivitiXml(String activitiXml) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter parameter = new Parameter("Attribute Name 1", "Attribute Name 1");
        parameters.add(parameter);
        return this.createJobDefinitionCreateRequest("testNamespace", "testHerdWorkflow", AbstractServiceTest.JOB_DESCRIPTION, activitiXml, parameters);
    }

    public JobDefinition createJobDefinitionForActivitiXml(String activitiXml) throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity("testNamespace");
        JobDefinitionCreateRequest jobDefinitionCreateRequest = this.createJobDefinitionCreateRequestFromActivitiXml(activitiXml);
        JobDefinition jobDefinition = this.jobDefinitionService.createJobDefinition(jobDefinitionCreateRequest, false);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertTrue((boolean)jobDefinition.getNamespace().equals(jobDefinitionCreateRequest.getNamespace()));
        Assert.assertTrue((boolean)jobDefinition.getJobName().equals(jobDefinitionCreateRequest.getJobName()));
        Assert.assertTrue((boolean)jobDefinition.getDescription().equals(jobDefinitionCreateRequest.getDescription()));
        return jobDefinition;
    }
}

