/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.AttributeDefinition;
import org.finra.herd.model.api.xml.BusinessObjectDataInvalidateUnregisteredRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectFormatKey;
import org.finra.herd.model.api.xml.MessageHeaderDefinition;
import org.finra.herd.model.api.xml.NotificationMessageDefinition;
import org.finra.herd.model.api.xml.NotificationMessageDefinitions;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.MessageHeader;
import org.finra.herd.model.dto.NotificationMessage;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.model.jpa.ConfigurationEntity;
import org.finra.herd.model.jpa.MessageTypeEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class MessageNotificationEventServiceTest
extends AbstractServiceTest {
    @Test
    public void testProcessBusinessObjectDataStatusChangeNotificationEvent() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:TestApplicationEvent xmlns:datamgt=\"http://testDomain/testApplication/testApplication-event\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n      <correlation-id>BusinessObjectData_$businessObjectDataId</correlation-id>\n      <context-message-type>testDomain/testApplication/BusinessObjectDataStatusChanged</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/testApplication/testApplication-event.xsd</xsd>\n      <event-id>\n         <system-name>testDomain/testApplication</system-name>\n         <system-unique-id>$uuid</system-unique-id>\n      </event-id>\n   </header>\n   <payload>\n      <eventDate>$current_time</eventDate>\n      <datamgtEvent>\n         <businessObjectDataStatusChanged>\n            <businessObjectDataKey>\n               <namespace>$businessObjectDataKey.namespace</namespace>\n               <businessObjectDefinitionName>$businessObjectDataKey.businessObjectDefinitionName</businessObjectDefinitionName>\n               <businessObjectFormatUsage>$businessObjectDataKey.businessObjectFormatUsage</businessObjectFormatUsage>\n               <businessObjectFormatFileType>$businessObjectDataKey.businessObjectFormatFileType</businessObjectFormatFileType>\n               <businessObjectFormatVersion>$businessObjectDataKey.businessObjectFormatVersion</businessObjectFormatVersion>\n               <partitionValue>$businessObjectDataKey.partitionValue</partitionValue>\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))               <subPartitionValues>\n#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues)                  <partitionValue>$subPartitionValue</partitionValue>\n#end               </subPartitionValues>\n#end               <businessObjectDataVersion>$businessObjectDataKey.businessObjectDataVersion</businessObjectDataVersion>\n            </businessObjectDataKey>\n            <newBusinessObjectDataStatus>$newBusinessObjectDataStatus</newBusinessObjectDataStatus>\n#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus))            <oldBusinessObjectDataStatus>$oldBusinessObjectDataStatus</oldBusinessObjectDataStatus>\n#end#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet()))            <attributes>\n#foreach($attributeName in $businessObjectDataAttributes.keySet())                <attribute name=\"$attributeName\">$!businessObjectDataAttributes.get($attributeName)</attribute>\n#end            </attributes>\n#end         </businessObjectDataStatusChanged>\n      </datamgtEvent>\n   </payload>\n   <soa-audit>\n      <triggered-date-time>$current_time</triggered-date-time>\n      <triggered-by-username>$username</triggered-by-username>\n      <transmission-id>$uuid</transmission-id>\n   </soa-audit>\n</datamgt:TestApplicationEvent>", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.messageNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, "VALID", "INVALID");
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusChangeMessageWithXmlPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, businessObjectDataEntity.getId(), "SYSTEM", "VALID", "INVALID", Collections.singletonList(new Attribute("Attribute Name 3", "Attribute Value 3")), NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testProcessBusinessObjectDataStatusChangeNotificationEventAttributeDefinitionCaseInsensitivity() throws Exception {
        List<AttributeDefinition> testAttributeDefinitions = Arrays.asList(new AttributeDefinition("Attribute Name 1".toUpperCase(), PUBLISH_ATTRIBUTE), new AttributeDefinition("Attribute Name 2".toLowerCase(), PUBLISH_ATTRIBUTE));
        List<Attribute> testAttributes = Arrays.asList(new Attribute("Attribute Name 1", "Attribute Name 1"), new Attribute("Attribute Name 2", "Attribute Name 2"));
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, testAttributeDefinitions, testAttributes);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:TestApplicationEvent xmlns:datamgt=\"http://testDomain/testApplication/testApplication-event\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n      <correlation-id>BusinessObjectData_$businessObjectDataId</correlation-id>\n      <context-message-type>testDomain/testApplication/BusinessObjectDataStatusChanged</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/testApplication/testApplication-event.xsd</xsd>\n      <event-id>\n         <system-name>testDomain/testApplication</system-name>\n         <system-unique-id>$uuid</system-unique-id>\n      </event-id>\n   </header>\n   <payload>\n      <eventDate>$current_time</eventDate>\n      <datamgtEvent>\n         <businessObjectDataStatusChanged>\n            <businessObjectDataKey>\n               <namespace>$businessObjectDataKey.namespace</namespace>\n               <businessObjectDefinitionName>$businessObjectDataKey.businessObjectDefinitionName</businessObjectDefinitionName>\n               <businessObjectFormatUsage>$businessObjectDataKey.businessObjectFormatUsage</businessObjectFormatUsage>\n               <businessObjectFormatFileType>$businessObjectDataKey.businessObjectFormatFileType</businessObjectFormatFileType>\n               <businessObjectFormatVersion>$businessObjectDataKey.businessObjectFormatVersion</businessObjectFormatVersion>\n               <partitionValue>$businessObjectDataKey.partitionValue</partitionValue>\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))               <subPartitionValues>\n#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues)                  <partitionValue>$subPartitionValue</partitionValue>\n#end               </subPartitionValues>\n#end               <businessObjectDataVersion>$businessObjectDataKey.businessObjectDataVersion</businessObjectDataVersion>\n            </businessObjectDataKey>\n            <newBusinessObjectDataStatus>$newBusinessObjectDataStatus</newBusinessObjectDataStatus>\n#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus))            <oldBusinessObjectDataStatus>$oldBusinessObjectDataStatus</oldBusinessObjectDataStatus>\n#end#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet()))            <attributes>\n#foreach($attributeName in $businessObjectDataAttributes.keySet())                <attribute name=\"$attributeName\">$!businessObjectDataAttributes.get($attributeName)</attribute>\n#end            </attributes>\n#end         </businessObjectDataStatusChanged>\n      </datamgtEvent>\n   </payload>\n   <soa-audit>\n      <triggered-date-time>$current_time</triggered-date-time>\n      <triggered-by-username>$username</triggered-by-username>\n      <transmission-id>$uuid</transmission-id>\n   </soa-audit>\n</datamgt:TestApplicationEvent>", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.messageNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, "VALID", "INVALID");
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusChangeMessageWithXmlPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, businessObjectDataEntity.getId(), "SYSTEM", "VALID", "INVALID", testAttributes, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testProcessBusinessObjectDataStatusChangeNotificationEventBusinessObjectDataAttributeNullValue() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, Collections.singletonList(new AttributeDefinition("Attribute Name 1", PUBLISH_ATTRIBUTE)), Collections.singletonList(new Attribute("Attribute Name 1", null)));
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:TestApplicationEvent xmlns:datamgt=\"http://testDomain/testApplication/testApplication-event\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n      <correlation-id>BusinessObjectData_$businessObjectDataId</correlation-id>\n      <context-message-type>testDomain/testApplication/BusinessObjectDataStatusChanged</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/testApplication/testApplication-event.xsd</xsd>\n      <event-id>\n         <system-name>testDomain/testApplication</system-name>\n         <system-unique-id>$uuid</system-unique-id>\n      </event-id>\n   </header>\n   <payload>\n      <eventDate>$current_time</eventDate>\n      <datamgtEvent>\n         <businessObjectDataStatusChanged>\n            <businessObjectDataKey>\n               <namespace>$businessObjectDataKey.namespace</namespace>\n               <businessObjectDefinitionName>$businessObjectDataKey.businessObjectDefinitionName</businessObjectDefinitionName>\n               <businessObjectFormatUsage>$businessObjectDataKey.businessObjectFormatUsage</businessObjectFormatUsage>\n               <businessObjectFormatFileType>$businessObjectDataKey.businessObjectFormatFileType</businessObjectFormatFileType>\n               <businessObjectFormatVersion>$businessObjectDataKey.businessObjectFormatVersion</businessObjectFormatVersion>\n               <partitionValue>$businessObjectDataKey.partitionValue</partitionValue>\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))               <subPartitionValues>\n#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues)                  <partitionValue>$subPartitionValue</partitionValue>\n#end               </subPartitionValues>\n#end               <businessObjectDataVersion>$businessObjectDataKey.businessObjectDataVersion</businessObjectDataVersion>\n            </businessObjectDataKey>\n            <newBusinessObjectDataStatus>$newBusinessObjectDataStatus</newBusinessObjectDataStatus>\n#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus))            <oldBusinessObjectDataStatus>$oldBusinessObjectDataStatus</oldBusinessObjectDataStatus>\n#end#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet()))            <attributes>\n#foreach($attributeName in $businessObjectDataAttributes.keySet())                <attribute name=\"$attributeName\">$!businessObjectDataAttributes.get($attributeName)</attribute>\n#end            </attributes>\n#end         </businessObjectDataStatusChanged>\n      </datamgtEvent>\n   </payload>\n   <soa-audit>\n      <triggered-date-time>$current_time</triggered-date-time>\n      <triggered-by-username>$username</triggered-by-username>\n      <transmission-id>$uuid</transmission-id>\n   </soa-audit>\n</datamgt:TestApplicationEvent>", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.messageNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, "VALID", "INVALID");
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusChangeMessageWithXmlPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, businessObjectDataEntity.getId(), "SYSTEM", "VALID", "INVALID", Collections.singletonList(new Attribute("Attribute Name 1", null)), NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testProcessBusinessObjectDataStatusChangeNotificationEventBusinessObjectDataAttributeSpecialValues() throws Exception {
        List<Attribute> testAttributes = Arrays.asList(new Attribute("Attribute Name 1", "      \t\t "), new Attribute("Attribute Name 2", ""));
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, Arrays.asList(new AttributeDefinition("Attribute Name 1", PUBLISH_ATTRIBUTE), new AttributeDefinition("Attribute Name 2", PUBLISH_ATTRIBUTE)), testAttributes);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:TestApplicationEvent xmlns:datamgt=\"http://testDomain/testApplication/testApplication-event\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n      <correlation-id>BusinessObjectData_$businessObjectDataId</correlation-id>\n      <context-message-type>testDomain/testApplication/BusinessObjectDataStatusChanged</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/testApplication/testApplication-event.xsd</xsd>\n      <event-id>\n         <system-name>testDomain/testApplication</system-name>\n         <system-unique-id>$uuid</system-unique-id>\n      </event-id>\n   </header>\n   <payload>\n      <eventDate>$current_time</eventDate>\n      <datamgtEvent>\n         <businessObjectDataStatusChanged>\n            <businessObjectDataKey>\n               <namespace>$businessObjectDataKey.namespace</namespace>\n               <businessObjectDefinitionName>$businessObjectDataKey.businessObjectDefinitionName</businessObjectDefinitionName>\n               <businessObjectFormatUsage>$businessObjectDataKey.businessObjectFormatUsage</businessObjectFormatUsage>\n               <businessObjectFormatFileType>$businessObjectDataKey.businessObjectFormatFileType</businessObjectFormatFileType>\n               <businessObjectFormatVersion>$businessObjectDataKey.businessObjectFormatVersion</businessObjectFormatVersion>\n               <partitionValue>$businessObjectDataKey.partitionValue</partitionValue>\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))               <subPartitionValues>\n#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues)                  <partitionValue>$subPartitionValue</partitionValue>\n#end               </subPartitionValues>\n#end               <businessObjectDataVersion>$businessObjectDataKey.businessObjectDataVersion</businessObjectDataVersion>\n            </businessObjectDataKey>\n            <newBusinessObjectDataStatus>$newBusinessObjectDataStatus</newBusinessObjectDataStatus>\n#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus))            <oldBusinessObjectDataStatus>$oldBusinessObjectDataStatus</oldBusinessObjectDataStatus>\n#end#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet()))            <attributes>\n#foreach($attributeName in $businessObjectDataAttributes.keySet())                <attribute name=\"$attributeName\">$!businessObjectDataAttributes.get($attributeName)</attribute>\n#end            </attributes>\n#end         </businessObjectDataStatusChanged>\n      </datamgtEvent>\n   </payload>\n   <soa-audit>\n      <triggered-date-time>$current_time</triggered-date-time>\n      <triggered-by-username>$username</triggered-by-username>\n      <transmission-id>$uuid</transmission-id>\n   </soa-audit>\n</datamgt:TestApplicationEvent>", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.messageNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, "VALID", "INVALID");
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusChangeMessageWithXmlPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, businessObjectDataEntity.getId(), "SYSTEM", "VALID", "INVALID", testAttributes, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessBusinessObjectDataStatusChangeNotificationEventHerdSqsNotificationNotEnabled() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData();
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        HashMap<String, Boolean> overrideMap = new HashMap<String, Boolean>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_ENABLED.getKey(), false);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            List result = this.messageNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, "VALID", "UPLOADING");
            Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)result));
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testProcessBusinessObjectDataStatusChangeNotificationEventNoBusinessObjectDataAttributeDefinitions() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, NO_ATTRIBUTE_DEFINITIONS, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:TestApplicationEvent xmlns:datamgt=\"http://testDomain/testApplication/testApplication-event\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n      <correlation-id>BusinessObjectData_$businessObjectDataId</correlation-id>\n      <context-message-type>testDomain/testApplication/BusinessObjectDataStatusChanged</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/testApplication/testApplication-event.xsd</xsd>\n      <event-id>\n         <system-name>testDomain/testApplication</system-name>\n         <system-unique-id>$uuid</system-unique-id>\n      </event-id>\n   </header>\n   <payload>\n      <eventDate>$current_time</eventDate>\n      <datamgtEvent>\n         <businessObjectDataStatusChanged>\n            <businessObjectDataKey>\n               <namespace>$businessObjectDataKey.namespace</namespace>\n               <businessObjectDefinitionName>$businessObjectDataKey.businessObjectDefinitionName</businessObjectDefinitionName>\n               <businessObjectFormatUsage>$businessObjectDataKey.businessObjectFormatUsage</businessObjectFormatUsage>\n               <businessObjectFormatFileType>$businessObjectDataKey.businessObjectFormatFileType</businessObjectFormatFileType>\n               <businessObjectFormatVersion>$businessObjectDataKey.businessObjectFormatVersion</businessObjectFormatVersion>\n               <partitionValue>$businessObjectDataKey.partitionValue</partitionValue>\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))               <subPartitionValues>\n#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues)                  <partitionValue>$subPartitionValue</partitionValue>\n#end               </subPartitionValues>\n#end               <businessObjectDataVersion>$businessObjectDataKey.businessObjectDataVersion</businessObjectDataVersion>\n            </businessObjectDataKey>\n            <newBusinessObjectDataStatus>$newBusinessObjectDataStatus</newBusinessObjectDataStatus>\n#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus))            <oldBusinessObjectDataStatus>$oldBusinessObjectDataStatus</oldBusinessObjectDataStatus>\n#end#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet()))            <attributes>\n#foreach($attributeName in $businessObjectDataAttributes.keySet())                <attribute name=\"$attributeName\">$!businessObjectDataAttributes.get($attributeName)</attribute>\n#end            </attributes>\n#end         </businessObjectDataStatusChanged>\n      </datamgtEvent>\n   </payload>\n   <soa-audit>\n      <triggered-date-time>$current_time</triggered-date-time>\n      <triggered-by-username>$username</triggered-by-username>\n      <transmission-id>$uuid</transmission-id>\n   </soa-audit>\n</datamgt:TestApplicationEvent>", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.messageNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, "VALID", "INVALID");
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusChangeMessageWithXmlPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, businessObjectDataEntity.getId(), "SYSTEM", "VALID", "INVALID", NO_ATTRIBUTES, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testProcessBusinessObjectDataStatusChangeNotificationEventNoBusinessObjectDataAttributes() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), NO_ATTRIBUTES);
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:TestApplicationEvent xmlns:datamgt=\"http://testDomain/testApplication/testApplication-event\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n      <correlation-id>BusinessObjectData_$businessObjectDataId</correlation-id>\n      <context-message-type>testDomain/testApplication/BusinessObjectDataStatusChanged</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/testApplication/testApplication-event.xsd</xsd>\n      <event-id>\n         <system-name>testDomain/testApplication</system-name>\n         <system-unique-id>$uuid</system-unique-id>\n      </event-id>\n   </header>\n   <payload>\n      <eventDate>$current_time</eventDate>\n      <datamgtEvent>\n         <businessObjectDataStatusChanged>\n            <businessObjectDataKey>\n               <namespace>$businessObjectDataKey.namespace</namespace>\n               <businessObjectDefinitionName>$businessObjectDataKey.businessObjectDefinitionName</businessObjectDefinitionName>\n               <businessObjectFormatUsage>$businessObjectDataKey.businessObjectFormatUsage</businessObjectFormatUsage>\n               <businessObjectFormatFileType>$businessObjectDataKey.businessObjectFormatFileType</businessObjectFormatFileType>\n               <businessObjectFormatVersion>$businessObjectDataKey.businessObjectFormatVersion</businessObjectFormatVersion>\n               <partitionValue>$businessObjectDataKey.partitionValue</partitionValue>\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))               <subPartitionValues>\n#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues)                  <partitionValue>$subPartitionValue</partitionValue>\n#end               </subPartitionValues>\n#end               <businessObjectDataVersion>$businessObjectDataKey.businessObjectDataVersion</businessObjectDataVersion>\n            </businessObjectDataKey>\n            <newBusinessObjectDataStatus>$newBusinessObjectDataStatus</newBusinessObjectDataStatus>\n#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus))            <oldBusinessObjectDataStatus>$oldBusinessObjectDataStatus</oldBusinessObjectDataStatus>\n#end#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet()))            <attributes>\n#foreach($attributeName in $businessObjectDataAttributes.keySet())                <attribute name=\"$attributeName\">$!businessObjectDataAttributes.get($attributeName)</attribute>\n#end            </attributes>\n#end         </businessObjectDataStatusChanged>\n      </datamgtEvent>\n   </payload>\n   <soa-audit>\n      <triggered-date-time>$current_time</triggered-date-time>\n      <triggered-by-username>$username</triggered-by-username>\n      <transmission-id>$uuid</transmission-id>\n   </soa-audit>\n</datamgt:TestApplicationEvent>", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.messageNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, "VALID", "INVALID");
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusChangeMessageWithXmlPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, businessObjectDataEntity.getId(), "SYSTEM", "VALID", "INVALID", NO_ATTRIBUTES, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testProcessBusinessObjectDataStatusChangeNotificationEventNoMessageDestination() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData();
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, NO_MESSAGE_DESTINATION, MESSAGE_TEXT, Collections.singletonList(new MessageHeaderDefinition(KEY, VALUE)))))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        try {
            this.messageNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, "VALID", "UPLOADING");
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Notification message destination must be specified. Please update \"%s\" configuration entry.", ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey()), (Object)e.getMessage());
        }
    }

    @Test
    public void testProcessBusinessObjectDataStatusChangeNotificationEventNoMessageHeaderDefinitions() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData(SUBPARTITION_VALUES, this.businessObjectFormatServiceTestHelper.getTestAttributeDefinitions(), this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:TestApplicationEvent xmlns:datamgt=\"http://testDomain/testApplication/testApplication-event\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n      <correlation-id>BusinessObjectData_$businessObjectDataId</correlation-id>\n      <context-message-type>testDomain/testApplication/BusinessObjectDataStatusChanged</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/testApplication/testApplication-event.xsd</xsd>\n      <event-id>\n         <system-name>testDomain/testApplication</system-name>\n         <system-unique-id>$uuid</system-unique-id>\n      </event-id>\n   </header>\n   <payload>\n      <eventDate>$current_time</eventDate>\n      <datamgtEvent>\n         <businessObjectDataStatusChanged>\n            <businessObjectDataKey>\n               <namespace>$businessObjectDataKey.namespace</namespace>\n               <businessObjectDefinitionName>$businessObjectDataKey.businessObjectDefinitionName</businessObjectDefinitionName>\n               <businessObjectFormatUsage>$businessObjectDataKey.businessObjectFormatUsage</businessObjectFormatUsage>\n               <businessObjectFormatFileType>$businessObjectDataKey.businessObjectFormatFileType</businessObjectFormatFileType>\n               <businessObjectFormatVersion>$businessObjectDataKey.businessObjectFormatVersion</businessObjectFormatVersion>\n               <partitionValue>$businessObjectDataKey.partitionValue</partitionValue>\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))               <subPartitionValues>\n#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues)                  <partitionValue>$subPartitionValue</partitionValue>\n#end               </subPartitionValues>\n#end               <businessObjectDataVersion>$businessObjectDataKey.businessObjectDataVersion</businessObjectDataVersion>\n            </businessObjectDataKey>\n            <newBusinessObjectDataStatus>$newBusinessObjectDataStatus</newBusinessObjectDataStatus>\n#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus))            <oldBusinessObjectDataStatus>$oldBusinessObjectDataStatus</oldBusinessObjectDataStatus>\n#end#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet()))            <attributes>\n#foreach($attributeName in $businessObjectDataAttributes.keySet())                <attribute name=\"$attributeName\">$!businessObjectDataAttributes.get($attributeName)</attribute>\n#end            </attributes>\n#end         </businessObjectDataStatusChanged>\n      </datamgtEvent>\n   </payload>\n   <soa-audit>\n      <triggered-date-time>$current_time</triggered-date-time>\n      <triggered-by-username>$username</triggered-by-username>\n      <transmission-id>$uuid</transmission-id>\n   </soa-audit>\n</datamgt:TestApplicationEvent>", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.messageNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, "VALID", "UPLOADING");
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusChangeMessageWithXmlPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, businessObjectDataEntity.getId(), "SYSTEM", "VALID", "UPLOADING", Collections.singletonList(new Attribute("Attribute Name 3", "Attribute Value 3")), NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testProcessBusinessObjectDataStatusChangeNotificationEventNoMessageType() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData();
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(NO_MESSAGE_TYPE, MESSAGE_DESTINATION, MESSAGE_TEXT, Collections.singletonList(new MessageHeaderDefinition(KEY, VALUE)))))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        try {
            this.messageNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, "VALID", "UPLOADING");
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Notification message type must be specified. Please update \"%s\" configuration entry.", ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey()), (Object)e.getMessage());
        }
    }

    @Test
    public void testProcessBusinessObjectDataStatusChangeNotificationEventNoMessageVelocityTemplate() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData();
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, NO_MESSAGE_VELOCITY_TEMPLATE, Collections.singletonList(new MessageHeaderDefinition(KEY, VALUE)))))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.messageNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, "VALID", "UPLOADING");
        Assert.assertEquals((long)0L, (long)CollectionUtils.size((Object)result));
    }

    @Test
    public void testProcessBusinessObjectDataStatusChangeNotificationEventNoOldStatus() throws Exception {
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataServiceTestHelper.createTestValidBusinessObjectData();
        BusinessObjectDataKey businessObjectDataKey = this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_DATA_STATUS_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:TestApplicationEvent xmlns:datamgt=\"http://testDomain/testApplication/testApplication-event\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n      <correlation-id>BusinessObjectData_$businessObjectDataId</correlation-id>\n      <context-message-type>testDomain/testApplication/BusinessObjectDataStatusChanged</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/testApplication/testApplication-event.xsd</xsd>\n      <event-id>\n         <system-name>testDomain/testApplication</system-name>\n         <system-unique-id>$uuid</system-unique-id>\n      </event-id>\n   </header>\n   <payload>\n      <eventDate>$current_time</eventDate>\n      <datamgtEvent>\n         <businessObjectDataStatusChanged>\n            <businessObjectDataKey>\n               <namespace>$businessObjectDataKey.namespace</namespace>\n               <businessObjectDefinitionName>$businessObjectDataKey.businessObjectDefinitionName</businessObjectDefinitionName>\n               <businessObjectFormatUsage>$businessObjectDataKey.businessObjectFormatUsage</businessObjectFormatUsage>\n               <businessObjectFormatFileType>$businessObjectDataKey.businessObjectFormatFileType</businessObjectFormatFileType>\n               <businessObjectFormatVersion>$businessObjectDataKey.businessObjectFormatVersion</businessObjectFormatVersion>\n               <partitionValue>$businessObjectDataKey.partitionValue</partitionValue>\n#if($CollectionUtils.isNotEmpty($businessObjectDataKey.subPartitionValues))               <subPartitionValues>\n#foreach ($subPartitionValue in $businessObjectDataKey.subPartitionValues)                  <partitionValue>$subPartitionValue</partitionValue>\n#end               </subPartitionValues>\n#end               <businessObjectDataVersion>$businessObjectDataKey.businessObjectDataVersion</businessObjectDataVersion>\n            </businessObjectDataKey>\n            <newBusinessObjectDataStatus>$newBusinessObjectDataStatus</newBusinessObjectDataStatus>\n#if($StringUtils.isNotEmpty($oldBusinessObjectDataStatus))            <oldBusinessObjectDataStatus>$oldBusinessObjectDataStatus</oldBusinessObjectDataStatus>\n#end#if($CollectionUtils.isNotEmpty($businessObjectDataAttributes.keySet()))            <attributes>\n#foreach($attributeName in $businessObjectDataAttributes.keySet())                <attribute name=\"$attributeName\">$!businessObjectDataAttributes.get($attributeName)</attribute>\n#end            </attributes>\n#end         </businessObjectDataStatusChanged>\n      </datamgtEvent>\n   </payload>\n   <soa-audit>\n      <triggered-date-time>$current_time</triggered-date-time>\n      <triggered-by-username>$username</triggered-by-username>\n      <transmission-id>$uuid</transmission-id>\n   </soa-audit>\n</datamgt:TestApplicationEvent>", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.messageNotificationEventService.processBusinessObjectDataStatusChangeNotificationEvent(businessObjectDataKey, "VALID", NO_BDATA_STATUS);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.businessObjectDataServiceTestHelper.validateBusinessObjectDataStatusChangeMessageWithXmlPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectDataKey, businessObjectDataEntity.getId(), "SYSTEM", "VALID", null, NO_ATTRIBUTES, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    @Test
    public void testProcessSystemMonitorNotificationEvent() throws Exception {
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_RESPONSE_VELOCITY_TEMPLATE.getKey(), "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:monitor xmlns:datamgt=\"http://testDomain/system-monitor\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n#if($StringUtils.isNotEmpty($incoming_message_correlation_id))      <correlation-id>$incoming_message_correlation_id</correlation-id>\n#end\n      <context-message-type>$incoming_message_context_message_type</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/system-monitor.xsd</xsd>\n   </header>\n   <payload>\n      <contextMessageTypeToPublish />\n   </payload>\n</datamgt:monitor>");
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            List result = this.messageNotificationEventService.processSystemMonitorNotificationEvent(this.getTestSystemMonitorIncomingMessage());
            Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
            this.validateSystemMonitorResponseNotificationMessage(MessageTypeEntity.MessageEventTypes.SQS.name(), "HERD_OUTGOING_QUEUE", (NotificationMessage)result.get(0));
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testProcessSystemMonitorNotificationEventHerdSqsNotificationNotEnabled() throws Exception {
        HashMap<String, Boolean> overrideMap = new HashMap<String, Boolean>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_ENABLED.getKey(), false);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            List result = this.messageNotificationEventService.processSystemMonitorNotificationEvent(this.getTestSystemMonitorIncomingMessage());
            Assert.assertEquals((long)0L, (long)result.size());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testProcessSystemMonitorNotificationEventNoMessageVelocityTemplate() throws Exception {
        HashMap<String, Object> overrideMap = new HashMap<String, Object>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_RESPONSE_VELOCITY_TEMPLATE.getKey(), null);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            List result = this.messageNotificationEventService.processSystemMonitorNotificationEvent(this.getTestSystemMonitorIncomingMessage());
            Assert.assertEquals((long)0L, (long)result.size());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testProcessSystemMonitorNotificationEventSqsOutgoingQueueNotDefined() throws Exception {
        HashMap<String, String> overrideMap = new HashMap<String, String>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_SYS_MONITOR_RESPONSE_VELOCITY_TEMPLATE.getKey(), "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:monitor xmlns:datamgt=\"http://testDomain/system-monitor\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n#if($StringUtils.isNotEmpty($incoming_message_correlation_id))      <correlation-id>$incoming_message_correlation_id</correlation-id>\n#end\n      <context-message-type>$incoming_message_context_message_type</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/system-monitor.xsd</xsd>\n   </header>\n   <payload>\n      <contextMessageTypeToPublish />\n   </payload>\n</datamgt:monitor>");
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_OUTGOING_QUEUE_NAME.getKey(), null);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            this.messageNotificationEventService.processSystemMonitorNotificationEvent(this.getTestSystemMonitorIncomingMessage());
            Assert.fail((String)"Suppose to throw IllegalStateException.");
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)String.format("SQS queue name not found. Ensure the \"%s\" configuration entry is configured.", ConfigurationValue.HERD_NOTIFICATION_SQS_OUTGOING_QUEUE_NAME.getKey()), (Object)ex.getMessage());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testProcessBusinessObjectFormatValueChangeNotificationEvent() throws Exception {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        BusinessObjectFormatKey businessObjectFormatKey = this.businessObjectFormatHelper.getBusinessObjectFormatKey(businessObjectFormatEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_FORMAT_VERSION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:TestApplicationEvent xmlns:datamgt=\"http://testDomain/testApplication/testApplication-event\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n      <context-message-type>testDomain/testApplication/BusinessObjectFormatVersionChanged</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/testApplication/testApplication-event.xsd</xsd>\n      <event-id>\n         <system-name>testDomain/testApplication</system-name>\n         <system-unique-id>$uuid</system-unique-id>\n      </event-id>\n   </header>\n   <payload>\n      <eventDate>$current_time</eventDate>\n      <datamgtEvent>\n         <businessObjectFormatVersionChanged>\n            <businessObjectFormatKey>\n               <namespace>$businessObjectFormatKey.namespace</namespace>\n               <businessObjectDefinitionName>$businessObjectFormatKey.businessObjectDefinitionName</businessObjectDefinitionName>\n               <businessObjectFormatUsage>$businessObjectFormatKey.businessObjectFormatUsage</businessObjectFormatUsage>\n               <businessObjectFormatFileType>$businessObjectFormatKey.businessObjectFormatFileType</businessObjectFormatFileType>\n               <businessObjectFormatVersion>$businessObjectFormatKey.businessObjectFormatVersion</businessObjectFormatVersion>\n            </businessObjectFormatKey>\n            <newBusinessObjectFormatVersion>$newBusinessObjectFormatVersion</newBusinessObjectFormatVersion>\n#if($StringUtils.isNotEmpty($oldBusinessObjectFormatVersion))            <oldBusinessObjectFormatVersion>$oldBusinessObjectFormatVersion</oldBusinessObjectFormatVersion>\n#end         </businessObjectFormatVersionChanged>\n      </datamgtEvent>\n   </payload>\n   <soa-audit>\n      <triggered-date-time>$current_time</triggered-date-time>\n      <triggered-by-username>$username</triggered-by-username>\n      <transmission-id>$uuid</transmission-id>\n   </soa-audit>\n</datamgt:TestApplicationEvent>", Collections.singletonList(new MessageHeaderDefinition(KEY, VALUE)))))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.messageNotificationEventService.processBusinessObjectFormatVersionChangeNotificationEvent(businessObjectFormatKey, NO_OLD_BUSINESS_OBJECT_FORMAT_VERSION);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormatVersionChangeMessageWithXmlPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectFormatKey, "SYSTEM", businessObjectFormatKey.getBusinessObjectFormatVersion().toString(), NO_OLD_BUSINESS_OBJECT_FORMAT_VERSION, Collections.singletonList(new MessageHeader(KEY, VALUE)), (NotificationMessage)result.get(0));
    }

    @Test
    public void testProcessBusinessObjectFormatValueChangeNotificationEventWithNoMessageHeaders() throws Exception {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        BusinessObjectFormatKey businessObjectFormatKey = this.businessObjectFormatHelper.getBusinessObjectFormatKey(businessObjectFormatEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_FORMAT_VERSION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, MESSAGE_DESTINATION, "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n<datamgt:TestApplicationEvent xmlns:datamgt=\"http://testDomain/testApplication/testApplication-event\">\n   <header>\n      <producer>\n         <name>testDomain/testApplication</name>\n         <environment>$herd_notification_sqs_environment</environment>\n      </producer>\n      <creation>\n         <datetime>$current_time</datetime>\n      </creation>\n      <context-message-type>testDomain/testApplication/BusinessObjectFormatVersionChanged</context-message-type>\n      <system-message-type>NoError</system-message-type>\n      <xsd>http://testDomain/testApplication/testApplication-event.xsd</xsd>\n      <event-id>\n         <system-name>testDomain/testApplication</system-name>\n         <system-unique-id>$uuid</system-unique-id>\n      </event-id>\n   </header>\n   <payload>\n      <eventDate>$current_time</eventDate>\n      <datamgtEvent>\n         <businessObjectFormatVersionChanged>\n            <businessObjectFormatKey>\n               <namespace>$businessObjectFormatKey.namespace</namespace>\n               <businessObjectDefinitionName>$businessObjectFormatKey.businessObjectDefinitionName</businessObjectDefinitionName>\n               <businessObjectFormatUsage>$businessObjectFormatKey.businessObjectFormatUsage</businessObjectFormatUsage>\n               <businessObjectFormatFileType>$businessObjectFormatKey.businessObjectFormatFileType</businessObjectFormatFileType>\n               <businessObjectFormatVersion>$businessObjectFormatKey.businessObjectFormatVersion</businessObjectFormatVersion>\n            </businessObjectFormatKey>\n            <newBusinessObjectFormatVersion>$newBusinessObjectFormatVersion</newBusinessObjectFormatVersion>\n#if($StringUtils.isNotEmpty($oldBusinessObjectFormatVersion))            <oldBusinessObjectFormatVersion>$oldBusinessObjectFormatVersion</oldBusinessObjectFormatVersion>\n#end         </businessObjectFormatVersionChanged>\n      </datamgtEvent>\n   </payload>\n   <soa-audit>\n      <triggered-date-time>$current_time</triggered-date-time>\n      <triggered-by-username>$username</triggered-by-username>\n      <transmission-id>$uuid</transmission-id>\n   </soa-audit>\n</datamgt:TestApplicationEvent>", NO_MESSAGE_HEADER_DEFINITIONS)))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        List result = this.messageNotificationEventService.processBusinessObjectFormatVersionChangeNotificationEvent(businessObjectFormatKey, NO_OLD_BUSINESS_OBJECT_FORMAT_VERSION);
        Assert.assertEquals((long)1L, (long)CollectionUtils.size((Object)result));
        this.businessObjectFormatServiceTestHelper.validateBusinessObjectFormatVersionChangeMessageWithXmlPayload(MESSAGE_TYPE, MESSAGE_DESTINATION, businessObjectFormatKey, "SYSTEM", businessObjectFormatKey.getBusinessObjectFormatVersion().toString(), NO_OLD_BUSINESS_OBJECT_FORMAT_VERSION, NO_MESSAGE_HEADERS, (NotificationMessage)result.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessBusinessObjectFormatVersionChangeNotificationEventHerdSqsNotificationNotEnabled() throws Exception {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        BusinessObjectFormatKey businessObjectFormatKey = this.businessObjectFormatHelper.getBusinessObjectFormatKey(businessObjectFormatEntity);
        HashMap<String, Boolean> overrideMap = new HashMap<String, Boolean>();
        overrideMap.put(ConfigurationValue.HERD_NOTIFICATION_SQS_ENABLED.getKey(), false);
        this.modifyPropertySourceInEnvironment(overrideMap);
        try {
            List result = this.messageNotificationEventService.processBusinessObjectFormatVersionChangeNotificationEvent(businessObjectFormatKey, NO_OLD_BUSINESS_OBJECT_FORMAT_VERSION);
            Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)result));
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testProcessBusinessObjectFormatVersionChangeNotificationEventNoMessageDestination() throws Exception {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        BusinessObjectFormatKey businessObjectFormatKey = this.businessObjectFormatHelper.getBusinessObjectFormatKey(businessObjectFormatEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_FORMAT_VERSION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(MESSAGE_TYPE, NO_MESSAGE_DESTINATION, MESSAGE_TEXT, Collections.singletonList(new MessageHeaderDefinition(KEY, VALUE)))))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        try {
            this.messageNotificationEventService.processBusinessObjectFormatVersionChangeNotificationEvent(businessObjectFormatKey, NO_OLD_BUSINESS_OBJECT_FORMAT_VERSION);
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Notification message destination must be specified. Please update \"%s\" configuration entry.", ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_FORMAT_VERSION_CHANGE_MESSAGE_DEFINITIONS.getKey()), (Object)e.getMessage());
        }
    }

    @Test
    public void testProcessBusinessObjectFormatVersionChangeNotificationEventNoMessageType() throws Exception {
        BusinessObjectDataInvalidateUnregisteredRequest request = new BusinessObjectDataInvalidateUnregisteredRequest(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, "S3_MANAGED");
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatServiceTestHelper.createBusinessObjectFormat(request);
        BusinessObjectFormatKey businessObjectFormatKey = this.businessObjectFormatHelper.getBusinessObjectFormatKey(businessObjectFormatEntity);
        ConfigurationEntity configurationEntity = new ConfigurationEntity();
        configurationEntity.setKey(ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_FORMAT_VERSION_CHANGE_MESSAGE_DEFINITIONS.getKey());
        configurationEntity.setValueClob(this.xmlHelper.objectToXml((Object)new NotificationMessageDefinitions(Collections.singletonList(new NotificationMessageDefinition(NO_MESSAGE_TYPE, MESSAGE_DESTINATION, MESSAGE_TEXT, Collections.singletonList(new MessageHeaderDefinition(KEY, VALUE)))))));
        this.configurationDao.saveAndRefresh((Object)configurationEntity);
        try {
            this.messageNotificationEventService.processBusinessObjectFormatVersionChangeNotificationEvent(businessObjectFormatKey, NO_OLD_BUSINESS_OBJECT_FORMAT_VERSION);
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Notification message type must be specified. Please update \"%s\" configuration entry.", ConfigurationValue.HERD_NOTIFICATION_BUSINESS_OBJECT_FORMAT_VERSION_CHANGE_MESSAGE_DEFINITIONS.getKey()), (Object)e.getMessage());
        }
    }
}

