/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.finra.herd.core.helper.LogLevel;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.Job;
import org.finra.herd.model.api.xml.JobAction;
import org.finra.herd.model.api.xml.JobDefinition;
import org.finra.herd.model.api.xml.NotificationRegistrationKey;
import org.finra.herd.model.api.xml.Parameter;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.model.jpa.NotificationEventTypeEntity;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.impl.BusinessObjectDataNotificationJobActionServiceImpl;
import org.finra.herd.service.impl.StorageUnitStatusChangeNotificationJobActionServiceImpl;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.util.CollectionUtils;

public class NotificationEventServiceTest
extends AbstractServiceTest {
    @Test
    public void testProcessBusinessObjectDataRegistrationNotificationEventSync() throws Exception {
        JobDefinition jobDefinition = this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/activitiWorkflowLogVariablesNoRegex.bpmn20.xml");
        ArrayList<JobAction> jobActions = new ArrayList<JobAction>();
        jobActions.add(new JobAction(jobDefinition.getNamespace(), jobDefinition.getJobName(), CORRELATION_DATA));
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, LATEST_VERSION_FLAG_SET, "PRTN_CLMN001", NO_PARTITION_KEY_GROUP, NO_ATTRIBUTES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns());
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectFormatEntity, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3");
        this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntity, businessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, null, jobActions, "ENABLED");
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME_2), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME_2, BDATA_STATUS, null, jobActions, "ENABLED");
        List notificationActions = this.notificationEventService.processBusinessObjectDataNotificationEventSync(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN, new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), BDATA_STATUS, null);
        Job job = (Job)notificationActions.get(0);
        Assert.assertEquals((Object)new Job(job.getId(), null, "testNamespace", "testHerdWorkflow", null, null, null, null, Arrays.asList(new Parameter("notification_businessObjectDefinitionName", BDEF_NAME), new Parameter("notification_partitionValues", PARTITION_VALUE + "|" + StringUtils.join((Iterable)SUBPARTITION_VALUES, (String)"|")), new Parameter("notification_namespace", NAMESPACE), new Parameter("notification_businessObjectData", this.jsonHelper.objectToJson((Object)this.businessObjectDataHelper.createBusinessObjectDataFromEntity(businessObjectDataEntity))), new Parameter("notification_businessObjectFormatUsage", FORMAT_USAGE_CODE), new Parameter("herd_workflowEnvironment", this.configurationHelper.getProperty(ConfigurationValue.HERD_ENVIRONMENT)), new Parameter("notification_businessObjectDefinitionNamespace", BDEF_NAMESPACE), new Parameter("notification_newBusinessObjectDataStatus", BDATA_STATUS), new Parameter("Attribute Name 1", "Attribute Value 1"), new Parameter("notification_businessObjectDataVersion", DATA_VERSION.toString()), new Parameter("notification_name", NOTIFICATION_NAME), new Parameter("notification_oldBusinessObjectDataStatus", null), new Parameter("notification_partitionColumnNames", "PRTN_CLMN001|PRTN_CLMN002|PRTN_CLMN003|PRTN_CLMN004|PRTN_CLMN005"), new Parameter("notification_businessObjectDataEventType", NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name()), new Parameter("notification_businessObjectFormatVersion", FORMAT_VERSION.toString()), new Parameter("notification_businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE), new Parameter("notification_correlationData", CORRELATION_DATA)), null, null, null), (Object)job);
    }

    @Test
    public void testProcessBusinessObjectDataRegistrationNotificationEventSyncAssertFireEnabledOnly() throws Exception {
        JobDefinition jobDefinition = this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/activitiWorkflowLogVariablesNoRegex.bpmn20.xml");
        List<JobAction> jobActions1 = Arrays.asList(new JobAction(jobDefinition.getNamespace(), jobDefinition.getJobName(), CORRELATION_DATA));
        List<JobAction> jobActions2 = Arrays.asList(new JobAction(jobDefinition.getNamespace(), jobDefinition.getJobName(), CORRELATION_DATA_2));
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, LATEST_VERSION_FLAG_SET, "PRTN_CLMN001", NO_PARTITION_KEY_GROUP, NO_ATTRIBUTES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns());
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectFormatEntity, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3");
        this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntity, businessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, null, jobActions1, "ENABLED");
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME_2), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME_2, BDATA_STATUS, null, jobActions2, "DISABLED");
        List notificationActions = this.notificationEventService.processBusinessObjectDataNotificationEventSync(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN, new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), BDATA_STATUS, null);
        Assert.assertEquals((long)1L, (long)notificationActions.size());
        Assert.assertEquals(Job.class, notificationActions.get(0).getClass());
        Job job = (Job)notificationActions.get(0);
        List parameters = job.getParameters();
        boolean found = false;
        for (Parameter parameter : parameters) {
            String name = parameter.getName();
            if (!"notification_correlationData".equals(name)) continue;
            Assert.assertEquals((Object)CORRELATION_DATA, (Object)parameter.getValue());
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void testProcessBusinessObjectDataRegistrationNotificationEventSyncAssertNoopWhenAllDisabled() throws Exception {
        JobDefinition jobDefinition = this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/activitiWorkflowLogVariablesNoRegex.bpmn20.xml");
        List<JobAction> jobActions1 = Arrays.asList(new JobAction(jobDefinition.getNamespace(), jobDefinition.getJobName(), CORRELATION_DATA));
        List<JobAction> jobActions2 = Arrays.asList(new JobAction(jobDefinition.getNamespace(), jobDefinition.getJobName(), CORRELATION_DATA_2));
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, LATEST_VERSION_FLAG_SET, "PRTN_CLMN001", NO_PARTITION_KEY_GROUP, NO_ATTRIBUTES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns());
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectFormatEntity, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3");
        this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntity, businessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, null, jobActions1, "DISABLED");
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME_2), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME_2, BDATA_STATUS, null, jobActions2, "DISABLED");
        List notificationActions = this.notificationEventService.processBusinessObjectDataNotificationEventSync(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN, new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), BDATA_STATUS, null);
        Assert.assertEquals((long)0L, (long)notificationActions.size());
    }

    @Test
    public void testProcessBusinessObjectDataRegistrationNotificationEventSyncMissingOptional() throws Exception {
        JobDefinition jobDefinition = this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/activitiWorkflowLogVariablesNoRegex.bpmn20.xml");
        ArrayList<JobAction> jobActions = new ArrayList<JobAction>();
        jobActions.add(new JobAction(jobDefinition.getNamespace(), jobDefinition.getJobName(), CORRELATION_DATA));
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), BDEF_NAMESPACE, BDEF_NAME, null, null, null, null, null, null, jobActions, "ENABLED");
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        List notificationActions = this.notificationEventService.processBusinessObjectDataNotificationEventSync(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN, businessObjectDataKey, BDATA_STATUS, null);
        Job job = (Job)notificationActions.get(0);
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((Object)"testNamespace", (Object)job.getNamespace());
        Assert.assertEquals((Object)"testHerdWorkflow", (Object)job.getJobName());
        Parameter parameter = null;
        for (Parameter param : job.getParameters()) {
            if (!param.getName().equals("notification_correlationData")) continue;
            parameter = param;
            break;
        }
        Assert.assertNotNull(parameter);
        Assert.assertEquals((Object)CORRELATION_DATA, (Object)parameter.getValue());
    }

    @Test
    public void testProcessBusinessObjectDataRegistrationNotificationEventSyncMultipleNotifications() throws Exception {
        JobDefinition jobDefinition = this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/activitiWorkflowLogVariablesNoRegex.bpmn20.xml");
        ArrayList<JobAction> jobActions = new ArrayList<JobAction>();
        jobActions.add(new JobAction(jobDefinition.getNamespace(), jobDefinition.getJobName(), CORRELATION_DATA));
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, Boolean.valueOf(true), BDATA_STATUS);
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3");
        this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntity, businessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, null, jobActions, "ENABLED");
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME_2), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, BDATA_STATUS, null, jobActions, "ENABLED");
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        List notificationActions = this.notificationEventService.processBusinessObjectDataNotificationEventSync(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN, businessObjectDataKey, BDATA_STATUS, null);
        Assert.assertTrue((notificationActions.size() == 2 ? 1 : 0) != 0);
        for (Object notificationAction : notificationActions) {
            Job job = (Job)notificationAction;
            Assert.assertNotNull((Object)job);
            Assert.assertEquals((Object)"testNamespace", (Object)job.getNamespace());
            Assert.assertEquals((Object)"testHerdWorkflow", (Object)job.getJobName());
            Parameter parameter = null;
            for (Parameter param : job.getParameters()) {
                if (!param.getName().equals("notification_correlationData")) continue;
                parameter = param;
                break;
            }
            Assert.assertNotNull(parameter);
            Assert.assertEquals((Object)CORRELATION_DATA, (Object)parameter.getValue());
        }
    }

    @Test
    public void testProcessBusinessObjectDataRegistrationNotificationEventSyncNoNotification() throws Exception {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, BDATA_STATUS);
        List notificationActions = this.notificationEventService.processBusinessObjectDataNotificationEventSync(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_RGSTN, businessObjectDataKey, BDATA_STATUS, null);
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)notificationActions));
    }

    @Test
    public void testProcessBusinessObjectDataStatusChangeNotificationEventSync() throws Exception {
        this.runProcessBusinessObjectDataStatusChangeNotificationEventSyncTest();
    }

    @Test
    public void testProcessBusinessObjectDataStatusChangeNotificationEventSyncWithInfoLoggingEnabled() throws Exception {
        LogLevel origLogLevel = this.getLogLevel(BusinessObjectDataNotificationJobActionServiceImpl.class);
        this.setLogLevel(BusinessObjectDataNotificationJobActionServiceImpl.class, LogLevel.INFO);
        try {
            this.runProcessBusinessObjectDataStatusChangeNotificationEventSyncTest();
        }
        finally {
            this.setLogLevel(BusinessObjectDataNotificationJobActionServiceImpl.class, origLogLevel);
        }
    }

    @Test
    public void testProcessStorageUnitStatusChangeNotificationEventSync() throws Exception {
        this.runProcessStorageUnitStatusChangeNotificationEventSyncTest();
    }

    @Test
    public void testProcessStorageUnitStatusChangeNotificationEventSyncWithInfoLoggingEnabled() throws Exception {
        LogLevel origLogLevel = this.getLogLevel(StorageUnitStatusChangeNotificationJobActionServiceImpl.class);
        this.setLogLevel(StorageUnitStatusChangeNotificationJobActionServiceImpl.class, LogLevel.INFO);
        try {
            this.runProcessStorageUnitStatusChangeNotificationEventSyncTest();
        }
        finally {
            this.setLogLevel(StorageUnitStatusChangeNotificationJobActionServiceImpl.class, origLogLevel);
        }
    }

    private void runProcessBusinessObjectDataStatusChangeNotificationEventSyncTest() throws Exception {
        JobDefinition jobDefinition = this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/activitiWorkflowLogVariablesNoRegex.bpmn20.xml");
        ArrayList<JobAction> jobActions = new ArrayList<JobAction>();
        jobActions.add(new JobAction(jobDefinition.getNamespace(), jobDefinition.getJobName(), CORRELATION_DATA));
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, LATEST_VERSION_FLAG_SET, "PRTN_CLMN001", NO_PARTITION_KEY_GROUP, NO_ATTRIBUTES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns());
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectFormatEntity, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "UPLOADING");
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3");
        this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntity, businessObjectDataEntity, "ENABLED", NO_STORAGE_DIRECTORY_PATH);
        this.notificationRegistrationDaoTestHelper.createBusinessObjectDataNotificationRegistrationEntity(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, "VALID", "UPLOADING", jobActions, "ENABLED");
        List notificationActions = this.notificationEventService.processBusinessObjectDataNotificationEventSync(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG, new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), "VALID", "UPLOADING");
        Job job = (Job)notificationActions.get(0);
        Assert.assertEquals((Object)new Job(job.getId(), null, "testNamespace", "testHerdWorkflow", null, null, null, null, Arrays.asList(new Parameter("notification_businessObjectDefinitionName", BDEF_NAME), new Parameter("notification_partitionValues", PARTITION_VALUE + "|" + StringUtils.join((Iterable)SUBPARTITION_VALUES, (String)"|")), new Parameter("notification_namespace", NAMESPACE), new Parameter("notification_businessObjectData", this.jsonHelper.objectToJson((Object)this.businessObjectDataHelper.createBusinessObjectDataFromEntity(businessObjectDataEntity))), new Parameter("notification_businessObjectFormatUsage", FORMAT_USAGE_CODE), new Parameter("herd_workflowEnvironment", this.configurationHelper.getProperty(ConfigurationValue.HERD_ENVIRONMENT)), new Parameter("notification_businessObjectDefinitionNamespace", BDEF_NAMESPACE), new Parameter("notification_newBusinessObjectDataStatus", "VALID"), new Parameter("Attribute Name 1", "Attribute Value 1"), new Parameter("notification_businessObjectDataVersion", DATA_VERSION.toString()), new Parameter("notification_name", NOTIFICATION_NAME), new Parameter("notification_oldBusinessObjectDataStatus", "UPLOADING"), new Parameter("notification_partitionColumnNames", "PRTN_CLMN001|PRTN_CLMN002|PRTN_CLMN003|PRTN_CLMN004|PRTN_CLMN005"), new Parameter("notification_businessObjectDataEventType", NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG.name()), new Parameter("notification_businessObjectFormatVersion", FORMAT_VERSION.toString()), new Parameter("notification_businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE), new Parameter("notification_correlationData", CORRELATION_DATA)), null, null, null), (Object)job);
    }

    private void runProcessStorageUnitStatusChangeNotificationEventSyncTest() throws Exception {
        JobDefinition jobDefinition = this.jobDefinitionServiceTestHelper.createJobDefinition("classpath:org/finra/herd/service/activitiWorkflowLogVariablesNoRegex.bpmn20.xml");
        ArrayList<JobAction> jobActions = new ArrayList<JobAction>();
        jobActions.add(new JobAction(jobDefinition.getNamespace(), jobDefinition.getJobName(), CORRELATION_DATA));
        BusinessObjectFormatEntity businessObjectFormatEntity = this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, FORMAT_DESCRIPTION, LATEST_VERSION_FLAG_SET, "PRTN_CLMN001", NO_PARTITION_KEY_GROUP, NO_ATTRIBUTES, "|", "\\", "\\N", this.schemaColumnDaoTestHelper.getTestSchemaColumns(), this.schemaColumnDaoTestHelper.getTestPartitionColumns());
        BusinessObjectDataEntity businessObjectDataEntity = this.businessObjectDataDaoTestHelper.createBusinessObjectDataEntity(businessObjectFormatEntity, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, LATEST_VERSION_FLAG_SET, "VALID");
        StorageEntity storageEntity = this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME, "S3");
        this.storageUnitDaoTestHelper.createStorageUnitEntity(storageEntity, businessObjectDataEntity, "DISABLED", NO_STORAGE_DIRECTORY_PATH);
        this.notificationRegistrationDaoTestHelper.createStorageUnitNotificationRegistrationEntity(new NotificationRegistrationKey(NAMESPACE, NOTIFICATION_NAME), NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name(), BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, STORAGE_NAME, "ENABLED", "DISABLED", jobActions, "ENABLED");
        List notificationActions = this.notificationEventService.processStorageUnitNotificationEventSync(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG, new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), STORAGE_NAME, "ENABLED", "DISABLED");
        Job job = (Job)notificationActions.get(0);
        Assert.assertEquals((Object)new Job(job.getId(), null, "testNamespace", "testHerdWorkflow", null, null, null, null, Arrays.asList(new Parameter("notification_businessObjectDefinitionName", BDEF_NAME), new Parameter("notification_partitionValues", PARTITION_VALUE + "|" + StringUtils.join((Iterable)SUBPARTITION_VALUES, (String)"|")), new Parameter("notification_namespace", NAMESPACE), new Parameter("notification_businessObjectData", this.jsonHelper.objectToJson((Object)this.businessObjectDataHelper.createBusinessObjectDataFromEntity(businessObjectDataEntity))), new Parameter("notification_businessObjectFormatUsage", FORMAT_USAGE_CODE), new Parameter("herd_workflowEnvironment", this.configurationHelper.getProperty(ConfigurationValue.HERD_ENVIRONMENT)), new Parameter("notification_businessObjectDefinitionNamespace", BDEF_NAMESPACE), new Parameter("Attribute Name 1", "Attribute Value 1"), new Parameter("notification_storageUnitEventType", NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG.name()), new Parameter("notification_oldStorageUnitStatus", "DISABLED"), new Parameter("notification_businessObjectDataVersion", DATA_VERSION.toString()), new Parameter("notification_name", NOTIFICATION_NAME), new Parameter("notification_partitionColumnNames", "PRTN_CLMN001|PRTN_CLMN002|PRTN_CLMN003|PRTN_CLMN004|PRTN_CLMN005"), new Parameter("notification_businessObjectFormatVersion", FORMAT_VERSION.toString()), new Parameter("notification_businessObjectFormatFileType", FORMAT_FILE_TYPE_CODE), new Parameter("notification_storageName", STORAGE_NAME), new Parameter("notification_newStorageUnitStatus", "ENABLED"), new Parameter("notification_correlationData", CORRELATION_DATA)), null, null, null), (Object)job);
    }
}

