/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.Collections;
import java.util.List;
import org.finra.herd.model.dto.MessageHeader;
import org.finra.herd.model.dto.NotificationMessage;
import org.finra.herd.model.jpa.MessageTypeEntity;
import org.finra.herd.model.jpa.NotificationMessageEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.NotificationMessagePublishingService;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class NotificationMessagePublishingServiceTest
extends AbstractServiceTest {
    @Autowired
    @Qualifier(value="notificationMessagePublishingServiceImpl")
    private NotificationMessagePublishingService notificationMessagePublishingServiceImpl;

    @Test
    public void testAddNotificationMessageToDatabaseQueue() {
        this.messageTypeDaoTestHelper.createMessageTypeEntity(MESSAGE_TYPE);
        List<MessageHeader> messageHeaders = Collections.singletonList(new MessageHeader(KEY, VALUE));
        NotificationMessage notificationMessage = new NotificationMessage(MESSAGE_TYPE, MESSAGE_DESTINATION, MESSAGE_TEXT, messageHeaders);
        this.notificationMessagePublishingService.addNotificationMessageToDatabaseQueue(notificationMessage);
        NotificationMessageEntity notificationMessageEntity = this.notificationMessageDao.getOldestNotificationMessage();
        Assert.assertNotNull((Object)notificationMessageEntity);
        Assert.assertEquals((Object)MESSAGE_TYPE, (Object)notificationMessageEntity.getMessageType().getCode());
        Assert.assertEquals((Object)MESSAGE_DESTINATION, (Object)notificationMessageEntity.getMessageDestination());
        Assert.assertEquals((Object)MESSAGE_TEXT, (Object)notificationMessageEntity.getMessageText());
        Assert.assertEquals((Object)this.jsonHelper.objectToJson(messageHeaders), (Object)notificationMessageEntity.getMessageHeaders());
    }

    @Test
    public void testAddNotificationMessageToDatabaseQueueNoMessageHeaders() {
        this.messageTypeDaoTestHelper.createMessageTypeEntity(MESSAGE_TYPE);
        NotificationMessage notificationMessage = new NotificationMessage(MESSAGE_TYPE, MESSAGE_DESTINATION, MESSAGE_TEXT, NO_MESSAGE_HEADERS);
        this.notificationMessagePublishingService.addNotificationMessageToDatabaseQueue(notificationMessage);
        NotificationMessageEntity notificationMessageEntity = this.notificationMessageDao.getOldestNotificationMessage();
        Assert.assertNotNull((Object)notificationMessageEntity);
        Assert.assertEquals((Object)MESSAGE_TYPE, (Object)notificationMessageEntity.getMessageType().getCode());
        Assert.assertEquals((Object)MESSAGE_DESTINATION, (Object)notificationMessageEntity.getMessageDestination());
        Assert.assertEquals((Object)MESSAGE_TEXT, (Object)notificationMessageEntity.getMessageText());
        Assert.assertNull((Object)notificationMessageEntity.getMessageHeaders());
    }

    @Test
    public void testNotificationPublishingServiceMethodsNewTransactionPropagation() {
        Assert.assertNull((Object)this.notificationMessageDao.getOldestNotificationMessage());
        this.notificationMessagePublishingServiceImpl.addNotificationMessageToDatabaseQueue(new NotificationMessage(MessageTypeEntity.MessageEventTypes.SQS.name(), MESSAGE_DESTINATION, MESSAGE_TEXT, Collections.singletonList(new MessageHeader(KEY, VALUE))));
        Assert.assertNotNull((Object)this.notificationMessageDao.getOldestNotificationMessage());
        Assert.assertTrue((boolean)this.notificationMessagePublishingServiceImpl.publishOldestNotificationMessageFromDatabaseQueue());
        this.notificationMessagePublishingServiceImpl.publishNotificationMessage(new NotificationMessage(MessageTypeEntity.MessageEventTypes.SQS.name(), MESSAGE_DESTINATION, MESSAGE_TEXT, Collections.singletonList(new MessageHeader(KEY, VALUE))));
    }

    @Test
    public void testPublishNotificationMessage() {
        this.notificationMessagePublishingService.publishNotificationMessage(new NotificationMessage(MessageTypeEntity.MessageEventTypes.SQS.name(), MESSAGE_DESTINATION, MESSAGE_TEXT, Collections.singletonList(new MessageHeader(KEY, VALUE))));
        this.notificationMessagePublishingService.publishNotificationMessage(new NotificationMessage(MessageTypeEntity.MessageEventTypes.SNS.name(), MESSAGE_DESTINATION, MESSAGE_TEXT, Collections.singletonList(new MessageHeader(KEY, VALUE))));
    }

    @Test
    public void testPublishNotificationMessageInvalidMessageType() {
        try {
            this.notificationMessagePublishingService.publishNotificationMessage(new NotificationMessage("I_DO_NOT_EXIST", MESSAGE_DESTINATION, MESSAGE_TEXT, Collections.singletonList(new MessageHeader(KEY, VALUE))));
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Notification message type \"%s\" is not supported.", "I_DO_NOT_EXIST"), (Object)e.getMessage());
        }
    }

    @Test
    public void testPublishOldestNotificationMessageFromDatabaseQueue() {
        this.notificationMessageDaoTestHelper.createNotificationMessageEntity(MessageTypeEntity.MessageEventTypes.SQS.name(), "AWS_SQS_QUEUE_NAME", MESSAGE_TEXT);
        Assert.assertTrue((boolean)this.notificationMessagePublishingService.publishOldestNotificationMessageFromDatabaseQueue());
        Assert.assertFalse((boolean)this.notificationMessagePublishingService.publishOldestNotificationMessageFromDatabaseQueue());
    }

    @Test
    public void testPublishOldestNotificationMessageFromDatabaseQueueAwsServiceException() {
        NotificationMessageEntity notificationMessageEntity = this.notificationMessageDaoTestHelper.createNotificationMessageEntity(MessageTypeEntity.MessageEventTypes.SQS.name(), "mock_sqs_queue_not_found_name", MESSAGE_TEXT);
        try {
            this.notificationMessagePublishingService.publishOldestNotificationMessageFromDatabaseQueue();
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("AWS SQS queue with \"%s\" name not found.", "mock_sqs_queue_not_found_name"), (Object)e.getMessage());
        }
        Assert.assertEquals((Object)this.notificationMessageDao.getOldestNotificationMessage(), (Object)notificationMessageEntity);
    }

    @Test
    public void testPublishOldestNotificationMessageFromDatabaseQueueJsonParseException() {
        NotificationMessageEntity notificationMessageEntity = this.notificationMessageDaoTestHelper.createNotificationMessageEntity(MESSAGE_TYPE, MESSAGE_DESTINATION, MESSAGE_TEXT);
        notificationMessageEntity.setMessageHeaders(INVALID_VALUE);
        this.notificationMessageDao.saveAndRefresh((Object)notificationMessageEntity);
        try {
            this.notificationMessagePublishingService.publishOldestNotificationMessageFromDatabaseQueue();
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Failed to unmarshall notification message headers. messageId=%d messageType=%s messageDestination=%s messageText=%s messageHeaders=%s", notificationMessageEntity.getId(), MESSAGE_TYPE, MESSAGE_DESTINATION, MESSAGE_TEXT, INVALID_VALUE), (Object)e.getMessage());
        }
        Assert.assertEquals((Object)this.notificationMessageDao.getOldestNotificationMessage(), (Object)notificationMessageEntity);
    }
}

