/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.api.xml.PartitionKeyGroup;
import org.finra.herd.model.api.xml.PartitionKeyGroupKey;
import org.finra.herd.model.api.xml.PartitionKeyGroupKeys;
import org.finra.herd.model.jpa.PartitionKeyGroupEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class PartitionKeyGroupServiceTest
extends AbstractServiceTest {
    @Test
    public void testCreatePartitionKeyGroup() {
        PartitionKeyGroup resultPartitionKeyGroup = this.partitionKeyGroupServiceTestHelper.createPartitionKeyGroup(PARTITION_KEY_GROUP);
        this.partitionKeyGroupServiceTestHelper.validatePartitionKeyGroup(PARTITION_KEY_GROUP, resultPartitionKeyGroup);
    }

    @Test
    public void testCreatePartitionKeyGroupMissingRequiredParameters() {
        try {
            this.partitionKeyGroupServiceTestHelper.createPartitionKeyGroup("      \t\t ");
            Assert.fail((String)"Should throw an IllegalArgumentException when partition key group is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition key group name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreatePartitionKeyGroupTrimParameters() {
        PartitionKeyGroup resultPartitionKeyGroup = this.partitionKeyGroupServiceTestHelper.createPartitionKeyGroup(this.addWhitespace(PARTITION_KEY_GROUP));
        this.partitionKeyGroupServiceTestHelper.validatePartitionKeyGroup(PARTITION_KEY_GROUP, resultPartitionKeyGroup);
    }

    @Test
    public void testCreatePartitionKeyGroupInvalidParameters() {
        try {
            this.partitionKeyGroupServiceTestHelper.createPartitionKeyGroup(this.addSlash(PARTITION_KEY_GROUP));
            Assert.fail((String)"Should throw an IllegalArgumentException when partition key group name contains a forward slash character.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Partition key group name can not contain a forward slash character.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreatePartitionKeyGroupEntityAlreadyExists() {
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        try {
            this.partitionKeyGroupServiceTestHelper.createPartitionKeyGroup(PARTITION_KEY_GROUP);
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((Object)String.format("Unable to create partition key group with name \"%s\" because it already exists.", PARTITION_KEY_GROUP), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetPartitionKeyGroup() {
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        PartitionKeyGroup resultPartitionKeyGroup = this.partitionKeyGroupService.getPartitionKeyGroup(new PartitionKeyGroupKey(PARTITION_KEY_GROUP));
        this.partitionKeyGroupServiceTestHelper.validatePartitionKeyGroup(PARTITION_KEY_GROUP, resultPartitionKeyGroup);
    }

    @Test
    public void testGetPartitionKeyGroupMissingRequiredParameters() {
        try {
            this.partitionKeyGroupService.getPartitionKeyGroup(new PartitionKeyGroupKey("      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when partition key group is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition key group name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetPartitionKeyGroupTrimParameters() {
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        PartitionKeyGroup resultPartitionKeyGroup = this.partitionKeyGroupService.getPartitionKeyGroup(new PartitionKeyGroupKey(this.addWhitespace(PARTITION_KEY_GROUP)));
        this.partitionKeyGroupServiceTestHelper.validatePartitionKeyGroup(PARTITION_KEY_GROUP, resultPartitionKeyGroup);
    }

    @Test
    public void testGetPartitionKeyGroupUpperCaseParameters() {
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP.toLowerCase());
        PartitionKeyGroup resultPartitionKeyGroup = this.partitionKeyGroupService.getPartitionKeyGroup(new PartitionKeyGroupKey(PARTITION_KEY_GROUP.toUpperCase()));
        this.partitionKeyGroupServiceTestHelper.validatePartitionKeyGroup(PARTITION_KEY_GROUP.toLowerCase(), resultPartitionKeyGroup);
    }

    @Test
    public void testGetPartitionKeyGroupLowerCaseParameters() {
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP.toUpperCase());
        PartitionKeyGroup resultPartitionKeyGroup = this.partitionKeyGroupService.getPartitionKeyGroup(new PartitionKeyGroupKey(PARTITION_KEY_GROUP.toLowerCase()));
        this.partitionKeyGroupServiceTestHelper.validatePartitionKeyGroup(PARTITION_KEY_GROUP.toUpperCase(), resultPartitionKeyGroup);
    }

    @Test
    public void testDeletePartitionKeyGroup() {
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        this.partitionKeyGroupService.getPartitionKeyGroup(new PartitionKeyGroupKey(PARTITION_KEY_GROUP));
        PartitionKeyGroup deletedPartitionKeyGroup = this.partitionKeyGroupService.deletePartitionKeyGroup(new PartitionKeyGroupKey(PARTITION_KEY_GROUP));
        this.partitionKeyGroupServiceTestHelper.validatePartitionKeyGroup(PARTITION_KEY_GROUP, deletedPartitionKeyGroup);
        Assert.assertNull((Object)this.partitionKeyGroupDao.getPartitionKeyGroupByKey(this.partitionKeyGroupServiceTestHelper.createPartitionKeyGroupKey(PARTITION_KEY_GROUP)));
    }

    @Test
    public void testDeletePartitionKeyGroupMissingRequiredParameters() {
        try {
            this.partitionKeyGroupService.deletePartitionKeyGroup(new PartitionKeyGroupKey("      \t\t "));
            Assert.fail((String)"Should throw an IllegalArgumentException when partition key group is not specified.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A partition key group name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeletePartitionKeyGroupTrimParameters() {
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        this.partitionKeyGroupService.getPartitionKeyGroup(new PartitionKeyGroupKey(PARTITION_KEY_GROUP));
        PartitionKeyGroup deletedPartitionKeyGroup = this.partitionKeyGroupService.deletePartitionKeyGroup(new PartitionKeyGroupKey(this.addWhitespace(PARTITION_KEY_GROUP)));
        this.partitionKeyGroupServiceTestHelper.validatePartitionKeyGroup(PARTITION_KEY_GROUP, deletedPartitionKeyGroup);
        Assert.assertNull((Object)this.partitionKeyGroupDao.getPartitionKeyGroupByKey(this.partitionKeyGroupServiceTestHelper.createPartitionKeyGroupKey(PARTITION_KEY_GROUP)));
    }

    @Test
    public void testDeletePartitionKeyGroupUpperCaseParameters() {
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP.toLowerCase());
        PartitionKeyGroup deletedPartitionKeyGroup = this.partitionKeyGroupService.deletePartitionKeyGroup(new PartitionKeyGroupKey(PARTITION_KEY_GROUP.toUpperCase()));
        this.partitionKeyGroupServiceTestHelper.validatePartitionKeyGroup(PARTITION_KEY_GROUP.toLowerCase(), deletedPartitionKeyGroup);
        Assert.assertNull((Object)this.partitionKeyGroupDao.getPartitionKeyGroupByKey(this.partitionKeyGroupServiceTestHelper.createPartitionKeyGroupKey(PARTITION_KEY_GROUP.toLowerCase())));
    }

    @Test
    public void testDeletePartitionKeyGroupLowerCaseParameters() {
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP.toUpperCase());
        this.partitionKeyGroupService.getPartitionKeyGroup(new PartitionKeyGroupKey(PARTITION_KEY_GROUP.toUpperCase()));
        PartitionKeyGroup deletedPartitionKeyGroup = this.partitionKeyGroupService.deletePartitionKeyGroup(new PartitionKeyGroupKey(PARTITION_KEY_GROUP.toLowerCase()));
        this.partitionKeyGroupServiceTestHelper.validatePartitionKeyGroup(PARTITION_KEY_GROUP.toUpperCase(), deletedPartitionKeyGroup);
        Assert.assertNull((Object)this.partitionKeyGroupDao.getPartitionKeyGroupByKey(this.partitionKeyGroupServiceTestHelper.createPartitionKeyGroupKey(PARTITION_KEY_GROUP.toUpperCase())));
    }

    @Test
    public void testDeletePartitionKeyGroupExpectedPartitionValuesPresent() {
        PartitionKeyGroupEntity partitionKeyGroupEntity = this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        this.expectedPartitionValueDaoTestHelper.createExpectedPartitionValueProcessDatesForApril2014(PARTITION_KEY_GROUP);
        this.herdDao.saveAndRefresh((Object)partitionKeyGroupEntity);
        PartitionKeyGroup deletedPartitionKeyGroup = this.partitionKeyGroupService.deletePartitionKeyGroup(new PartitionKeyGroupKey(PARTITION_KEY_GROUP));
        this.partitionKeyGroupServiceTestHelper.validatePartitionKeyGroup(PARTITION_KEY_GROUP, deletedPartitionKeyGroup);
        Assert.assertNull((Object)this.partitionKeyGroupDao.getPartitionKeyGroupByKey(this.partitionKeyGroupServiceTestHelper.createPartitionKeyGroupKey(PARTITION_KEY_GROUP)));
    }

    @Test
    public void testDeletePartitionKeyGroupUsedByFormat() {
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        this.businessObjectFormatDaoTestHelper.createBusinessObjectFormatEntity(NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, FORMAT_DESCRIPTION, Boolean.valueOf(true), PARTITION_KEY, PARTITION_KEY_GROUP);
        try {
            this.partitionKeyGroupService.deletePartitionKeyGroup(new PartitionKeyGroupKey(PARTITION_KEY_GROUP));
            Assert.fail((String)"Suppose to throw an IllegalArgumentException when partition key group is used by business object format.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Can not delete \"%s\" partition key group since it is being used by a business object format.", PARTITION_KEY_GROUP), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetPartitionKeyGroups() {
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP);
        this.partitionKeyGroupDaoTestHelper.createPartitionKeyGroupEntity(PARTITION_KEY_GROUP_2);
        PartitionKeyGroupKeys partitionKeyGroupKeys = this.partitionKeyGroupService.getPartitionKeyGroups();
        Assert.assertTrue((partitionKeyGroupKeys.getPartitionKeyGroupKeys().size() >= 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)partitionKeyGroupKeys.getPartitionKeyGroupKeys().contains(this.partitionKeyGroupServiceTestHelper.createPartitionKeyGroupKey(PARTITION_KEY_GROUP)));
        Assert.assertTrue((boolean)partitionKeyGroupKeys.getPartitionKeyGroupKeys().contains(this.partitionKeyGroupServiceTestHelper.createPartitionKeyGroupKey(PARTITION_KEY_GROUP_2)));
    }
}

