/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKey;
import org.finra.herd.model.api.xml.RelationalTableRegistrationCreateRequest;
import org.finra.herd.model.dto.RelationalStorageAttributesDto;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.RelationalTableRegistrationHelperService;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class RelationalTableRegistrationHelperServiceTest
extends AbstractServiceTest {
    @Autowired
    @Qualifier(value="relationalTableRegistrationHelperServiceImpl")
    private RelationalTableRegistrationHelperService relationalTableRegistrationHelperServiceImpl;

    @Test
    public void testGetRelationalStorageAttributesBusinessObjectDefinitionAlreadyExists() {
        this.namespaceDaoTestHelper.createNamespaceEntity(BDEF_NAMESPACE);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        try {
            this.relationalTableRegistrationHelperService.getRelationalStorageAttributes(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME));
            Assert.fail();
        }
        catch (AlreadyExistsException ex) {
            Assert.assertEquals((Object)String.format("Business object definition with name \"%s\" already exists for namespace \"%s\".", BDEF_NAME, BDEF_NAMESPACE), (Object)ex.getMessage());
        }
    }

    @Test
    public void testGetRelationalStorageAttributesInvalidStoragePlatform() {
        this.relationalTableRegistrationServiceTestHelper.createDatabaseEntitiesForRelationalTableRegistrationTesting(BDEF_NAMESPACE, DATA_PROVIDER_NAME, STORAGE_NAME);
        this.storageDaoTestHelper.createStorageEntity(STORAGE_NAME_2, STORAGE_PLATFORM_CODE);
        try {
            this.relationalTableRegistrationHelperService.getRelationalStorageAttributes(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME_2));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Cannot register relational table in \"%s\" storage of %s storage platform type. Only %s storage platform type is supported by this feature.", STORAGE_NAME_2, STORAGE_PLATFORM_CODE, "RELATIONAL"), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetRelationalStorageAttributesRequiredDatabaseEntitiesNoExist() {
        this.relationalTableRegistrationServiceTestHelper.createDatabaseEntitiesForRelationalTableRegistrationTesting(BDEF_NAMESPACE, DATA_PROVIDER_NAME, STORAGE_NAME);
        try {
            this.relationalTableRegistrationHelperService.getRelationalStorageAttributes(new RelationalTableRegistrationCreateRequest("I_DO_NOT_EXIST", BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Namespace \"%s\" doesn't exist.", "I_DO_NOT_EXIST"), (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.getRelationalStorageAttributes(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Data provider with name \"%s\" doesn't exist.", "I_DO_NOT_EXIST"), (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.getRelationalStorageAttributes(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, "I_DO_NOT_EXIST"));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage with name \"%s\" doesn't exist.", "I_DO_NOT_EXIST"), (Object)e.getMessage());
        }
    }

    @Test
    public void testRegisterRelationalTableBusinessObjectDefinitionAlreadyExists() {
        this.namespaceDaoTestHelper.createNamespaceEntity(BDEF_NAMESPACE);
        this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME), DATA_PROVIDER_NAME, BDEF_DESCRIPTION);
        try {
            this.relationalTableRegistrationHelperService.registerRelationalTable(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME), this.relationalTableRegistrationServiceTestHelper.getExpectedSchemaColumns());
            Assert.fail();
        }
        catch (AlreadyExistsException ex) {
            Assert.assertEquals((Object)String.format("Unable to create business object definition with name \"%s\" because it already exists for namespace \"%s\".", BDEF_NAME, BDEF_NAMESPACE), (Object)ex.getMessage());
        }
    }

    @Test
    public void testRegisterRelationalTableRequiredDatabaseEntitiesNoExist() {
        this.relationalTableRegistrationServiceTestHelper.createDatabaseEntitiesForRelationalTableRegistrationTesting(BDEF_NAMESPACE, DATA_PROVIDER_NAME, STORAGE_NAME);
        try {
            this.relationalTableRegistrationHelperService.registerRelationalTable(new RelationalTableRegistrationCreateRequest("I_DO_NOT_EXIST", BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME), this.relationalTableRegistrationServiceTestHelper.getExpectedSchemaColumns());
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Namespace \"%s\" doesn't exist.", "I_DO_NOT_EXIST"), (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.registerRelationalTable(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, "I_DO_NOT_EXIST", RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME), this.relationalTableRegistrationServiceTestHelper.getExpectedSchemaColumns());
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Data provider with name \"%s\" doesn't exist.", "I_DO_NOT_EXIST"), (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.registerRelationalTable(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, "I_DO_NOT_EXIST"), this.relationalTableRegistrationServiceTestHelper.getExpectedSchemaColumns());
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Storage with name \"%s\" doesn't exist.", "I_DO_NOT_EXIST"), (Object)e.getMessage());
        }
    }

    @Test
    public void testRelationalTableRegistrationHelperServiceMethodsNewTransactionPropagation() {
        try {
            this.relationalTableRegistrationHelperServiceImpl.getRelationalStorageAttributes(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Namespace \"%s\" doesn't exist.", BDEF_NAMESPACE), (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperServiceImpl.registerRelationalTable(new RelationalTableRegistrationCreateRequest(), new ArrayList());
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperServiceImpl.retrieveRelationalTableColumns(new RelationalStorageAttributesDto("jdbc:h2:mem:herdTestDb", USERNAME, NO_USER_CREDENTIAL_NAME), RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Failed to retrieve description of a relational table with \"%s\" name under \"%s\" schema at jdbc.url=\"%s\" using jdbc.username=\"%s\". Reason: Wrong user name or password [28000-196]", RELATIONAL_TABLE_NAME, RELATIONAL_SCHEMA_NAME, "jdbc:h2:mem:herdTestDb", USERNAME), (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperServiceImpl.validateAndTrimRelationalTableRegistrationCreateRequest(new RelationalTableRegistrationCreateRequest());
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testRetrieveRelationalTableColumnsRelationTableNoExists() {
        RelationalStorageAttributesDto relationalStorageAttributesDto = new RelationalStorageAttributesDto();
        relationalStorageAttributesDto.setJdbcUrl("jdbc:h2:mem:herdTestDb");
        relationalStorageAttributesDto.setJdbcUsername("");
        relationalStorageAttributesDto.setJdbcUserCredentialName(NO_USER_CREDENTIAL_NAME);
        try {
            this.relationalTableRegistrationHelperService.retrieveRelationalTableColumns(relationalStorageAttributesDto, RELATIONAL_SCHEMA_NAME, "I_DO_NOT_EXIST");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Relational table with \"%s\" name not found under \"%s\" schema at jdbc.url=\"%s\" for jdbc.username=\"%s\".", "I_DO_NOT_EXIST", RELATIONAL_SCHEMA_NAME, "jdbc:h2:mem:herdTestDb", ""), (Object)e.getMessage());
        }
    }

    @Test
    public void testRetrieveRelationalTableColumnsSqlException() {
        RelationalStorageAttributesDto relationalStorageAttributesDto = new RelationalStorageAttributesDto();
        relationalStorageAttributesDto.setJdbcUrl(INVALID_VALUE);
        relationalStorageAttributesDto.setJdbcUsername(USERNAME);
        relationalStorageAttributesDto.setJdbcUserCredentialName(NO_USER_CREDENTIAL_NAME);
        try {
            this.relationalTableRegistrationHelperService.retrieveRelationalTableColumns(relationalStorageAttributesDto, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Failed to retrieve description of a relational table with \"%s\" name under \"%s\" schema at jdbc.url=\"%s\" using jdbc.username=\"%s\". Reason: No suitable driver found for %s", RELATIONAL_TABLE_NAME, RELATIONAL_SCHEMA_NAME, INVALID_VALUE, USERNAME, INVALID_VALUE), (Object)e.getMessage());
        }
    }

    @Test
    public void testValidateAndTrimRelationalTableRegistrationCreateRequestMissingOptionalParametersAsBlanks() {
        RelationalTableRegistrationCreateRequest relationalTableRegistrationCreateRequest = new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, "      \t\t ", FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME);
        this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(relationalTableRegistrationCreateRequest);
        Assert.assertEquals((Object)new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, "", FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME), (Object)relationalTableRegistrationCreateRequest);
    }

    @Test
    public void testValidateAndTrimRelationalTableRegistrationCreateRequestMissingOptionalParametersAsNulls() {
        RelationalTableRegistrationCreateRequest relationalTableRegistrationCreateRequest = new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, NO_BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME);
        this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(relationalTableRegistrationCreateRequest);
        Assert.assertEquals((Object)new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, NO_BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME), (Object)relationalTableRegistrationCreateRequest);
    }

    @Test
    public void testValidateAndTrimRelationalTableRegistrationCreateRequestMissingRequiredParameters() {
        try {
            this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A relational table registration create request must be specified.", (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(new RelationalTableRegistrationCreateRequest("      \t\t ", BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, "      \t\t ", BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object definition name must be specified.", (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, "      \t\t ", DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format usage must be specified.", (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, "      \t\t ", RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A data provider name must be specified.", (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, "      \t\t ", RELATIONAL_TABLE_NAME, STORAGE_NAME));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A relational schema name must be specified.", (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, "      \t\t ", STORAGE_NAME));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A relational table name must be specified.", (Object)e.getMessage());
        }
        try {
            this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, "      \t\t "));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage name must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void testValidateAndTrimRelationalTableRegistrationCreateRequestTrimParameters() {
        RelationalTableRegistrationCreateRequest relationalTableRegistrationCreateRequest = new RelationalTableRegistrationCreateRequest(this.addWhitespace(BDEF_NAMESPACE), this.addWhitespace(BDEF_NAME), this.addWhitespace(BDEF_DISPLAY_NAME), this.addWhitespace(FORMAT_USAGE_CODE), this.addWhitespace(DATA_PROVIDER_NAME), this.addWhitespace(RELATIONAL_SCHEMA_NAME), this.addWhitespace(RELATIONAL_TABLE_NAME), this.addWhitespace(STORAGE_NAME));
        this.relationalTableRegistrationHelperService.validateAndTrimRelationalTableRegistrationCreateRequest(relationalTableRegistrationCreateRequest);
        Assert.assertEquals((Object)new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, RELATIONAL_SCHEMA_NAME, RELATIONAL_TABLE_NAME, STORAGE_NAME), (Object)relationalTableRegistrationCreateRequest);
    }
}

