/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.BusinessObjectData;
import org.finra.herd.model.api.xml.BusinessObjectDefinition;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKey;
import org.finra.herd.model.api.xml.BusinessObjectFormat;
import org.finra.herd.model.api.xml.BusinessObjectFormatKey;
import org.finra.herd.model.api.xml.RelationalTableRegistrationCreateRequest;
import org.finra.herd.model.api.xml.Schema;
import org.finra.herd.model.api.xml.Storage;
import org.finra.herd.model.api.xml.StorageUnit;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.RelationalTableRegistrationService;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class RelationalTableRegistrationServiceTest
extends AbstractServiceTest {
    @Autowired
    @Qualifier(value="relationalTableRegistrationServiceImpl")
    private RelationalTableRegistrationService relationalTableRegistrationServiceImpl;

    @Test
    public void testCreateRelationalTableRegistration() {
        this.relationalTableRegistrationServiceTestHelper.createDatabaseEntitiesForRelationalTableRegistrationTesting(BDEF_NAMESPACE, DATA_PROVIDER_NAME, STORAGE_NAME);
        String relationalSchemaName = "PUBLIC";
        String relationalTableName = "bus_objct_dfntn".toUpperCase();
        RelationalTableRegistrationCreateRequest relationalTableRegistrationCreateRequest = new RelationalTableRegistrationCreateRequest(BDEF_NAMESPACE, BDEF_NAME, BDEF_DISPLAY_NAME, FORMAT_USAGE_CODE, DATA_PROVIDER_NAME, relationalSchemaName, relationalTableName, STORAGE_NAME);
        BusinessObjectData businessObjectData = this.relationalTableRegistrationService.createRelationalTableRegistration(relationalTableRegistrationCreateRequest);
        StorageUnit expectedStorageUnit = new StorageUnit();
        expectedStorageUnit.setStorage(new Storage(STORAGE_NAME, "RELATIONAL", this.relationalTableRegistrationServiceTestHelper.getStorageAttributes()));
        expectedStorageUnit.setStorageUnitStatus("ENABLED");
        BusinessObjectData expectedBusinessObjectData = new BusinessObjectData();
        expectedBusinessObjectData.setId(businessObjectData.getId());
        expectedBusinessObjectData.setNamespace(BDEF_NAMESPACE);
        expectedBusinessObjectData.setBusinessObjectDefinitionName(BDEF_NAME);
        expectedBusinessObjectData.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE);
        expectedBusinessObjectData.setBusinessObjectFormatFileType("RELATIONAL_TABLE");
        expectedBusinessObjectData.setBusinessObjectFormatVersion(INITIAL_FORMAT_VERSION.intValue());
        expectedBusinessObjectData.setPartitionValue("none");
        expectedBusinessObjectData.setSubPartitionValues(new ArrayList());
        expectedBusinessObjectData.setVersion(INITIAL_DATA_VERSION.intValue());
        expectedBusinessObjectData.setPartitionKey("partition");
        expectedBusinessObjectData.setLatestVersion(LATEST_VERSION_FLAG_SET);
        expectedBusinessObjectData.setStatus("VALID");
        expectedBusinessObjectData.setStorageUnits(Collections.singletonList(expectedStorageUnit));
        expectedBusinessObjectData.setAttributes(new ArrayList());
        expectedBusinessObjectData.setBusinessObjectDataParents(new ArrayList());
        expectedBusinessObjectData.setBusinessObjectDataChildren(new ArrayList());
        Assert.assertEquals((Object)expectedBusinessObjectData, (Object)businessObjectData);
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, "RELATIONAL_TABLE", INITIAL_FORMAT_VERSION);
        BusinessObjectFormat businessObjectFormat = this.businessObjectFormatService.getBusinessObjectFormat(businessObjectFormatKey);
        Schema expectedSchema = new Schema();
        expectedSchema.setColumns(this.relationalTableRegistrationServiceTestHelper.getExpectedSchemaColumns());
        expectedSchema.setNullValue("");
        BusinessObjectFormat expectedBusinessObjectFormat = new BusinessObjectFormat();
        expectedBusinessObjectFormat.setId(businessObjectFormat.getId());
        expectedBusinessObjectFormat.setNamespace(BDEF_NAMESPACE);
        expectedBusinessObjectFormat.setBusinessObjectDefinitionName(BDEF_NAME);
        expectedBusinessObjectFormat.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE);
        expectedBusinessObjectFormat.setBusinessObjectFormatFileType("RELATIONAL_TABLE");
        expectedBusinessObjectFormat.setBusinessObjectFormatVersion(INITIAL_FORMAT_VERSION.intValue());
        expectedBusinessObjectFormat.setLatestVersion(LATEST_VERSION_FLAG_SET.booleanValue());
        expectedBusinessObjectFormat.setPartitionKey("partition");
        expectedBusinessObjectFormat.setBusinessObjectFormatParents(new ArrayList());
        expectedBusinessObjectFormat.setBusinessObjectFormatChildren(new ArrayList());
        expectedBusinessObjectFormat.setAttributeDefinitions(new ArrayList());
        expectedBusinessObjectFormat.setAttributes(Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_FORMAT_ATTRIBUTE_NAME_RELATIONAL_SCHEMA_NAME), relationalSchemaName), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.BUSINESS_OBJECT_FORMAT_ATTRIBUTE_NAME_RELATIONAL_TABLE_NAME), relationalTableName)));
        expectedBusinessObjectFormat.setSchema(expectedSchema);
        Assert.assertEquals((Object)expectedBusinessObjectFormat, (Object)businessObjectFormat);
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(BDEF_NAMESPACE, BDEF_NAME);
        BusinessObjectDefinition businessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(businessObjectDefinitionKey, Boolean.valueOf(true));
        BusinessObjectDefinition expectedBusinessObjectDefinition = new BusinessObjectDefinition();
        expectedBusinessObjectDefinition.setId(businessObjectDefinition.getId());
        expectedBusinessObjectDefinition.setNamespace(BDEF_NAMESPACE);
        expectedBusinessObjectDefinition.setBusinessObjectDefinitionName(BDEF_NAME);
        expectedBusinessObjectDefinition.setDataProviderName(DATA_PROVIDER_NAME);
        expectedBusinessObjectDefinition.setDisplayName(BDEF_DISPLAY_NAME);
        expectedBusinessObjectDefinition.setAttributes(new ArrayList());
        expectedBusinessObjectDefinition.setSampleDataFiles(new ArrayList());
        expectedBusinessObjectDefinition.setCreatedByUserId(businessObjectDefinition.getCreatedByUserId());
        expectedBusinessObjectDefinition.setLastUpdatedByUserId(businessObjectDefinition.getLastUpdatedByUserId());
        expectedBusinessObjectDefinition.setLastUpdatedOn(businessObjectDefinition.getLastUpdatedOn());
        expectedBusinessObjectDefinition.setBusinessObjectDefinitionChangeEvents(businessObjectDefinition.getBusinessObjectDefinitionChangeEvents());
        Assert.assertEquals((Object)expectedBusinessObjectDefinition, (Object)businessObjectDefinition);
    }

    @Test
    public void testRelationalTableRegistrationServiceMethodsNewTransactionPropagation() {
        try {
            this.relationalTableRegistrationServiceImpl.createRelationalTableRegistration(new RelationalTableRegistrationCreateRequest());
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A namespace must be specified.", (Object)e.getMessage());
        }
    }
}

