/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.dao.DataProviderDaoTestHelper;
import org.finra.herd.dao.FileTypeDaoTestHelper;
import org.finra.herd.dao.NamespaceDaoTestHelper;
import org.finra.herd.dao.StorageDaoTestHelper;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.SchemaColumn;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.service.AbstractServiceTest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class RelationalTableRegistrationServiceTestHelper {
    @Autowired
    private ConfigurationHelper configurationHelper;
    @Autowired
    private DataProviderDaoTestHelper dataProviderDaoTestHelper;
    @Autowired
    private FileTypeDaoTestHelper fileTypeDaoTestHelper;
    @Autowired
    private NamespaceDaoTestHelper namespaceDaoTestHelper;
    @Autowired
    private StorageDaoTestHelper storageDaoTestHelper;

    RelationalTableRegistrationServiceTestHelper() {
    }

    void createDatabaseEntitiesForRelationalTableRegistrationTesting(String namespace, String dataProviderName, String storageName) {
        this.namespaceDaoTestHelper.createNamespaceEntity(namespace);
        this.dataProviderDaoTestHelper.createDataProviderEntity(dataProviderName);
        this.fileTypeDaoTestHelper.createFileTypeEntity("RELATIONAL_TABLE", AbstractServiceTest.FORMAT_FILE_TYPE_DESCRIPTION);
        this.storageDaoTestHelper.createStorageEntity(storageName, "RELATIONAL", this.getStorageAttributes());
    }

    List<SchemaColumn> getExpectedSchemaColumns() {
        ArrayList<SchemaColumn> expectedSchemaColumns = new ArrayList<SchemaColumn>();
        expectedSchemaColumns.add(new SchemaColumn("BUS_OBJCT_DFNTN_ID", "INTEGER", "10", Boolean.valueOf(true), null, null));
        expectedSchemaColumns.add(new SchemaColumn("CREAT_USER_ID", "VARCHAR", "255", Boolean.valueOf(false), null, null));
        expectedSchemaColumns.add(new SchemaColumn("CREAT_TS", "TIMESTAMP", "23", Boolean.valueOf(false), null, null));
        expectedSchemaColumns.add(new SchemaColumn("UPDT_USER_ID", "VARCHAR", "255", Boolean.valueOf(false), null, null));
        expectedSchemaColumns.add(new SchemaColumn("UPDT_TS", "TIMESTAMP", "23", Boolean.valueOf(false), null, null));
        expectedSchemaColumns.add(new SchemaColumn("DESC_TX", "VARCHAR", "500", Boolean.valueOf(false), null, null));
        expectedSchemaColumns.add(new SchemaColumn("DSPLY_NAME_TX", "VARCHAR", "255", Boolean.valueOf(false), null, null));
        expectedSchemaColumns.add(new SchemaColumn("NAME_TX", "VARCHAR", "255", Boolean.valueOf(false), null, null));
        expectedSchemaColumns.add(new SchemaColumn("DATA_PRVDR_CD", "VARCHAR", "255", Boolean.valueOf(true), null, null));
        expectedSchemaColumns.add(new SchemaColumn("DESC_BUS_OBJCT_FRMT_ID", "INTEGER", "10", Boolean.valueOf(false), null, null));
        expectedSchemaColumns.add(new SchemaColumn("NAME_SPACE_CD", "VARCHAR", "255", Boolean.valueOf(true), null, null));
        return expectedSchemaColumns;
    }

    List<Attribute> getStorageAttributes() {
        return Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.STORAGE_ATTRIBUTE_NAME_JDBC_URL), "jdbc:h2:mem:herdTestDb"), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.STORAGE_ATTRIBUTE_NAME_JDBC_USER_CREDENTIAL_NAME), ""), new Attribute(this.configurationHelper.getProperty(ConfigurationValue.STORAGE_ATTRIBUTE_NAME_JDBC_USERNAME), ""));
    }
}

