/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.sql.Timestamp;
import java.util.Arrays;
import org.finra.herd.dao.SearchIndexDao;
import org.finra.herd.model.api.xml.SearchIndex;
import org.finra.herd.model.api.xml.SearchIndexActivation;
import org.finra.herd.model.api.xml.SearchIndexActivationCreateRequest;
import org.finra.herd.model.api.xml.SearchIndexKey;
import org.finra.herd.model.jpa.SearchIndexEntity;
import org.finra.herd.model.jpa.SearchIndexStatusEntity;
import org.finra.herd.model.jpa.SearchIndexTypeEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.AlternateKeyHelper;
import org.finra.herd.service.helper.SearchIndexDaoHelper;
import org.finra.herd.service.impl.SearchIndexActivationServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SearchIndexActivationServiceTest
extends AbstractServiceTest {
    @InjectMocks
    private SearchIndexActivationServiceImpl searchIndexActivationService;
    @Mock
    private AlternateKeyHelper alternateKeyHelper;
    @Mock
    private SearchIndexDaoHelper searchIndexDaoHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    @Ignore
    public void testSearchIndexActivation() {
        String searchIndexType = SearchIndexTypeEntity.SearchIndexTypes.BUS_OBJCT_DFNTN.name();
        SearchIndexTypeEntity searchIndexTypeEntity = new SearchIndexTypeEntity();
        searchIndexTypeEntity.setCode(searchIndexType);
        String searchIndexStatus = SearchIndexStatusEntity.SearchIndexStatuses.READY.name();
        SearchIndexStatusEntity searchIndexStatusEntity = new SearchIndexStatusEntity();
        searchIndexStatusEntity.setCode(searchIndexStatus);
        SearchIndexEntity searchIndexEntity = this.searchIndexDaoTestHelper.createSearchIndexEntity(SEARCH_INDEX_NAME, searchIndexType, searchIndexStatus);
        SearchIndexKey searchIndexKey = new SearchIndexKey(SEARCH_INDEX_NAME);
        SearchIndexEntity responseSearchIndexEntity = new SearchIndexEntity();
        responseSearchIndexEntity.setName(SEARCH_INDEX_NAME);
        responseSearchIndexEntity.setType(searchIndexTypeEntity);
        responseSearchIndexEntity.setActive(Boolean.TRUE);
        responseSearchIndexEntity.setCreatedBy(USER_ID);
        responseSearchIndexEntity.setCreatedOn(new Timestamp(CREATED_ON.toGregorianCalendar().getTimeInMillis()));
        responseSearchIndexEntity.setUpdatedOn(new Timestamp(UPDATED_ON.toGregorianCalendar().getTimeInMillis()));
        SearchIndexActivationCreateRequest searchIndexActivationCreateRequest = new SearchIndexActivationCreateRequest();
        searchIndexActivationCreateRequest.setSearchIndexKey(searchIndexKey);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("Search index name", SEARCH_INDEX_NAME)).thenReturn((Object)SEARCH_INDEX_NAME);
        Mockito.when((Object)this.searchIndexDaoHelper.getSearchIndexEntity(searchIndexKey)).thenReturn((Object)searchIndexEntity);
        Mockito.when((Object)this.searchIndexDao.getSearchIndexEntities(searchIndexTypeEntity)).thenReturn(Arrays.asList(searchIndexEntity));
        Mockito.when((Object)this.searchIndexDao.saveAndRefresh(Matchers.any(SearchIndexEntity.class))).thenReturn((Object)responseSearchIndexEntity);
        SearchIndexActivation response = this.searchIndexActivationService.createSearchIndexActivation(searchIndexActivationCreateRequest);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("Search index name", SEARCH_INDEX_NAME);
        ((SearchIndexDaoHelper)Mockito.verify((Object)this.searchIndexDaoHelper)).getSearchIndexEntity(searchIndexKey);
        ((SearchIndexDao)Mockito.verify((Object)this.searchIndexDao)).getSearchIndexEntities(searchIndexTypeEntity);
        ((SearchIndexDao)Mockito.verify((Object)this.searchIndexDao)).saveAndRefresh(Matchers.any(SearchIndexEntity.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.searchIndexDao, this.searchIndexDaoHelper});
        Assert.assertEquals((Object)new SearchIndex(searchIndexKey, searchIndexType, searchIndexStatus, SEARCH_INDEX_ACTIVE_FLAG.booleanValue(), NO_SEARCH_INDEX_STATISTICS, USER_ID, CREATED_ON, UPDATED_ON), (Object)response);
    }
}

