/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.finra.herd.dao.BusinessObjectDefinitionDao;
import org.finra.herd.dao.IndexFunctionsDao;
import org.finra.herd.dao.TagDao;
import org.finra.herd.model.api.xml.SearchIndexKey;
import org.finra.herd.model.jpa.BusinessObjectDefinitionEntity;
import org.finra.herd.model.jpa.SearchIndexStatusEntity;
import org.finra.herd.model.jpa.TagEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.functional.QuadConsumer;
import org.finra.herd.service.helper.BusinessObjectDefinitionHelper;
import org.finra.herd.service.helper.SearchIndexDaoHelper;
import org.finra.herd.service.helper.TagHelper;
import org.finra.herd.service.impl.SearchIndexHelperServiceImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SearchIndexHelperServiceTest
extends AbstractServiceTest {
    @Mock
    private BusinessObjectDefinitionDao businessObjectDefinitionDao;
    @Mock
    private BusinessObjectDefinitionHelper businessObjectDefinitionHelper;
    @Mock
    private IndexFunctionsDao indexFunctionsDao;
    @Mock
    private SearchIndexDaoHelper searchIndexDaoHelper;
    @InjectMocks
    private SearchIndexHelperServiceImpl searchIndexHelperService;
    @Mock
    private TagDao tagDao;
    @Mock
    private TagHelper tagHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testIndexAllBusinessObjectDefinitions() {
        SearchIndexKey searchIndexKey = new SearchIndexKey(SEARCH_INDEX_NAME);
        List<BusinessObjectDefinitionEntity> businessObjectDefinitionEntities = Collections.unmodifiableList(Arrays.asList(this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, this.businessObjectDefinitionServiceTestHelper.getNewAttributes()), this.businessObjectDefinitionDaoTestHelper.createBusinessObjectDefinitionEntity(BDEF_NAMESPACE_2, BDEF_NAME_2, DATA_PROVIDER_NAME_2, BDEF_DESCRIPTION_2, this.businessObjectDefinitionServiceTestHelper.getNewAttributes2())));
        int chunkSize = 100;
        Mockito.when((Object)this.businessObjectDefinitionDao.getAllBusinessObjectDefinitions(Integer.valueOf(0), Integer.valueOf(chunkSize))).thenReturn(businessObjectDefinitionEntities);
        Mockito.when((Object)this.businessObjectDefinitionDao.getAllBusinessObjectDefinitions(Integer.valueOf(chunkSize), Integer.valueOf(chunkSize))).thenReturn(new ArrayList());
        Mockito.when((Object)this.indexFunctionsDao.getNumberOfTypesInIndex((String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)2L);
        Future response = this.searchIndexHelperService.indexAllBusinessObjectDefinitions(searchIndexKey, SEARCH_INDEX_DOCUMENT_TYPE);
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getAllBusinessObjectDefinitions(Integer.valueOf(0), Integer.valueOf(chunkSize));
        ((BusinessObjectDefinitionDao)Mockito.verify((Object)this.businessObjectDefinitionDao)).getAllBusinessObjectDefinitions(Integer.valueOf(chunkSize), Integer.valueOf(chunkSize));
        ((BusinessObjectDefinitionHelper)Mockito.verify((Object)this.businessObjectDefinitionHelper)).executeFunctionForBusinessObjectDefinitionEntities((String)Matchers.eq((Object)SEARCH_INDEX_NAME), (String)Matchers.eq((Object)SEARCH_INDEX_DOCUMENT_TYPE), (List)Matchers.eq(businessObjectDefinitionEntities), (QuadConsumer)Matchers.any());
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).getNumberOfTypesInIndex((String)Matchers.any(), (String)Matchers.any());
        ((SearchIndexDaoHelper)Mockito.verify((Object)this.searchIndexDaoHelper)).updateSearchIndexStatus(searchIndexKey, SearchIndexStatusEntity.SearchIndexStatuses.READY.name());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDefinitionDao, this.businessObjectDefinitionHelper, this.searchIndexDaoHelper, this.tagDao, this.tagHelper});
        Assert.assertNotNull((Object)response);
        MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.instanceOf(Future.class));
    }

    @Test
    public void testIndexAllTags() {
        SearchIndexKey searchIndexKey = new SearchIndexKey(SEARCH_INDEX_NAME);
        List<TagEntity> tagEntities = Collections.unmodifiableList(Arrays.asList(this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION), this.tagDaoTestHelper.createTagEntity(TAG_TYPE_2, TAG_CODE_2, TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2)));
        Mockito.when((Object)this.tagDao.getTags()).thenReturn(tagEntities);
        ((IndexFunctionsDao)Mockito.doNothing().when((Object)this.indexFunctionsDao)).createIndexDocument((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        Mockito.when((Object)this.indexFunctionsDao.getNumberOfTypesInIndex(SEARCH_INDEX_NAME, SEARCH_INDEX_DOCUMENT_TYPE)).thenReturn((Object)2L);
        Future response = this.searchIndexHelperService.indexAllTags(searchIndexKey, SEARCH_INDEX_DOCUMENT_TYPE);
        ((TagDao)Mockito.verify((Object)this.tagDao)).getTags();
        ((TagHelper)Mockito.verify((Object)this.tagHelper)).executeFunctionForTagEntities((String)Matchers.eq((Object)SEARCH_INDEX_NAME), (String)Matchers.eq((Object)SEARCH_INDEX_DOCUMENT_TYPE), (List)Matchers.eq(tagEntities), (QuadConsumer)Matchers.any());
        ((IndexFunctionsDao)Mockito.verify((Object)this.indexFunctionsDao)).getNumberOfTypesInIndex(SEARCH_INDEX_NAME, SEARCH_INDEX_DOCUMENT_TYPE);
        ((SearchIndexDaoHelper)Mockito.verify((Object)this.searchIndexDaoHelper)).updateSearchIndexStatus(searchIndexKey, SearchIndexStatusEntity.SearchIndexStatuses.READY.name());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDefinitionDao, this.businessObjectDefinitionHelper, this.searchIndexDaoHelper, this.tagDao, this.tagHelper});
        Assert.assertNotNull((Object)response);
        MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.instanceOf(Future.class));
    }
}

